/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyOnExitCodesRequirement;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyOnExitCodesRequirementBuilder;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyOnExitCodesRequirementFluent;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyOnPodConditionsPattern;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyOnPodConditionsPatternBuilder;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyOnPodConditionsPatternFluent;
import io.kubernetes.client.openapi.models.V1PodFailurePolicyRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1PodFailurePolicyRuleFluent<A extends V1PodFailurePolicyRuleFluent<A>>
extends BaseFluent<A> {
    private String action;
    private V1PodFailurePolicyOnExitCodesRequirementBuilder onExitCodes;
    private ArrayList<V1PodFailurePolicyOnPodConditionsPatternBuilder> onPodConditions;

    public V1PodFailurePolicyRuleFluent() {
    }

    public V1PodFailurePolicyRuleFluent(V1PodFailurePolicyRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1PodFailurePolicyRule instance) {
        V1PodFailurePolicyRule v1PodFailurePolicyRule = instance = instance != null ? instance : new V1PodFailurePolicyRule();
        if (instance != null) {
            this.withAction(instance.getAction());
            this.withOnExitCodes(instance.getOnExitCodes());
            this.withOnPodConditions(instance.getOnPodConditions());
        }
    }

    public String getAction() {
        return this.action;
    }

    public A withAction(String action) {
        this.action = action;
        return (A)this;
    }

    public boolean hasAction() {
        return this.action != null;
    }

    public V1PodFailurePolicyOnExitCodesRequirement buildOnExitCodes() {
        return this.onExitCodes != null ? this.onExitCodes.build() : null;
    }

    public A withOnExitCodes(V1PodFailurePolicyOnExitCodesRequirement onExitCodes) {
        this._visitables.remove("onExitCodes");
        if (onExitCodes != null) {
            this.onExitCodes = new V1PodFailurePolicyOnExitCodesRequirementBuilder(onExitCodes);
            this._visitables.get("onExitCodes").add(this.onExitCodes);
        } else {
            this.onExitCodes = null;
            this._visitables.get("onExitCodes").remove(this.onExitCodes);
        }
        return (A)this;
    }

    public boolean hasOnExitCodes() {
        return this.onExitCodes != null;
    }

    public OnExitCodesNested<A> withNewOnExitCodes() {
        return new OnExitCodesNested(null);
    }

    public OnExitCodesNested<A> withNewOnExitCodesLike(V1PodFailurePolicyOnExitCodesRequirement item) {
        return new OnExitCodesNested(item);
    }

    public OnExitCodesNested<A> editOnExitCodes() {
        return this.withNewOnExitCodesLike(Optional.ofNullable(this.buildOnExitCodes()).orElse(null));
    }

    public OnExitCodesNested<A> editOrNewOnExitCodes() {
        return this.withNewOnExitCodesLike(Optional.ofNullable(this.buildOnExitCodes()).orElse(new V1PodFailurePolicyOnExitCodesRequirementBuilder().build()));
    }

    public OnExitCodesNested<A> editOrNewOnExitCodesLike(V1PodFailurePolicyOnExitCodesRequirement item) {
        return this.withNewOnExitCodesLike(Optional.ofNullable(this.buildOnExitCodes()).orElse(item));
    }

    public A addToOnPodConditions(int index, V1PodFailurePolicyOnPodConditionsPattern item) {
        if (this.onPodConditions == null) {
            this.onPodConditions = new ArrayList();
        }
        V1PodFailurePolicyOnPodConditionsPatternBuilder builder = new V1PodFailurePolicyOnPodConditionsPatternBuilder(item);
        if (index < 0 || index >= this.onPodConditions.size()) {
            this._visitables.get("onPodConditions").add(builder);
            this.onPodConditions.add(builder);
        } else {
            this._visitables.get("onPodConditions").add(builder);
            this.onPodConditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToOnPodConditions(int index, V1PodFailurePolicyOnPodConditionsPattern item) {
        if (this.onPodConditions == null) {
            this.onPodConditions = new ArrayList();
        }
        V1PodFailurePolicyOnPodConditionsPatternBuilder builder = new V1PodFailurePolicyOnPodConditionsPatternBuilder(item);
        if (index < 0 || index >= this.onPodConditions.size()) {
            this._visitables.get("onPodConditions").add(builder);
            this.onPodConditions.add(builder);
        } else {
            this._visitables.get("onPodConditions").add(builder);
            this.onPodConditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToOnPodConditions(V1PodFailurePolicyOnPodConditionsPattern ... items) {
        if (this.onPodConditions == null) {
            this.onPodConditions = new ArrayList();
        }
        for (V1PodFailurePolicyOnPodConditionsPattern item : items) {
            V1PodFailurePolicyOnPodConditionsPatternBuilder builder = new V1PodFailurePolicyOnPodConditionsPatternBuilder(item);
            this._visitables.get("onPodConditions").add(builder);
            this.onPodConditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToOnPodConditions(Collection<V1PodFailurePolicyOnPodConditionsPattern> items) {
        if (this.onPodConditions == null) {
            this.onPodConditions = new ArrayList();
        }
        for (V1PodFailurePolicyOnPodConditionsPattern item : items) {
            V1PodFailurePolicyOnPodConditionsPatternBuilder builder = new V1PodFailurePolicyOnPodConditionsPatternBuilder(item);
            this._visitables.get("onPodConditions").add(builder);
            this.onPodConditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromOnPodConditions(V1PodFailurePolicyOnPodConditionsPattern ... items) {
        if (this.onPodConditions == null) {
            return (A)this;
        }
        for (V1PodFailurePolicyOnPodConditionsPattern item : items) {
            V1PodFailurePolicyOnPodConditionsPatternBuilder builder = new V1PodFailurePolicyOnPodConditionsPatternBuilder(item);
            this._visitables.get("onPodConditions").remove(builder);
            this.onPodConditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromOnPodConditions(Collection<V1PodFailurePolicyOnPodConditionsPattern> items) {
        if (this.onPodConditions == null) {
            return (A)this;
        }
        for (V1PodFailurePolicyOnPodConditionsPattern item : items) {
            V1PodFailurePolicyOnPodConditionsPatternBuilder builder = new V1PodFailurePolicyOnPodConditionsPatternBuilder(item);
            this._visitables.get("onPodConditions").remove(builder);
            this.onPodConditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromOnPodConditions(Predicate<V1PodFailurePolicyOnPodConditionsPatternBuilder> predicate) {
        if (this.onPodConditions == null) {
            return (A)this;
        }
        Iterator<V1PodFailurePolicyOnPodConditionsPatternBuilder> each = this.onPodConditions.iterator();
        Object visitables = this._visitables.get("onPodConditions");
        while (each.hasNext()) {
            V1PodFailurePolicyOnPodConditionsPatternBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1PodFailurePolicyOnPodConditionsPattern> buildOnPodConditions() {
        return this.onPodConditions != null ? V1PodFailurePolicyRuleFluent.build(this.onPodConditions) : null;
    }

    public V1PodFailurePolicyOnPodConditionsPattern buildOnPodCondition(int index) {
        return this.onPodConditions.get(index).build();
    }

    public V1PodFailurePolicyOnPodConditionsPattern buildFirstOnPodCondition() {
        return this.onPodConditions.get(0).build();
    }

    public V1PodFailurePolicyOnPodConditionsPattern buildLastOnPodCondition() {
        return this.onPodConditions.get(this.onPodConditions.size() - 1).build();
    }

    public V1PodFailurePolicyOnPodConditionsPattern buildMatchingOnPodCondition(Predicate<V1PodFailurePolicyOnPodConditionsPatternBuilder> predicate) {
        for (V1PodFailurePolicyOnPodConditionsPatternBuilder item : this.onPodConditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingOnPodCondition(Predicate<V1PodFailurePolicyOnPodConditionsPatternBuilder> predicate) {
        for (V1PodFailurePolicyOnPodConditionsPatternBuilder item : this.onPodConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withOnPodConditions(List<V1PodFailurePolicyOnPodConditionsPattern> onPodConditions) {
        if (this.onPodConditions != null) {
            this._visitables.get("onPodConditions").clear();
        }
        if (onPodConditions != null) {
            this.onPodConditions = new ArrayList();
            for (V1PodFailurePolicyOnPodConditionsPattern item : onPodConditions) {
                this.addToOnPodConditions(item);
            }
        } else {
            this.onPodConditions = null;
        }
        return (A)this;
    }

    public A withOnPodConditions(V1PodFailurePolicyOnPodConditionsPattern ... onPodConditions) {
        if (this.onPodConditions != null) {
            this.onPodConditions.clear();
            this._visitables.remove("onPodConditions");
        }
        if (onPodConditions != null) {
            for (V1PodFailurePolicyOnPodConditionsPattern item : onPodConditions) {
                this.addToOnPodConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasOnPodConditions() {
        return this.onPodConditions != null && !this.onPodConditions.isEmpty();
    }

    public OnPodConditionsNested<A> addNewOnPodCondition() {
        return new OnPodConditionsNested(-1, null);
    }

    public OnPodConditionsNested<A> addNewOnPodConditionLike(V1PodFailurePolicyOnPodConditionsPattern item) {
        return new OnPodConditionsNested(-1, item);
    }

    public OnPodConditionsNested<A> setNewOnPodConditionLike(int index, V1PodFailurePolicyOnPodConditionsPattern item) {
        return new OnPodConditionsNested(index, item);
    }

    public OnPodConditionsNested<A> editOnPodCondition(int index) {
        if (this.onPodConditions.size() <= index) {
            throw new RuntimeException("Can't edit onPodConditions. Index exceeds size.");
        }
        return this.setNewOnPodConditionLike(index, this.buildOnPodCondition(index));
    }

    public OnPodConditionsNested<A> editFirstOnPodCondition() {
        if (this.onPodConditions.size() == 0) {
            throw new RuntimeException("Can't edit first onPodConditions. The list is empty.");
        }
        return this.setNewOnPodConditionLike(0, this.buildOnPodCondition(0));
    }

    public OnPodConditionsNested<A> editLastOnPodCondition() {
        int index = this.onPodConditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last onPodConditions. The list is empty.");
        }
        return this.setNewOnPodConditionLike(index, this.buildOnPodCondition(index));
    }

    public OnPodConditionsNested<A> editMatchingOnPodCondition(Predicate<V1PodFailurePolicyOnPodConditionsPatternBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.onPodConditions.size(); ++i) {
            if (!predicate.test(this.onPodConditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching onPodConditions. No match found.");
        }
        return this.setNewOnPodConditionLike(index, this.buildOnPodCondition(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PodFailurePolicyRuleFluent that = (V1PodFailurePolicyRuleFluent)o;
        if (!Objects.equals(this.action, that.action)) {
            return false;
        }
        if (!Objects.equals(this.onExitCodes, that.onExitCodes)) {
            return false;
        }
        return Objects.equals(this.onPodConditions, that.onPodConditions);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.action, this.onExitCodes, this.onPodConditions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.action != null) {
            sb.append("action:");
            sb.append(this.action + ",");
        }
        if (this.onExitCodes != null) {
            sb.append("onExitCodes:");
            sb.append(String.valueOf(this.onExitCodes) + ",");
        }
        if (this.onPodConditions != null && !this.onPodConditions.isEmpty()) {
            sb.append("onPodConditions:");
            sb.append(this.onPodConditions);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OnExitCodesNested<N>
    extends V1PodFailurePolicyOnExitCodesRequirementFluent<OnExitCodesNested<N>>
    implements Nested<N> {
        V1PodFailurePolicyOnExitCodesRequirementBuilder builder;

        OnExitCodesNested(V1PodFailurePolicyOnExitCodesRequirement item) {
            this.builder = new V1PodFailurePolicyOnExitCodesRequirementBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodFailurePolicyRuleFluent.this.withOnExitCodes(this.builder.build());
        }

        public N endOnExitCodes() {
            return this.and();
        }
    }

    public class OnPodConditionsNested<N>
    extends V1PodFailurePolicyOnPodConditionsPatternFluent<OnPodConditionsNested<N>>
    implements Nested<N> {
        V1PodFailurePolicyOnPodConditionsPatternBuilder builder;
        int index;

        OnPodConditionsNested(int index, V1PodFailurePolicyOnPodConditionsPattern item) {
            this.index = index;
            this.builder = new V1PodFailurePolicyOnPodConditionsPatternBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodFailurePolicyRuleFluent.this.setToOnPodConditions(this.index, this.builder.build());
        }

        public N endOnPodCondition() {
            return this.and();
        }
    }
}

