/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1ObjectReference;
import java.util.Objects;

public class V1ObjectReferenceFluent<A extends V1ObjectReferenceFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String fieldPath;
    private String kind;
    private String name;
    private String namespace;
    private String resourceVersion;
    private String uid;

    public V1ObjectReferenceFluent() {
    }

    public V1ObjectReferenceFluent(V1ObjectReference instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ObjectReference instance) {
        V1ObjectReference v1ObjectReference = instance = instance != null ? instance : new V1ObjectReference();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withFieldPath(instance.getFieldPath());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withResourceVersion(instance.getResourceVersion());
            this.withUid(instance.getUid());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getFieldPath() {
        return this.fieldPath;
    }

    public A withFieldPath(String fieldPath) {
        this.fieldPath = fieldPath;
        return (A)this;
    }

    public boolean hasFieldPath() {
        return this.fieldPath != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    public boolean hasNamespace() {
        return this.namespace != null;
    }

    public String getResourceVersion() {
        return this.resourceVersion;
    }

    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return (A)this;
    }

    public boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    public boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ObjectReferenceFluent that = (V1ObjectReferenceFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.fieldPath, that.fieldPath)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.resourceVersion, that.resourceVersion)) {
            return false;
        }
        return Objects.equals(this.uid, that.uid);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.fieldPath, this.kind, this.name, this.namespace, this.resourceVersion, this.uid, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.fieldPath != null) {
            sb.append("fieldPath:");
            sb.append(this.fieldPath + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.resourceVersion != null) {
            sb.append("resourceVersion:");
            sb.append(this.resourceVersion + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid);
        }
        sb.append("}");
        return sb.toString();
    }
}

