/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1NodeSelector;
import io.kubernetes.client.openapi.models.V1NodeSelectorTerm;
import io.kubernetes.client.openapi.models.V1NodeSelectorTermBuilder;
import io.kubernetes.client.openapi.models.V1NodeSelectorTermFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1NodeSelectorFluent<A extends V1NodeSelectorFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1NodeSelectorTermBuilder> nodeSelectorTerms;

    public V1NodeSelectorFluent() {
    }

    public V1NodeSelectorFluent(V1NodeSelector instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1NodeSelector instance) {
        V1NodeSelector v1NodeSelector = instance = instance != null ? instance : new V1NodeSelector();
        if (instance != null) {
            this.withNodeSelectorTerms(instance.getNodeSelectorTerms());
        }
    }

    public A addToNodeSelectorTerms(int index, V1NodeSelectorTerm item) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList();
        }
        V1NodeSelectorTermBuilder builder = new V1NodeSelectorTermBuilder(item);
        if (index < 0 || index >= this.nodeSelectorTerms.size()) {
            this._visitables.get("nodeSelectorTerms").add(builder);
            this.nodeSelectorTerms.add(builder);
        } else {
            this._visitables.get("nodeSelectorTerms").add(builder);
            this.nodeSelectorTerms.add(index, builder);
        }
        return (A)this;
    }

    public A setToNodeSelectorTerms(int index, V1NodeSelectorTerm item) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList();
        }
        V1NodeSelectorTermBuilder builder = new V1NodeSelectorTermBuilder(item);
        if (index < 0 || index >= this.nodeSelectorTerms.size()) {
            this._visitables.get("nodeSelectorTerms").add(builder);
            this.nodeSelectorTerms.add(builder);
        } else {
            this._visitables.get("nodeSelectorTerms").add(builder);
            this.nodeSelectorTerms.set(index, builder);
        }
        return (A)this;
    }

    public A addToNodeSelectorTerms(V1NodeSelectorTerm ... items) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList();
        }
        for (V1NodeSelectorTerm item : items) {
            V1NodeSelectorTermBuilder builder = new V1NodeSelectorTermBuilder(item);
            this._visitables.get("nodeSelectorTerms").add(builder);
            this.nodeSelectorTerms.add(builder);
        }
        return (A)this;
    }

    public A addAllToNodeSelectorTerms(Collection<V1NodeSelectorTerm> items) {
        if (this.nodeSelectorTerms == null) {
            this.nodeSelectorTerms = new ArrayList();
        }
        for (V1NodeSelectorTerm item : items) {
            V1NodeSelectorTermBuilder builder = new V1NodeSelectorTermBuilder(item);
            this._visitables.get("nodeSelectorTerms").add(builder);
            this.nodeSelectorTerms.add(builder);
        }
        return (A)this;
    }

    public A removeFromNodeSelectorTerms(V1NodeSelectorTerm ... items) {
        if (this.nodeSelectorTerms == null) {
            return (A)this;
        }
        for (V1NodeSelectorTerm item : items) {
            V1NodeSelectorTermBuilder builder = new V1NodeSelectorTermBuilder(item);
            this._visitables.get("nodeSelectorTerms").remove(builder);
            this.nodeSelectorTerms.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromNodeSelectorTerms(Collection<V1NodeSelectorTerm> items) {
        if (this.nodeSelectorTerms == null) {
            return (A)this;
        }
        for (V1NodeSelectorTerm item : items) {
            V1NodeSelectorTermBuilder builder = new V1NodeSelectorTermBuilder(item);
            this._visitables.get("nodeSelectorTerms").remove(builder);
            this.nodeSelectorTerms.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromNodeSelectorTerms(Predicate<V1NodeSelectorTermBuilder> predicate) {
        if (this.nodeSelectorTerms == null) {
            return (A)this;
        }
        Iterator<V1NodeSelectorTermBuilder> each = this.nodeSelectorTerms.iterator();
        Object visitables = this._visitables.get("nodeSelectorTerms");
        while (each.hasNext()) {
            V1NodeSelectorTermBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1NodeSelectorTerm> buildNodeSelectorTerms() {
        return this.nodeSelectorTerms != null ? V1NodeSelectorFluent.build(this.nodeSelectorTerms) : null;
    }

    public V1NodeSelectorTerm buildNodeSelectorTerm(int index) {
        return this.nodeSelectorTerms.get(index).build();
    }

    public V1NodeSelectorTerm buildFirstNodeSelectorTerm() {
        return this.nodeSelectorTerms.get(0).build();
    }

    public V1NodeSelectorTerm buildLastNodeSelectorTerm() {
        return this.nodeSelectorTerms.get(this.nodeSelectorTerms.size() - 1).build();
    }

    public V1NodeSelectorTerm buildMatchingNodeSelectorTerm(Predicate<V1NodeSelectorTermBuilder> predicate) {
        for (V1NodeSelectorTermBuilder item : this.nodeSelectorTerms) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingNodeSelectorTerm(Predicate<V1NodeSelectorTermBuilder> predicate) {
        for (V1NodeSelectorTermBuilder item : this.nodeSelectorTerms) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNodeSelectorTerms(List<V1NodeSelectorTerm> nodeSelectorTerms) {
        if (this.nodeSelectorTerms != null) {
            this._visitables.get("nodeSelectorTerms").clear();
        }
        if (nodeSelectorTerms != null) {
            this.nodeSelectorTerms = new ArrayList();
            for (V1NodeSelectorTerm item : nodeSelectorTerms) {
                this.addToNodeSelectorTerms(item);
            }
        } else {
            this.nodeSelectorTerms = null;
        }
        return (A)this;
    }

    public A withNodeSelectorTerms(V1NodeSelectorTerm ... nodeSelectorTerms) {
        if (this.nodeSelectorTerms != null) {
            this.nodeSelectorTerms.clear();
            this._visitables.remove("nodeSelectorTerms");
        }
        if (nodeSelectorTerms != null) {
            for (V1NodeSelectorTerm item : nodeSelectorTerms) {
                this.addToNodeSelectorTerms(item);
            }
        }
        return (A)this;
    }

    public boolean hasNodeSelectorTerms() {
        return this.nodeSelectorTerms != null && !this.nodeSelectorTerms.isEmpty();
    }

    public NodeSelectorTermsNested<A> addNewNodeSelectorTerm() {
        return new NodeSelectorTermsNested(-1, null);
    }

    public NodeSelectorTermsNested<A> addNewNodeSelectorTermLike(V1NodeSelectorTerm item) {
        return new NodeSelectorTermsNested(-1, item);
    }

    public NodeSelectorTermsNested<A> setNewNodeSelectorTermLike(int index, V1NodeSelectorTerm item) {
        return new NodeSelectorTermsNested(index, item);
    }

    public NodeSelectorTermsNested<A> editNodeSelectorTerm(int index) {
        if (this.nodeSelectorTerms.size() <= index) {
            throw new RuntimeException("Can't edit nodeSelectorTerms. Index exceeds size.");
        }
        return this.setNewNodeSelectorTermLike(index, this.buildNodeSelectorTerm(index));
    }

    public NodeSelectorTermsNested<A> editFirstNodeSelectorTerm() {
        if (this.nodeSelectorTerms.size() == 0) {
            throw new RuntimeException("Can't edit first nodeSelectorTerms. The list is empty.");
        }
        return this.setNewNodeSelectorTermLike(0, this.buildNodeSelectorTerm(0));
    }

    public NodeSelectorTermsNested<A> editLastNodeSelectorTerm() {
        int index = this.nodeSelectorTerms.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last nodeSelectorTerms. The list is empty.");
        }
        return this.setNewNodeSelectorTermLike(index, this.buildNodeSelectorTerm(index));
    }

    public NodeSelectorTermsNested<A> editMatchingNodeSelectorTerm(Predicate<V1NodeSelectorTermBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.nodeSelectorTerms.size(); ++i) {
            if (!predicate.test(this.nodeSelectorTerms.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching nodeSelectorTerms. No match found.");
        }
        return this.setNewNodeSelectorTermLike(index, this.buildNodeSelectorTerm(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1NodeSelectorFluent that = (V1NodeSelectorFluent)o;
        return Objects.equals(this.nodeSelectorTerms, that.nodeSelectorTerms);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nodeSelectorTerms, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.nodeSelectorTerms != null && !this.nodeSelectorTerms.isEmpty()) {
            sb.append("nodeSelectorTerms:");
            sb.append(this.nodeSelectorTerms);
        }
        sb.append("}");
        return sb.toString();
    }

    public class NodeSelectorTermsNested<N>
    extends V1NodeSelectorTermFluent<NodeSelectorTermsNested<N>>
    implements Nested<N> {
        V1NodeSelectorTermBuilder builder;
        int index;

        NodeSelectorTermsNested(int index, V1NodeSelectorTerm item) {
            this.index = index;
            this.builder = new V1NodeSelectorTermBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1NodeSelectorFluent.this.setToNodeSelectorTerms(this.index, this.builder.build());
        }

        public N endNodeSelectorTerm() {
            return this.and();
        }
    }
}

