/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="NetworkPolicyPort describes a port to allow traffic on")
public class V1NetworkPolicyPort {
    public static final String SERIALIZED_NAME_END_PORT = "endPort";
    @SerializedName(value="endPort")
    @Nullable
    private Integer endPort;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    @Nullable
    private IntOrString port;
    public static final String SERIALIZED_NAME_PROTOCOL = "protocol";
    @SerializedName(value="protocol")
    @Nullable
    private String protocol;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1NetworkPolicyPort endPort(@Nullable Integer endPort) {
        this.endPort = endPort;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="endPort indicates that the range of ports from port to endPort if set, inclusive, should be allowed by the policy. This field cannot be defined if the port field is not defined or if the port field is defined as a named (string) port. The endPort must be equal or greater than port.")
    public Integer getEndPort() {
        return this.endPort;
    }

    public void setEndPort(@Nullable Integer endPort) {
        this.endPort = endPort;
    }

    public V1NetworkPolicyPort port(@Nullable IntOrString port) {
        this.port = port;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number.")
    public IntOrString getPort() {
        return this.port;
    }

    public void setPort(@Nullable IntOrString port) {
        this.port = port;
    }

    public V1NetworkPolicyPort protocol(@Nullable String protocol) {
        this.protocol = protocol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="protocol represents the protocol (TCP, UDP, or SCTP) which traffic must match. If not specified, this field defaults to TCP.")
    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(@Nullable String protocol) {
        this.protocol = protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1NetworkPolicyPort v1NetworkPolicyPort = (V1NetworkPolicyPort)o;
        return Objects.equals(this.endPort, v1NetworkPolicyPort.endPort) && Objects.equals(this.port, v1NetworkPolicyPort.port) && Objects.equals(this.protocol, v1NetworkPolicyPort.protocol);
    }

    public int hashCode() {
        return Objects.hash(this.endPort, this.port, this.protocol);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1NetworkPolicyPort {\n");
        sb.append("    endPort: ").append(this.toIndentedString(this.endPort)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("    protocol: ").append(this.toIndentedString(this.protocol)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1NetworkPolicyPort is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1NetworkPolicyPort` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_PORT) != null && !jsonObj.get(SERIALIZED_NAME_PORT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PORT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `port` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PORT).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PROTOCOL) != null && !jsonObj.get(SERIALIZED_NAME_PROTOCOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PROTOCOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `protocol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PROTOCOL).toString()));
        }
    }

    public static V1NetworkPolicyPort fromJson(String jsonString) throws IOException {
        return (V1NetworkPolicyPort)JSON.getGson().fromJson(jsonString, V1NetworkPolicyPort.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_END_PORT);
        openapiFields.add(SERIALIZED_NAME_PORT);
        openapiFields.add(SERIALIZED_NAME_PROTOCOL);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1NetworkPolicyPort.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1NetworkPolicyPort.class));
            return new TypeAdapter<V1NetworkPolicyPort>(){

                public void write(JsonWriter out, V1NetworkPolicyPort value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1NetworkPolicyPort read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1NetworkPolicyPort.validateJsonElement(jsonElement);
                    return (V1NetworkPolicyPort)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

