/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ImageVolumeSource represents a image volume resource.")
public class V1ImageVolumeSource {
    public static final String SERIALIZED_NAME_PULL_POLICY = "pullPolicy";
    @SerializedName(value="pullPolicy")
    @Nullable
    private String pullPolicy;
    public static final String SERIALIZED_NAME_REFERENCE = "reference";
    @SerializedName(value="reference")
    @Nullable
    private String reference;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ImageVolumeSource pullPolicy(@Nullable String pullPolicy) {
        this.pullPolicy = pullPolicy;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Policy for pulling OCI objects. Possible values are: Always: the kubelet always attempts to pull the reference. Container creation will fail If the pull fails. Never: the kubelet never pulls the reference and only uses a local image or artifact. Container creation will fail if the reference isn't present. IfNotPresent: the kubelet pulls if the reference isn't already present on disk. Container creation will fail if the reference isn't present and the pull fails. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.")
    public String getPullPolicy() {
        return this.pullPolicy;
    }

    public void setPullPolicy(@Nullable String pullPolicy) {
        this.pullPolicy = pullPolicy;
    }

    public V1ImageVolumeSource reference(@Nullable String reference) {
        this.reference = reference;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Required: Image or artifact reference to be used. Behaves in the same way as pod.spec.containers[*].image. Pull secrets will be assembled in the same way as for the container image by looking up node credentials, SA image pull secrets, and pod spec image pull secrets. More info: https://kubernetes.io/docs/concepts/containers/images This field is optional to allow higher level config management to default or override container images in workload controllers like Deployments and StatefulSets.")
    public String getReference() {
        return this.reference;
    }

    public void setReference(@Nullable String reference) {
        this.reference = reference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ImageVolumeSource v1ImageVolumeSource = (V1ImageVolumeSource)o;
        return Objects.equals(this.pullPolicy, v1ImageVolumeSource.pullPolicy) && Objects.equals(this.reference, v1ImageVolumeSource.reference);
    }

    public int hashCode() {
        return Objects.hash(this.pullPolicy, this.reference);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ImageVolumeSource {\n");
        sb.append("    pullPolicy: ").append(this.toIndentedString(this.pullPolicy)).append("\n");
        sb.append("    reference: ").append(this.toIndentedString(this.reference)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ImageVolumeSource is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ImageVolumeSource` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_PULL_POLICY) != null && !jsonObj.get(SERIALIZED_NAME_PULL_POLICY).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_PULL_POLICY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `pullPolicy` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PULL_POLICY).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REFERENCE) != null && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_REFERENCE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reference` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REFERENCE).toString()));
        }
    }

    public static V1ImageVolumeSource fromJson(String jsonString) throws IOException {
        return (V1ImageVolumeSource)JSON.getGson().fromJson(jsonString, V1ImageVolumeSource.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_PULL_POLICY);
        openapiFields.add(SERIALIZED_NAME_REFERENCE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ImageVolumeSource.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ImageVolumeSource.class));
            return new TypeAdapter<V1ImageVolumeSource>(){

                public void write(JsonWriter out, V1ImageVolumeSource value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ImageVolumeSource read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ImageVolumeSource.validateJsonElement(jsonElement);
                    return (V1ImageVolumeSource)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

