/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="IPBlock describes a particular CIDR (Ex. \"192.168.1.0/24\",\"2001:db8::/64\") that is allowed to the pods matched by a NetworkPolicySpec's podSelector. The except entry describes CIDRs that should not be included within this rule.")
public class V1IPBlock {
    public static final String SERIALIZED_NAME_CIDR = "cidr";
    @SerializedName(value="cidr")
    @Nonnull
    private String cidr;
    public static final String SERIALIZED_NAME_EXCEPT = "except";
    @SerializedName(value="except")
    @Nullable
    private List<String> except = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1IPBlock cidr(@Nonnull String cidr) {
        this.cidr = cidr;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="cidr is a string representing the IPBlock Valid examples are \"192.168.1.0/24\" or \"2001:db8::/64\"")
    public String getCidr() {
        return this.cidr;
    }

    public void setCidr(@Nonnull String cidr) {
        this.cidr = cidr;
    }

    public V1IPBlock except(@Nullable List<String> except) {
        this.except = except;
        return this;
    }

    public V1IPBlock addExceptItem(String exceptItem) {
        if (this.except == null) {
            this.except = new ArrayList<String>();
        }
        this.except.add(exceptItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="except is a slice of CIDRs that should not be included within an IPBlock Valid examples are \"192.168.1.0/24\" or \"2001:db8::/64\" Except values will be rejected if they are outside the cidr range")
    public List<String> getExcept() {
        return this.except;
    }

    public void setExcept(@Nullable List<String> except) {
        this.except = except;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1IPBlock v1IPBlock = (V1IPBlock)o;
        return Objects.equals(this.cidr, v1IPBlock.cidr) && Objects.equals(this.except, v1IPBlock.except);
    }

    public int hashCode() {
        return Objects.hash(this.cidr, this.except);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1IPBlock {\n");
        sb.append("    cidr: ").append(this.toIndentedString(this.cidr)).append("\n");
        sb.append("    except: ").append(this.toIndentedString(this.except)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1IPBlock is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1IPBlock` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_CIDR).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cidr` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CIDR).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXCEPT) != null && !jsonObj.get(SERIALIZED_NAME_EXCEPT).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EXCEPT).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `except` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXCEPT).toString()));
        }
    }

    public static V1IPBlock fromJson(String jsonString) throws IOException {
        return (V1IPBlock)JSON.getGson().fromJson(jsonString, V1IPBlock.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CIDR);
        openapiFields.add(SERIALIZED_NAME_EXCEPT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CIDR);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1IPBlock.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1IPBlock.class));
            return new TypeAdapter<V1IPBlock>(){

                public void write(JsonWriter out, V1IPBlock value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1IPBlock read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1IPBlock.validateJsonElement(jsonElement);
                    return (V1IPBlock)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

