/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1CrossVersionObjectReference;
import io.kubernetes.client.openapi.models.V1CrossVersionObjectReferenceBuilder;
import io.kubernetes.client.openapi.models.V1CrossVersionObjectReferenceFluent;
import io.kubernetes.client.openapi.models.V1HorizontalPodAutoscalerSpec;
import java.util.Objects;
import java.util.Optional;

public class V1HorizontalPodAutoscalerSpecFluent<A extends V1HorizontalPodAutoscalerSpecFluent<A>>
extends BaseFluent<A> {
    private Integer maxReplicas;
    private Integer minReplicas;
    private V1CrossVersionObjectReferenceBuilder scaleTargetRef;
    private Integer targetCPUUtilizationPercentage;

    public V1HorizontalPodAutoscalerSpecFluent() {
    }

    public V1HorizontalPodAutoscalerSpecFluent(V1HorizontalPodAutoscalerSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1HorizontalPodAutoscalerSpec instance) {
        V1HorizontalPodAutoscalerSpec v1HorizontalPodAutoscalerSpec = instance = instance != null ? instance : new V1HorizontalPodAutoscalerSpec();
        if (instance != null) {
            this.withMaxReplicas(instance.getMaxReplicas());
            this.withMinReplicas(instance.getMinReplicas());
            this.withScaleTargetRef(instance.getScaleTargetRef());
            this.withTargetCPUUtilizationPercentage(instance.getTargetCPUUtilizationPercentage());
        }
    }

    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas = maxReplicas;
        return (A)this;
    }

    public boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas = minReplicas;
        return (A)this;
    }

    public boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    public V1CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef != null ? this.scaleTargetRef.build() : null;
    }

    public A withScaleTargetRef(V1CrossVersionObjectReference scaleTargetRef) {
        this._visitables.remove("scaleTargetRef");
        if (scaleTargetRef != null) {
            this.scaleTargetRef = new V1CrossVersionObjectReferenceBuilder(scaleTargetRef);
            this._visitables.get("scaleTargetRef").add(this.scaleTargetRef);
        } else {
            this.scaleTargetRef = null;
            this._visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
        }
        return (A)this;
    }

    public boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNested(null);
    }

    public ScaleTargetRefNested<A> withNewScaleTargetRefLike(V1CrossVersionObjectReference item) {
        return new ScaleTargetRefNested(item);
    }

    public ScaleTargetRefNested<A> editScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(null));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(new V1CrossVersionObjectReferenceBuilder().build()));
    }

    public ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(V1CrossVersionObjectReference item) {
        return this.withNewScaleTargetRefLike(Optional.ofNullable(this.buildScaleTargetRef()).orElse(item));
    }

    public Integer getTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage;
    }

    public A withTargetCPUUtilizationPercentage(Integer targetCPUUtilizationPercentage) {
        this.targetCPUUtilizationPercentage = targetCPUUtilizationPercentage;
        return (A)this;
    }

    public boolean hasTargetCPUUtilizationPercentage() {
        return this.targetCPUUtilizationPercentage != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1HorizontalPodAutoscalerSpecFluent that = (V1HorizontalPodAutoscalerSpecFluent)o;
        if (!Objects.equals(this.maxReplicas, that.maxReplicas)) {
            return false;
        }
        if (!Objects.equals(this.minReplicas, that.minReplicas)) {
            return false;
        }
        if (!Objects.equals(this.scaleTargetRef, that.scaleTargetRef)) {
            return false;
        }
        return Objects.equals(this.targetCPUUtilizationPercentage, that.targetCPUUtilizationPercentage);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.maxReplicas, this.minReplicas, this.scaleTargetRef, this.targetCPUUtilizationPercentage, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.maxReplicas != null) {
            sb.append("maxReplicas:");
            sb.append(this.maxReplicas + ",");
        }
        if (this.minReplicas != null) {
            sb.append("minReplicas:");
            sb.append(this.minReplicas + ",");
        }
        if (this.scaleTargetRef != null) {
            sb.append("scaleTargetRef:");
            sb.append(String.valueOf(this.scaleTargetRef) + ",");
        }
        if (this.targetCPUUtilizationPercentage != null) {
            sb.append("targetCPUUtilizationPercentage:");
            sb.append(this.targetCPUUtilizationPercentage);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ScaleTargetRefNested<N>
    extends V1CrossVersionObjectReferenceFluent<ScaleTargetRefNested<N>>
    implements Nested<N> {
        V1CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNested(V1CrossVersionObjectReference item) {
            this.builder = new V1CrossVersionObjectReferenceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1HorizontalPodAutoscalerSpecFluent.this.withScaleTargetRef(this.builder.build());
        }

        public N endScaleTargetRef() {
            return this.and();
        }
    }
}

