/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="ExecAction describes a \"run in container\" action.")
public class V1ExecAction {
    public static final String SERIALIZED_NAME_COMMAND = "command";
    @SerializedName(value="command")
    @Nullable
    private List<String> command = new ArrayList<String>();
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1ExecAction command(@Nullable List<String> command) {
        this.command = command;
        return this;
    }

    public V1ExecAction addCommandItem(String commandItem) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(commandItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.")
    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(@Nullable List<String> command) {
        this.command = command;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1ExecAction v1ExecAction = (V1ExecAction)o;
        return Objects.equals(this.command, v1ExecAction.command);
    }

    public int hashCode() {
        return Objects.hash(this.command);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1ExecAction {\n");
        sb.append("    command: ").append(this.toIndentedString(this.command)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1ExecAction is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1ExecAction` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_COMMAND) != null && !jsonObj.get(SERIALIZED_NAME_COMMAND).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_COMMAND).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `command` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_COMMAND).toString()));
        }
    }

    public static V1ExecAction fromJson(String jsonString) throws IOException {
        return (V1ExecAction)JSON.getGson().fromJson(jsonString, V1ExecAction.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_COMMAND);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1ExecAction.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1ExecAction.class));
            return new TypeAdapter<V1ExecAction>(){

                public void write(JsonWriter out, V1ExecAction value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1ExecAction read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    V1ExecAction.validateJsonElement(jsonElement);
                    return (V1ExecAction)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

