/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1APIResource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1APIResourceFluent<A extends V1APIResourceFluent<A>>
extends BaseFluent<A> {
    private List<String> categories;
    private String group;
    private String kind;
    private String name;
    private Boolean namespaced;
    private List<String> shortNames;
    private String singularName;
    private String storageVersionHash;
    private List<String> verbs;
    private String version;

    public V1APIResourceFluent() {
    }

    public V1APIResourceFluent(V1APIResource instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1APIResource instance) {
        V1APIResource v1APIResource = instance = instance != null ? instance : new V1APIResource();
        if (instance != null) {
            this.withCategories(instance.getCategories());
            this.withGroup(instance.getGroup());
            this.withKind(instance.getKind());
            this.withName(instance.getName());
            this.withNamespaced(instance.getNamespaced());
            this.withShortNames(instance.getShortNames());
            this.withSingularName(instance.getSingularName());
            this.withStorageVersionHash(instance.getStorageVersionHash());
            this.withVerbs(instance.getVerbs());
            this.withVersion(instance.getVersion());
        }
    }

    public A addToCategories(int index, String item) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.add(index, item);
        return (A)this;
    }

    public A setToCategories(int index, String item) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        this.categories.set(index, item);
        return (A)this;
    }

    public A addToCategories(String ... items) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        for (String item : items) {
            this.categories.add(item);
        }
        return (A)this;
    }

    public A addAllToCategories(Collection<String> items) {
        if (this.categories == null) {
            this.categories = new ArrayList<String>();
        }
        for (String item : items) {
            this.categories.add(item);
        }
        return (A)this;
    }

    public A removeFromCategories(String ... items) {
        if (this.categories == null) {
            return (A)this;
        }
        for (String item : items) {
            this.categories.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCategories(Collection<String> items) {
        if (this.categories == null) {
            return (A)this;
        }
        for (String item : items) {
            this.categories.remove(item);
        }
        return (A)this;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public String getCategory(int index) {
        return this.categories.get(index);
    }

    public String getFirstCategory() {
        return this.categories.get(0);
    }

    public String getLastCategory() {
        return this.categories.get(this.categories.size() - 1);
    }

    public String getMatchingCategory(Predicate<String> predicate) {
        for (String item : this.categories) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCategory(Predicate<String> predicate) {
        for (String item : this.categories) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCategories(List<String> categories) {
        if (categories != null) {
            this.categories = new ArrayList<String>();
            for (String item : categories) {
                this.addToCategories(item);
            }
        } else {
            this.categories = null;
        }
        return (A)this;
    }

    public A withCategories(String ... categories) {
        if (this.categories != null) {
            this.categories.clear();
            this._visitables.remove("categories");
        }
        if (categories != null) {
            for (String item : categories) {
                this.addToCategories(item);
            }
        }
        return (A)this;
    }

    public boolean hasCategories() {
        return this.categories != null && !this.categories.isEmpty();
    }

    public String getGroup() {
        return this.group;
    }

    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public Boolean getNamespaced() {
        return this.namespaced;
    }

    public A withNamespaced(Boolean namespaced) {
        this.namespaced = namespaced;
        return (A)this;
    }

    public boolean hasNamespaced() {
        return this.namespaced != null;
    }

    public A addToShortNames(int index, String item) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        this.shortNames.add(index, item);
        return (A)this;
    }

    public A setToShortNames(int index, String item) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        this.shortNames.set(index, item);
        return (A)this;
    }

    public A addToShortNames(String ... items) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.shortNames.add(item);
        }
        return (A)this;
    }

    public A addAllToShortNames(Collection<String> items) {
        if (this.shortNames == null) {
            this.shortNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.shortNames.add(item);
        }
        return (A)this;
    }

    public A removeFromShortNames(String ... items) {
        if (this.shortNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.shortNames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromShortNames(Collection<String> items) {
        if (this.shortNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.shortNames.remove(item);
        }
        return (A)this;
    }

    public List<String> getShortNames() {
        return this.shortNames;
    }

    public String getShortName(int index) {
        return this.shortNames.get(index);
    }

    public String getFirstShortName() {
        return this.shortNames.get(0);
    }

    public String getLastShortName() {
        return this.shortNames.get(this.shortNames.size() - 1);
    }

    public String getMatchingShortName(Predicate<String> predicate) {
        for (String item : this.shortNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingShortName(Predicate<String> predicate) {
        for (String item : this.shortNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withShortNames(List<String> shortNames) {
        if (shortNames != null) {
            this.shortNames = new ArrayList<String>();
            for (String item : shortNames) {
                this.addToShortNames(item);
            }
        } else {
            this.shortNames = null;
        }
        return (A)this;
    }

    public A withShortNames(String ... shortNames) {
        if (this.shortNames != null) {
            this.shortNames.clear();
            this._visitables.remove("shortNames");
        }
        if (shortNames != null) {
            for (String item : shortNames) {
                this.addToShortNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasShortNames() {
        return this.shortNames != null && !this.shortNames.isEmpty();
    }

    public String getSingularName() {
        return this.singularName;
    }

    public A withSingularName(String singularName) {
        this.singularName = singularName;
        return (A)this;
    }

    public boolean hasSingularName() {
        return this.singularName != null;
    }

    public String getStorageVersionHash() {
        return this.storageVersionHash;
    }

    public A withStorageVersionHash(String storageVersionHash) {
        this.storageVersionHash = storageVersionHash;
        return (A)this;
    }

    public boolean hasStorageVersionHash() {
        return this.storageVersionHash != null;
    }

    public A addToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)this;
    }

    public A setToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.set(index, item);
        return (A)this;
    }

    public A addToVerbs(String ... items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    public A addAllToVerbs(Collection<String> items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    public A removeFromVerbs(String ... items) {
        if (this.verbs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.verbs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromVerbs(Collection<String> items) {
        if (this.verbs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.verbs.remove(item);
        }
        return (A)this;
    }

    public List<String> getVerbs() {
        return this.verbs;
    }

    public String getVerb(int index) {
        return this.verbs.get(index);
    }

    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVerbs(List<String> verbs) {
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)this;
    }

    public A withVerbs(String ... verbs) {
        if (this.verbs != null) {
            this.verbs.clear();
            this._visitables.remove("verbs");
        }
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)this;
    }

    public boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    public String getVersion() {
        return this.version;
    }

    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    public boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1APIResourceFluent that = (V1APIResourceFluent)o;
        if (!Objects.equals(this.categories, that.categories)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespaced, that.namespaced)) {
            return false;
        }
        if (!Objects.equals(this.shortNames, that.shortNames)) {
            return false;
        }
        if (!Objects.equals(this.singularName, that.singularName)) {
            return false;
        }
        if (!Objects.equals(this.storageVersionHash, that.storageVersionHash)) {
            return false;
        }
        if (!Objects.equals(this.verbs, that.verbs)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.categories, this.group, this.kind, this.name, this.namespaced, this.shortNames, this.singularName, this.storageVersionHash, this.verbs, this.version, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.categories != null && !this.categories.isEmpty()) {
            sb.append("categories:");
            sb.append(String.valueOf(this.categories) + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespaced != null) {
            sb.append("namespaced:");
            sb.append(this.namespaced + ",");
        }
        if (this.shortNames != null && !this.shortNames.isEmpty()) {
            sb.append("shortNames:");
            sb.append(String.valueOf(this.shortNames) + ",");
        }
        if (this.singularName != null) {
            sb.append("singularName:");
            sb.append(this.singularName + ",");
        }
        if (this.storageVersionHash != null) {
            sb.append("storageVersionHash:");
            sb.append(this.storageVersionHash + ",");
        }
        if (this.verbs != null && !this.verbs.isEmpty()) {
            sb.append("verbs:");
            sb.append(String.valueOf(this.verbs) + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withNamespaced() {
        return this.withNamespaced(true);
    }
}

