/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1ObjectMetaBuilder;
import io.kubernetes.client.openapi.models.V1ObjectMetaFluent;
import io.kubernetes.client.openapi.models.V1beta2FlowSchema;
import io.kubernetes.client.openapi.models.V1beta2FlowSchemaSpec;
import io.kubernetes.client.openapi.models.V1beta2FlowSchemaSpecBuilder;
import io.kubernetes.client.openapi.models.V1beta2FlowSchemaSpecFluent;
import io.kubernetes.client.openapi.models.V1beta2FlowSchemaStatus;
import io.kubernetes.client.openapi.models.V1beta2FlowSchemaStatusBuilder;
import io.kubernetes.client.openapi.models.V1beta2FlowSchemaStatusFluent;
import java.util.Objects;
import java.util.Optional;

public class V1beta2FlowSchemaFluent<A extends V1beta2FlowSchemaFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private String kind;
    private V1ObjectMetaBuilder metadata;
    private V1beta2FlowSchemaSpecBuilder spec;
    private V1beta2FlowSchemaStatusBuilder status;

    public V1beta2FlowSchemaFluent() {
    }

    public V1beta2FlowSchemaFluent(V1beta2FlowSchema instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1beta2FlowSchema instance) {
        V1beta2FlowSchema v1beta2FlowSchema = instance = instance != null ? instance : new V1beta2FlowSchema();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public V1ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(V1ObjectMeta metadata) {
        this._visitables.remove("metadata");
        if (metadata != null) {
            this.metadata = new V1ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(V1ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new V1ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(V1ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public V1beta2FlowSchemaSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(V1beta2FlowSchemaSpec spec) {
        this._visitables.remove("spec");
        if (spec != null) {
            this.spec = new V1beta2FlowSchemaSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get("spec").remove(this.spec);
        }
        return (A)this;
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(V1beta2FlowSchemaSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new V1beta2FlowSchemaSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(V1beta2FlowSchemaSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    public V1beta2FlowSchemaStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    public A withStatus(V1beta2FlowSchemaStatus status) {
        this._visitables.remove("status");
        if (status != null) {
            this.status = new V1beta2FlowSchemaStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get("status").remove(this.status);
        }
        return (A)this;
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public StatusNested<A> withNewStatus() {
        return new StatusNested(null);
    }

    public StatusNested<A> withNewStatusLike(V1beta2FlowSchemaStatus item) {
        return new StatusNested(item);
    }

    public StatusNested<A> editStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(null));
    }

    public StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(new V1beta2FlowSchemaStatusBuilder().build()));
    }

    public StatusNested<A> editOrNewStatusLike(V1beta2FlowSchemaStatus item) {
        return this.withNewStatusLike(Optional.ofNullable(this.buildStatus()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1beta2FlowSchemaFluent that = (V1beta2FlowSchemaFluent)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        return Objects.equals(this.status, that.status);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status);
        }
        sb.append("}");
        return sb.toString();
    }

    public class MetadataNested<N>
    extends V1ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        V1ObjectMetaBuilder builder;

        MetadataNested(V1ObjectMeta item) {
            this.builder = new V1ObjectMetaBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta2FlowSchemaFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends V1beta2FlowSchemaSpecFluent<SpecNested<N>>
    implements Nested<N> {
        V1beta2FlowSchemaSpecBuilder builder;

        SpecNested(V1beta2FlowSchemaSpec item) {
            this.builder = new V1beta2FlowSchemaSpecBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta2FlowSchemaFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class StatusNested<N>
    extends V1beta2FlowSchemaStatusFluent<StatusNested<N>>
    implements Nested<N> {
        V1beta2FlowSchemaStatusBuilder builder;

        StatusNested(V1beta2FlowSchemaStatus item) {
            this.builder = new V1beta2FlowSchemaStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1beta2FlowSchemaFluent.this.withStatus(this.builder.build());
        }

        public N endStatus() {
            return this.and();
        }
    }
}

