/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.kubernetes.client.openapi.JSON;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class V1RuleWithOperations {
    public static final String SERIALIZED_NAME_API_GROUPS = "apiGroups";
    @SerializedName(value="apiGroups")
    private List<String> apiGroups;
    public static final String SERIALIZED_NAME_API_VERSIONS = "apiVersions";
    @SerializedName(value="apiVersions")
    private List<String> apiVersions;
    public static final String SERIALIZED_NAME_OPERATIONS = "operations";
    @SerializedName(value="operations")
    private List<String> operations;
    public static final String SERIALIZED_NAME_RESOURCES = "resources";
    @SerializedName(value="resources")
    private List<String> resources;
    public static final String SERIALIZED_NAME_SCOPE = "scope";
    @SerializedName(value="scope")
    private String scope;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public V1RuleWithOperations apiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
        return this;
    }

    public V1RuleWithOperations addApiGroupsItem(String apiGroupsItem) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(apiGroupsItem);
        return this;
    }

    @Nullable
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public void setApiGroups(List<String> apiGroups) {
        this.apiGroups = apiGroups;
    }

    public V1RuleWithOperations apiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
        return this;
    }

    public V1RuleWithOperations addApiVersionsItem(String apiVersionsItem) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.add(apiVersionsItem);
        return this;
    }

    @Nullable
    public List<String> getApiVersions() {
        return this.apiVersions;
    }

    public void setApiVersions(List<String> apiVersions) {
        this.apiVersions = apiVersions;
    }

    public V1RuleWithOperations operations(List<String> operations) {
        this.operations = operations;
        return this;
    }

    public V1RuleWithOperations addOperationsItem(String operationsItem) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        this.operations.add(operationsItem);
        return this;
    }

    @Nullable
    public List<String> getOperations() {
        return this.operations;
    }

    public void setOperations(List<String> operations) {
        this.operations = operations;
    }

    public V1RuleWithOperations resources(List<String> resources) {
        this.resources = resources;
        return this;
    }

    public V1RuleWithOperations addResourcesItem(String resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nullable
    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(List<String> resources) {
        this.resources = resources;
    }

    public V1RuleWithOperations scope(String scope) {
        this.scope = scope;
        return this;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1RuleWithOperations v1RuleWithOperations = (V1RuleWithOperations)o;
        return Objects.equals(this.apiGroups, v1RuleWithOperations.apiGroups) && Objects.equals(this.apiVersions, v1RuleWithOperations.apiVersions) && Objects.equals(this.operations, v1RuleWithOperations.operations) && Objects.equals(this.resources, v1RuleWithOperations.resources) && Objects.equals(this.scope, v1RuleWithOperations.scope);
    }

    public int hashCode() {
        return Objects.hash(this.apiGroups, this.apiVersions, this.operations, this.resources, this.scope);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1RuleWithOperations {\n");
        sb.append("    apiGroups: ").append(this.toIndentedString(this.apiGroups)).append("\n");
        sb.append("    apiVersions: ").append(this.toIndentedString(this.apiVersions)).append("\n");
        sb.append("    operations: ").append(this.toIndentedString(this.operations)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    scope: ").append(this.toIndentedString(this.scope)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in V1RuleWithOperations is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonObj.entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `V1RuleWithOperations` properties. JSON: %s", entry.getKey(), jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_GROUPS) != null && !jsonObj.get(SERIALIZED_NAME_API_GROUPS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiGroups` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_GROUPS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_API_VERSIONS) != null && !jsonObj.get(SERIALIZED_NAME_API_VERSIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `apiVersions` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_API_VERSIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPERATIONS) != null && !jsonObj.get(SERIALIZED_NAME_OPERATIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `operations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPERATIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_RESOURCES) != null && !jsonObj.get(SERIALIZED_NAME_RESOURCES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `resources` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RESOURCES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SCOPE) != null && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SCOPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `scope` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SCOPE).toString()));
        }
    }

    public static V1RuleWithOperations fromJson(String jsonString) throws IOException {
        return (V1RuleWithOperations)JSON.getGson().fromJson(jsonString, V1RuleWithOperations.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_API_GROUPS);
        openapiFields.add(SERIALIZED_NAME_API_VERSIONS);
        openapiFields.add(SERIALIZED_NAME_OPERATIONS);
        openapiFields.add(SERIALIZED_NAME_RESOURCES);
        openapiFields.add(SERIALIZED_NAME_SCOPE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!V1RuleWithOperations.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(V1RuleWithOperations.class));
            return new TypeAdapter<V1RuleWithOperations>(){

                public void write(JsonWriter out, V1RuleWithOperations value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public V1RuleWithOperations read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    V1RuleWithOperations.validateJsonObject(jsonObj);
                    return (V1RuleWithOperations)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

