/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1ResourceRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ResourceRuleFluent<A extends V1ResourceRuleFluent<A>>
extends BaseFluent<A> {
    private List<String> apiGroups;
    private List<String> resourceNames;
    private List<String> resources;
    private List<String> verbs;

    public V1ResourceRuleFluent() {
    }

    public V1ResourceRuleFluent(V1ResourceRule instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1ResourceRule instance) {
        V1ResourceRule v1ResourceRule = instance = instance != null ? instance : new V1ResourceRule();
        if (instance != null) {
            this.withApiGroups(instance.getApiGroups());
            this.withResourceNames(instance.getResourceNames());
            this.withResources(instance.getResources());
            this.withVerbs(instance.getVerbs());
        }
    }

    public A addToApiGroups(int index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(index, item);
        return (A)this;
    }

    public A setToApiGroups(int index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.set(index, item);
        return (A)this;
    }

    public A addToApiGroups(String ... items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)this;
    }

    public A addAllToApiGroups(Collection<String> items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)this;
    }

    public A removeFromApiGroups(String ... items) {
        if (this.apiGroups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.apiGroups.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromApiGroups(Collection<String> items) {
        if (this.apiGroups == null) {
            return (A)this;
        }
        for (String item : items) {
            this.apiGroups.remove(item);
        }
        return (A)this;
    }

    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    public String getApiGroup(int index) {
        return this.apiGroups.get(index);
    }

    public String getFirstApiGroup() {
        return this.apiGroups.get(0);
    }

    public String getLastApiGroup() {
        return this.apiGroups.get(this.apiGroups.size() - 1);
    }

    public String getMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withApiGroups(List<String> apiGroups) {
        if (apiGroups != null) {
            this.apiGroups = new ArrayList<String>();
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        } else {
            this.apiGroups = null;
        }
        return (A)this;
    }

    public A withApiGroups(String ... apiGroups) {
        if (this.apiGroups != null) {
            this.apiGroups.clear();
            this._visitables.remove("apiGroups");
        }
        if (apiGroups != null) {
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        }
        return (A)this;
    }

    public boolean hasApiGroups() {
        return this.apiGroups != null && !this.apiGroups.isEmpty();
    }

    public A addToResourceNames(int index, String item) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.add(index, item);
        return (A)this;
    }

    public A setToResourceNames(int index, String item) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.set(index, item);
        return (A)this;
    }

    public A addToResourceNames(String ... items) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.resourceNames.add(item);
        }
        return (A)this;
    }

    public A addAllToResourceNames(Collection<String> items) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.resourceNames.add(item);
        }
        return (A)this;
    }

    public A removeFromResourceNames(String ... items) {
        if (this.resourceNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.resourceNames.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromResourceNames(Collection<String> items) {
        if (this.resourceNames == null) {
            return (A)this;
        }
        for (String item : items) {
            this.resourceNames.remove(item);
        }
        return (A)this;
    }

    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    public String getResourceName(int index) {
        return this.resourceNames.get(index);
    }

    public String getFirstResourceName() {
        return this.resourceNames.get(0);
    }

    public String getLastResourceName() {
        return this.resourceNames.get(this.resourceNames.size() - 1);
    }

    public String getMatchingResourceName(Predicate<String> predicate) {
        for (String item : this.resourceNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingResourceName(Predicate<String> predicate) {
        for (String item : this.resourceNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceNames(List<String> resourceNames) {
        if (resourceNames != null) {
            this.resourceNames = new ArrayList<String>();
            for (String item : resourceNames) {
                this.addToResourceNames(item);
            }
        } else {
            this.resourceNames = null;
        }
        return (A)this;
    }

    public A withResourceNames(String ... resourceNames) {
        if (this.resourceNames != null) {
            this.resourceNames.clear();
            this._visitables.remove("resourceNames");
        }
        if (resourceNames != null) {
            for (String item : resourceNames) {
                this.addToResourceNames(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceNames() {
        return this.resourceNames != null && !this.resourceNames.isEmpty();
    }

    public A addToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(index, item);
        return (A)this;
    }

    public A setToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.set(index, item);
        return (A)this;
    }

    public A addToResources(String ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    public A addAllToResources(Collection<String> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    public A removeFromResources(String ... items) {
        if (this.resources == null) {
            return (A)this;
        }
        for (String item : items) {
            this.resources.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromResources(Collection<String> items) {
        if (this.resources == null) {
            return (A)this;
        }
        for (String item : items) {
            this.resources.remove(item);
        }
        return (A)this;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public String getResource(int index) {
        return this.resources.get(index);
    }

    public String getFirstResource() {
        return this.resources.get(0);
    }

    public String getLastResource() {
        return this.resources.get(this.resources.size() - 1);
    }

    public String getMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResources(List<String> resources) {
        if (resources != null) {
            this.resources = new ArrayList<String>();
            for (String item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    public A withResources(String ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove("resources");
        }
        if (resources != null) {
            for (String item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    public A addToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.add(index, item);
        return (A)this;
    }

    public A setToVerbs(int index, String item) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        this.verbs.set(index, item);
        return (A)this;
    }

    public A addToVerbs(String ... items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    public A addAllToVerbs(Collection<String> items) {
        if (this.verbs == null) {
            this.verbs = new ArrayList<String>();
        }
        for (String item : items) {
            this.verbs.add(item);
        }
        return (A)this;
    }

    public A removeFromVerbs(String ... items) {
        if (this.verbs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.verbs.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromVerbs(Collection<String> items) {
        if (this.verbs == null) {
            return (A)this;
        }
        for (String item : items) {
            this.verbs.remove(item);
        }
        return (A)this;
    }

    public List<String> getVerbs() {
        return this.verbs;
    }

    public String getVerb(int index) {
        return this.verbs.get(index);
    }

    public String getFirstVerb() {
        return this.verbs.get(0);
    }

    public String getLastVerb() {
        return this.verbs.get(this.verbs.size() - 1);
    }

    public String getMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingVerb(Predicate<String> predicate) {
        for (String item : this.verbs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVerbs(List<String> verbs) {
        if (verbs != null) {
            this.verbs = new ArrayList<String>();
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        } else {
            this.verbs = null;
        }
        return (A)this;
    }

    public A withVerbs(String ... verbs) {
        if (this.verbs != null) {
            this.verbs.clear();
            this._visitables.remove("verbs");
        }
        if (verbs != null) {
            for (String item : verbs) {
                this.addToVerbs(item);
            }
        }
        return (A)this;
    }

    public boolean hasVerbs() {
        return this.verbs != null && !this.verbs.isEmpty();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ResourceRuleFluent that = (V1ResourceRuleFluent)o;
        if (!Objects.equals(this.apiGroups, that.apiGroups)) {
            return false;
        }
        if (!Objects.equals(this.resourceNames, that.resourceNames)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        return Objects.equals(this.verbs, that.verbs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiGroups, this.resourceNames, this.resources, this.verbs, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiGroups != null && !this.apiGroups.isEmpty()) {
            sb.append("apiGroups:");
            sb.append(this.apiGroups + ",");
        }
        if (this.resourceNames != null && !this.resourceNames.isEmpty()) {
            sb.append("resourceNames:");
            sb.append(this.resourceNames + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.verbs != null && !this.verbs.isEmpty()) {
            sb.append("verbs:");
            sb.append(this.verbs);
        }
        sb.append("}");
        return sb.toString();
    }
}

