/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1ContainerStatusBuilder;
import io.kubernetes.client.openapi.models.V1ContainerStatusFluent;
import io.kubernetes.client.openapi.models.V1HostIP;
import io.kubernetes.client.openapi.models.V1HostIPBuilder;
import io.kubernetes.client.openapi.models.V1HostIPFluent;
import io.kubernetes.client.openapi.models.V1PodCondition;
import io.kubernetes.client.openapi.models.V1PodConditionBuilder;
import io.kubernetes.client.openapi.models.V1PodConditionFluent;
import io.kubernetes.client.openapi.models.V1PodIP;
import io.kubernetes.client.openapi.models.V1PodIPBuilder;
import io.kubernetes.client.openapi.models.V1PodIPFluent;
import io.kubernetes.client.openapi.models.V1PodResourceClaimStatus;
import io.kubernetes.client.openapi.models.V1PodResourceClaimStatusBuilder;
import io.kubernetes.client.openapi.models.V1PodResourceClaimStatusFluent;
import io.kubernetes.client.openapi.models.V1PodStatus;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1PodStatusFluent<A extends V1PodStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1PodConditionBuilder> conditions;
    private ArrayList<V1ContainerStatusBuilder> containerStatuses;
    private ArrayList<V1ContainerStatusBuilder> ephemeralContainerStatuses;
    private String hostIP;
    private ArrayList<V1HostIPBuilder> hostIPs;
    private ArrayList<V1ContainerStatusBuilder> initContainerStatuses;
    private String message;
    private String nominatedNodeName;
    private String phase;
    private String podIP;
    private ArrayList<V1PodIPBuilder> podIPs;
    private String qosClass;
    private String reason;
    private String resize;
    private ArrayList<V1PodResourceClaimStatusBuilder> resourceClaimStatuses;
    private OffsetDateTime startTime;

    public V1PodStatusFluent() {
    }

    public V1PodStatusFluent(V1PodStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1PodStatus instance) {
        V1PodStatus v1PodStatus = instance = instance != null ? instance : new V1PodStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withContainerStatuses(instance.getContainerStatuses());
            this.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses());
            this.withHostIP(instance.getHostIP());
            this.withHostIPs(instance.getHostIPs());
            this.withInitContainerStatuses(instance.getInitContainerStatuses());
            this.withMessage(instance.getMessage());
            this.withNominatedNodeName(instance.getNominatedNodeName());
            this.withPhase(instance.getPhase());
            this.withPodIP(instance.getPodIP());
            this.withPodIPs(instance.getPodIPs());
            this.withQosClass(instance.getQosClass());
            this.withReason(instance.getReason());
            this.withResize(instance.getResize());
            this.withResourceClaimStatuses(instance.getResourceClaimStatuses());
            this.withStartTime(instance.getStartTime());
        }
    }

    public A addToConditions(int index, V1PodCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, V1PodCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(V1PodCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1PodCondition item : items) {
            V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<V1PodCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1PodCondition item : items) {
            V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(V1PodCondition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1PodCondition item : items) {
            V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<V1PodCondition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1PodCondition item : items) {
            V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<V1PodConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1PodConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1PodConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1PodCondition> buildConditions() {
        return this.conditions != null ? V1PodStatusFluent.build(this.conditions) : null;
    }

    public V1PodCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1PodCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1PodCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public V1PodCondition buildMatchingCondition(Predicate<V1PodConditionBuilder> predicate) {
        for (V1PodConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<V1PodConditionBuilder> predicate) {
        for (V1PodConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<V1PodCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1PodCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(V1PodCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V1PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(V1PodCondition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, V1PodCondition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<V1PodConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public A addToContainerStatuses(int index, V1ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        if (index < 0 || index >= this.containerStatuses.size()) {
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        } else {
            this._visitables.get("containerStatuses").add(index, builder);
            this.containerStatuses.add(index, builder);
        }
        return (A)this;
    }

    public A setToContainerStatuses(int index, V1ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        if (index < 0 || index >= this.containerStatuses.size()) {
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        } else {
            this._visitables.get("containerStatuses").set(index, builder);
            this.containerStatuses.set(index, builder);
        }
        return (A)this;
    }

    public A addToContainerStatuses(V1ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    public A addAllToContainerStatuses(Collection<V1ContainerStatus> items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    public A removeFromContainerStatuses(V1ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").remove(builder);
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromContainerStatuses(Collection<V1ContainerStatus> items) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").remove(builder);
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromContainerStatuses(Predicate<V1ContainerStatusBuilder> predicate) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        Iterator<V1ContainerStatusBuilder> each = this.containerStatuses.iterator();
        Object visitables = this._visitables.get("containerStatuses");
        while (each.hasNext()) {
            V1ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ContainerStatus> buildContainerStatuses() {
        return this.containerStatuses != null ? V1PodStatusFluent.build(this.containerStatuses) : null;
    }

    public V1ContainerStatus buildContainerStatus(int index) {
        return this.containerStatuses.get(index).build();
    }

    public V1ContainerStatus buildFirstContainerStatus() {
        return this.containerStatuses.get(0).build();
    }

    public V1ContainerStatus buildLastContainerStatus() {
        return this.containerStatuses.get(this.containerStatuses.size() - 1).build();
    }

    public V1ContainerStatus buildMatchingContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withContainerStatuses(List<V1ContainerStatus> containerStatuses) {
        if (this.containerStatuses != null) {
            this._visitables.get("containerStatuses").clear();
        }
        if (containerStatuses != null) {
            this.containerStatuses = new ArrayList();
            for (V1ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        } else {
            this.containerStatuses = null;
        }
        return (A)this;
    }

    public A withContainerStatuses(V1ContainerStatus ... containerStatuses) {
        if (this.containerStatuses != null) {
            this.containerStatuses.clear();
            this._visitables.remove("containerStatuses");
        }
        if (containerStatuses != null) {
            for (V1ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)this;
    }

    public boolean hasContainerStatuses() {
        return this.containerStatuses != null && !this.containerStatuses.isEmpty();
    }

    public ContainerStatusesNested<A> addNewContainerStatus() {
        return new ContainerStatusesNested(-1, null);
    }

    public ContainerStatusesNested<A> addNewContainerStatusLike(V1ContainerStatus item) {
        return new ContainerStatusesNested(-1, item);
    }

    public ContainerStatusesNested<A> setNewContainerStatusLike(int index, V1ContainerStatus item) {
        return new ContainerStatusesNested(index, item);
    }

    public ContainerStatusesNested<A> editContainerStatus(int index) {
        if (this.containerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    public ContainerStatusesNested<A> editFirstContainerStatus() {
        if (this.containerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(0, this.buildContainerStatus(0));
    }

    public ContainerStatusesNested<A> editLastContainerStatus() {
        int index = this.containerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    public ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerStatuses.size(); ++i) {
            if (!predicate.test(this.containerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    public A addToEphemeralContainerStatuses(int index, V1ContainerStatus item) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        if (index < 0 || index >= this.ephemeralContainerStatuses.size()) {
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        } else {
            this._visitables.get("ephemeralContainerStatuses").add(index, builder);
            this.ephemeralContainerStatuses.add(index, builder);
        }
        return (A)this;
    }

    public A setToEphemeralContainerStatuses(int index, V1ContainerStatus item) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        if (index < 0 || index >= this.ephemeralContainerStatuses.size()) {
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        } else {
            this._visitables.get("ephemeralContainerStatuses").set(index, builder);
            this.ephemeralContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    public A addToEphemeralContainerStatuses(V1ContainerStatus ... items) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        }
        return (A)this;
    }

    public A addAllToEphemeralContainerStatuses(Collection<V1ContainerStatus> items) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        }
        return (A)this;
    }

    public A removeFromEphemeralContainerStatuses(V1ContainerStatus ... items) {
        if (this.ephemeralContainerStatuses == null) {
            return (A)this;
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").remove(builder);
            this.ephemeralContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEphemeralContainerStatuses(Collection<V1ContainerStatus> items) {
        if (this.ephemeralContainerStatuses == null) {
            return (A)this;
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").remove(builder);
            this.ephemeralContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEphemeralContainerStatuses(Predicate<V1ContainerStatusBuilder> predicate) {
        if (this.ephemeralContainerStatuses == null) {
            return (A)this;
        }
        Iterator<V1ContainerStatusBuilder> each = this.ephemeralContainerStatuses.iterator();
        Object visitables = this._visitables.get("ephemeralContainerStatuses");
        while (each.hasNext()) {
            V1ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ContainerStatus> buildEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses != null ? V1PodStatusFluent.build(this.ephemeralContainerStatuses) : null;
    }

    public V1ContainerStatus buildEphemeralContainerStatus(int index) {
        return this.ephemeralContainerStatuses.get(index).build();
    }

    public V1ContainerStatus buildFirstEphemeralContainerStatus() {
        return this.ephemeralContainerStatuses.get(0).build();
    }

    public V1ContainerStatus buildLastEphemeralContainerStatus() {
        return this.ephemeralContainerStatuses.get(this.ephemeralContainerStatuses.size() - 1).build();
    }

    public V1ContainerStatus buildMatchingEphemeralContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.ephemeralContainerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEphemeralContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.ephemeralContainerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEphemeralContainerStatuses(List<V1ContainerStatus> ephemeralContainerStatuses) {
        if (this.ephemeralContainerStatuses != null) {
            this._visitables.get("ephemeralContainerStatuses").clear();
        }
        if (ephemeralContainerStatuses != null) {
            this.ephemeralContainerStatuses = new ArrayList();
            for (V1ContainerStatus item : ephemeralContainerStatuses) {
                this.addToEphemeralContainerStatuses(item);
            }
        } else {
            this.ephemeralContainerStatuses = null;
        }
        return (A)this;
    }

    public A withEphemeralContainerStatuses(V1ContainerStatus ... ephemeralContainerStatuses) {
        if (this.ephemeralContainerStatuses != null) {
            this.ephemeralContainerStatuses.clear();
            this._visitables.remove("ephemeralContainerStatuses");
        }
        if (ephemeralContainerStatuses != null) {
            for (V1ContainerStatus item : ephemeralContainerStatuses) {
                this.addToEphemeralContainerStatuses(item);
            }
        }
        return (A)this;
    }

    public boolean hasEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses != null && !this.ephemeralContainerStatuses.isEmpty();
    }

    public EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatus() {
        return new EphemeralContainerStatusesNested(-1, null);
    }

    public EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatusLike(V1ContainerStatus item) {
        return new EphemeralContainerStatusesNested(-1, item);
    }

    public EphemeralContainerStatusesNested<A> setNewEphemeralContainerStatusLike(int index, V1ContainerStatus item) {
        return new EphemeralContainerStatusesNested(index, item);
    }

    public EphemeralContainerStatusesNested<A> editEphemeralContainerStatus(int index) {
        if (this.ephemeralContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit ephemeralContainerStatuses. Index exceeds size.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    public EphemeralContainerStatusesNested<A> editFirstEphemeralContainerStatus() {
        if (this.ephemeralContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first ephemeralContainerStatuses. The list is empty.");
        }
        return this.setNewEphemeralContainerStatusLike(0, this.buildEphemeralContainerStatus(0));
    }

    public EphemeralContainerStatusesNested<A> editLastEphemeralContainerStatus() {
        int index = this.ephemeralContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ephemeralContainerStatuses. The list is empty.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    public EphemeralContainerStatusesNested<A> editMatchingEphemeralContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ephemeralContainerStatuses.size(); ++i) {
            if (!predicate.test(this.ephemeralContainerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ephemeralContainerStatuses. No match found.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    public String getHostIP() {
        return this.hostIP;
    }

    public A withHostIP(String hostIP) {
        this.hostIP = hostIP;
        return (A)this;
    }

    public boolean hasHostIP() {
        return this.hostIP != null;
    }

    public A addToHostIPs(int index, V1HostIP item) {
        if (this.hostIPs == null) {
            this.hostIPs = new ArrayList();
        }
        V1HostIPBuilder builder = new V1HostIPBuilder(item);
        if (index < 0 || index >= this.hostIPs.size()) {
            this._visitables.get("hostIPs").add(builder);
            this.hostIPs.add(builder);
        } else {
            this._visitables.get("hostIPs").add(index, builder);
            this.hostIPs.add(index, builder);
        }
        return (A)this;
    }

    public A setToHostIPs(int index, V1HostIP item) {
        if (this.hostIPs == null) {
            this.hostIPs = new ArrayList();
        }
        V1HostIPBuilder builder = new V1HostIPBuilder(item);
        if (index < 0 || index >= this.hostIPs.size()) {
            this._visitables.get("hostIPs").add(builder);
            this.hostIPs.add(builder);
        } else {
            this._visitables.get("hostIPs").set(index, builder);
            this.hostIPs.set(index, builder);
        }
        return (A)this;
    }

    public A addToHostIPs(V1HostIP ... items) {
        if (this.hostIPs == null) {
            this.hostIPs = new ArrayList();
        }
        for (V1HostIP item : items) {
            V1HostIPBuilder builder = new V1HostIPBuilder(item);
            this._visitables.get("hostIPs").add(builder);
            this.hostIPs.add(builder);
        }
        return (A)this;
    }

    public A addAllToHostIPs(Collection<V1HostIP> items) {
        if (this.hostIPs == null) {
            this.hostIPs = new ArrayList();
        }
        for (V1HostIP item : items) {
            V1HostIPBuilder builder = new V1HostIPBuilder(item);
            this._visitables.get("hostIPs").add(builder);
            this.hostIPs.add(builder);
        }
        return (A)this;
    }

    public A removeFromHostIPs(V1HostIP ... items) {
        if (this.hostIPs == null) {
            return (A)this;
        }
        for (V1HostIP item : items) {
            V1HostIPBuilder builder = new V1HostIPBuilder(item);
            this._visitables.get("hostIPs").remove(builder);
            this.hostIPs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromHostIPs(Collection<V1HostIP> items) {
        if (this.hostIPs == null) {
            return (A)this;
        }
        for (V1HostIP item : items) {
            V1HostIPBuilder builder = new V1HostIPBuilder(item);
            this._visitables.get("hostIPs").remove(builder);
            this.hostIPs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromHostIPs(Predicate<V1HostIPBuilder> predicate) {
        if (this.hostIPs == null) {
            return (A)this;
        }
        Iterator<V1HostIPBuilder> each = this.hostIPs.iterator();
        Object visitables = this._visitables.get("hostIPs");
        while (each.hasNext()) {
            V1HostIPBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1HostIP> buildHostIPs() {
        return this.hostIPs != null ? V1PodStatusFluent.build(this.hostIPs) : null;
    }

    public V1HostIP buildHostIP(int index) {
        return this.hostIPs.get(index).build();
    }

    public V1HostIP buildFirstHostIP() {
        return this.hostIPs.get(0).build();
    }

    public V1HostIP buildLastHostIP() {
        return this.hostIPs.get(this.hostIPs.size() - 1).build();
    }

    public V1HostIP buildMatchingHostIP(Predicate<V1HostIPBuilder> predicate) {
        for (V1HostIPBuilder item : this.hostIPs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHostIP(Predicate<V1HostIPBuilder> predicate) {
        for (V1HostIPBuilder item : this.hostIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHostIPs(List<V1HostIP> hostIPs) {
        if (this.hostIPs != null) {
            this._visitables.get("hostIPs").clear();
        }
        if (hostIPs != null) {
            this.hostIPs = new ArrayList();
            for (V1HostIP item : hostIPs) {
                this.addToHostIPs(item);
            }
        } else {
            this.hostIPs = null;
        }
        return (A)this;
    }

    public A withHostIPs(V1HostIP ... hostIPs) {
        if (this.hostIPs != null) {
            this.hostIPs.clear();
            this._visitables.remove("hostIPs");
        }
        if (hostIPs != null) {
            for (V1HostIP item : hostIPs) {
                this.addToHostIPs(item);
            }
        }
        return (A)this;
    }

    public boolean hasHostIPs() {
        return this.hostIPs != null && !this.hostIPs.isEmpty();
    }

    public HostIPsNested<A> addNewHostIP() {
        return new HostIPsNested(-1, null);
    }

    public HostIPsNested<A> addNewHostIPLike(V1HostIP item) {
        return new HostIPsNested(-1, item);
    }

    public HostIPsNested<A> setNewHostIPLike(int index, V1HostIP item) {
        return new HostIPsNested(index, item);
    }

    public HostIPsNested<A> editHostIP(int index) {
        if (this.hostIPs.size() <= index) {
            throw new RuntimeException("Can't edit hostIPs. Index exceeds size.");
        }
        return this.setNewHostIPLike(index, this.buildHostIP(index));
    }

    public HostIPsNested<A> editFirstHostIP() {
        if (this.hostIPs.size() == 0) {
            throw new RuntimeException("Can't edit first hostIPs. The list is empty.");
        }
        return this.setNewHostIPLike(0, this.buildHostIP(0));
    }

    public HostIPsNested<A> editLastHostIP() {
        int index = this.hostIPs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last hostIPs. The list is empty.");
        }
        return this.setNewHostIPLike(index, this.buildHostIP(index));
    }

    public HostIPsNested<A> editMatchingHostIP(Predicate<V1HostIPBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.hostIPs.size(); ++i) {
            if (!predicate.test(this.hostIPs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching hostIPs. No match found.");
        }
        return this.setNewHostIPLike(index, this.buildHostIP(index));
    }

    public A addToInitContainerStatuses(int index, V1ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        } else {
            this._visitables.get("initContainerStatuses").add(index, builder);
            this.initContainerStatuses.add(index, builder);
        }
        return (A)this;
    }

    public A setToInitContainerStatuses(int index, V1ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        } else {
            this._visitables.get("initContainerStatuses").set(index, builder);
            this.initContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    public A addToInitContainerStatuses(V1ContainerStatus ... items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    public A addAllToInitContainerStatuses(Collection<V1ContainerStatus> items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    public A removeFromInitContainerStatuses(V1ContainerStatus ... items) {
        if (this.initContainerStatuses == null) {
            return (A)this;
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").remove(builder);
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromInitContainerStatuses(Collection<V1ContainerStatus> items) {
        if (this.initContainerStatuses == null) {
            return (A)this;
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").remove(builder);
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromInitContainerStatuses(Predicate<V1ContainerStatusBuilder> predicate) {
        if (this.initContainerStatuses == null) {
            return (A)this;
        }
        Iterator<V1ContainerStatusBuilder> each = this.initContainerStatuses.iterator();
        Object visitables = this._visitables.get("initContainerStatuses");
        while (each.hasNext()) {
            V1ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ContainerStatus> buildInitContainerStatuses() {
        return this.initContainerStatuses != null ? V1PodStatusFluent.build(this.initContainerStatuses) : null;
    }

    public V1ContainerStatus buildInitContainerStatus(int index) {
        return this.initContainerStatuses.get(index).build();
    }

    public V1ContainerStatus buildFirstInitContainerStatus() {
        return this.initContainerStatuses.get(0).build();
    }

    public V1ContainerStatus buildLastInitContainerStatus() {
        return this.initContainerStatuses.get(this.initContainerStatuses.size() - 1).build();
    }

    public V1ContainerStatus buildMatchingInitContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingInitContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withInitContainerStatuses(List<V1ContainerStatus> initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this._visitables.get("initContainerStatuses").clear();
        }
        if (initContainerStatuses != null) {
            this.initContainerStatuses = new ArrayList();
            for (V1ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        } else {
            this.initContainerStatuses = null;
        }
        return (A)this;
    }

    public A withInitContainerStatuses(V1ContainerStatus ... initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this.initContainerStatuses.clear();
            this._visitables.remove("initContainerStatuses");
        }
        if (initContainerStatuses != null) {
            for (V1ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        }
        return (A)this;
    }

    public boolean hasInitContainerStatuses() {
        return this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty();
    }

    public InitContainerStatusesNested<A> addNewInitContainerStatus() {
        return new InitContainerStatusesNested(-1, null);
    }

    public InitContainerStatusesNested<A> addNewInitContainerStatusLike(V1ContainerStatus item) {
        return new InitContainerStatusesNested(-1, item);
    }

    public InitContainerStatusesNested<A> setNewInitContainerStatusLike(int index, V1ContainerStatus item) {
        return new InitContainerStatusesNested(index, item);
    }

    public InitContainerStatusesNested<A> editInitContainerStatus(int index) {
        if (this.initContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    public InitContainerStatusesNested<A> editFirstInitContainerStatus() {
        if (this.initContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(0, this.buildInitContainerStatus(0));
    }

    public InitContainerStatusesNested<A> editLastInitContainerStatus() {
        int index = this.initContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    public InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainerStatuses.size(); ++i) {
            if (!predicate.test(this.initContainerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    public String getMessage() {
        return this.message;
    }

    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public String getNominatedNodeName() {
        return this.nominatedNodeName;
    }

    public A withNominatedNodeName(String nominatedNodeName) {
        this.nominatedNodeName = nominatedNodeName;
        return (A)this;
    }

    public boolean hasNominatedNodeName() {
        return this.nominatedNodeName != null;
    }

    public String getPhase() {
        return this.phase;
    }

    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    public boolean hasPhase() {
        return this.phase != null;
    }

    public String getPodIP() {
        return this.podIP;
    }

    public A withPodIP(String podIP) {
        this.podIP = podIP;
        return (A)this;
    }

    public boolean hasPodIP() {
        return this.podIP != null;
    }

    public A addToPodIPs(int index, V1PodIP item) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        V1PodIPBuilder builder = new V1PodIPBuilder(item);
        if (index < 0 || index >= this.podIPs.size()) {
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        } else {
            this._visitables.get("podIPs").add(index, builder);
            this.podIPs.add(index, builder);
        }
        return (A)this;
    }

    public A setToPodIPs(int index, V1PodIP item) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        V1PodIPBuilder builder = new V1PodIPBuilder(item);
        if (index < 0 || index >= this.podIPs.size()) {
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        } else {
            this._visitables.get("podIPs").set(index, builder);
            this.podIPs.set(index, builder);
        }
        return (A)this;
    }

    public A addToPodIPs(V1PodIP ... items) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        for (V1PodIP item : items) {
            V1PodIPBuilder builder = new V1PodIPBuilder(item);
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        }
        return (A)this;
    }

    public A addAllToPodIPs(Collection<V1PodIP> items) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        for (V1PodIP item : items) {
            V1PodIPBuilder builder = new V1PodIPBuilder(item);
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        }
        return (A)this;
    }

    public A removeFromPodIPs(V1PodIP ... items) {
        if (this.podIPs == null) {
            return (A)this;
        }
        for (V1PodIP item : items) {
            V1PodIPBuilder builder = new V1PodIPBuilder(item);
            this._visitables.get("podIPs").remove(builder);
            this.podIPs.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPodIPs(Collection<V1PodIP> items) {
        if (this.podIPs == null) {
            return (A)this;
        }
        for (V1PodIP item : items) {
            V1PodIPBuilder builder = new V1PodIPBuilder(item);
            this._visitables.get("podIPs").remove(builder);
            this.podIPs.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPodIPs(Predicate<V1PodIPBuilder> predicate) {
        if (this.podIPs == null) {
            return (A)this;
        }
        Iterator<V1PodIPBuilder> each = this.podIPs.iterator();
        Object visitables = this._visitables.get("podIPs");
        while (each.hasNext()) {
            V1PodIPBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1PodIP> buildPodIPs() {
        return this.podIPs != null ? V1PodStatusFluent.build(this.podIPs) : null;
    }

    public V1PodIP buildPodIP(int index) {
        return this.podIPs.get(index).build();
    }

    public V1PodIP buildFirstPodIP() {
        return this.podIPs.get(0).build();
    }

    public V1PodIP buildLastPodIP() {
        return this.podIPs.get(this.podIPs.size() - 1).build();
    }

    public V1PodIP buildMatchingPodIP(Predicate<V1PodIPBuilder> predicate) {
        for (V1PodIPBuilder item : this.podIPs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPodIP(Predicate<V1PodIPBuilder> predicate) {
        for (V1PodIPBuilder item : this.podIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPodIPs(List<V1PodIP> podIPs) {
        if (this.podIPs != null) {
            this._visitables.get("podIPs").clear();
        }
        if (podIPs != null) {
            this.podIPs = new ArrayList();
            for (V1PodIP item : podIPs) {
                this.addToPodIPs(item);
            }
        } else {
            this.podIPs = null;
        }
        return (A)this;
    }

    public A withPodIPs(V1PodIP ... podIPs) {
        if (this.podIPs != null) {
            this.podIPs.clear();
            this._visitables.remove("podIPs");
        }
        if (podIPs != null) {
            for (V1PodIP item : podIPs) {
                this.addToPodIPs(item);
            }
        }
        return (A)this;
    }

    public boolean hasPodIPs() {
        return this.podIPs != null && !this.podIPs.isEmpty();
    }

    public PodIPsNested<A> addNewPodIP() {
        return new PodIPsNested(-1, null);
    }

    public PodIPsNested<A> addNewPodIPLike(V1PodIP item) {
        return new PodIPsNested(-1, item);
    }

    public PodIPsNested<A> setNewPodIPLike(int index, V1PodIP item) {
        return new PodIPsNested(index, item);
    }

    public PodIPsNested<A> editPodIP(int index) {
        if (this.podIPs.size() <= index) {
            throw new RuntimeException("Can't edit podIPs. Index exceeds size.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    public PodIPsNested<A> editFirstPodIP() {
        if (this.podIPs.size() == 0) {
            throw new RuntimeException("Can't edit first podIPs. The list is empty.");
        }
        return this.setNewPodIPLike(0, this.buildPodIP(0));
    }

    public PodIPsNested<A> editLastPodIP() {
        int index = this.podIPs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last podIPs. The list is empty.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    public PodIPsNested<A> editMatchingPodIP(Predicate<V1PodIPBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.podIPs.size(); ++i) {
            if (!predicate.test(this.podIPs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching podIPs. No match found.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    public String getQosClass() {
        return this.qosClass;
    }

    public A withQosClass(String qosClass) {
        this.qosClass = qosClass;
        return (A)this;
    }

    public boolean hasQosClass() {
        return this.qosClass != null;
    }

    public String getReason() {
        return this.reason;
    }

    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    public boolean hasReason() {
        return this.reason != null;
    }

    public String getResize() {
        return this.resize;
    }

    public A withResize(String resize) {
        this.resize = resize;
        return (A)this;
    }

    public boolean hasResize() {
        return this.resize != null;
    }

    public A addToResourceClaimStatuses(int index, V1PodResourceClaimStatus item) {
        if (this.resourceClaimStatuses == null) {
            this.resourceClaimStatuses = new ArrayList();
        }
        V1PodResourceClaimStatusBuilder builder = new V1PodResourceClaimStatusBuilder(item);
        if (index < 0 || index >= this.resourceClaimStatuses.size()) {
            this._visitables.get("resourceClaimStatuses").add(builder);
            this.resourceClaimStatuses.add(builder);
        } else {
            this._visitables.get("resourceClaimStatuses").add(index, builder);
            this.resourceClaimStatuses.add(index, builder);
        }
        return (A)this;
    }

    public A setToResourceClaimStatuses(int index, V1PodResourceClaimStatus item) {
        if (this.resourceClaimStatuses == null) {
            this.resourceClaimStatuses = new ArrayList();
        }
        V1PodResourceClaimStatusBuilder builder = new V1PodResourceClaimStatusBuilder(item);
        if (index < 0 || index >= this.resourceClaimStatuses.size()) {
            this._visitables.get("resourceClaimStatuses").add(builder);
            this.resourceClaimStatuses.add(builder);
        } else {
            this._visitables.get("resourceClaimStatuses").set(index, builder);
            this.resourceClaimStatuses.set(index, builder);
        }
        return (A)this;
    }

    public A addToResourceClaimStatuses(V1PodResourceClaimStatus ... items) {
        if (this.resourceClaimStatuses == null) {
            this.resourceClaimStatuses = new ArrayList();
        }
        for (V1PodResourceClaimStatus item : items) {
            V1PodResourceClaimStatusBuilder builder = new V1PodResourceClaimStatusBuilder(item);
            this._visitables.get("resourceClaimStatuses").add(builder);
            this.resourceClaimStatuses.add(builder);
        }
        return (A)this;
    }

    public A addAllToResourceClaimStatuses(Collection<V1PodResourceClaimStatus> items) {
        if (this.resourceClaimStatuses == null) {
            this.resourceClaimStatuses = new ArrayList();
        }
        for (V1PodResourceClaimStatus item : items) {
            V1PodResourceClaimStatusBuilder builder = new V1PodResourceClaimStatusBuilder(item);
            this._visitables.get("resourceClaimStatuses").add(builder);
            this.resourceClaimStatuses.add(builder);
        }
        return (A)this;
    }

    public A removeFromResourceClaimStatuses(V1PodResourceClaimStatus ... items) {
        if (this.resourceClaimStatuses == null) {
            return (A)this;
        }
        for (V1PodResourceClaimStatus item : items) {
            V1PodResourceClaimStatusBuilder builder = new V1PodResourceClaimStatusBuilder(item);
            this._visitables.get("resourceClaimStatuses").remove(builder);
            this.resourceClaimStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResourceClaimStatuses(Collection<V1PodResourceClaimStatus> items) {
        if (this.resourceClaimStatuses == null) {
            return (A)this;
        }
        for (V1PodResourceClaimStatus item : items) {
            V1PodResourceClaimStatusBuilder builder = new V1PodResourceClaimStatusBuilder(item);
            this._visitables.get("resourceClaimStatuses").remove(builder);
            this.resourceClaimStatuses.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResourceClaimStatuses(Predicate<V1PodResourceClaimStatusBuilder> predicate) {
        if (this.resourceClaimStatuses == null) {
            return (A)this;
        }
        Iterator<V1PodResourceClaimStatusBuilder> each = this.resourceClaimStatuses.iterator();
        Object visitables = this._visitables.get("resourceClaimStatuses");
        while (each.hasNext()) {
            V1PodResourceClaimStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1PodResourceClaimStatus> buildResourceClaimStatuses() {
        return this.resourceClaimStatuses != null ? V1PodStatusFluent.build(this.resourceClaimStatuses) : null;
    }

    public V1PodResourceClaimStatus buildResourceClaimStatus(int index) {
        return this.resourceClaimStatuses.get(index).build();
    }

    public V1PodResourceClaimStatus buildFirstResourceClaimStatus() {
        return this.resourceClaimStatuses.get(0).build();
    }

    public V1PodResourceClaimStatus buildLastResourceClaimStatus() {
        return this.resourceClaimStatuses.get(this.resourceClaimStatuses.size() - 1).build();
    }

    public V1PodResourceClaimStatus buildMatchingResourceClaimStatus(Predicate<V1PodResourceClaimStatusBuilder> predicate) {
        for (V1PodResourceClaimStatusBuilder item : this.resourceClaimStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResourceClaimStatus(Predicate<V1PodResourceClaimStatusBuilder> predicate) {
        for (V1PodResourceClaimStatusBuilder item : this.resourceClaimStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResourceClaimStatuses(List<V1PodResourceClaimStatus> resourceClaimStatuses) {
        if (this.resourceClaimStatuses != null) {
            this._visitables.get("resourceClaimStatuses").clear();
        }
        if (resourceClaimStatuses != null) {
            this.resourceClaimStatuses = new ArrayList();
            for (V1PodResourceClaimStatus item : resourceClaimStatuses) {
                this.addToResourceClaimStatuses(item);
            }
        } else {
            this.resourceClaimStatuses = null;
        }
        return (A)this;
    }

    public A withResourceClaimStatuses(V1PodResourceClaimStatus ... resourceClaimStatuses) {
        if (this.resourceClaimStatuses != null) {
            this.resourceClaimStatuses.clear();
            this._visitables.remove("resourceClaimStatuses");
        }
        if (resourceClaimStatuses != null) {
            for (V1PodResourceClaimStatus item : resourceClaimStatuses) {
                this.addToResourceClaimStatuses(item);
            }
        }
        return (A)this;
    }

    public boolean hasResourceClaimStatuses() {
        return this.resourceClaimStatuses != null && !this.resourceClaimStatuses.isEmpty();
    }

    public ResourceClaimStatusesNested<A> addNewResourceClaimStatus() {
        return new ResourceClaimStatusesNested(-1, null);
    }

    public ResourceClaimStatusesNested<A> addNewResourceClaimStatusLike(V1PodResourceClaimStatus item) {
        return new ResourceClaimStatusesNested(-1, item);
    }

    public ResourceClaimStatusesNested<A> setNewResourceClaimStatusLike(int index, V1PodResourceClaimStatus item) {
        return new ResourceClaimStatusesNested(index, item);
    }

    public ResourceClaimStatusesNested<A> editResourceClaimStatus(int index) {
        if (this.resourceClaimStatuses.size() <= index) {
            throw new RuntimeException("Can't edit resourceClaimStatuses. Index exceeds size.");
        }
        return this.setNewResourceClaimStatusLike(index, this.buildResourceClaimStatus(index));
    }

    public ResourceClaimStatusesNested<A> editFirstResourceClaimStatus() {
        if (this.resourceClaimStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first resourceClaimStatuses. The list is empty.");
        }
        return this.setNewResourceClaimStatusLike(0, this.buildResourceClaimStatus(0));
    }

    public ResourceClaimStatusesNested<A> editLastResourceClaimStatus() {
        int index = this.resourceClaimStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resourceClaimStatuses. The list is empty.");
        }
        return this.setNewResourceClaimStatusLike(index, this.buildResourceClaimStatus(index));
    }

    public ResourceClaimStatusesNested<A> editMatchingResourceClaimStatus(Predicate<V1PodResourceClaimStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceClaimStatuses.size(); ++i) {
            if (!predicate.test(this.resourceClaimStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resourceClaimStatuses. No match found.");
        }
        return this.setNewResourceClaimStatusLike(index, this.buildResourceClaimStatus(index));
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public A withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    public boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PodStatusFluent that = (V1PodStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.containerStatuses, that.containerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.ephemeralContainerStatuses, that.ephemeralContainerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.hostIP, that.hostIP)) {
            return false;
        }
        if (!Objects.equals(this.hostIPs, that.hostIPs)) {
            return false;
        }
        if (!Objects.equals(this.initContainerStatuses, that.initContainerStatuses)) {
            return false;
        }
        if (!Objects.equals(this.message, that.message)) {
            return false;
        }
        if (!Objects.equals(this.nominatedNodeName, that.nominatedNodeName)) {
            return false;
        }
        if (!Objects.equals(this.phase, that.phase)) {
            return false;
        }
        if (!Objects.equals(this.podIP, that.podIP)) {
            return false;
        }
        if (!Objects.equals(this.podIPs, that.podIPs)) {
            return false;
        }
        if (!Objects.equals(this.qosClass, that.qosClass)) {
            return false;
        }
        if (!Objects.equals(this.reason, that.reason)) {
            return false;
        }
        if (!Objects.equals(this.resize, that.resize)) {
            return false;
        }
        if (!Objects.equals(this.resourceClaimStatuses, that.resourceClaimStatuses)) {
            return false;
        }
        return Objects.equals(this.startTime, that.startTime);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.containerStatuses, this.ephemeralContainerStatuses, this.hostIP, this.hostIPs, this.initContainerStatuses, this.message, this.nominatedNodeName, this.phase, this.podIP, this.podIPs, this.qosClass, this.reason, this.resize, this.resourceClaimStatuses, this.startTime, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.containerStatuses != null && !this.containerStatuses.isEmpty()) {
            sb.append("containerStatuses:");
            sb.append(this.containerStatuses + ",");
        }
        if (this.ephemeralContainerStatuses != null && !this.ephemeralContainerStatuses.isEmpty()) {
            sb.append("ephemeralContainerStatuses:");
            sb.append(this.ephemeralContainerStatuses + ",");
        }
        if (this.hostIP != null) {
            sb.append("hostIP:");
            sb.append(this.hostIP + ",");
        }
        if (this.hostIPs != null && !this.hostIPs.isEmpty()) {
            sb.append("hostIPs:");
            sb.append(this.hostIPs + ",");
        }
        if (this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty()) {
            sb.append("initContainerStatuses:");
            sb.append(this.initContainerStatuses + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.nominatedNodeName != null) {
            sb.append("nominatedNodeName:");
            sb.append(this.nominatedNodeName + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.podIP != null) {
            sb.append("podIP:");
            sb.append(this.podIP + ",");
        }
        if (this.podIPs != null && !this.podIPs.isEmpty()) {
            sb.append("podIPs:");
            sb.append(this.podIPs + ",");
        }
        if (this.qosClass != null) {
            sb.append("qosClass:");
            sb.append(this.qosClass + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.resize != null) {
            sb.append("resize:");
            sb.append(this.resize + ",");
        }
        if (this.resourceClaimStatuses != null && !this.resourceClaimStatuses.isEmpty()) {
            sb.append("resourceClaimStatuses:");
            sb.append(this.resourceClaimStatuses + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends V1PodConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        V1PodConditionBuilder builder;
        int index;

        ConditionsNested(int index, V1PodCondition item) {
            this.index = index;
            this.builder = new V1PodConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }

    public class ContainerStatusesNested<N>
    extends V1ContainerStatusFluent<ContainerStatusesNested<N>>
    implements Nested<N> {
        V1ContainerStatusBuilder builder;
        int index;

        ContainerStatusesNested(int index, V1ContainerStatus item) {
            this.index = index;
            this.builder = new V1ContainerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluent.this.setToContainerStatuses(this.index, this.builder.build());
        }

        public N endContainerStatus() {
            return this.and();
        }
    }

    public class EphemeralContainerStatusesNested<N>
    extends V1ContainerStatusFluent<EphemeralContainerStatusesNested<N>>
    implements Nested<N> {
        V1ContainerStatusBuilder builder;
        int index;

        EphemeralContainerStatusesNested(int index, V1ContainerStatus item) {
            this.index = index;
            this.builder = new V1ContainerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluent.this.setToEphemeralContainerStatuses(this.index, this.builder.build());
        }

        public N endEphemeralContainerStatus() {
            return this.and();
        }
    }

    public class HostIPsNested<N>
    extends V1HostIPFluent<HostIPsNested<N>>
    implements Nested<N> {
        V1HostIPBuilder builder;
        int index;

        HostIPsNested(int index, V1HostIP item) {
            this.index = index;
            this.builder = new V1HostIPBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluent.this.setToHostIPs(this.index, this.builder.build());
        }

        public N endHostIP() {
            return this.and();
        }
    }

    public class InitContainerStatusesNested<N>
    extends V1ContainerStatusFluent<InitContainerStatusesNested<N>>
    implements Nested<N> {
        V1ContainerStatusBuilder builder;
        int index;

        InitContainerStatusesNested(int index, V1ContainerStatus item) {
            this.index = index;
            this.builder = new V1ContainerStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluent.this.setToInitContainerStatuses(this.index, this.builder.build());
        }

        public N endInitContainerStatus() {
            return this.and();
        }
    }

    public class PodIPsNested<N>
    extends V1PodIPFluent<PodIPsNested<N>>
    implements Nested<N> {
        V1PodIPBuilder builder;
        int index;

        PodIPsNested(int index, V1PodIP item) {
            this.index = index;
            this.builder = new V1PodIPBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluent.this.setToPodIPs(this.index, this.builder.build());
        }

        public N endPodIP() {
            return this.and();
        }
    }

    public class ResourceClaimStatusesNested<N>
    extends V1PodResourceClaimStatusFluent<ResourceClaimStatusesNested<N>>
    implements Nested<N> {
        V1PodResourceClaimStatusBuilder builder;
        int index;

        ResourceClaimStatusesNested(int index, V1PodResourceClaimStatus item) {
            this.index = index;
            this.builder = new V1PodResourceClaimStatusBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluent.this.setToResourceClaimStatuses(this.index, this.builder.build());
        }

        public N endResourceClaimStatus() {
            return this.and();
        }
    }
}

