/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ClaimSource;
import io.kubernetes.client.openapi.models.V1ClaimSourceBuilder;
import io.kubernetes.client.openapi.models.V1ClaimSourceFluent;
import io.kubernetes.client.openapi.models.V1PodResourceClaim;
import java.util.Objects;
import java.util.Optional;

public class V1PodResourceClaimFluent<A extends V1PodResourceClaimFluent<A>>
extends BaseFluent<A> {
    private String name;
    private V1ClaimSourceBuilder source;

    public V1PodResourceClaimFluent() {
    }

    public V1PodResourceClaimFluent(V1PodResourceClaim instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1PodResourceClaim instance) {
        V1PodResourceClaim v1PodResourceClaim = instance = instance != null ? instance : new V1PodResourceClaim();
        if (instance != null) {
            this.withName(instance.getName());
            this.withSource(instance.getSource());
        }
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public V1ClaimSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    public A withSource(V1ClaimSource source) {
        this._visitables.remove("source");
        if (source != null) {
            this.source = new V1ClaimSourceBuilder(source);
            this._visitables.get("source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get("source").remove(this.source);
        }
        return (A)this;
    }

    public boolean hasSource() {
        return this.source != null;
    }

    public SourceNested<A> withNewSource() {
        return new SourceNested(null);
    }

    public SourceNested<A> withNewSourceLike(V1ClaimSource item) {
        return new SourceNested(item);
    }

    public SourceNested<A> editSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(null));
    }

    public SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(new V1ClaimSourceBuilder().build()));
    }

    public SourceNested<A> editOrNewSourceLike(V1ClaimSource item) {
        return this.withNewSourceLike(Optional.ofNullable(this.buildSource()).orElse(item));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PodResourceClaimFluent that = (V1PodResourceClaimFluent)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.source, that.source);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.source, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SourceNested<N>
    extends V1ClaimSourceFluent<SourceNested<N>>
    implements Nested<N> {
        V1ClaimSourceBuilder builder;

        SourceNested(V1ClaimSource item) {
            this.builder = new V1ClaimSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodResourceClaimFluent.this.withSource(this.builder.build());
        }

        public N endSource() {
            return this.and();
        }
    }
}

