/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1Condition;
import io.kubernetes.client.openapi.models.V1ConditionBuilder;
import io.kubernetes.client.openapi.models.V1ConditionFluent;
import io.kubernetes.client.openapi.models.V1PodDisruptionBudgetStatus;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class V1PodDisruptionBudgetStatusFluent<A extends V1PodDisruptionBudgetStatusFluent<A>>
extends BaseFluent<A> {
    private ArrayList<V1ConditionBuilder> conditions;
    private Integer currentHealthy;
    private Integer desiredHealthy;
    private Map<String, OffsetDateTime> disruptedPods;
    private Integer disruptionsAllowed;
    private Integer expectedPods;
    private Long observedGeneration;

    public V1PodDisruptionBudgetStatusFluent() {
    }

    public V1PodDisruptionBudgetStatusFluent(V1PodDisruptionBudgetStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1PodDisruptionBudgetStatus instance) {
        V1PodDisruptionBudgetStatus v1PodDisruptionBudgetStatus = instance = instance != null ? instance : new V1PodDisruptionBudgetStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withCurrentHealthy(instance.getCurrentHealthy());
            this.withDesiredHealthy(instance.getDesiredHealthy());
            this.withDisruptedPods(instance.getDisruptedPods());
            this.withDisruptionsAllowed(instance.getDisruptionsAllowed());
            this.withExpectedPods(instance.getExpectedPods());
            this.withObservedGeneration(instance.getObservedGeneration());
        }
    }

    public A addToConditions(int index, V1Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1ConditionBuilder builder = new V1ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    public A setToConditions(int index, V1Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1ConditionBuilder builder = new V1ConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    public A addToConditions(V1Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A addAllToConditions(Collection<V1Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    public A removeFromConditions(V1Condition ... items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromConditions(Collection<V1Condition> items) {
        if (this.conditions == null) {
            return (A)this;
        }
        for (V1Condition item : items) {
            V1ConditionBuilder builder = new V1ConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<V1ConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1ConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1ConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1Condition> buildConditions() {
        return this.conditions != null ? V1PodDisruptionBudgetStatusFluent.build(this.conditions) : null;
    }

    public V1Condition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public V1Condition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public V1Condition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    public V1Condition buildMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        for (V1ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        for (V1ConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<V1Condition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    public A withConditions(V1Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (V1Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public ConditionsNested<A> addNewCondition() {
        return new ConditionsNested(-1, null);
    }

    public ConditionsNested<A> addNewConditionLike(V1Condition item) {
        return new ConditionsNested(-1, item);
    }

    public ConditionsNested<A> setNewConditionLike(int index, V1Condition item) {
        return new ConditionsNested(index, item);
    }

    public ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    public ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public ConditionsNested<A> editMatchingCondition(Predicate<V1ConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public Integer getCurrentHealthy() {
        return this.currentHealthy;
    }

    public A withCurrentHealthy(Integer currentHealthy) {
        this.currentHealthy = currentHealthy;
        return (A)this;
    }

    public boolean hasCurrentHealthy() {
        return this.currentHealthy != null;
    }

    public Integer getDesiredHealthy() {
        return this.desiredHealthy;
    }

    public A withDesiredHealthy(Integer desiredHealthy) {
        this.desiredHealthy = desiredHealthy;
        return (A)this;
    }

    public boolean hasDesiredHealthy() {
        return this.desiredHealthy != null;
    }

    public A addToDisruptedPods(String key, OffsetDateTime value) {
        if (this.disruptedPods == null && key != null && value != null) {
            this.disruptedPods = new LinkedHashMap<String, OffsetDateTime>();
        }
        if (key != null && value != null) {
            this.disruptedPods.put(key, value);
        }
        return (A)this;
    }

    public A addToDisruptedPods(Map<String, OffsetDateTime> map) {
        if (this.disruptedPods == null && map != null) {
            this.disruptedPods = new LinkedHashMap<String, OffsetDateTime>();
        }
        if (map != null) {
            this.disruptedPods.putAll(map);
        }
        return (A)this;
    }

    public A removeFromDisruptedPods(String key) {
        if (this.disruptedPods == null) {
            return (A)this;
        }
        if (key != null && this.disruptedPods != null) {
            this.disruptedPods.remove(key);
        }
        return (A)this;
    }

    public A removeFromDisruptedPods(Map<String, OffsetDateTime> map) {
        if (this.disruptedPods == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.disruptedPods == null) continue;
                this.disruptedPods.remove(key);
            }
        }
        return (A)this;
    }

    public Map<String, OffsetDateTime> getDisruptedPods() {
        return this.disruptedPods;
    }

    public <K, V> A withDisruptedPods(Map<String, OffsetDateTime> disruptedPods) {
        this.disruptedPods = disruptedPods == null ? null : new LinkedHashMap<String, OffsetDateTime>(disruptedPods);
        return (A)this;
    }

    public boolean hasDisruptedPods() {
        return this.disruptedPods != null;
    }

    public Integer getDisruptionsAllowed() {
        return this.disruptionsAllowed;
    }

    public A withDisruptionsAllowed(Integer disruptionsAllowed) {
        this.disruptionsAllowed = disruptionsAllowed;
        return (A)this;
    }

    public boolean hasDisruptionsAllowed() {
        return this.disruptionsAllowed != null;
    }

    public Integer getExpectedPods() {
        return this.expectedPods;
    }

    public A withExpectedPods(Integer expectedPods) {
        this.expectedPods = expectedPods;
        return (A)this;
    }

    public boolean hasExpectedPods() {
        return this.expectedPods != null;
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1PodDisruptionBudgetStatusFluent that = (V1PodDisruptionBudgetStatusFluent)o;
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.currentHealthy, that.currentHealthy)) {
            return false;
        }
        if (!Objects.equals(this.desiredHealthy, that.desiredHealthy)) {
            return false;
        }
        if (!Objects.equals(this.disruptedPods, that.disruptedPods)) {
            return false;
        }
        if (!Objects.equals(this.disruptionsAllowed, that.disruptionsAllowed)) {
            return false;
        }
        if (!Objects.equals(this.expectedPods, that.expectedPods)) {
            return false;
        }
        return Objects.equals(this.observedGeneration, that.observedGeneration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.currentHealthy, this.desiredHealthy, this.disruptedPods, this.disruptionsAllowed, this.expectedPods, this.observedGeneration, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.currentHealthy != null) {
            sb.append("currentHealthy:");
            sb.append(this.currentHealthy + ",");
        }
        if (this.desiredHealthy != null) {
            sb.append("desiredHealthy:");
            sb.append(this.desiredHealthy + ",");
        }
        if (this.disruptedPods != null && !this.disruptedPods.isEmpty()) {
            sb.append("disruptedPods:");
            sb.append(this.disruptedPods + ",");
        }
        if (this.disruptionsAllowed != null) {
            sb.append("disruptionsAllowed:");
            sb.append(this.disruptionsAllowed + ",");
        }
        if (this.expectedPods != null) {
            sb.append("expectedPods:");
            sb.append(this.expectedPods + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ConditionsNested<N>
    extends V1ConditionFluent<ConditionsNested<N>>
    implements Nested<N> {
        V1ConditionBuilder builder;
        int index;

        ConditionsNested(int index, V1Condition item) {
            this.index = index;
            this.builder = new V1ConditionBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1PodDisruptionBudgetStatusFluent.this.setToConditions(this.index, this.builder.build());
        }

        public N endCondition() {
            return this.and();
        }
    }
}

