/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1Container;
import io.kubernetes.client.openapi.models.V1ContainerPort;
import io.kubernetes.client.openapi.models.V1ContainerPortBuilder;
import io.kubernetes.client.openapi.models.V1ContainerPortFluent;
import io.kubernetes.client.openapi.models.V1ContainerResizePolicy;
import io.kubernetes.client.openapi.models.V1ContainerResizePolicyBuilder;
import io.kubernetes.client.openapi.models.V1ContainerResizePolicyFluent;
import io.kubernetes.client.openapi.models.V1EnvFromSource;
import io.kubernetes.client.openapi.models.V1EnvFromSourceBuilder;
import io.kubernetes.client.openapi.models.V1EnvFromSourceFluent;
import io.kubernetes.client.openapi.models.V1EnvVar;
import io.kubernetes.client.openapi.models.V1EnvVarBuilder;
import io.kubernetes.client.openapi.models.V1EnvVarFluent;
import io.kubernetes.client.openapi.models.V1Lifecycle;
import io.kubernetes.client.openapi.models.V1LifecycleBuilder;
import io.kubernetes.client.openapi.models.V1LifecycleFluent;
import io.kubernetes.client.openapi.models.V1Probe;
import io.kubernetes.client.openapi.models.V1ProbeBuilder;
import io.kubernetes.client.openapi.models.V1ProbeFluent;
import io.kubernetes.client.openapi.models.V1ResourceRequirements;
import io.kubernetes.client.openapi.models.V1ResourceRequirementsBuilder;
import io.kubernetes.client.openapi.models.V1ResourceRequirementsFluent;
import io.kubernetes.client.openapi.models.V1SecurityContext;
import io.kubernetes.client.openapi.models.V1SecurityContextBuilder;
import io.kubernetes.client.openapi.models.V1SecurityContextFluent;
import io.kubernetes.client.openapi.models.V1VolumeDevice;
import io.kubernetes.client.openapi.models.V1VolumeDeviceBuilder;
import io.kubernetes.client.openapi.models.V1VolumeDeviceFluent;
import io.kubernetes.client.openapi.models.V1VolumeMount;
import io.kubernetes.client.openapi.models.V1VolumeMountBuilder;
import io.kubernetes.client.openapi.models.V1VolumeMountFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class V1ContainerFluent<A extends V1ContainerFluent<A>>
extends BaseFluent<A> {
    private List<String> args;
    private List<String> command;
    private ArrayList<V1EnvVarBuilder> env;
    private ArrayList<V1EnvFromSourceBuilder> envFrom;
    private String image;
    private String imagePullPolicy;
    private V1LifecycleBuilder lifecycle;
    private V1ProbeBuilder livenessProbe;
    private String name;
    private ArrayList<V1ContainerPortBuilder> ports;
    private V1ProbeBuilder readinessProbe;
    private ArrayList<V1ContainerResizePolicyBuilder> resizePolicy;
    private V1ResourceRequirementsBuilder resources;
    private String restartPolicy;
    private V1SecurityContextBuilder securityContext;
    private V1ProbeBuilder startupProbe;
    private Boolean stdin;
    private Boolean stdinOnce;
    private String terminationMessagePath;
    private String terminationMessagePolicy;
    private Boolean tty;
    private ArrayList<V1VolumeDeviceBuilder> volumeDevices;
    private ArrayList<V1VolumeMountBuilder> volumeMounts;
    private String workingDir;

    public V1ContainerFluent() {
    }

    public V1ContainerFluent(V1Container instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(V1Container instance) {
        V1Container v1Container = instance = instance != null ? instance : new V1Container();
        if (instance != null) {
            this.withArgs(instance.getArgs());
            this.withCommand(instance.getCommand());
            this.withEnv(instance.getEnv());
            this.withEnvFrom(instance.getEnvFrom());
            this.withImage(instance.getImage());
            this.withImagePullPolicy(instance.getImagePullPolicy());
            this.withLifecycle(instance.getLifecycle());
            this.withLivenessProbe(instance.getLivenessProbe());
            this.withName(instance.getName());
            this.withPorts(instance.getPorts());
            this.withReadinessProbe(instance.getReadinessProbe());
            this.withResizePolicy(instance.getResizePolicy());
            this.withResources(instance.getResources());
            this.withRestartPolicy(instance.getRestartPolicy());
            this.withSecurityContext(instance.getSecurityContext());
            this.withStartupProbe(instance.getStartupProbe());
            this.withStdin(instance.getStdin());
            this.withStdinOnce(instance.getStdinOnce());
            this.withTerminationMessagePath(instance.getTerminationMessagePath());
            this.withTerminationMessagePolicy(instance.getTerminationMessagePolicy());
            this.withTty(instance.getTty());
            this.withVolumeDevices(instance.getVolumeDevices());
            this.withVolumeMounts(instance.getVolumeMounts());
            this.withWorkingDir(instance.getWorkingDir());
        }
    }

    public A addToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.add(index, item);
        return (A)this;
    }

    public A setToArgs(int index, String item) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        this.args.set(index, item);
        return (A)this;
    }

    public A addToArgs(String ... items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    public A addAllToArgs(Collection<String> items) {
        if (this.args == null) {
            this.args = new ArrayList<String>();
        }
        for (String item : items) {
            this.args.add(item);
        }
        return (A)this;
    }

    public A removeFromArgs(String ... items) {
        if (this.args == null) {
            return (A)this;
        }
        for (String item : items) {
            this.args.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromArgs(Collection<String> items) {
        if (this.args == null) {
            return (A)this;
        }
        for (String item : items) {
            this.args.remove(item);
        }
        return (A)this;
    }

    public List<String> getArgs() {
        return this.args;
    }

    public String getArg(int index) {
        return this.args.get(index);
    }

    public String getFirstArg() {
        return this.args.get(0);
    }

    public String getLastArg() {
        return this.args.get(this.args.size() - 1);
    }

    public String getMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingArg(Predicate<String> predicate) {
        for (String item : this.args) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withArgs(List<String> args) {
        if (args != null) {
            this.args = new ArrayList<String>();
            for (String item : args) {
                this.addToArgs(item);
            }
        } else {
            this.args = null;
        }
        return (A)this;
    }

    public A withArgs(String ... args) {
        if (this.args != null) {
            this.args.clear();
            this._visitables.remove("args");
        }
        if (args != null) {
            for (String item : args) {
                this.addToArgs(item);
            }
        }
        return (A)this;
    }

    public boolean hasArgs() {
        return this.args != null && !this.args.isEmpty();
    }

    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)this;
    }

    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)this;
    }

    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    public A removeFromCommand(String ... items) {
        if (this.command == null) {
            return (A)this;
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)this;
    }

    public A removeAllFromCommand(Collection<String> items) {
        if (this.command == null) {
            return (A)this;
        }
        for (String item : items) {
            this.command.remove(item);
        }
        return (A)this;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public String getCommand(int index) {
        return this.command.get(index);
    }

    public String getFirstCommand() {
        return this.command.get(0);
    }

    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withCommand(List<String> command) {
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = null;
        }
        return (A)this;
    }

    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
            this._visitables.remove("command");
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    public boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    public A addToEnv(int index, V1EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get("env").add(index, builder);
            this.env.add(index, builder);
        }
        return (A)this;
    }

    public A setToEnv(int index, V1EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
        if (index < 0 || index >= this.env.size()) {
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        } else {
            this._visitables.get("env").set(index, builder);
            this.env.set(index, builder);
        }
        return (A)this;
    }

    public A addToEnv(V1EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (V1EnvVar item : items) {
            V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    public A addAllToEnv(Collection<V1EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList();
        }
        for (V1EnvVar item : items) {
            V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
            this._visitables.get("env").add(builder);
            this.env.add(builder);
        }
        return (A)this;
    }

    public A removeFromEnv(V1EnvVar ... items) {
        if (this.env == null) {
            return (A)this;
        }
        for (V1EnvVar item : items) {
            V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEnv(Collection<V1EnvVar> items) {
        if (this.env == null) {
            return (A)this;
        }
        for (V1EnvVar item : items) {
            V1EnvVarBuilder builder = new V1EnvVarBuilder(item);
            this._visitables.get("env").remove(builder);
            this.env.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEnv(Predicate<V1EnvVarBuilder> predicate) {
        if (this.env == null) {
            return (A)this;
        }
        Iterator<V1EnvVarBuilder> each = this.env.iterator();
        Object visitables = this._visitables.get("env");
        while (each.hasNext()) {
            V1EnvVarBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1EnvVar> buildEnv() {
        return this.env != null ? V1ContainerFluent.build(this.env) : null;
    }

    public V1EnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public V1EnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public V1EnvVar buildLastEnv() {
        return this.env.get(this.env.size() - 1).build();
    }

    public V1EnvVar buildMatchingEnv(Predicate<V1EnvVarBuilder> predicate) {
        for (V1EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnv(Predicate<V1EnvVarBuilder> predicate) {
        for (V1EnvVarBuilder item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnv(List<V1EnvVar> env) {
        if (this.env != null) {
            this._visitables.get("env").clear();
        }
        if (env != null) {
            this.env = new ArrayList();
            for (V1EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    public A withEnv(V1EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove("env");
        }
        if (env != null) {
            for (V1EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    public boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    public EnvNested<A> addNewEnv() {
        return new EnvNested(-1, null);
    }

    public EnvNested<A> addNewEnvLike(V1EnvVar item) {
        return new EnvNested(-1, item);
    }

    public EnvNested<A> setNewEnvLike(int index, V1EnvVar item) {
        return new EnvNested(index, item);
    }

    public EnvNested<A> editEnv(int index) {
        if (this.env.size() <= index) {
            throw new RuntimeException("Can't edit env. Index exceeds size.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editFirstEnv() {
        if (this.env.size() == 0) {
            throw new RuntimeException("Can't edit first env. The list is empty.");
        }
        return this.setNewEnvLike(0, this.buildEnv(0));
    }

    public EnvNested<A> editLastEnv() {
        int index = this.env.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last env. The list is empty.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public EnvNested<A> editMatchingEnv(Predicate<V1EnvVarBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.env.size(); ++i) {
            if (!predicate.test(this.env.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching env. No match found.");
        }
        return this.setNewEnvLike(index, this.buildEnv(index));
    }

    public A addToEnvFrom(int index, V1EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
        if (index < 0 || index >= this.envFrom.size()) {
            this._visitables.get("envFrom").add(builder);
            this.envFrom.add(builder);
        } else {
            this._visitables.get("envFrom").add(index, builder);
            this.envFrom.add(index, builder);
        }
        return (A)this;
    }

    public A setToEnvFrom(int index, V1EnvFromSource item) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
        if (index < 0 || index >= this.envFrom.size()) {
            this._visitables.get("envFrom").add(builder);
            this.envFrom.add(builder);
        } else {
            this._visitables.get("envFrom").set(index, builder);
            this.envFrom.set(index, builder);
        }
        return (A)this;
    }

    public A addToEnvFrom(V1EnvFromSource ... items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        for (V1EnvFromSource item : items) {
            V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").add(builder);
            this.envFrom.add(builder);
        }
        return (A)this;
    }

    public A addAllToEnvFrom(Collection<V1EnvFromSource> items) {
        if (this.envFrom == null) {
            this.envFrom = new ArrayList();
        }
        for (V1EnvFromSource item : items) {
            V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").add(builder);
            this.envFrom.add(builder);
        }
        return (A)this;
    }

    public A removeFromEnvFrom(V1EnvFromSource ... items) {
        if (this.envFrom == null) {
            return (A)this;
        }
        for (V1EnvFromSource item : items) {
            V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").remove(builder);
            this.envFrom.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromEnvFrom(Collection<V1EnvFromSource> items) {
        if (this.envFrom == null) {
            return (A)this;
        }
        for (V1EnvFromSource item : items) {
            V1EnvFromSourceBuilder builder = new V1EnvFromSourceBuilder(item);
            this._visitables.get("envFrom").remove(builder);
            this.envFrom.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromEnvFrom(Predicate<V1EnvFromSourceBuilder> predicate) {
        if (this.envFrom == null) {
            return (A)this;
        }
        Iterator<V1EnvFromSourceBuilder> each = this.envFrom.iterator();
        Object visitables = this._visitables.get("envFrom");
        while (each.hasNext()) {
            V1EnvFromSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1EnvFromSource> buildEnvFrom() {
        return this.envFrom != null ? V1ContainerFluent.build(this.envFrom) : null;
    }

    public V1EnvFromSource buildEnvFrom(int index) {
        return this.envFrom.get(index).build();
    }

    public V1EnvFromSource buildFirstEnvFrom() {
        return this.envFrom.get(0).build();
    }

    public V1EnvFromSource buildLastEnvFrom() {
        return this.envFrom.get(this.envFrom.size() - 1).build();
    }

    public V1EnvFromSource buildMatchingEnvFrom(Predicate<V1EnvFromSourceBuilder> predicate) {
        for (V1EnvFromSourceBuilder item : this.envFrom) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingEnvFrom(Predicate<V1EnvFromSourceBuilder> predicate) {
        for (V1EnvFromSourceBuilder item : this.envFrom) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withEnvFrom(List<V1EnvFromSource> envFrom) {
        if (this.envFrom != null) {
            this._visitables.get("envFrom").clear();
        }
        if (envFrom != null) {
            this.envFrom = new ArrayList();
            for (V1EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        } else {
            this.envFrom = null;
        }
        return (A)this;
    }

    public A withEnvFrom(V1EnvFromSource ... envFrom) {
        if (this.envFrom != null) {
            this.envFrom.clear();
            this._visitables.remove("envFrom");
        }
        if (envFrom != null) {
            for (V1EnvFromSource item : envFrom) {
                this.addToEnvFrom(item);
            }
        }
        return (A)this;
    }

    public boolean hasEnvFrom() {
        return this.envFrom != null && !this.envFrom.isEmpty();
    }

    public EnvFromNested<A> addNewEnvFrom() {
        return new EnvFromNested(-1, null);
    }

    public EnvFromNested<A> addNewEnvFromLike(V1EnvFromSource item) {
        return new EnvFromNested(-1, item);
    }

    public EnvFromNested<A> setNewEnvFromLike(int index, V1EnvFromSource item) {
        return new EnvFromNested(index, item);
    }

    public EnvFromNested<A> editEnvFrom(int index) {
        if (this.envFrom.size() <= index) {
            throw new RuntimeException("Can't edit envFrom. Index exceeds size.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    public EnvFromNested<A> editFirstEnvFrom() {
        if (this.envFrom.size() == 0) {
            throw new RuntimeException("Can't edit first envFrom. The list is empty.");
        }
        return this.setNewEnvFromLike(0, this.buildEnvFrom(0));
    }

    public EnvFromNested<A> editLastEnvFrom() {
        int index = this.envFrom.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last envFrom. The list is empty.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    public EnvFromNested<A> editMatchingEnvFrom(Predicate<V1EnvFromSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.envFrom.size(); ++i) {
            if (!predicate.test(this.envFrom.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching envFrom. No match found.");
        }
        return this.setNewEnvFromLike(index, this.buildEnvFrom(index));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public String getImagePullPolicy() {
        return this.imagePullPolicy;
    }

    public A withImagePullPolicy(String imagePullPolicy) {
        this.imagePullPolicy = imagePullPolicy;
        return (A)this;
    }

    public boolean hasImagePullPolicy() {
        return this.imagePullPolicy != null;
    }

    public V1Lifecycle buildLifecycle() {
        return this.lifecycle != null ? this.lifecycle.build() : null;
    }

    public A withLifecycle(V1Lifecycle lifecycle) {
        this._visitables.remove("lifecycle");
        if (lifecycle != null) {
            this.lifecycle = new V1LifecycleBuilder(lifecycle);
            this._visitables.get("lifecycle").add(this.lifecycle);
        } else {
            this.lifecycle = null;
            this._visitables.get("lifecycle").remove(this.lifecycle);
        }
        return (A)this;
    }

    public boolean hasLifecycle() {
        return this.lifecycle != null;
    }

    public LifecycleNested<A> withNewLifecycle() {
        return new LifecycleNested(null);
    }

    public LifecycleNested<A> withNewLifecycleLike(V1Lifecycle item) {
        return new LifecycleNested(item);
    }

    public LifecycleNested<A> editLifecycle() {
        return this.withNewLifecycleLike(Optional.ofNullable(this.buildLifecycle()).orElse(null));
    }

    public LifecycleNested<A> editOrNewLifecycle() {
        return this.withNewLifecycleLike(Optional.ofNullable(this.buildLifecycle()).orElse(new V1LifecycleBuilder().build()));
    }

    public LifecycleNested<A> editOrNewLifecycleLike(V1Lifecycle item) {
        return this.withNewLifecycleLike(Optional.ofNullable(this.buildLifecycle()).orElse(item));
    }

    public V1Probe buildLivenessProbe() {
        return this.livenessProbe != null ? this.livenessProbe.build() : null;
    }

    public A withLivenessProbe(V1Probe livenessProbe) {
        this._visitables.remove("livenessProbe");
        if (livenessProbe != null) {
            this.livenessProbe = new V1ProbeBuilder(livenessProbe);
            this._visitables.get("livenessProbe").add(this.livenessProbe);
        } else {
            this.livenessProbe = null;
            this._visitables.get("livenessProbe").remove(this.livenessProbe);
        }
        return (A)this;
    }

    public boolean hasLivenessProbe() {
        return this.livenessProbe != null;
    }

    public LivenessProbeNested<A> withNewLivenessProbe() {
        return new LivenessProbeNested(null);
    }

    public LivenessProbeNested<A> withNewLivenessProbeLike(V1Probe item) {
        return new LivenessProbeNested(item);
    }

    public LivenessProbeNested<A> editLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(null));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbe() {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(new V1ProbeBuilder().build()));
    }

    public LivenessProbeNested<A> editOrNewLivenessProbeLike(V1Probe item) {
        return this.withNewLivenessProbeLike(Optional.ofNullable(this.buildLivenessProbe()).orElse(item));
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public A addToPorts(int index, V1ContainerPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    public A setToPorts(int index, V1ContainerPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    public A addToPorts(V1ContainerPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (V1ContainerPort item : items) {
            V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A addAllToPorts(Collection<V1ContainerPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (V1ContainerPort item : items) {
            V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    public A removeFromPorts(V1ContainerPort ... items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (V1ContainerPort item : items) {
            V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromPorts(Collection<V1ContainerPort> items) {
        if (this.ports == null) {
            return (A)this;
        }
        for (V1ContainerPort item : items) {
            V1ContainerPortBuilder builder = new V1ContainerPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            this.ports.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromPorts(Predicate<V1ContainerPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<V1ContainerPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            V1ContainerPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ContainerPort> buildPorts() {
        return this.ports != null ? V1ContainerFluent.build(this.ports) : null;
    }

    public V1ContainerPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    public V1ContainerPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    public V1ContainerPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    public V1ContainerPort buildMatchingPort(Predicate<V1ContainerPortBuilder> predicate) {
        for (V1ContainerPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingPort(Predicate<V1ContainerPortBuilder> predicate) {
        for (V1ContainerPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPorts(List<V1ContainerPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (V1ContainerPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    public A withPorts(V1ContainerPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (V1ContainerPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    public boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public PortsNested<A> addNewPort() {
        return new PortsNested(-1, null);
    }

    public PortsNested<A> addNewPortLike(V1ContainerPort item) {
        return new PortsNested(-1, item);
    }

    public PortsNested<A> setNewPortLike(int index, V1ContainerPort item) {
        return new PortsNested(index, item);
    }

    public PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    public PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public PortsNested<A> editMatchingPort(Predicate<V1ContainerPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public V1Probe buildReadinessProbe() {
        return this.readinessProbe != null ? this.readinessProbe.build() : null;
    }

    public A withReadinessProbe(V1Probe readinessProbe) {
        this._visitables.remove("readinessProbe");
        if (readinessProbe != null) {
            this.readinessProbe = new V1ProbeBuilder(readinessProbe);
            this._visitables.get("readinessProbe").add(this.readinessProbe);
        } else {
            this.readinessProbe = null;
            this._visitables.get("readinessProbe").remove(this.readinessProbe);
        }
        return (A)this;
    }

    public boolean hasReadinessProbe() {
        return this.readinessProbe != null;
    }

    public ReadinessProbeNested<A> withNewReadinessProbe() {
        return new ReadinessProbeNested(null);
    }

    public ReadinessProbeNested<A> withNewReadinessProbeLike(V1Probe item) {
        return new ReadinessProbeNested(item);
    }

    public ReadinessProbeNested<A> editReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(null));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbe() {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(new V1ProbeBuilder().build()));
    }

    public ReadinessProbeNested<A> editOrNewReadinessProbeLike(V1Probe item) {
        return this.withNewReadinessProbeLike(Optional.ofNullable(this.buildReadinessProbe()).orElse(item));
    }

    public A addToResizePolicy(int index, V1ContainerResizePolicy item) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList();
        }
        V1ContainerResizePolicyBuilder builder = new V1ContainerResizePolicyBuilder(item);
        if (index < 0 || index >= this.resizePolicy.size()) {
            this._visitables.get("resizePolicy").add(builder);
            this.resizePolicy.add(builder);
        } else {
            this._visitables.get("resizePolicy").add(index, builder);
            this.resizePolicy.add(index, builder);
        }
        return (A)this;
    }

    public A setToResizePolicy(int index, V1ContainerResizePolicy item) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList();
        }
        V1ContainerResizePolicyBuilder builder = new V1ContainerResizePolicyBuilder(item);
        if (index < 0 || index >= this.resizePolicy.size()) {
            this._visitables.get("resizePolicy").add(builder);
            this.resizePolicy.add(builder);
        } else {
            this._visitables.get("resizePolicy").set(index, builder);
            this.resizePolicy.set(index, builder);
        }
        return (A)this;
    }

    public A addToResizePolicy(V1ContainerResizePolicy ... items) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList();
        }
        for (V1ContainerResizePolicy item : items) {
            V1ContainerResizePolicyBuilder builder = new V1ContainerResizePolicyBuilder(item);
            this._visitables.get("resizePolicy").add(builder);
            this.resizePolicy.add(builder);
        }
        return (A)this;
    }

    public A addAllToResizePolicy(Collection<V1ContainerResizePolicy> items) {
        if (this.resizePolicy == null) {
            this.resizePolicy = new ArrayList();
        }
        for (V1ContainerResizePolicy item : items) {
            V1ContainerResizePolicyBuilder builder = new V1ContainerResizePolicyBuilder(item);
            this._visitables.get("resizePolicy").add(builder);
            this.resizePolicy.add(builder);
        }
        return (A)this;
    }

    public A removeFromResizePolicy(V1ContainerResizePolicy ... items) {
        if (this.resizePolicy == null) {
            return (A)this;
        }
        for (V1ContainerResizePolicy item : items) {
            V1ContainerResizePolicyBuilder builder = new V1ContainerResizePolicyBuilder(item);
            this._visitables.get("resizePolicy").remove(builder);
            this.resizePolicy.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromResizePolicy(Collection<V1ContainerResizePolicy> items) {
        if (this.resizePolicy == null) {
            return (A)this;
        }
        for (V1ContainerResizePolicy item : items) {
            V1ContainerResizePolicyBuilder builder = new V1ContainerResizePolicyBuilder(item);
            this._visitables.get("resizePolicy").remove(builder);
            this.resizePolicy.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromResizePolicy(Predicate<V1ContainerResizePolicyBuilder> predicate) {
        if (this.resizePolicy == null) {
            return (A)this;
        }
        Iterator<V1ContainerResizePolicyBuilder> each = this.resizePolicy.iterator();
        Object visitables = this._visitables.get("resizePolicy");
        while (each.hasNext()) {
            V1ContainerResizePolicyBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1ContainerResizePolicy> buildResizePolicy() {
        return this.resizePolicy != null ? V1ContainerFluent.build(this.resizePolicy) : null;
    }

    public V1ContainerResizePolicy buildResizePolicy(int index) {
        return this.resizePolicy.get(index).build();
    }

    public V1ContainerResizePolicy buildFirstResizePolicy() {
        return this.resizePolicy.get(0).build();
    }

    public V1ContainerResizePolicy buildLastResizePolicy() {
        return this.resizePolicy.get(this.resizePolicy.size() - 1).build();
    }

    public V1ContainerResizePolicy buildMatchingResizePolicy(Predicate<V1ContainerResizePolicyBuilder> predicate) {
        for (V1ContainerResizePolicyBuilder item : this.resizePolicy) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingResizePolicy(Predicate<V1ContainerResizePolicyBuilder> predicate) {
        for (V1ContainerResizePolicyBuilder item : this.resizePolicy) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withResizePolicy(List<V1ContainerResizePolicy> resizePolicy) {
        if (this.resizePolicy != null) {
            this._visitables.get("resizePolicy").clear();
        }
        if (resizePolicy != null) {
            this.resizePolicy = new ArrayList();
            for (V1ContainerResizePolicy item : resizePolicy) {
                this.addToResizePolicy(item);
            }
        } else {
            this.resizePolicy = null;
        }
        return (A)this;
    }

    public A withResizePolicy(V1ContainerResizePolicy ... resizePolicy) {
        if (this.resizePolicy != null) {
            this.resizePolicy.clear();
            this._visitables.remove("resizePolicy");
        }
        if (resizePolicy != null) {
            for (V1ContainerResizePolicy item : resizePolicy) {
                this.addToResizePolicy(item);
            }
        }
        return (A)this;
    }

    public boolean hasResizePolicy() {
        return this.resizePolicy != null && !this.resizePolicy.isEmpty();
    }

    public ResizePolicyNested<A> addNewResizePolicy() {
        return new ResizePolicyNested(-1, null);
    }

    public ResizePolicyNested<A> addNewResizePolicyLike(V1ContainerResizePolicy item) {
        return new ResizePolicyNested(-1, item);
    }

    public ResizePolicyNested<A> setNewResizePolicyLike(int index, V1ContainerResizePolicy item) {
        return new ResizePolicyNested(index, item);
    }

    public ResizePolicyNested<A> editResizePolicy(int index) {
        if (this.resizePolicy.size() <= index) {
            throw new RuntimeException("Can't edit resizePolicy. Index exceeds size.");
        }
        return this.setNewResizePolicyLike(index, this.buildResizePolicy(index));
    }

    public ResizePolicyNested<A> editFirstResizePolicy() {
        if (this.resizePolicy.size() == 0) {
            throw new RuntimeException("Can't edit first resizePolicy. The list is empty.");
        }
        return this.setNewResizePolicyLike(0, this.buildResizePolicy(0));
    }

    public ResizePolicyNested<A> editLastResizePolicy() {
        int index = this.resizePolicy.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resizePolicy. The list is empty.");
        }
        return this.setNewResizePolicyLike(index, this.buildResizePolicy(index));
    }

    public ResizePolicyNested<A> editMatchingResizePolicy(Predicate<V1ContainerResizePolicyBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resizePolicy.size(); ++i) {
            if (!predicate.test(this.resizePolicy.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resizePolicy. No match found.");
        }
        return this.setNewResizePolicyLike(index, this.buildResizePolicy(index));
    }

    public V1ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    public A withResources(V1ResourceRequirements resources) {
        this._visitables.remove("resources");
        if (resources != null) {
            this.resources = new V1ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    public boolean hasResources() {
        return this.resources != null;
    }

    public ResourcesNested<A> withNewResources() {
        return new ResourcesNested(null);
    }

    public ResourcesNested<A> withNewResourcesLike(V1ResourceRequirements item) {
        return new ResourcesNested(item);
    }

    public ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(null));
    }

    public ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(new V1ResourceRequirementsBuilder().build()));
    }

    public ResourcesNested<A> editOrNewResourcesLike(V1ResourceRequirements item) {
        return this.withNewResourcesLike(Optional.ofNullable(this.buildResources()).orElse(item));
    }

    public String getRestartPolicy() {
        return this.restartPolicy;
    }

    public A withRestartPolicy(String restartPolicy) {
        this.restartPolicy = restartPolicy;
        return (A)this;
    }

    public boolean hasRestartPolicy() {
        return this.restartPolicy != null;
    }

    public V1SecurityContext buildSecurityContext() {
        return this.securityContext != null ? this.securityContext.build() : null;
    }

    public A withSecurityContext(V1SecurityContext securityContext) {
        this._visitables.remove("securityContext");
        if (securityContext != null) {
            this.securityContext = new V1SecurityContextBuilder(securityContext);
            this._visitables.get("securityContext").add(this.securityContext);
        } else {
            this.securityContext = null;
            this._visitables.get("securityContext").remove(this.securityContext);
        }
        return (A)this;
    }

    public boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public SecurityContextNested<A> withNewSecurityContext() {
        return new SecurityContextNested(null);
    }

    public SecurityContextNested<A> withNewSecurityContextLike(V1SecurityContext item) {
        return new SecurityContextNested(item);
    }

    public SecurityContextNested<A> editSecurityContext() {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(null));
    }

    public SecurityContextNested<A> editOrNewSecurityContext() {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(new V1SecurityContextBuilder().build()));
    }

    public SecurityContextNested<A> editOrNewSecurityContextLike(V1SecurityContext item) {
        return this.withNewSecurityContextLike(Optional.ofNullable(this.buildSecurityContext()).orElse(item));
    }

    public V1Probe buildStartupProbe() {
        return this.startupProbe != null ? this.startupProbe.build() : null;
    }

    public A withStartupProbe(V1Probe startupProbe) {
        this._visitables.remove("startupProbe");
        if (startupProbe != null) {
            this.startupProbe = new V1ProbeBuilder(startupProbe);
            this._visitables.get("startupProbe").add(this.startupProbe);
        } else {
            this.startupProbe = null;
            this._visitables.get("startupProbe").remove(this.startupProbe);
        }
        return (A)this;
    }

    public boolean hasStartupProbe() {
        return this.startupProbe != null;
    }

    public StartupProbeNested<A> withNewStartupProbe() {
        return new StartupProbeNested(null);
    }

    public StartupProbeNested<A> withNewStartupProbeLike(V1Probe item) {
        return new StartupProbeNested(item);
    }

    public StartupProbeNested<A> editStartupProbe() {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(null));
    }

    public StartupProbeNested<A> editOrNewStartupProbe() {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(new V1ProbeBuilder().build()));
    }

    public StartupProbeNested<A> editOrNewStartupProbeLike(V1Probe item) {
        return this.withNewStartupProbeLike(Optional.ofNullable(this.buildStartupProbe()).orElse(item));
    }

    public Boolean getStdin() {
        return this.stdin;
    }

    public A withStdin(Boolean stdin) {
        this.stdin = stdin;
        return (A)this;
    }

    public boolean hasStdin() {
        return this.stdin != null;
    }

    public Boolean getStdinOnce() {
        return this.stdinOnce;
    }

    public A withStdinOnce(Boolean stdinOnce) {
        this.stdinOnce = stdinOnce;
        return (A)this;
    }

    public boolean hasStdinOnce() {
        return this.stdinOnce != null;
    }

    public String getTerminationMessagePath() {
        return this.terminationMessagePath;
    }

    public A withTerminationMessagePath(String terminationMessagePath) {
        this.terminationMessagePath = terminationMessagePath;
        return (A)this;
    }

    public boolean hasTerminationMessagePath() {
        return this.terminationMessagePath != null;
    }

    public String getTerminationMessagePolicy() {
        return this.terminationMessagePolicy;
    }

    public A withTerminationMessagePolicy(String terminationMessagePolicy) {
        this.terminationMessagePolicy = terminationMessagePolicy;
        return (A)this;
    }

    public boolean hasTerminationMessagePolicy() {
        return this.terminationMessagePolicy != null;
    }

    public Boolean getTty() {
        return this.tty;
    }

    public A withTty(Boolean tty) {
        this.tty = tty;
        return (A)this;
    }

    public boolean hasTty() {
        return this.tty != null;
    }

    public A addToVolumeDevices(int index, V1VolumeDevice item) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
        if (index < 0 || index >= this.volumeDevices.size()) {
            this._visitables.get("volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        } else {
            this._visitables.get("volumeDevices").add(index, builder);
            this.volumeDevices.add(index, builder);
        }
        return (A)this;
    }

    public A setToVolumeDevices(int index, V1VolumeDevice item) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
        if (index < 0 || index >= this.volumeDevices.size()) {
            this._visitables.get("volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        } else {
            this._visitables.get("volumeDevices").set(index, builder);
            this.volumeDevices.set(index, builder);
        }
        return (A)this;
    }

    public A addToVolumeDevices(V1VolumeDevice ... items) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        for (V1VolumeDevice item : items) {
            V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
            this._visitables.get("volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        }
        return (A)this;
    }

    public A addAllToVolumeDevices(Collection<V1VolumeDevice> items) {
        if (this.volumeDevices == null) {
            this.volumeDevices = new ArrayList();
        }
        for (V1VolumeDevice item : items) {
            V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
            this._visitables.get("volumeDevices").add(builder);
            this.volumeDevices.add(builder);
        }
        return (A)this;
    }

    public A removeFromVolumeDevices(V1VolumeDevice ... items) {
        if (this.volumeDevices == null) {
            return (A)this;
        }
        for (V1VolumeDevice item : items) {
            V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
            this._visitables.get("volumeDevices").remove(builder);
            this.volumeDevices.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVolumeDevices(Collection<V1VolumeDevice> items) {
        if (this.volumeDevices == null) {
            return (A)this;
        }
        for (V1VolumeDevice item : items) {
            V1VolumeDeviceBuilder builder = new V1VolumeDeviceBuilder(item);
            this._visitables.get("volumeDevices").remove(builder);
            this.volumeDevices.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVolumeDevices(Predicate<V1VolumeDeviceBuilder> predicate) {
        if (this.volumeDevices == null) {
            return (A)this;
        }
        Iterator<V1VolumeDeviceBuilder> each = this.volumeDevices.iterator();
        Object visitables = this._visitables.get("volumeDevices");
        while (each.hasNext()) {
            V1VolumeDeviceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1VolumeDevice> buildVolumeDevices() {
        return this.volumeDevices != null ? V1ContainerFluent.build(this.volumeDevices) : null;
    }

    public V1VolumeDevice buildVolumeDevice(int index) {
        return this.volumeDevices.get(index).build();
    }

    public V1VolumeDevice buildFirstVolumeDevice() {
        return this.volumeDevices.get(0).build();
    }

    public V1VolumeDevice buildLastVolumeDevice() {
        return this.volumeDevices.get(this.volumeDevices.size() - 1).build();
    }

    public V1VolumeDevice buildMatchingVolumeDevice(Predicate<V1VolumeDeviceBuilder> predicate) {
        for (V1VolumeDeviceBuilder item : this.volumeDevices) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolumeDevice(Predicate<V1VolumeDeviceBuilder> predicate) {
        for (V1VolumeDeviceBuilder item : this.volumeDevices) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeDevices(List<V1VolumeDevice> volumeDevices) {
        if (this.volumeDevices != null) {
            this._visitables.get("volumeDevices").clear();
        }
        if (volumeDevices != null) {
            this.volumeDevices = new ArrayList();
            for (V1VolumeDevice item : volumeDevices) {
                this.addToVolumeDevices(item);
            }
        } else {
            this.volumeDevices = null;
        }
        return (A)this;
    }

    public A withVolumeDevices(V1VolumeDevice ... volumeDevices) {
        if (this.volumeDevices != null) {
            this.volumeDevices.clear();
            this._visitables.remove("volumeDevices");
        }
        if (volumeDevices != null) {
            for (V1VolumeDevice item : volumeDevices) {
                this.addToVolumeDevices(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumeDevices() {
        return this.volumeDevices != null && !this.volumeDevices.isEmpty();
    }

    public VolumeDevicesNested<A> addNewVolumeDevice() {
        return new VolumeDevicesNested(-1, null);
    }

    public VolumeDevicesNested<A> addNewVolumeDeviceLike(V1VolumeDevice item) {
        return new VolumeDevicesNested(-1, item);
    }

    public VolumeDevicesNested<A> setNewVolumeDeviceLike(int index, V1VolumeDevice item) {
        return new VolumeDevicesNested(index, item);
    }

    public VolumeDevicesNested<A> editVolumeDevice(int index) {
        if (this.volumeDevices.size() <= index) {
            throw new RuntimeException("Can't edit volumeDevices. Index exceeds size.");
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    public VolumeDevicesNested<A> editFirstVolumeDevice() {
        if (this.volumeDevices.size() == 0) {
            throw new RuntimeException("Can't edit first volumeDevices. The list is empty.");
        }
        return this.setNewVolumeDeviceLike(0, this.buildVolumeDevice(0));
    }

    public VolumeDevicesNested<A> editLastVolumeDevice() {
        int index = this.volumeDevices.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeDevices. The list is empty.");
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    public VolumeDevicesNested<A> editMatchingVolumeDevice(Predicate<V1VolumeDeviceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeDevices.size(); ++i) {
            if (!predicate.test(this.volumeDevices.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeDevices. No match found.");
        }
        return this.setNewVolumeDeviceLike(index, this.buildVolumeDevice(index));
    }

    public A addToVolumeMounts(int index, V1VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get("volumeMounts").add(index, builder);
            this.volumeMounts.add(index, builder);
        }
        return (A)this;
    }

    public A setToVolumeMounts(int index, V1VolumeMount item) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
        if (index < 0 || index >= this.volumeMounts.size()) {
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        } else {
            this._visitables.get("volumeMounts").set(index, builder);
            this.volumeMounts.set(index, builder);
        }
        return (A)this;
    }

    public A addToVolumeMounts(V1VolumeMount ... items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (V1VolumeMount item : items) {
            V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    public A addAllToVolumeMounts(Collection<V1VolumeMount> items) {
        if (this.volumeMounts == null) {
            this.volumeMounts = new ArrayList();
        }
        for (V1VolumeMount item : items) {
            V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").add(builder);
            this.volumeMounts.add(builder);
        }
        return (A)this;
    }

    public A removeFromVolumeMounts(V1VolumeMount ... items) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        for (V1VolumeMount item : items) {
            V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    public A removeAllFromVolumeMounts(Collection<V1VolumeMount> items) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        for (V1VolumeMount item : items) {
            V1VolumeMountBuilder builder = new V1VolumeMountBuilder(item);
            this._visitables.get("volumeMounts").remove(builder);
            this.volumeMounts.remove(builder);
        }
        return (A)this;
    }

    public A removeMatchingFromVolumeMounts(Predicate<V1VolumeMountBuilder> predicate) {
        if (this.volumeMounts == null) {
            return (A)this;
        }
        Iterator<V1VolumeMountBuilder> each = this.volumeMounts.iterator();
        Object visitables = this._visitables.get("volumeMounts");
        while (each.hasNext()) {
            V1VolumeMountBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    public List<V1VolumeMount> buildVolumeMounts() {
        return this.volumeMounts != null ? V1ContainerFluent.build(this.volumeMounts) : null;
    }

    public V1VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public V1VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public V1VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(this.volumeMounts.size() - 1).build();
    }

    public V1VolumeMount buildMatchingVolumeMount(Predicate<V1VolumeMountBuilder> predicate) {
        for (V1VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingVolumeMount(Predicate<V1VolumeMountBuilder> predicate) {
        for (V1VolumeMountBuilder item : this.volumeMounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withVolumeMounts(List<V1VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) {
            this._visitables.get("volumeMounts").clear();
        }
        if (volumeMounts != null) {
            this.volumeMounts = new ArrayList();
            for (V1VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        } else {
            this.volumeMounts = null;
        }
        return (A)this;
    }

    public A withVolumeMounts(V1VolumeMount ... volumeMounts) {
        if (this.volumeMounts != null) {
            this.volumeMounts.clear();
            this._visitables.remove("volumeMounts");
        }
        if (volumeMounts != null) {
            for (V1VolumeMount item : volumeMounts) {
                this.addToVolumeMounts(item);
            }
        }
        return (A)this;
    }

    public boolean hasVolumeMounts() {
        return this.volumeMounts != null && !this.volumeMounts.isEmpty();
    }

    public VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNested(-1, null);
    }

    public VolumeMountsNested<A> addNewVolumeMountLike(V1VolumeMount item) {
        return new VolumeMountsNested(-1, item);
    }

    public VolumeMountsNested<A> setNewVolumeMountLike(int index, V1VolumeMount item) {
        return new VolumeMountsNested(index, item);
    }

    public VolumeMountsNested<A> editVolumeMount(int index) {
        if (this.volumeMounts.size() <= index) {
            throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public VolumeMountsNested<A> editFirstVolumeMount() {
        if (this.volumeMounts.size() == 0) {
            throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(0, this.buildVolumeMount(0));
    }

    public VolumeMountsNested<A> editLastVolumeMount() {
        int index = this.volumeMounts.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public VolumeMountsNested<A> editMatchingVolumeMount(Predicate<V1VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.volumeMounts.size(); ++i) {
            if (!predicate.test(this.volumeMounts.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        }
        return this.setNewVolumeMountLike(index, this.buildVolumeMount(index));
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public A withWorkingDir(String workingDir) {
        this.workingDir = workingDir;
        return (A)this;
    }

    public boolean hasWorkingDir() {
        return this.workingDir != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ContainerFluent that = (V1ContainerFluent)o;
        if (!Objects.equals(this.args, that.args)) {
            return false;
        }
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.envFrom, that.envFrom)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.imagePullPolicy, that.imagePullPolicy)) {
            return false;
        }
        if (!Objects.equals(this.lifecycle, that.lifecycle)) {
            return false;
        }
        if (!Objects.equals(this.livenessProbe, that.livenessProbe)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals(this.readinessProbe, that.readinessProbe)) {
            return false;
        }
        if (!Objects.equals(this.resizePolicy, that.resizePolicy)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.restartPolicy, that.restartPolicy)) {
            return false;
        }
        if (!Objects.equals(this.securityContext, that.securityContext)) {
            return false;
        }
        if (!Objects.equals(this.startupProbe, that.startupProbe)) {
            return false;
        }
        if (!Objects.equals(this.stdin, that.stdin)) {
            return false;
        }
        if (!Objects.equals(this.stdinOnce, that.stdinOnce)) {
            return false;
        }
        if (!Objects.equals(this.terminationMessagePath, that.terminationMessagePath)) {
            return false;
        }
        if (!Objects.equals(this.terminationMessagePolicy, that.terminationMessagePolicy)) {
            return false;
        }
        if (!Objects.equals(this.tty, that.tty)) {
            return false;
        }
        if (!Objects.equals(this.volumeDevices, that.volumeDevices)) {
            return false;
        }
        if (!Objects.equals(this.volumeMounts, that.volumeMounts)) {
            return false;
        }
        return Objects.equals(this.workingDir, that.workingDir);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.args, this.command, this.env, this.envFrom, this.image, this.imagePullPolicy, this.lifecycle, this.livenessProbe, this.name, this.ports, this.readinessProbe, this.resizePolicy, this.resources, this.restartPolicy, this.securityContext, this.startupProbe, this.stdin, this.stdinOnce, this.terminationMessagePath, this.terminationMessagePolicy, this.tty, this.volumeDevices, this.volumeMounts, this.workingDir, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.args != null && !this.args.isEmpty()) {
            sb.append("args:");
            sb.append(this.args + ",");
        }
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(this.command + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.envFrom != null && !this.envFrom.isEmpty()) {
            sb.append("envFrom:");
            sb.append(this.envFrom + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.imagePullPolicy != null) {
            sb.append("imagePullPolicy:");
            sb.append(this.imagePullPolicy + ",");
        }
        if (this.lifecycle != null) {
            sb.append("lifecycle:");
            sb.append(this.lifecycle + ",");
        }
        if (this.livenessProbe != null) {
            sb.append("livenessProbe:");
            sb.append(this.livenessProbe + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.readinessProbe != null) {
            sb.append("readinessProbe:");
            sb.append(this.readinessProbe + ",");
        }
        if (this.resizePolicy != null && !this.resizePolicy.isEmpty()) {
            sb.append("resizePolicy:");
            sb.append(this.resizePolicy + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.restartPolicy != null) {
            sb.append("restartPolicy:");
            sb.append(this.restartPolicy + ",");
        }
        if (this.securityContext != null) {
            sb.append("securityContext:");
            sb.append(this.securityContext + ",");
        }
        if (this.startupProbe != null) {
            sb.append("startupProbe:");
            sb.append(this.startupProbe + ",");
        }
        if (this.stdin != null) {
            sb.append("stdin:");
            sb.append(this.stdin + ",");
        }
        if (this.stdinOnce != null) {
            sb.append("stdinOnce:");
            sb.append(this.stdinOnce + ",");
        }
        if (this.terminationMessagePath != null) {
            sb.append("terminationMessagePath:");
            sb.append(this.terminationMessagePath + ",");
        }
        if (this.terminationMessagePolicy != null) {
            sb.append("terminationMessagePolicy:");
            sb.append(this.terminationMessagePolicy + ",");
        }
        if (this.tty != null) {
            sb.append("tty:");
            sb.append(this.tty + ",");
        }
        if (this.volumeDevices != null && !this.volumeDevices.isEmpty()) {
            sb.append("volumeDevices:");
            sb.append(this.volumeDevices + ",");
        }
        if (this.volumeMounts != null && !this.volumeMounts.isEmpty()) {
            sb.append("volumeMounts:");
            sb.append(this.volumeMounts + ",");
        }
        if (this.workingDir != null) {
            sb.append("workingDir:");
            sb.append(this.workingDir);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withStdin() {
        return this.withStdin(true);
    }

    public A withStdinOnce() {
        return this.withStdinOnce(true);
    }

    public A withTty() {
        return this.withTty(true);
    }

    public class EnvNested<N>
    extends V1EnvVarFluent<EnvNested<N>>
    implements Nested<N> {
        V1EnvVarBuilder builder;
        int index;

        EnvNested(int index, V1EnvVar item) {
            this.index = index;
            this.builder = new V1EnvVarBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluent.this.setToEnv(this.index, this.builder.build());
        }

        public N endEnv() {
            return this.and();
        }
    }

    public class EnvFromNested<N>
    extends V1EnvFromSourceFluent<EnvFromNested<N>>
    implements Nested<N> {
        V1EnvFromSourceBuilder builder;
        int index;

        EnvFromNested(int index, V1EnvFromSource item) {
            this.index = index;
            this.builder = new V1EnvFromSourceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluent.this.setToEnvFrom(this.index, this.builder.build());
        }

        public N endEnvFrom() {
            return this.and();
        }
    }

    public class LifecycleNested<N>
    extends V1LifecycleFluent<LifecycleNested<N>>
    implements Nested<N> {
        V1LifecycleBuilder builder;

        LifecycleNested(V1Lifecycle item) {
            this.builder = new V1LifecycleBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluent.this.withLifecycle(this.builder.build());
        }

        public N endLifecycle() {
            return this.and();
        }
    }

    public class LivenessProbeNested<N>
    extends V1ProbeFluent<LivenessProbeNested<N>>
    implements Nested<N> {
        V1ProbeBuilder builder;

        LivenessProbeNested(V1Probe item) {
            this.builder = new V1ProbeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluent.this.withLivenessProbe(this.builder.build());
        }

        public N endLivenessProbe() {
            return this.and();
        }
    }

    public class PortsNested<N>
    extends V1ContainerPortFluent<PortsNested<N>>
    implements Nested<N> {
        V1ContainerPortBuilder builder;
        int index;

        PortsNested(int index, V1ContainerPort item) {
            this.index = index;
            this.builder = new V1ContainerPortBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluent.this.setToPorts(this.index, this.builder.build());
        }

        public N endPort() {
            return this.and();
        }
    }

    public class ReadinessProbeNested<N>
    extends V1ProbeFluent<ReadinessProbeNested<N>>
    implements Nested<N> {
        V1ProbeBuilder builder;

        ReadinessProbeNested(V1Probe item) {
            this.builder = new V1ProbeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluent.this.withReadinessProbe(this.builder.build());
        }

        public N endReadinessProbe() {
            return this.and();
        }
    }

    public class ResizePolicyNested<N>
    extends V1ContainerResizePolicyFluent<ResizePolicyNested<N>>
    implements Nested<N> {
        V1ContainerResizePolicyBuilder builder;
        int index;

        ResizePolicyNested(int index, V1ContainerResizePolicy item) {
            this.index = index;
            this.builder = new V1ContainerResizePolicyBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluent.this.setToResizePolicy(this.index, this.builder.build());
        }

        public N endResizePolicy() {
            return this.and();
        }
    }

    public class ResourcesNested<N>
    extends V1ResourceRequirementsFluent<ResourcesNested<N>>
    implements Nested<N> {
        V1ResourceRequirementsBuilder builder;

        ResourcesNested(V1ResourceRequirements item) {
            this.builder = new V1ResourceRequirementsBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluent.this.withResources(this.builder.build());
        }

        public N endResources() {
            return this.and();
        }
    }

    public class SecurityContextNested<N>
    extends V1SecurityContextFluent<SecurityContextNested<N>>
    implements Nested<N> {
        V1SecurityContextBuilder builder;

        SecurityContextNested(V1SecurityContext item) {
            this.builder = new V1SecurityContextBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluent.this.withSecurityContext(this.builder.build());
        }

        public N endSecurityContext() {
            return this.and();
        }
    }

    public class StartupProbeNested<N>
    extends V1ProbeFluent<StartupProbeNested<N>>
    implements Nested<N> {
        V1ProbeBuilder builder;

        StartupProbeNested(V1Probe item) {
            this.builder = new V1ProbeBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluent.this.withStartupProbe(this.builder.build());
        }

        public N endStartupProbe() {
            return this.and();
        }
    }

    public class VolumeDevicesNested<N>
    extends V1VolumeDeviceFluent<VolumeDevicesNested<N>>
    implements Nested<N> {
        V1VolumeDeviceBuilder builder;
        int index;

        VolumeDevicesNested(int index, V1VolumeDevice item) {
            this.index = index;
            this.builder = new V1VolumeDeviceBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluent.this.setToVolumeDevices(this.index, this.builder.build());
        }

        public N endVolumeDevice() {
            return this.and();
        }
    }

    public class VolumeMountsNested<N>
    extends V1VolumeMountFluent<VolumeMountsNested<N>>
    implements Nested<N> {
        V1VolumeMountBuilder builder;
        int index;

        VolumeMountsNested(int index, V1VolumeMount item) {
            this.index = index;
            this.builder = new V1VolumeMountBuilder(this, item);
        }

        @Override
        public N and() {
            return (N)V1ContainerFluent.this.setToVolumeMounts(this.index, this.builder.build());
        }

        public N endVolumeMount() {
            return this.and();
        }
    }
}

