/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V2MetricTarget;
import io.kubernetes.client.openapi.models.V2MetricTargetFluent;
import java.util.Objects;

public class V2MetricTargetFluentImpl<A extends V2MetricTargetFluent<A>>
extends BaseFluent<A>
implements V2MetricTargetFluent<A> {
    private Integer averageUtilization;
    private Quantity averageValue;
    private String type;
    private Quantity value;

    public V2MetricTargetFluentImpl() {
    }

    public V2MetricTargetFluentImpl(V2MetricTarget instance) {
        this.withAverageUtilization(instance.getAverageUtilization());
        this.withAverageValue(instance.getAverageValue());
        this.withType(instance.getType());
        this.withValue(instance.getValue());
    }

    @Override
    public Integer getAverageUtilization() {
        return this.averageUtilization;
    }

    @Override
    public A withAverageUtilization(Integer averageUtilization) {
        this.averageUtilization = averageUtilization;
        return (A)this;
    }

    @Override
    public Boolean hasAverageUtilization() {
        return this.averageUtilization != null;
    }

    @Override
    public Quantity getAverageValue() {
        return this.averageValue;
    }

    @Override
    public A withAverageValue(Quantity averageValue) {
        this.averageValue = averageValue;
        return (A)this;
    }

    @Override
    public Boolean hasAverageValue() {
        return this.averageValue != null;
    }

    @Override
    public A withNewAverageValue(String value) {
        return this.withAverageValue(new Quantity(value));
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public A withType(String type) {
        this.type = type;
        return (A)this;
    }

    @Override
    public Boolean hasType() {
        return this.type != null;
    }

    @Override
    public Quantity getValue() {
        return this.value;
    }

    @Override
    public A withValue(Quantity value) {
        this.value = value;
        return (A)this;
    }

    @Override
    public Boolean hasValue() {
        return this.value != null;
    }

    @Override
    public A withNewValue(String value) {
        return this.withValue(new Quantity(value));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V2MetricTargetFluentImpl that = (V2MetricTargetFluentImpl)o;
        if (this.averageUtilization != null ? !this.averageUtilization.equals(that.averageUtilization) : that.averageUtilization != null) {
            return false;
        }
        if (this.averageValue != null ? !this.averageValue.equals((Object)that.averageValue) : that.averageValue != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals((Object)that.value) : that.value != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.averageUtilization, this.averageValue, this.type, this.value, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.averageUtilization != null) {
            sb.append("averageUtilization:");
            sb.append(this.averageUtilization + ",");
        }
        if (this.averageValue != null) {
            sb.append("averageValue:");
            sb.append(this.averageValue + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value);
        }
        sb.append("}");
        return sb.toString();
    }
}

