/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1alpha1ServerStorageVersion;
import io.kubernetes.client.openapi.models.V1alpha1ServerStorageVersionBuilder;
import io.kubernetes.client.openapi.models.V1alpha1ServerStorageVersionFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionCondition;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionConditionBuilder;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionConditionFluentImpl;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionStatus;
import io.kubernetes.client.openapi.models.V1alpha1StorageVersionStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1alpha1StorageVersionStatusFluentImpl<A extends V1alpha1StorageVersionStatusFluent<A>>
extends BaseFluent<A>
implements V1alpha1StorageVersionStatusFluent<A> {
    private String commonEncodingVersion;
    private ArrayList<V1alpha1StorageVersionConditionBuilder> conditions;
    private ArrayList<V1alpha1ServerStorageVersionBuilder> storageVersions;

    public V1alpha1StorageVersionStatusFluentImpl() {
    }

    public V1alpha1StorageVersionStatusFluentImpl(V1alpha1StorageVersionStatus instance) {
        this.withCommonEncodingVersion(instance.getCommonEncodingVersion());
        this.withConditions(instance.getConditions());
        this.withStorageVersions(instance.getStorageVersions());
    }

    @Override
    public String getCommonEncodingVersion() {
        return this.commonEncodingVersion;
    }

    @Override
    public A withCommonEncodingVersion(String commonEncodingVersion) {
        this.commonEncodingVersion = commonEncodingVersion;
        return (A)this;
    }

    @Override
    public Boolean hasCommonEncodingVersion() {
        return this.commonEncodingVersion != null;
    }

    @Override
    public A addToConditions(Integer index, V1alpha1StorageVersionCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1alpha1StorageVersionConditionBuilder builder = new V1alpha1StorageVersionConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, V1alpha1StorageVersionCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1alpha1StorageVersionConditionBuilder builder = new V1alpha1StorageVersionConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1alpha1StorageVersionCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1alpha1StorageVersionCondition item : items) {
            V1alpha1StorageVersionConditionBuilder builder = new V1alpha1StorageVersionConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1alpha1StorageVersionCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1alpha1StorageVersionCondition item : items) {
            V1alpha1StorageVersionConditionBuilder builder = new V1alpha1StorageVersionConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1alpha1StorageVersionCondition ... items) {
        for (V1alpha1StorageVersionCondition item : items) {
            V1alpha1StorageVersionConditionBuilder builder = new V1alpha1StorageVersionConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1alpha1StorageVersionCondition> items) {
        for (V1alpha1StorageVersionCondition item : items) {
            V1alpha1StorageVersionConditionBuilder builder = new V1alpha1StorageVersionConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<V1alpha1StorageVersionConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1alpha1StorageVersionConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1alpha1StorageVersionConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1alpha1StorageVersionCondition> getConditions() {
        return this.conditions != null ? V1alpha1StorageVersionStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<V1alpha1StorageVersionCondition> buildConditions() {
        return this.conditions != null ? V1alpha1StorageVersionStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public V1alpha1StorageVersionCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1alpha1StorageVersionCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1alpha1StorageVersionCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1alpha1StorageVersionCondition buildMatchingCondition(Predicate<V1alpha1StorageVersionConditionBuilder> predicate) {
        for (V1alpha1StorageVersionConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V1alpha1StorageVersionConditionBuilder> predicate) {
        for (V1alpha1StorageVersionConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V1alpha1StorageVersionCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1alpha1StorageVersionCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1alpha1StorageVersionCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V1alpha1StorageVersionCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.ConditionsNested<A> addNewConditionLike(V1alpha1StorageVersionCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, V1alpha1StorageVersionCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1alpha1StorageVersionConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public A addToStorageVersions(Integer index, V1alpha1ServerStorageVersion item) {
        if (this.storageVersions == null) {
            this.storageVersions = new ArrayList();
        }
        V1alpha1ServerStorageVersionBuilder builder = new V1alpha1ServerStorageVersionBuilder(item);
        this._visitables.get("storageVersions").add(index >= 0 ? index.intValue() : this._visitables.get("storageVersions").size(), builder);
        this.storageVersions.add(index >= 0 ? index.intValue() : this.storageVersions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToStorageVersions(Integer index, V1alpha1ServerStorageVersion item) {
        if (this.storageVersions == null) {
            this.storageVersions = new ArrayList();
        }
        V1alpha1ServerStorageVersionBuilder builder = new V1alpha1ServerStorageVersionBuilder(item);
        if (index < 0 || index >= this._visitables.get("storageVersions").size()) {
            this._visitables.get("storageVersions").add(builder);
        } else {
            this._visitables.get("storageVersions").set(index, builder);
        }
        if (index < 0 || index >= this.storageVersions.size()) {
            this.storageVersions.add(builder);
        } else {
            this.storageVersions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToStorageVersions(V1alpha1ServerStorageVersion ... items) {
        if (this.storageVersions == null) {
            this.storageVersions = new ArrayList();
        }
        for (V1alpha1ServerStorageVersion item : items) {
            V1alpha1ServerStorageVersionBuilder builder = new V1alpha1ServerStorageVersionBuilder(item);
            this._visitables.get("storageVersions").add(builder);
            this.storageVersions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToStorageVersions(Collection<V1alpha1ServerStorageVersion> items) {
        if (this.storageVersions == null) {
            this.storageVersions = new ArrayList();
        }
        for (V1alpha1ServerStorageVersion item : items) {
            V1alpha1ServerStorageVersionBuilder builder = new V1alpha1ServerStorageVersionBuilder(item);
            this._visitables.get("storageVersions").add(builder);
            this.storageVersions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromStorageVersions(V1alpha1ServerStorageVersion ... items) {
        for (V1alpha1ServerStorageVersion item : items) {
            V1alpha1ServerStorageVersionBuilder builder = new V1alpha1ServerStorageVersionBuilder(item);
            this._visitables.get("storageVersions").remove(builder);
            if (this.storageVersions == null) continue;
            this.storageVersions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromStorageVersions(Collection<V1alpha1ServerStorageVersion> items) {
        for (V1alpha1ServerStorageVersion item : items) {
            V1alpha1ServerStorageVersionBuilder builder = new V1alpha1ServerStorageVersionBuilder(item);
            this._visitables.get("storageVersions").remove(builder);
            if (this.storageVersions == null) continue;
            this.storageVersions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromStorageVersions(Predicate<V1alpha1ServerStorageVersionBuilder> predicate) {
        if (this.storageVersions == null) {
            return (A)this;
        }
        Iterator<V1alpha1ServerStorageVersionBuilder> each = this.storageVersions.iterator();
        Object visitables = this._visitables.get("storageVersions");
        while (each.hasNext()) {
            V1alpha1ServerStorageVersionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1alpha1ServerStorageVersion> getStorageVersions() {
        return this.storageVersions != null ? V1alpha1StorageVersionStatusFluentImpl.build(this.storageVersions) : null;
    }

    @Override
    public List<V1alpha1ServerStorageVersion> buildStorageVersions() {
        return this.storageVersions != null ? V1alpha1StorageVersionStatusFluentImpl.build(this.storageVersions) : null;
    }

    @Override
    public V1alpha1ServerStorageVersion buildStorageVersion(Integer index) {
        return this.storageVersions.get(index).build();
    }

    @Override
    public V1alpha1ServerStorageVersion buildFirstStorageVersion() {
        return this.storageVersions.get(0).build();
    }

    @Override
    public V1alpha1ServerStorageVersion buildLastStorageVersion() {
        return this.storageVersions.get(this.storageVersions.size() - 1).build();
    }

    @Override
    public V1alpha1ServerStorageVersion buildMatchingStorageVersion(Predicate<V1alpha1ServerStorageVersionBuilder> predicate) {
        for (V1alpha1ServerStorageVersionBuilder item : this.storageVersions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStorageVersion(Predicate<V1alpha1ServerStorageVersionBuilder> predicate) {
        for (V1alpha1ServerStorageVersionBuilder item : this.storageVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withStorageVersions(List<V1alpha1ServerStorageVersion> storageVersions) {
        if (this.storageVersions != null) {
            this._visitables.get("storageVersions").removeAll(this.storageVersions);
        }
        if (storageVersions != null) {
            this.storageVersions = new ArrayList();
            for (V1alpha1ServerStorageVersion item : storageVersions) {
                this.addToStorageVersions(item);
            }
        } else {
            this.storageVersions = null;
        }
        return (A)this;
    }

    @Override
    public A withStorageVersions(V1alpha1ServerStorageVersion ... storageVersions) {
        if (this.storageVersions != null) {
            this.storageVersions.clear();
        }
        if (storageVersions != null) {
            for (V1alpha1ServerStorageVersion item : storageVersions) {
                this.addToStorageVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasStorageVersions() {
        return this.storageVersions != null && !this.storageVersions.isEmpty();
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.StorageVersionsNested<A> addNewStorageVersion() {
        return new StorageVersionsNestedImpl();
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.StorageVersionsNested<A> addNewStorageVersionLike(V1alpha1ServerStorageVersion item) {
        return new StorageVersionsNestedImpl(-1, item);
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.StorageVersionsNested<A> setNewStorageVersionLike(Integer index, V1alpha1ServerStorageVersion item) {
        return new StorageVersionsNestedImpl(index, item);
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.StorageVersionsNested<A> editStorageVersion(Integer index) {
        if (this.storageVersions.size() <= index) {
            throw new RuntimeException("Can't edit storageVersions. Index exceeds size.");
        }
        return this.setNewStorageVersionLike(index, this.buildStorageVersion(index));
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.StorageVersionsNested<A> editFirstStorageVersion() {
        if (this.storageVersions.size() == 0) {
            throw new RuntimeException("Can't edit first storageVersions. The list is empty.");
        }
        return this.setNewStorageVersionLike(0, this.buildStorageVersion(0));
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.StorageVersionsNested<A> editLastStorageVersion() {
        int index = this.storageVersions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last storageVersions. The list is empty.");
        }
        return this.setNewStorageVersionLike(index, this.buildStorageVersion(index));
    }

    @Override
    public V1alpha1StorageVersionStatusFluent.StorageVersionsNested<A> editMatchingStorageVersion(Predicate<V1alpha1ServerStorageVersionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.storageVersions.size(); ++i) {
            if (!predicate.test(this.storageVersions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching storageVersions. No match found.");
        }
        return this.setNewStorageVersionLike(index, this.buildStorageVersion(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1alpha1StorageVersionStatusFluentImpl that = (V1alpha1StorageVersionStatusFluentImpl)o;
        if (this.commonEncodingVersion != null ? !this.commonEncodingVersion.equals(that.commonEncodingVersion) : that.commonEncodingVersion != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        return !(this.storageVersions != null ? !this.storageVersions.equals(that.storageVersions) : that.storageVersions != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.commonEncodingVersion, this.conditions, this.storageVersions, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.commonEncodingVersion != null) {
            sb.append("commonEncodingVersion:");
            sb.append(this.commonEncodingVersion + ",");
        }
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.storageVersions != null && !this.storageVersions.isEmpty()) {
            sb.append("storageVersions:");
            sb.append(this.storageVersions);
        }
        sb.append("}");
        return sb.toString();
    }

    class ConditionsNestedImpl<N>
    extends V1alpha1StorageVersionConditionFluentImpl<V1alpha1StorageVersionStatusFluent.ConditionsNested<N>>
    implements V1alpha1StorageVersionStatusFluent.ConditionsNested<N>,
    Nested<N> {
        V1alpha1StorageVersionConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, V1alpha1StorageVersionCondition item) {
            this.index = index;
            this.builder = new V1alpha1StorageVersionConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1alpha1StorageVersionConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1StorageVersionStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    class StorageVersionsNestedImpl<N>
    extends V1alpha1ServerStorageVersionFluentImpl<V1alpha1StorageVersionStatusFluent.StorageVersionsNested<N>>
    implements V1alpha1StorageVersionStatusFluent.StorageVersionsNested<N>,
    Nested<N> {
        V1alpha1ServerStorageVersionBuilder builder;
        Integer index;

        StorageVersionsNestedImpl(Integer index, V1alpha1ServerStorageVersion item) {
            this.index = index;
            this.builder = new V1alpha1ServerStorageVersionBuilder(this, item);
        }

        StorageVersionsNestedImpl() {
            this.index = -1;
            this.builder = new V1alpha1ServerStorageVersionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1alpha1StorageVersionStatusFluentImpl.this.setToStorageVersions(this.index, this.builder.build());
        }

        @Override
        public N endStorageVersion() {
            return this.and();
        }
    }
}

