/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1ContainerStatus;
import io.kubernetes.client.openapi.models.V1ContainerStatusBuilder;
import io.kubernetes.client.openapi.models.V1ContainerStatusFluentImpl;
import io.kubernetes.client.openapi.models.V1PodCondition;
import io.kubernetes.client.openapi.models.V1PodConditionBuilder;
import io.kubernetes.client.openapi.models.V1PodConditionFluentImpl;
import io.kubernetes.client.openapi.models.V1PodIP;
import io.kubernetes.client.openapi.models.V1PodIPBuilder;
import io.kubernetes.client.openapi.models.V1PodIPFluentImpl;
import io.kubernetes.client.openapi.models.V1PodStatus;
import io.kubernetes.client.openapi.models.V1PodStatusFluent;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1PodStatusFluentImpl<A extends V1PodStatusFluent<A>>
extends BaseFluent<A>
implements V1PodStatusFluent<A> {
    private ArrayList<V1PodConditionBuilder> conditions;
    private ArrayList<V1ContainerStatusBuilder> containerStatuses;
    private ArrayList<V1ContainerStatusBuilder> ephemeralContainerStatuses;
    private String hostIP;
    private ArrayList<V1ContainerStatusBuilder> initContainerStatuses;
    private String message;
    private String nominatedNodeName;
    private String phase;
    private String podIP;
    private ArrayList<V1PodIPBuilder> podIPs;
    private String qosClass;
    private String reason;
    private OffsetDateTime startTime;

    public V1PodStatusFluentImpl() {
    }

    public V1PodStatusFluentImpl(V1PodStatus instance) {
        this.withConditions(instance.getConditions());
        this.withContainerStatuses(instance.getContainerStatuses());
        this.withEphemeralContainerStatuses(instance.getEphemeralContainerStatuses());
        this.withHostIP(instance.getHostIP());
        this.withInitContainerStatuses(instance.getInitContainerStatuses());
        this.withMessage(instance.getMessage());
        this.withNominatedNodeName(instance.getNominatedNodeName());
        this.withPhase(instance.getPhase());
        this.withPodIP(instance.getPodIP());
        this.withPodIPs(instance.getPodIPs());
        this.withQosClass(instance.getQosClass());
        this.withReason(instance.getReason());
        this.withStartTime(instance.getStartTime());
    }

    @Override
    public A addToConditions(Integer index, V1PodCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index.intValue() : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index.intValue() : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(Integer index, V1PodCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1PodCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1PodCondition item : items) {
            V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1PodCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (V1PodCondition item : items) {
            V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1PodCondition ... items) {
        for (V1PodCondition item : items) {
            V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1PodCondition> items) {
        for (V1PodCondition item : items) {
            V1PodConditionBuilder builder = new V1PodConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<V1PodConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1PodConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1PodConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1PodCondition> getConditions() {
        return this.conditions != null ? V1PodStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<V1PodCondition> buildConditions() {
        return this.conditions != null ? V1PodStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public V1PodCondition buildCondition(Integer index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1PodCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1PodCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1PodCondition buildMatchingCondition(Predicate<V1PodConditionBuilder> predicate) {
        for (V1PodConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V1PodConditionBuilder> predicate) {
        for (V1PodConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V1PodCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (V1PodCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1PodCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V1PodCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> addNewConditionLike(V1PodCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index, V1PodCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> editCondition(Integer index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1PodStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1PodConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public A addToContainerStatuses(Integer index, V1ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        this._visitables.get("containerStatuses").add(index >= 0 ? index.intValue() : this._visitables.get("containerStatuses").size(), builder);
        this.containerStatuses.add(index >= 0 ? index.intValue() : this.containerStatuses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToContainerStatuses(Integer index, V1ContainerStatus item) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("containerStatuses").size()) {
            this._visitables.get("containerStatuses").add(builder);
        } else {
            this._visitables.get("containerStatuses").set(index, builder);
        }
        if (index < 0 || index >= this.containerStatuses.size()) {
            this.containerStatuses.add(builder);
        } else {
            this.containerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToContainerStatuses(V1ContainerStatus ... items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerStatuses(Collection<V1ContainerStatus> items) {
        if (this.containerStatuses == null) {
            this.containerStatuses = new ArrayList();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").add(builder);
            this.containerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerStatuses(V1ContainerStatus ... items) {
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").remove(builder);
            if (this.containerStatuses == null) continue;
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerStatuses(Collection<V1ContainerStatus> items) {
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("containerStatuses").remove(builder);
            if (this.containerStatuses == null) continue;
            this.containerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromContainerStatuses(Predicate<V1ContainerStatusBuilder> predicate) {
        if (this.containerStatuses == null) {
            return (A)this;
        }
        Iterator<V1ContainerStatusBuilder> each = this.containerStatuses.iterator();
        Object visitables = this._visitables.get("containerStatuses");
        while (each.hasNext()) {
            V1ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ContainerStatus> getContainerStatuses() {
        return this.containerStatuses != null ? V1PodStatusFluentImpl.build(this.containerStatuses) : null;
    }

    @Override
    public List<V1ContainerStatus> buildContainerStatuses() {
        return this.containerStatuses != null ? V1PodStatusFluentImpl.build(this.containerStatuses) : null;
    }

    @Override
    public V1ContainerStatus buildContainerStatus(Integer index) {
        return this.containerStatuses.get(index).build();
    }

    @Override
    public V1ContainerStatus buildFirstContainerStatus() {
        return this.containerStatuses.get(0).build();
    }

    @Override
    public V1ContainerStatus buildLastContainerStatus() {
        return this.containerStatuses.get(this.containerStatuses.size() - 1).build();
    }

    @Override
    public V1ContainerStatus buildMatchingContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.containerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainerStatuses(List<V1ContainerStatus> containerStatuses) {
        if (this.containerStatuses != null) {
            this._visitables.get("containerStatuses").removeAll(this.containerStatuses);
        }
        if (containerStatuses != null) {
            this.containerStatuses = new ArrayList();
            for (V1ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        } else {
            this.containerStatuses = null;
        }
        return (A)this;
    }

    @Override
    public A withContainerStatuses(V1ContainerStatus ... containerStatuses) {
        if (this.containerStatuses != null) {
            this.containerStatuses.clear();
        }
        if (containerStatuses != null) {
            for (V1ContainerStatus item : containerStatuses) {
                this.addToContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerStatuses() {
        return this.containerStatuses != null && !this.containerStatuses.isEmpty();
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus() {
        return new ContainerStatusesNestedImpl();
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(V1ContainerStatus item) {
        return new ContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> setNewContainerStatusLike(Integer index, V1ContainerStatus item) {
        return new ContainerStatusesNestedImpl(index, item);
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> editContainerStatus(Integer index) {
        if (this.containerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit containerStatuses. Index exceeds size.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> editFirstContainerStatus() {
        if (this.containerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(0, this.buildContainerStatus(0));
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> editLastContainerStatus() {
        int index = this.containerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last containerStatuses. The list is empty.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public V1PodStatusFluent.ContainerStatusesNested<A> editMatchingContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.containerStatuses.size(); ++i) {
            if (!predicate.test(this.containerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching containerStatuses. No match found.");
        }
        return this.setNewContainerStatusLike(index, this.buildContainerStatus(index));
    }

    @Override
    public A addToEphemeralContainerStatuses(Integer index, V1ContainerStatus item) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        this._visitables.get("ephemeralContainerStatuses").add(index >= 0 ? index.intValue() : this._visitables.get("ephemeralContainerStatuses").size(), builder);
        this.ephemeralContainerStatuses.add(index >= 0 ? index.intValue() : this.ephemeralContainerStatuses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEphemeralContainerStatuses(Integer index, V1ContainerStatus item) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("ephemeralContainerStatuses").size()) {
            this._visitables.get("ephemeralContainerStatuses").add(builder);
        } else {
            this._visitables.get("ephemeralContainerStatuses").set(index, builder);
        }
        if (index < 0 || index >= this.ephemeralContainerStatuses.size()) {
            this.ephemeralContainerStatuses.add(builder);
        } else {
            this.ephemeralContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEphemeralContainerStatuses(V1ContainerStatus ... items) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEphemeralContainerStatuses(Collection<V1ContainerStatus> items) {
        if (this.ephemeralContainerStatuses == null) {
            this.ephemeralContainerStatuses = new ArrayList();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").add(builder);
            this.ephemeralContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEphemeralContainerStatuses(V1ContainerStatus ... items) {
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").remove(builder);
            if (this.ephemeralContainerStatuses == null) continue;
            this.ephemeralContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEphemeralContainerStatuses(Collection<V1ContainerStatus> items) {
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("ephemeralContainerStatuses").remove(builder);
            if (this.ephemeralContainerStatuses == null) continue;
            this.ephemeralContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEphemeralContainerStatuses(Predicate<V1ContainerStatusBuilder> predicate) {
        if (this.ephemeralContainerStatuses == null) {
            return (A)this;
        }
        Iterator<V1ContainerStatusBuilder> each = this.ephemeralContainerStatuses.iterator();
        Object visitables = this._visitables.get("ephemeralContainerStatuses");
        while (each.hasNext()) {
            V1ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ContainerStatus> getEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses != null ? V1PodStatusFluentImpl.build(this.ephemeralContainerStatuses) : null;
    }

    @Override
    public List<V1ContainerStatus> buildEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses != null ? V1PodStatusFluentImpl.build(this.ephemeralContainerStatuses) : null;
    }

    @Override
    public V1ContainerStatus buildEphemeralContainerStatus(Integer index) {
        return this.ephemeralContainerStatuses.get(index).build();
    }

    @Override
    public V1ContainerStatus buildFirstEphemeralContainerStatus() {
        return this.ephemeralContainerStatuses.get(0).build();
    }

    @Override
    public V1ContainerStatus buildLastEphemeralContainerStatus() {
        return this.ephemeralContainerStatuses.get(this.ephemeralContainerStatuses.size() - 1).build();
    }

    @Override
    public V1ContainerStatus buildMatchingEphemeralContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.ephemeralContainerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEphemeralContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.ephemeralContainerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEphemeralContainerStatuses(List<V1ContainerStatus> ephemeralContainerStatuses) {
        if (this.ephemeralContainerStatuses != null) {
            this._visitables.get("ephemeralContainerStatuses").removeAll(this.ephemeralContainerStatuses);
        }
        if (ephemeralContainerStatuses != null) {
            this.ephemeralContainerStatuses = new ArrayList();
            for (V1ContainerStatus item : ephemeralContainerStatuses) {
                this.addToEphemeralContainerStatuses(item);
            }
        } else {
            this.ephemeralContainerStatuses = null;
        }
        return (A)this;
    }

    @Override
    public A withEphemeralContainerStatuses(V1ContainerStatus ... ephemeralContainerStatuses) {
        if (this.ephemeralContainerStatuses != null) {
            this.ephemeralContainerStatuses.clear();
        }
        if (ephemeralContainerStatuses != null) {
            for (V1ContainerStatus item : ephemeralContainerStatuses) {
                this.addToEphemeralContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEphemeralContainerStatuses() {
        return this.ephemeralContainerStatuses != null && !this.ephemeralContainerStatuses.isEmpty();
    }

    @Override
    public V1PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatus() {
        return new EphemeralContainerStatusesNestedImpl();
    }

    @Override
    public V1PodStatusFluent.EphemeralContainerStatusesNested<A> addNewEphemeralContainerStatusLike(V1ContainerStatus item) {
        return new EphemeralContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public V1PodStatusFluent.EphemeralContainerStatusesNested<A> setNewEphemeralContainerStatusLike(Integer index, V1ContainerStatus item) {
        return new EphemeralContainerStatusesNestedImpl(index, item);
    }

    @Override
    public V1PodStatusFluent.EphemeralContainerStatusesNested<A> editEphemeralContainerStatus(Integer index) {
        if (this.ephemeralContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit ephemeralContainerStatuses. Index exceeds size.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    @Override
    public V1PodStatusFluent.EphemeralContainerStatusesNested<A> editFirstEphemeralContainerStatus() {
        if (this.ephemeralContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first ephemeralContainerStatuses. The list is empty.");
        }
        return this.setNewEphemeralContainerStatusLike(0, this.buildEphemeralContainerStatus(0));
    }

    @Override
    public V1PodStatusFluent.EphemeralContainerStatusesNested<A> editLastEphemeralContainerStatus() {
        int index = this.ephemeralContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ephemeralContainerStatuses. The list is empty.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    @Override
    public V1PodStatusFluent.EphemeralContainerStatusesNested<A> editMatchingEphemeralContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ephemeralContainerStatuses.size(); ++i) {
            if (!predicate.test(this.ephemeralContainerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ephemeralContainerStatuses. No match found.");
        }
        return this.setNewEphemeralContainerStatusLike(index, this.buildEphemeralContainerStatus(index));
    }

    @Override
    public String getHostIP() {
        return this.hostIP;
    }

    @Override
    public A withHostIP(String hostIP) {
        this.hostIP = hostIP;
        return (A)this;
    }

    @Override
    public Boolean hasHostIP() {
        return this.hostIP != null;
    }

    @Override
    public A addToInitContainerStatuses(Integer index, V1ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        this._visitables.get("initContainerStatuses").add(index >= 0 ? index.intValue() : this._visitables.get("initContainerStatuses").size(), builder);
        this.initContainerStatuses.add(index >= 0 ? index.intValue() : this.initContainerStatuses.size(), builder);
        return (A)this;
    }

    @Override
    public A setToInitContainerStatuses(Integer index, V1ContainerStatus item) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
        if (index < 0 || index >= this._visitables.get("initContainerStatuses").size()) {
            this._visitables.get("initContainerStatuses").add(builder);
        } else {
            this._visitables.get("initContainerStatuses").set(index, builder);
        }
        if (index < 0 || index >= this.initContainerStatuses.size()) {
            this.initContainerStatuses.add(builder);
        } else {
            this.initContainerStatuses.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToInitContainerStatuses(V1ContainerStatus ... items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToInitContainerStatuses(Collection<V1ContainerStatus> items) {
        if (this.initContainerStatuses == null) {
            this.initContainerStatuses = new ArrayList();
        }
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").add(builder);
            this.initContainerStatuses.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromInitContainerStatuses(V1ContainerStatus ... items) {
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").remove(builder);
            if (this.initContainerStatuses == null) continue;
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromInitContainerStatuses(Collection<V1ContainerStatus> items) {
        for (V1ContainerStatus item : items) {
            V1ContainerStatusBuilder builder = new V1ContainerStatusBuilder(item);
            this._visitables.get("initContainerStatuses").remove(builder);
            if (this.initContainerStatuses == null) continue;
            this.initContainerStatuses.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromInitContainerStatuses(Predicate<V1ContainerStatusBuilder> predicate) {
        if (this.initContainerStatuses == null) {
            return (A)this;
        }
        Iterator<V1ContainerStatusBuilder> each = this.initContainerStatuses.iterator();
        Object visitables = this._visitables.get("initContainerStatuses");
        while (each.hasNext()) {
            V1ContainerStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1ContainerStatus> getInitContainerStatuses() {
        return this.initContainerStatuses != null ? V1PodStatusFluentImpl.build(this.initContainerStatuses) : null;
    }

    @Override
    public List<V1ContainerStatus> buildInitContainerStatuses() {
        return this.initContainerStatuses != null ? V1PodStatusFluentImpl.build(this.initContainerStatuses) : null;
    }

    @Override
    public V1ContainerStatus buildInitContainerStatus(Integer index) {
        return this.initContainerStatuses.get(index).build();
    }

    @Override
    public V1ContainerStatus buildFirstInitContainerStatus() {
        return this.initContainerStatuses.get(0).build();
    }

    @Override
    public V1ContainerStatus buildLastInitContainerStatus() {
        return this.initContainerStatuses.get(this.initContainerStatuses.size() - 1).build();
    }

    @Override
    public V1ContainerStatus buildMatchingInitContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingInitContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        for (V1ContainerStatusBuilder item : this.initContainerStatuses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withInitContainerStatuses(List<V1ContainerStatus> initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this._visitables.get("initContainerStatuses").removeAll(this.initContainerStatuses);
        }
        if (initContainerStatuses != null) {
            this.initContainerStatuses = new ArrayList();
            for (V1ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        } else {
            this.initContainerStatuses = null;
        }
        return (A)this;
    }

    @Override
    public A withInitContainerStatuses(V1ContainerStatus ... initContainerStatuses) {
        if (this.initContainerStatuses != null) {
            this.initContainerStatuses.clear();
        }
        if (initContainerStatuses != null) {
            for (V1ContainerStatus item : initContainerStatuses) {
                this.addToInitContainerStatuses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasInitContainerStatuses() {
        return this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty();
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatus() {
        return new InitContainerStatusesNestedImpl();
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> addNewInitContainerStatusLike(V1ContainerStatus item) {
        return new InitContainerStatusesNestedImpl(-1, item);
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> setNewInitContainerStatusLike(Integer index, V1ContainerStatus item) {
        return new InitContainerStatusesNestedImpl(index, item);
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> editInitContainerStatus(Integer index) {
        if (this.initContainerStatuses.size() <= index) {
            throw new RuntimeException("Can't edit initContainerStatuses. Index exceeds size.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> editFirstInitContainerStatus() {
        if (this.initContainerStatuses.size() == 0) {
            throw new RuntimeException("Can't edit first initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(0, this.buildInitContainerStatus(0));
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> editLastInitContainerStatus() {
        int index = this.initContainerStatuses.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last initContainerStatuses. The list is empty.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public V1PodStatusFluent.InitContainerStatusesNested<A> editMatchingInitContainerStatus(Predicate<V1ContainerStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.initContainerStatuses.size(); ++i) {
            if (!predicate.test(this.initContainerStatuses.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching initContainerStatuses. No match found.");
        }
        return this.setNewInitContainerStatusLike(index, this.buildInitContainerStatus(index));
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public A withMessage(String message) {
        this.message = message;
        return (A)this;
    }

    @Override
    public Boolean hasMessage() {
        return this.message != null;
    }

    @Override
    public String getNominatedNodeName() {
        return this.nominatedNodeName;
    }

    @Override
    public A withNominatedNodeName(String nominatedNodeName) {
        this.nominatedNodeName = nominatedNodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNominatedNodeName() {
        return this.nominatedNodeName != null;
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    public String getPodIP() {
        return this.podIP;
    }

    @Override
    public A withPodIP(String podIP) {
        this.podIP = podIP;
        return (A)this;
    }

    @Override
    public Boolean hasPodIP() {
        return this.podIP != null;
    }

    @Override
    public A addToPodIPs(Integer index, V1PodIP item) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        V1PodIPBuilder builder = new V1PodIPBuilder(item);
        this._visitables.get("podIPs").add(index >= 0 ? index.intValue() : this._visitables.get("podIPs").size(), builder);
        this.podIPs.add(index >= 0 ? index.intValue() : this.podIPs.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPodIPs(Integer index, V1PodIP item) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        V1PodIPBuilder builder = new V1PodIPBuilder(item);
        if (index < 0 || index >= this._visitables.get("podIPs").size()) {
            this._visitables.get("podIPs").add(builder);
        } else {
            this._visitables.get("podIPs").set(index, builder);
        }
        if (index < 0 || index >= this.podIPs.size()) {
            this.podIPs.add(builder);
        } else {
            this.podIPs.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPodIPs(V1PodIP ... items) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        for (V1PodIP item : items) {
            V1PodIPBuilder builder = new V1PodIPBuilder(item);
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPodIPs(Collection<V1PodIP> items) {
        if (this.podIPs == null) {
            this.podIPs = new ArrayList();
        }
        for (V1PodIP item : items) {
            V1PodIPBuilder builder = new V1PodIPBuilder(item);
            this._visitables.get("podIPs").add(builder);
            this.podIPs.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPodIPs(V1PodIP ... items) {
        for (V1PodIP item : items) {
            V1PodIPBuilder builder = new V1PodIPBuilder(item);
            this._visitables.get("podIPs").remove(builder);
            if (this.podIPs == null) continue;
            this.podIPs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPodIPs(Collection<V1PodIP> items) {
        for (V1PodIP item : items) {
            V1PodIPBuilder builder = new V1PodIPBuilder(item);
            this._visitables.get("podIPs").remove(builder);
            if (this.podIPs == null) continue;
            this.podIPs.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPodIPs(Predicate<V1PodIPBuilder> predicate) {
        if (this.podIPs == null) {
            return (A)this;
        }
        Iterator<V1PodIPBuilder> each = this.podIPs.iterator();
        Object visitables = this._visitables.get("podIPs");
        while (each.hasNext()) {
            V1PodIPBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1PodIP> getPodIPs() {
        return this.podIPs != null ? V1PodStatusFluentImpl.build(this.podIPs) : null;
    }

    @Override
    public List<V1PodIP> buildPodIPs() {
        return this.podIPs != null ? V1PodStatusFluentImpl.build(this.podIPs) : null;
    }

    @Override
    public V1PodIP buildPodIP(Integer index) {
        return this.podIPs.get(index).build();
    }

    @Override
    public V1PodIP buildFirstPodIP() {
        return this.podIPs.get(0).build();
    }

    @Override
    public V1PodIP buildLastPodIP() {
        return this.podIPs.get(this.podIPs.size() - 1).build();
    }

    @Override
    public V1PodIP buildMatchingPodIP(Predicate<V1PodIPBuilder> predicate) {
        for (V1PodIPBuilder item : this.podIPs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPodIP(Predicate<V1PodIPBuilder> predicate) {
        for (V1PodIPBuilder item : this.podIPs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPodIPs(List<V1PodIP> podIPs) {
        if (this.podIPs != null) {
            this._visitables.get("podIPs").removeAll(this.podIPs);
        }
        if (podIPs != null) {
            this.podIPs = new ArrayList();
            for (V1PodIP item : podIPs) {
                this.addToPodIPs(item);
            }
        } else {
            this.podIPs = null;
        }
        return (A)this;
    }

    @Override
    public A withPodIPs(V1PodIP ... podIPs) {
        if (this.podIPs != null) {
            this.podIPs.clear();
        }
        if (podIPs != null) {
            for (V1PodIP item : podIPs) {
                this.addToPodIPs(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodIPs() {
        return this.podIPs != null && !this.podIPs.isEmpty();
    }

    @Override
    public V1PodStatusFluent.PodIPsNested<A> addNewPodIP() {
        return new PodIPsNestedImpl();
    }

    @Override
    public V1PodStatusFluent.PodIPsNested<A> addNewPodIPLike(V1PodIP item) {
        return new PodIPsNestedImpl(-1, item);
    }

    @Override
    public V1PodStatusFluent.PodIPsNested<A> setNewPodIPLike(Integer index, V1PodIP item) {
        return new PodIPsNestedImpl(index, item);
    }

    @Override
    public V1PodStatusFluent.PodIPsNested<A> editPodIP(Integer index) {
        if (this.podIPs.size() <= index) {
            throw new RuntimeException("Can't edit podIPs. Index exceeds size.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    @Override
    public V1PodStatusFluent.PodIPsNested<A> editFirstPodIP() {
        if (this.podIPs.size() == 0) {
            throw new RuntimeException("Can't edit first podIPs. The list is empty.");
        }
        return this.setNewPodIPLike(0, this.buildPodIP(0));
    }

    @Override
    public V1PodStatusFluent.PodIPsNested<A> editLastPodIP() {
        int index = this.podIPs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last podIPs. The list is empty.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    @Override
    public V1PodStatusFluent.PodIPsNested<A> editMatchingPodIP(Predicate<V1PodIPBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.podIPs.size(); ++i) {
            if (!predicate.test(this.podIPs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching podIPs. No match found.");
        }
        return this.setNewPodIPLike(index, this.buildPodIP(index));
    }

    @Override
    public String getQosClass() {
        return this.qosClass;
    }

    @Override
    public A withQosClass(String qosClass) {
        this.qosClass = qosClass;
        return (A)this;
    }

    @Override
    public Boolean hasQosClass() {
        return this.qosClass != null;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public A withReason(String reason) {
        this.reason = reason;
        return (A)this;
    }

    @Override
    public Boolean hasReason() {
        return this.reason != null;
    }

    @Override
    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    @Override
    public A withStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return (A)this;
    }

    @Override
    public Boolean hasStartTime() {
        return this.startTime != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PodStatusFluentImpl that = (V1PodStatusFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.containerStatuses != null ? !this.containerStatuses.equals(that.containerStatuses) : that.containerStatuses != null) {
            return false;
        }
        if (this.ephemeralContainerStatuses != null ? !this.ephemeralContainerStatuses.equals(that.ephemeralContainerStatuses) : that.ephemeralContainerStatuses != null) {
            return false;
        }
        if (this.hostIP != null ? !this.hostIP.equals(that.hostIP) : that.hostIP != null) {
            return false;
        }
        if (this.initContainerStatuses != null ? !this.initContainerStatuses.equals(that.initContainerStatuses) : that.initContainerStatuses != null) {
            return false;
        }
        if (this.message != null ? !this.message.equals(that.message) : that.message != null) {
            return false;
        }
        if (this.nominatedNodeName != null ? !this.nominatedNodeName.equals(that.nominatedNodeName) : that.nominatedNodeName != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.podIP != null ? !this.podIP.equals(that.podIP) : that.podIP != null) {
            return false;
        }
        if (this.podIPs != null ? !this.podIPs.equals(that.podIPs) : that.podIPs != null) {
            return false;
        }
        if (this.qosClass != null ? !this.qosClass.equals(that.qosClass) : that.qosClass != null) {
            return false;
        }
        if (this.reason != null ? !this.reason.equals(that.reason) : that.reason != null) {
            return false;
        }
        return !(this.startTime != null ? !this.startTime.equals(that.startTime) : that.startTime != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.conditions, this.containerStatuses, this.ephemeralContainerStatuses, this.hostIP, this.initContainerStatuses, this.message, this.nominatedNodeName, this.phase, this.podIP, this.podIPs, this.qosClass, this.reason, this.startTime, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.containerStatuses != null && !this.containerStatuses.isEmpty()) {
            sb.append("containerStatuses:");
            sb.append(this.containerStatuses + ",");
        }
        if (this.ephemeralContainerStatuses != null && !this.ephemeralContainerStatuses.isEmpty()) {
            sb.append("ephemeralContainerStatuses:");
            sb.append(this.ephemeralContainerStatuses + ",");
        }
        if (this.hostIP != null) {
            sb.append("hostIP:");
            sb.append(this.hostIP + ",");
        }
        if (this.initContainerStatuses != null && !this.initContainerStatuses.isEmpty()) {
            sb.append("initContainerStatuses:");
            sb.append(this.initContainerStatuses + ",");
        }
        if (this.message != null) {
            sb.append("message:");
            sb.append(this.message + ",");
        }
        if (this.nominatedNodeName != null) {
            sb.append("nominatedNodeName:");
            sb.append(this.nominatedNodeName + ",");
        }
        if (this.phase != null) {
            sb.append("phase:");
            sb.append(this.phase + ",");
        }
        if (this.podIP != null) {
            sb.append("podIP:");
            sb.append(this.podIP + ",");
        }
        if (this.podIPs != null && !this.podIPs.isEmpty()) {
            sb.append("podIPs:");
            sb.append(this.podIPs + ",");
        }
        if (this.qosClass != null) {
            sb.append("qosClass:");
            sb.append(this.qosClass + ",");
        }
        if (this.reason != null) {
            sb.append("reason:");
            sb.append(this.reason + ",");
        }
        if (this.startTime != null) {
            sb.append("startTime:");
            sb.append(this.startTime);
        }
        sb.append("}");
        return sb.toString();
    }

    class ConditionsNestedImpl<N>
    extends V1PodConditionFluentImpl<V1PodStatusFluent.ConditionsNested<N>>
    implements V1PodStatusFluent.ConditionsNested<N>,
    Nested<N> {
        V1PodConditionBuilder builder;
        Integer index;

        ConditionsNestedImpl(Integer index, V1PodCondition item) {
            this.index = index;
            this.builder = new V1PodConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1PodConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }

    class ContainerStatusesNestedImpl<N>
    extends V1ContainerStatusFluentImpl<V1PodStatusFluent.ContainerStatusesNested<N>>
    implements V1PodStatusFluent.ContainerStatusesNested<N>,
    Nested<N> {
        V1ContainerStatusBuilder builder;
        Integer index;

        ContainerStatusesNestedImpl(Integer index, V1ContainerStatus item) {
            this.index = index;
            this.builder = new V1ContainerStatusBuilder(this, item);
        }

        ContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new V1ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluentImpl.this.setToContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endContainerStatus() {
            return this.and();
        }
    }

    class EphemeralContainerStatusesNestedImpl<N>
    extends V1ContainerStatusFluentImpl<V1PodStatusFluent.EphemeralContainerStatusesNested<N>>
    implements V1PodStatusFluent.EphemeralContainerStatusesNested<N>,
    Nested<N> {
        V1ContainerStatusBuilder builder;
        Integer index;

        EphemeralContainerStatusesNestedImpl(Integer index, V1ContainerStatus item) {
            this.index = index;
            this.builder = new V1ContainerStatusBuilder(this, item);
        }

        EphemeralContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new V1ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluentImpl.this.setToEphemeralContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endEphemeralContainerStatus() {
            return this.and();
        }
    }

    class InitContainerStatusesNestedImpl<N>
    extends V1ContainerStatusFluentImpl<V1PodStatusFluent.InitContainerStatusesNested<N>>
    implements V1PodStatusFluent.InitContainerStatusesNested<N>,
    Nested<N> {
        V1ContainerStatusBuilder builder;
        Integer index;

        InitContainerStatusesNestedImpl(Integer index, V1ContainerStatus item) {
            this.index = index;
            this.builder = new V1ContainerStatusBuilder(this, item);
        }

        InitContainerStatusesNestedImpl() {
            this.index = -1;
            this.builder = new V1ContainerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluentImpl.this.setToInitContainerStatuses(this.index, this.builder.build());
        }

        @Override
        public N endInitContainerStatus() {
            return this.and();
        }
    }

    class PodIPsNestedImpl<N>
    extends V1PodIPFluentImpl<V1PodStatusFluent.PodIPsNested<N>>
    implements V1PodStatusFluent.PodIPsNested<N>,
    Nested<N> {
        V1PodIPBuilder builder;
        Integer index;

        PodIPsNestedImpl(Integer index, V1PodIP item) {
            this.index = index;
            this.builder = new V1PodIPBuilder(this, item);
        }

        PodIPsNestedImpl() {
            this.index = -1;
            this.builder = new V1PodIPBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PodStatusFluentImpl.this.setToPodIPs(this.index, this.builder.build());
        }

        @Override
        public N endPodIP() {
            return this.and();
        }
    }
}

