/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.ApiregistrationV1ServiceReference;
import io.kubernetes.client.openapi.models.ApiregistrationV1ServiceReferenceBuilder;
import io.kubernetes.client.openapi.models.ApiregistrationV1ServiceReferenceFluentImpl;
import io.kubernetes.client.openapi.models.V1APIServiceSpec;
import io.kubernetes.client.openapi.models.V1APIServiceSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class V1APIServiceSpecFluentImpl<A extends V1APIServiceSpecFluent<A>>
extends BaseFluent<A>
implements V1APIServiceSpecFluent<A> {
    private List<Byte> caBundle;
    private String group;
    private Integer groupPriorityMinimum;
    private Boolean insecureSkipTLSVerify;
    private ApiregistrationV1ServiceReferenceBuilder service;
    private String version;
    private Integer versionPriority;

    public V1APIServiceSpecFluentImpl() {
    }

    public V1APIServiceSpecFluentImpl(V1APIServiceSpec instance) {
        this.withCaBundle(instance.getCaBundle());
        this.withGroup(instance.getGroup());
        this.withGroupPriorityMinimum(instance.getGroupPriorityMinimum());
        this.withInsecureSkipTLSVerify(instance.getInsecureSkipTLSVerify());
        this.withService(instance.getService());
        this.withVersion(instance.getVersion());
        this.withVersionPriority(instance.getVersionPriority());
    }

    @Override
    public A withCaBundle(byte ... caBundle) {
        if (this.caBundle != null) {
            this.caBundle.clear();
        }
        if (caBundle != null) {
            for (byte item : caBundle) {
                this.addToCaBundle(item);
            }
        }
        return (A)this;
    }

    @Override
    public byte[] getCaBundle() {
        int size = this.caBundle != null ? this.caBundle.size() : 0;
        byte[] result = new byte[size];
        if (size == 0) {
            return result;
        }
        int index = 0;
        for (byte item : this.caBundle) {
            result[index++] = item;
        }
        return result;
    }

    @Override
    public A addToCaBundle(Integer index, Byte item) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Byte>();
        }
        this.caBundle.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCaBundle(Integer index, Byte item) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Byte>();
        }
        this.caBundle.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCaBundle(Byte ... items) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.caBundle.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCaBundle(Collection<Byte> items) {
        if (this.caBundle == null) {
            this.caBundle = new ArrayList<Byte>();
        }
        for (Byte item : items) {
            this.caBundle.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCaBundle(Byte ... items) {
        for (Byte item : items) {
            if (this.caBundle == null) continue;
            this.caBundle.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCaBundle(Collection<Byte> items) {
        for (Byte item : items) {
            if (this.caBundle == null) continue;
            this.caBundle.remove(item);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCaBundle() {
        return this.caBundle != null && !this.caBundle.isEmpty();
    }

    @Override
    public String getGroup() {
        return this.group;
    }

    @Override
    public A withGroup(String group) {
        this.group = group;
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null;
    }

    @Override
    public Integer getGroupPriorityMinimum() {
        return this.groupPriorityMinimum;
    }

    @Override
    public A withGroupPriorityMinimum(Integer groupPriorityMinimum) {
        this.groupPriorityMinimum = groupPriorityMinimum;
        return (A)this;
    }

    @Override
    public Boolean hasGroupPriorityMinimum() {
        return this.groupPriorityMinimum != null;
    }

    @Override
    public Boolean getInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify;
    }

    @Override
    public A withInsecureSkipTLSVerify(Boolean insecureSkipTLSVerify) {
        this.insecureSkipTLSVerify = insecureSkipTLSVerify;
        return (A)this;
    }

    @Override
    public Boolean hasInsecureSkipTLSVerify() {
        return this.insecureSkipTLSVerify != null;
    }

    @Override
    @Deprecated
    public ApiregistrationV1ServiceReference getService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public ApiregistrationV1ServiceReference buildService() {
        return this.service != null ? this.service.build() : null;
    }

    @Override
    public A withService(ApiregistrationV1ServiceReference service) {
        this._visitables.get("service").remove(this.service);
        if (service != null) {
            this.service = new ApiregistrationV1ServiceReferenceBuilder(service);
            this._visitables.get("service").add(this.service);
        } else {
            this.service = null;
            this._visitables.get("service").remove(this.service);
        }
        return (A)this;
    }

    @Override
    public Boolean hasService() {
        return this.service != null;
    }

    @Override
    public V1APIServiceSpecFluent.ServiceNested<A> withNewService() {
        return new ServiceNestedImpl();
    }

    @Override
    public V1APIServiceSpecFluent.ServiceNested<A> withNewServiceLike(ApiregistrationV1ServiceReference item) {
        return new ServiceNestedImpl(item);
    }

    @Override
    public V1APIServiceSpecFluent.ServiceNested<A> editService() {
        return this.withNewServiceLike(this.getService());
    }

    @Override
    public V1APIServiceSpecFluent.ServiceNested<A> editOrNewService() {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : new ApiregistrationV1ServiceReferenceBuilder().build());
    }

    @Override
    public V1APIServiceSpecFluent.ServiceNested<A> editOrNewServiceLike(ApiregistrationV1ServiceReference item) {
        return this.withNewServiceLike(this.getService() != null ? this.getService() : item);
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public Integer getVersionPriority() {
        return this.versionPriority;
    }

    @Override
    public A withVersionPriority(Integer versionPriority) {
        this.versionPriority = versionPriority;
        return (A)this;
    }

    @Override
    public Boolean hasVersionPriority() {
        return this.versionPriority != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1APIServiceSpecFluentImpl that = (V1APIServiceSpecFluentImpl)o;
        if (this.caBundle != null ? !this.caBundle.equals(that.caBundle) : that.caBundle != null) {
            return false;
        }
        if (this.group != null ? !this.group.equals(that.group) : that.group != null) {
            return false;
        }
        if (this.groupPriorityMinimum != null ? !this.groupPriorityMinimum.equals(that.groupPriorityMinimum) : that.groupPriorityMinimum != null) {
            return false;
        }
        if (this.insecureSkipTLSVerify != null ? !this.insecureSkipTLSVerify.equals(that.insecureSkipTLSVerify) : that.insecureSkipTLSVerify != null) {
            return false;
        }
        if (this.service != null ? !this.service.equals(that.service) : that.service != null) {
            return false;
        }
        if (this.version != null ? !this.version.equals(that.version) : that.version != null) {
            return false;
        }
        return !(this.versionPriority != null ? !this.versionPriority.equals(that.versionPriority) : that.versionPriority != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.caBundle, this.group, this.groupPriorityMinimum, this.insecureSkipTLSVerify, this.service, this.version, this.versionPriority, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.caBundle != null && !this.caBundle.isEmpty()) {
            sb.append("caBundle:");
            sb.append(this.caBundle + ",");
        }
        if (this.group != null) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.groupPriorityMinimum != null) {
            sb.append("groupPriorityMinimum:");
            sb.append(this.groupPriorityMinimum + ",");
        }
        if (this.insecureSkipTLSVerify != null) {
            sb.append("insecureSkipTLSVerify:");
            sb.append(this.insecureSkipTLSVerify + ",");
        }
        if (this.service != null) {
            sb.append("service:");
            sb.append(this.service + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.versionPriority != null) {
            sb.append("versionPriority:");
            sb.append(this.versionPriority);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withInsecureSkipTLSVerify() {
        return this.withInsecureSkipTLSVerify(true);
    }

    class ServiceNestedImpl<N>
    extends ApiregistrationV1ServiceReferenceFluentImpl<V1APIServiceSpecFluent.ServiceNested<N>>
    implements V1APIServiceSpecFluent.ServiceNested<N>,
    Nested<N> {
        ApiregistrationV1ServiceReferenceBuilder builder;

        ServiceNestedImpl(ApiregistrationV1ServiceReference item) {
            this.builder = new ApiregistrationV1ServiceReferenceBuilder(this, item);
        }

        ServiceNestedImpl() {
            this.builder = new ApiregistrationV1ServiceReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1APIServiceSpecFluentImpl.this.withService(this.builder.build());
        }

        @Override
        public N endService() {
            return this.and();
        }
    }
}

