/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.util.pipeline;

import io.ktor.util.Attributes;
import io.ktor.util.AttributesJvmKt;
import io.ktor.util.InternalAPI;
import io.ktor.util.pipeline.InvalidPhaseException;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.util.pipeline.PipelineContextKt;
import io.ktor.util.pipeline.PipelineExecutor;
import io.ktor.util.pipeline.PipelinePhase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u001c\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002:\u0002LMBS\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012?\u0010\u0006\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b\u00a2\u0006\u0002\b\f0\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\rB\u0019\u0012\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000f\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0010J\u000e\u0010$\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010%\u001a\u00020\u000bH\u0016JD\u0010&\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b\u00a2\u0006\u0002\b\f0\u0007H\u0002\u00f8\u0001\u0000J%\u0010'\u001a\b\u0012\u0004\u0012\u00028\u00000(2\u0006\u0010)\u001a\u00028\u00012\u0006\u0010*\u001a\u00028\u0000H\u0000\u00a2\u0006\u0004\b+\u0010,J!\u0010-\u001a\u00028\u00002\u0006\u0010)\u001a\u00028\u00012\u0006\u0010*\u001a\u00028\u0000H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\u001c\u0010/\u001a\u00020\u00162\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002J\u001e\u00101\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u0001022\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u00103\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u00104\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0016\u00105\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u00107\u001a\u00020\u000b2\u0006\u00106\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005JQ\u00108\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000529\u00109\u001a5\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b\u00a2\u0006\u0002\b\f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010:JI\u0010;\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b\u00a2\u0006\u0002\b\f0\u0007H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\b<J\u001a\u0010=\u001a\u00020\u000b2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000JL\u0010>\u001a\u00020\u000b2?\u0010?\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b\u00a2\u0006\u0002\b\f0\u0007H\u0002\u00f8\u0001\u0000JQ\u0010@\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b\u00a2\u0006\u0002\b\f0\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0002\bAJ\b\u0010B\u001a\u00020\u000bH\u0002J\u001c\u0010C\u001a\u00020\u000b2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0000H\u0002J\u001c\u0010E\u001a\u00020\u000b2\u0012\u0010F\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u000102H\u0002JD\u0010G\u001a;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b\u00a2\u0006\u0002\b\f0\u0007H\u0002\u00f8\u0001\u0000JS\u0010H\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u000529\u00109\u001a5\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b\u00a2\u0006\u0002\b\fH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010IJ:\u0010J\u001a\u00020\u000b\"\u0004\b\u0002\u0010K*\u0012\u0012\u0004\u0012\u0002HK0\"j\b\u0012\u0004\u0012\u0002HK`#2\u0016\u00100\u001a\u0012\u0012\u0004\u0012\u0002HK0\"j\b\u0012\u0004\u0012\u0002HK`#H\u0002R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014RL\u0010\u0006\u001a=\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b\u00a2\u0006\u0002\b\f\u0018\u00010\u0007X\u0082\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u00168FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001a\u0010\u001dR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001e\u0010!\u001a\u0012\u0012\u0004\u0012\u00020\u00020\"j\b\u0012\u0004\u0012\u00020\u0002`#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006N"}, d2={"Lio/ktor/util/pipeline/Pipeline;", "TSubject", "", "TContext", "phase", "Lio/ktor/util/pipeline/PipelinePhase;", "interceptors", "", "Lkotlin/Function3;", "Lio/ktor/util/pipeline/PipelineContext;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/util/pipeline/PipelinePhase;Ljava/util/List;)V", "phases", "", "([Lio/ktor/util/pipeline/PipelinePhase;)V", "attributes", "Lio/ktor/util/Attributes;", "getAttributes", "()Lio/ktor/util/Attributes;", "interceptorsListShared", "", "interceptorsListSharedPhase", "interceptorsQuantity", "", "isEmpty", "isEmpty$annotations", "()V", "()Z", "items", "getItems", "()Ljava/util/List;", "phasesRaw", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "addPhase", "afterIntercepted", "cacheInterceptors", "createContext", "Lio/ktor/util/pipeline/PipelineExecutor;", "context", "subject", "createContext$ktor_utils", "(Ljava/lang/Object;Ljava/lang/Object;)Lio/ktor/util/pipeline/PipelineExecutor;", "execute", "(Ljava/lang/Object;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "fastPathMerge", "from", "findPhase", "Lio/ktor/util/pipeline/Pipeline$PhaseContent;", "findPhaseIndex", "hasPhase", "insertPhaseAfter", "reference", "insertPhaseBefore", "intercept", "block", "(Lio/ktor/util/pipeline/PipelinePhase;Lkotlin/jvm/functions/Function3;)V", "interceptorsForTests", "interceptorsForTests$ktor_utils", "merge", "notSharedInterceptorsList", "list", "phaseInterceptors", "phaseInterceptors$ktor_utils", "resetInterceptorsList", "setInterceptorsListFromAnotherPipeline", "pipeline", "setInterceptorsListFromPhase", "phaseContent", "sharedInterceptorsList", "tryAddToPhaseFastpath", "(Lio/ktor/util/pipeline/PipelinePhase;Lkotlin/jvm/functions/Function3;)Z", "addAllAF", "E", "PhaseContent", "PipelinePhaseRelation", "ktor-utils"})
public class Pipeline<TSubject, TContext> {
    @NotNull
    private final Attributes attributes;
    private final ArrayList<Object> phasesRaw;
    private int interceptorsQuantity;
    private volatile List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> interceptors;
    private boolean interceptorsListShared;
    private PipelinePhase interceptorsListSharedPhase;

    @NotNull
    public final Attributes getAttributes() {
        return this.attributes;
    }

    @Nullable
    public final Object execute(@NotNull TContext context, @NotNull TSubject subject, @NotNull Continuation<? super TSubject> $completion) {
        return this.createContext$ktor_utils(context, subject).execute(subject, $completion);
    }

    @NotNull
    public final PipelineExecutor<TSubject> createContext$ktor_utils(@NotNull TContext context, @NotNull TSubject subject) {
        Intrinsics.checkParameterIsNotNull(context, (String)"context");
        Intrinsics.checkParameterIsNotNull(subject, (String)"subject");
        return PipelineContextKt.pipelineExecutorFor(context, this.sharedInterceptorsList(), subject);
    }

    /*
     * WARNING - void declaration
     */
    private final PhaseContent<TSubject, TContext> findPhase(PipelinePhase phase) {
        ArrayList<Object> phasesList = this.phasesRaw;
        int n = 0;
        int n2 = phasesList.size();
        while (n < n2) {
            Object e;
            void index;
            Intrinsics.checkExpressionValueIsNotNull((Object)phasesList.get((int)index), (String)"phasesList[index]");
            if (e == phase) {
                PhaseContent content = new PhaseContent(phase, PipelinePhaseRelation.Last.INSTANCE);
                phasesList.set((int)index, content);
                return content;
            }
            if (e instanceof PhaseContent && ((PhaseContent)e).getPhase() == phase) {
                return (PhaseContent)e;
            }
            ++index;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final int findPhaseIndex(PipelinePhase phase) {
        ArrayList<Object> phasesList = this.phasesRaw;
        int n = 0;
        int n2 = phasesList.size();
        while (n < n2) {
            Object e;
            void index;
            Intrinsics.checkExpressionValueIsNotNull((Object)phasesList.get((int)index), (String)"phasesList[index]");
            if (e == phase) {
                return (int)index;
            }
            if (e instanceof PhaseContent && ((PhaseContent)e).getPhase() == phase) {
                return (int)index;
            }
            ++index;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean hasPhase(PipelinePhase phase) {
        ArrayList<Object> phasesList = this.phasesRaw;
        int n = 0;
        int n2 = phasesList.size();
        while (n < n2) {
            Object e;
            void index;
            Intrinsics.checkExpressionValueIsNotNull((Object)phasesList.get((int)index), (String)"phasesList[index]");
            if (e == phase) {
                return true;
            }
            if (e instanceof PhaseContent && ((PhaseContent)e).getPhase() == phase) {
                return true;
            }
            ++index;
        }
        return false;
    }

    @NotNull
    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> phaseInterceptors$ktor_utils(@NotNull PipelinePhase phase) {
        Intrinsics.checkParameterIsNotNull((Object)phase, (String)"phase");
        PhaseContent<TSubject, TContext> phaseContent = this.findPhase(phase);
        return phaseContent != null && (phaseContent = phaseContent.sharedInterceptors()) != null ? (List)((Object)phaseContent) : CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PipelinePhase> getItems() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.phasesRaw;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PipelinePhase pipelinePhase;
            void it;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object v0 = it;
            if (!(v0 instanceof PipelinePhase)) {
                v0 = null;
            }
            if ((pipelinePhase = (PipelinePhase)v0) == null) {
                Object v2 = it;
                if (!(v2 instanceof PhaseContent)) {
                    v2 = null;
                }
                PhaseContent phaseContent = v2;
                pipelinePhase = phaseContent != null ? phaseContent.getPhase() : null;
                if (pipelinePhase == null) {
                    Intrinsics.throwNpe();
                }
            }
            PipelinePhase pipelinePhase2 = pipelinePhase;
            collection.add(pipelinePhase2);
        }
        return (List)destination$iv$iv;
    }

    public final void addPhase(@NotNull PipelinePhase phase) {
        Intrinsics.checkParameterIsNotNull((Object)phase, (String)"phase");
        if (this.hasPhase(phase)) {
            return;
        }
        this.phasesRaw.add(phase);
    }

    public final void insertPhaseAfter(@NotNull PipelinePhase reference, @NotNull PipelinePhase phase) {
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)phase, (String)"phase");
        if (this.hasPhase(phase)) {
            return;
        }
        int index = this.findPhaseIndex(reference);
        if (index == -1) {
            throw (Throwable)new InvalidPhaseException("Phase " + reference + " was not registered for this pipeline");
        }
        this.phasesRaw.add(index + 1, new PhaseContent(phase, new PipelinePhaseRelation.After(reference)));
    }

    public final void insertPhaseBefore(@NotNull PipelinePhase reference, @NotNull PipelinePhase phase) {
        Intrinsics.checkParameterIsNotNull((Object)reference, (String)"reference");
        Intrinsics.checkParameterIsNotNull((Object)phase, (String)"phase");
        if (this.hasPhase(phase)) {
            return;
        }
        int index = this.findPhaseIndex(reference);
        if (index == -1) {
            throw (Throwable)new InvalidPhaseException("Phase " + reference + " was not registered for this pipeline");
        }
        this.phasesRaw.add(index, new PhaseContent(phase, new PipelinePhaseRelation.Before(reference)));
    }

    @InternalAPI
    public static /* synthetic */ void isEmpty$annotations() {
    }

    public final boolean isEmpty() {
        return this.interceptorsQuantity == 0;
    }

    @NotNull
    public final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> interceptorsForTests$ktor_utils() {
        List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<Unit>, Object>> list = this.interceptors;
        if (list == null) {
            list = this.cacheInterceptors();
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> cacheInterceptors() {
        int n;
        int n2;
        int interceptorsQuantity = this.interceptorsQuantity;
        if (interceptorsQuantity == 0) {
            this.notSharedInterceptorsList(CollectionsKt.emptyList());
            return CollectionsKt.emptyList();
        }
        ArrayList<Object> phases = this.phasesRaw;
        if (interceptorsQuantity == 1 && (n2 = 0) <= (n = CollectionsKt.getLastIndex((List)phases))) {
            while (true) {
                PhaseContent phaseContent;
                void phaseIndex;
                Object object;
                if (!((object = phases.get((int)phaseIndex)) instanceof PhaseContent)) {
                    object = null;
                }
                if ((PhaseContent)object == null) {
                } else if (!phaseContent.isEmpty()) {
                    ArrayList interceptors = phaseContent.sharedInterceptors();
                    this.setInterceptorsListFromPhase(phaseContent);
                    return interceptors;
                }
                if (phaseIndex == n) break;
                ++phaseIndex;
            }
        }
        ArrayList destination = new ArrayList(interceptorsQuantity);
        n = 0;
        int n3 = CollectionsKt.getLastIndex((List)phases);
        if (n <= n3) {
            while (true) {
                void phaseIndex;
                Object object;
                if (!((object = phases.get((int)phaseIndex)) instanceof PhaseContent)) {
                    object = null;
                }
                if ((PhaseContent)object == null) {
                } else {
                    PhaseContent phase;
                    phase.addTo(destination);
                }
                if (phaseIndex == n3) break;
                ++phaseIndex;
            }
        }
        this.notSharedInterceptorsList(destination);
        return destination;
    }

    public final void intercept(@NotNull PipelinePhase phase, @NotNull Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object> block) {
        Intrinsics.checkParameterIsNotNull((Object)phase, (String)"phase");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        PhaseContent<? super TSubject, TContext> phaseContent = this.findPhase(phase);
        if (phaseContent == null) {
            throw (Throwable)new InvalidPhaseException("Phase " + phase + " was not registered for this pipeline");
        }
        PhaseContent<? super TSubject, TContext> phaseContent2 = phaseContent;
        if (this.tryAddToPhaseFastpath(phase, block)) {
            int n = this.interceptorsQuantity;
            this.interceptorsQuantity = n + 1;
            return;
        }
        phaseContent2.addInterceptor(block);
        int n = this.interceptorsQuantity;
        this.interceptorsQuantity = n + 1;
        this.resetInterceptorsList();
        this.afterIntercepted();
    }

    public void afterIntercepted() {
    }

    /*
     * WARNING - void declaration
     */
    public final void merge(@NotNull Pipeline<TSubject, TContext> from) {
        Intrinsics.checkParameterIsNotNull(from, (String)"from");
        if (this.fastPathMerge(from)) {
            return;
        }
        if (this.interceptorsQuantity == 0) {
            this.setInterceptorsListFromAnotherPipeline(from);
        } else {
            this.resetInterceptorsList();
        }
        ArrayList<Object> fromPhases = from.phasesRaw;
        int n = 0;
        int n2 = CollectionsKt.getLastIndex((List)fromPhases);
        if (n <= n2) {
            while (true) {
                PipelinePhase fromPhase;
                PipelinePhase pipelinePhase;
                Object fromPhaseOrContent;
                void index;
                Intrinsics.checkExpressionValueIsNotNull((Object)fromPhases.get((int)index), (String)"fromPhases[index]");
                Object object = fromPhaseOrContent;
                if (!(object instanceof PipelinePhase)) {
                    object = null;
                }
                if ((pipelinePhase = (PipelinePhase)object) == null) {
                    Object object2 = fromPhaseOrContent;
                    if (object2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type io.ktor.util.pipeline.Pipeline.PhaseContent<*, *>");
                    }
                    pipelinePhase = fromPhase = ((PhaseContent)object2).getPhase();
                }
                if (!this.hasPhase(fromPhase)) {
                    PipelinePhaseRelation fromPhaseRelation;
                    PipelinePhaseRelation pipelinePhaseRelation;
                    if (fromPhaseOrContent == fromPhase) {
                        pipelinePhaseRelation = PipelinePhaseRelation.Last.INSTANCE;
                    } else {
                        Object object3 = fromPhaseOrContent;
                        if (object3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type io.ktor.util.pipeline.Pipeline.PhaseContent<*, *>");
                        }
                        pipelinePhaseRelation = ((PhaseContent)object3).getRelation();
                    }
                    PipelinePhaseRelation pipelinePhaseRelation2 = fromPhaseRelation = pipelinePhaseRelation;
                    if (pipelinePhaseRelation2 instanceof PipelinePhaseRelation.Last) {
                        this.addPhase(fromPhase);
                    } else if (pipelinePhaseRelation2 instanceof PipelinePhaseRelation.Before) {
                        this.insertPhaseBefore(((PipelinePhaseRelation.Before)fromPhaseRelation).getRelativeTo(), fromPhase);
                    } else if (pipelinePhaseRelation2 instanceof PipelinePhaseRelation.After) {
                        this.insertPhaseAfter(((PipelinePhaseRelation.After)fromPhaseRelation).getRelativeTo(), fromPhase);
                    }
                }
                if (fromPhaseOrContent instanceof PhaseContent && !((PhaseContent)fromPhaseOrContent).isEmpty()) {
                    PhaseContent cfr_ignored_0 = (PhaseContent)fromPhaseOrContent;
                    PhaseContent phaseContent = (PhaseContent)fromPhaseOrContent;
                    PhaseContent<TSubject, TContext> phaseContent2 = this.findPhase(fromPhase);
                    if (phaseContent2 == null) {
                        Intrinsics.throwNpe();
                    }
                    phaseContent.addTo(phaseContent2);
                    this.interceptorsQuantity += ((PhaseContent)fromPhaseOrContent).getSize();
                }
                if (index == n2) break;
                ++index;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final <E> void addAllAF(@NotNull ArrayList<E> $this$addAllAF, ArrayList<E> from) {
        $this$addAllAF.ensureCapacity($this$addAllAF.size() + from.size());
        int n = 0;
        int n2 = from.size();
        while (n < n2) {
            void index;
            $this$addAllAF.add(from.get((int)index));
            ++index;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean fastPathMerge(Pipeline<TSubject, TContext> from) {
        if (from.phasesRaw.isEmpty()) {
            return true;
        }
        if (this.phasesRaw.isEmpty()) {
            int n = 0;
            ArrayList<Object> fromPhases = from.phasesRaw;
            int n2 = CollectionsKt.getLastIndex((List)fromPhases);
            if (n <= n2) {
                while (true) {
                    Object fromPhaseOrContent;
                    void index;
                    Intrinsics.checkExpressionValueIsNotNull((Object)fromPhases.get((int)index), (String)"fromPhases[index]");
                    if (fromPhaseOrContent instanceof PipelinePhase) {
                        this.phasesRaw.add(fromPhaseOrContent);
                    } else if (fromPhaseOrContent instanceof PhaseContent) {
                        PhaseContent cfr_ignored_0 = (PhaseContent)fromPhaseOrContent;
                        this.phasesRaw.add(new PhaseContent(((PhaseContent)fromPhaseOrContent).getPhase(), ((PhaseContent)fromPhaseOrContent).getRelation(), ((PhaseContent)fromPhaseOrContent).sharedInterceptors()));
                    }
                    if (index == n2) break;
                    ++index;
                }
            }
            this.interceptorsQuantity += from.interceptorsQuantity;
            this.setInterceptorsListFromAnotherPipeline(from);
            return true;
        }
        return false;
    }

    private final List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<? super Unit>, Object>> sharedInterceptorsList() {
        if (this.interceptors == null) {
            this.cacheInterceptors();
        }
        this.interceptorsListShared = true;
        List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> list = this.interceptors;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        return list;
    }

    private final void resetInterceptorsList() {
        this.interceptors = null;
        this.interceptorsListShared = false;
        this.interceptorsListSharedPhase = null;
    }

    private final void notSharedInterceptorsList(List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> list) {
        this.interceptors = list;
        this.interceptorsListShared = false;
        this.interceptorsListSharedPhase = null;
    }

    private final void setInterceptorsListFromPhase(PhaseContent<TSubject, TContext> phaseContent) {
        this.interceptors = phaseContent.sharedInterceptors();
        this.interceptorsListShared = false;
        this.interceptorsListSharedPhase = phaseContent.getPhase();
    }

    private final void setInterceptorsListFromAnotherPipeline(Pipeline<TSubject, TContext> pipeline) {
        this.interceptors = super.sharedInterceptorsList();
        this.interceptorsListShared = true;
        this.interceptorsListSharedPhase = null;
    }

    private final boolean tryAddToPhaseFastpath(PipelinePhase phase, Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object> block) {
        if (this.phasesRaw.isEmpty()) {
            return false;
        }
        if (this.interceptors == null) {
            return false;
        }
        if (!this.interceptorsListShared) {
            if (Intrinsics.areEqual((Object)this.interceptorsListSharedPhase, (Object)phase)) {
                List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<Unit>, Object>> list = this.interceptors;
                if (!TypeIntrinsics.isMutableList(list)) {
                    list = null;
                }
                if (list != null) {
                    List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<Unit>, Object>> list2 = list;
                    boolean bl = false;
                    boolean bl2 = false;
                    List<Function3<PipelineContext<TSubject, TContext>, TSubject, Continuation<Unit>, Object>> it = list2;
                    boolean bl3 = false;
                    it.add(block);
                    return true;
                }
            }
            if ((Intrinsics.areEqual((Object)phase, (Object)CollectionsKt.last((List)this.phasesRaw)) || this.findPhaseIndex(phase) == CollectionsKt.getLastIndex((List)this.phasesRaw)) && TypeIntrinsics.isMutableList(this.interceptors)) {
                PhaseContent<? super TSubject, TContext> phaseContent = this.findPhase(phase);
                if (phaseContent == null) {
                    Intrinsics.throwNpe();
                }
                phaseContent.addInterceptor(block);
                List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> list = this.interceptors;
                if (list == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.MutableList<io.ktor.util.pipeline.PipelineInterceptor<TSubject, TContext> /* = suspend io.ktor.util.pipeline.PipelineContext<TSubject, TContext>.(TSubject) -> kotlin.Unit */>");
                }
                List list3 = TypeIntrinsics.asMutableList(list);
                boolean bl = false;
                boolean bl4 = false;
                List it = list3;
                boolean bl5 = false;
                it.add(block);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Pipeline(PipelinePhase ... phases) {
        Collection collection;
        void $this$mapTo$iv;
        Intrinsics.checkParameterIsNotNull((Object)phases, (String)"phases");
        this.attributes = AttributesJvmKt.Attributes$default(false, 1, null);
        PipelinePhase[] pipelinePhaseArray = phases;
        Collection collection2 = new ArrayList(phases.length + 1);
        Pipeline pipeline = this;
        boolean $i$f$mapTo = false;
        void var5_6 = $this$mapTo$iv;
        int n = ((void)var5_6).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void destination$iv;
            void item$iv;
            void var9_10 = item$iv = var5_6[i];
            collection = destination$iv;
            boolean bl = false;
            void var13_13 = it;
            collection.add(var13_13);
        }
        collection = collection2;
        pipeline.phasesRaw = (ArrayList)collection;
    }

    public Pipeline(@NotNull PipelinePhase phase, @NotNull List<? extends Function3<? super PipelineContext<TSubject, TContext>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object>> interceptors) {
        Intrinsics.checkParameterIsNotNull((Object)phase, (String)"phase");
        Intrinsics.checkParameterIsNotNull(interceptors, (String)"interceptors");
        this(phase);
        Iterable $this$forEach$iv = interceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function3 it = (Function3)element$iv;
            boolean bl = false;
            this.intercept(phase, it);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u0000 +*\b\b\u0002\u0010\u0001*\u00020\u0002*\b\b\u0003\u0010\u0003*\u00020\u00022\u00020\u0002:\u0001+B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u0096\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012|\u0010\t\u001ax\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\f\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b\u00a2\u0006\u0002\b\u000f0\nj;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\f\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b\u00a2\u0006\u0002\b\u000f`\u0010\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011JI\u0010!\u001a\u00020\u000e29\u0010\"\u001a5\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\f\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b\u00a2\u0006\u0002\b\u000f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#J\u001a\u0010$\u001a\u00020\u000e2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\u0000J\u0087\u0001\u0010$\u001a\u00020\u000e2|\u0010%\u001ax\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\f\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b\u00a2\u0006\u0002\b\u000f0\nj;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\f\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b\u00a2\u0006\u0002\b\u000f`\u0010\u00f8\u0001\u0000J\u007f\u0010&\u001ax\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\f\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b\u00a2\u0006\u0002\b\u000f0\nj;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\f\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b\u00a2\u0006\u0002\b\u000f`\u0010\u00f8\u0001\u0000J\b\u0010'\u001a\u00020\u000eH\u0002J\u007f\u0010(\u001ax\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\f\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b\u00a2\u0006\u0002\b\u000f0\nj;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\f\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b\u00a2\u0006\u0002\b\u000f`\u0010\u00f8\u0001\u0000J\b\u0010)\u001a\u00020*H\u0016R\u0087\u0001\u0010\t\u001ax\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\f\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b\u00a2\u0006\u0002\b\u000f0\nj;\u00127\u00125\b\u0001\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0002\u0012\u0004\u0012\u00028\u00030\f\u0012\u0004\u0012\u00028\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000b\u00a2\u0006\u0002\b\u000f`\u0010X\u0082\u000e\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0014\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006,"}, d2={"Lio/ktor/util/pipeline/Pipeline$PhaseContent;", "TSubject", "", "Call", "phase", "Lio/ktor/util/pipeline/PipelinePhase;", "relation", "Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation;", "(Lio/ktor/util/pipeline/PipelinePhase;Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation;)V", "interceptors", "Ljava/util/ArrayList;", "Lkotlin/Function3;", "Lio/ktor/util/pipeline/PipelineContext;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "Lkotlin/collections/ArrayList;", "(Lio/ktor/util/pipeline/PipelinePhase;Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation;Ljava/util/ArrayList;)V", "isEmpty", "", "()Z", "getPhase", "()Lio/ktor/util/pipeline/PipelinePhase;", "getRelation", "()Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation;", "shared", "getShared", "setShared", "(Z)V", "size", "", "getSize", "()I", "addInterceptor", "interceptor", "(Lkotlin/jvm/functions/Function3;)V", "addTo", "destination", "copiedInterceptors", "copyInterceptors", "sharedInterceptors", "toString", "", "Companion", "ktor-utils"})
    private static final class PhaseContent<TSubject, Call> {
        private boolean shared;
        @NotNull
        private final PipelinePhase phase;
        @NotNull
        private final PipelinePhaseRelation relation;
        private ArrayList<Function3<PipelineContext<TSubject, Call>, TSubject, Continuation<? super Unit>, Object>> interceptors;
        @NotNull
        private static final ArrayList<Object> SharedArrayList;
        public static final Companion Companion;

        public final boolean getShared() {
            return this.shared;
        }

        public final void setShared(boolean bl) {
            this.shared = bl;
        }

        public final boolean isEmpty() {
            return this.interceptors.isEmpty();
        }

        public final int getSize() {
            return this.interceptors.size();
        }

        public final void addInterceptor(@NotNull Function3<? super PipelineContext<TSubject, Call>, ? super TSubject, ? super Continuation<? super Unit>, ? extends Object> interceptor) {
            Intrinsics.checkParameterIsNotNull(interceptor, (String)"interceptor");
            if (this.shared) {
                this.copyInterceptors();
            }
            this.interceptors.add(interceptor);
        }

        /*
         * WARNING - void declaration
         */
        public final void addTo(@NotNull ArrayList<Function3<PipelineContext<TSubject, Call>, TSubject, Continuation<? super Unit>, Object>> destination) {
            Intrinsics.checkParameterIsNotNull(destination, (String)"destination");
            ArrayList<Function3<PipelineContext<TSubject, Call>, TSubject, Continuation<Unit>, Object>> interceptors = this.interceptors;
            destination.ensureCapacity(destination.size() + interceptors.size());
            int n = 0;
            int n2 = interceptors.size();
            while (n < n2) {
                void index;
                destination.add(interceptors.get((int)index));
                ++index;
            }
        }

        public final void addTo(@NotNull PhaseContent<TSubject, Call> destination) {
            Intrinsics.checkParameterIsNotNull(destination, (String)"destination");
            if (this.isEmpty()) {
                return;
            }
            if (destination.isEmpty()) {
                destination.interceptors = this.sharedInterceptors();
                destination.shared = true;
                return;
            }
            if (destination.shared) {
                super.copyInterceptors();
            }
            this.addTo(destination.interceptors);
        }

        @NotNull
        public final ArrayList<Function3<PipelineContext<TSubject, Call>, TSubject, Continuation<? super Unit>, Object>> sharedInterceptors() {
            this.shared = true;
            return this.interceptors;
        }

        @NotNull
        public final ArrayList<Function3<PipelineContext<TSubject, Call>, TSubject, Continuation<? super Unit>, Object>> copiedInterceptors() {
            return new ArrayList<Function3<PipelineContext<TSubject, Call>, TSubject, Continuation<? super Unit>, Object>>((Collection)this.interceptors);
        }

        @NotNull
        public String toString() {
            return "Phase `" + this.phase.getName() + "`, " + this.getSize() + " handlers";
        }

        private final void copyInterceptors() {
            this.interceptors = this.copiedInterceptors();
            this.shared = false;
        }

        @NotNull
        public final PipelinePhase getPhase() {
            return this.phase;
        }

        @NotNull
        public final PipelinePhaseRelation getRelation() {
            return this.relation;
        }

        public PhaseContent(@NotNull PipelinePhase phase, @NotNull PipelinePhaseRelation relation, @NotNull ArrayList<Function3<PipelineContext<TSubject, Call>, TSubject, Continuation<? super Unit>, Object>> interceptors) {
            Intrinsics.checkParameterIsNotNull((Object)phase, (String)"phase");
            Intrinsics.checkParameterIsNotNull((Object)relation, (String)"relation");
            Intrinsics.checkParameterIsNotNull(interceptors, (String)"interceptors");
            this.phase = phase;
            this.relation = relation;
            this.interceptors = interceptors;
            this.shared = true;
        }

        public PhaseContent(@NotNull PipelinePhase phase, @NotNull PipelinePhaseRelation relation) {
            Intrinsics.checkParameterIsNotNull((Object)phase, (String)"phase");
            Intrinsics.checkParameterIsNotNull((Object)relation, (String)"relation");
            ArrayList<Object> arrayList = SharedArrayList;
            if (arrayList == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.ArrayList<io.ktor.util.pipeline.PipelineInterceptor<TSubject, Call> /* = suspend io.ktor.util.pipeline.PipelineContext<TSubject, Call>.(TSubject) -> kotlin.Unit */> /* = java.util.ArrayList<suspend io.ktor.util.pipeline.PipelineContext<TSubject, Call>.(TSubject) -> kotlin.Unit> */");
            }
            this(phase, relation, arrayList);
            boolean bl = SharedArrayList.isEmpty();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "The shared empty array list has been modified";
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }

        static {
            Companion = new Companion(null);
            SharedArrayList = new ArrayList(0);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R%\u0010\u0003\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004j\n\u0012\u0006\u0012\u0004\u0018\u00010\u0001`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/ktor/util/pipeline/Pipeline$PhaseContent$Companion;", "", "()V", "SharedArrayList", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getSharedArrayList", "()Ljava/util/ArrayList;", "ktor-utils"})
        public static final class Companion {
            @NotNull
            public final ArrayList<Object> getSharedArrayList() {
                return SharedArrayList;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\t"}, d2={"Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation;", "", "()V", "After", "Before", "Last", "Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation$After;", "Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation$Before;", "Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation$Last;", "ktor-utils"})
    private static abstract class PipelinePhaseRelation {
        private PipelinePhaseRelation() {
        }

        public /* synthetic */ PipelinePhaseRelation(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0007"}, d2={"Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation$After;", "Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation;", "relativeTo", "Lio/ktor/util/pipeline/PipelinePhase;", "(Lio/ktor/util/pipeline/PipelinePhase;)V", "getRelativeTo", "()Lio/ktor/util/pipeline/PipelinePhase;", "ktor-utils"})
        public static final class After
        extends PipelinePhaseRelation {
            @NotNull
            private final PipelinePhase relativeTo;

            @NotNull
            public final PipelinePhase getRelativeTo() {
                return this.relativeTo;
            }

            public After(@NotNull PipelinePhase relativeTo) {
                Intrinsics.checkParameterIsNotNull((Object)relativeTo, (String)"relativeTo");
                super(null);
                this.relativeTo = relativeTo;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0007"}, d2={"Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation$Before;", "Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation;", "relativeTo", "Lio/ktor/util/pipeline/PipelinePhase;", "(Lio/ktor/util/pipeline/PipelinePhase;)V", "getRelativeTo", "()Lio/ktor/util/pipeline/PipelinePhase;", "ktor-utils"})
        public static final class Before
        extends PipelinePhaseRelation {
            @NotNull
            private final PipelinePhase relativeTo;

            @NotNull
            public final PipelinePhase getRelativeTo() {
                return this.relativeTo;
            }

            public Before(@NotNull PipelinePhase relativeTo) {
                Intrinsics.checkParameterIsNotNull((Object)relativeTo, (String)"relativeTo");
                super(null);
                this.relativeTo = relativeTo;
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0003"}, d2={"Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation$Last;", "Lio/ktor/util/pipeline/Pipeline$PipelinePhaseRelation;", "()V", "ktor-utils"})
        public static final class Last
        extends PipelinePhaseRelation {
            public static final Last INSTANCE;

            private Last() {
                super(null);
            }

            static {
                Last last;
                INSTANCE = last = new Last();
            }
        }
    }
}

