/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.tomcat;

import io.ktor.application.Application;
import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.server.engine.ApplicationEngine;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineContextCancellationHelperKt;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import io.ktor.server.servlet.DefaultServletUpgrade;
import io.ktor.server.servlet.KtorServlet;
import io.ktor.server.servlet.ServletUpgrade;
import io.ktor.server.tomcat.TomcatApplicationEngine;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.CompletableDeferred;
import org.apache.catalina.Context;
import org.apache.catalina.Service;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.jni.Library;
import org.apache.tomcat.jni.SSL;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.jsse.JSSEImplementation;
import org.apache.tomcat.util.net.openssl.OpenSSLImplementation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000_\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003*\u0001\u000e\u0018\u0000 $2\u00020\u0001:\u0002$%B&\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#H\u0016R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006&"}, d2={"Lio/ktor/server/tomcat/TomcatApplicationEngine;", "Lio/ktor/server/engine/BaseApplicationEngine;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "configure", "Lkotlin/Function1;", "Lio/ktor/server/tomcat/TomcatApplicationEngine$Configuration;", "", "Lkotlin/ExtensionFunctionType;", "(Lio/ktor/server/engine/ApplicationEngineEnvironment;Lkotlin/jvm/functions/Function1;)V", "cancellationDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "configuration", "ktorServlet", "io/ktor/server/tomcat/TomcatApplicationEngine$ktorServlet$1", "Lio/ktor/server/tomcat/TomcatApplicationEngine$ktorServlet$1;", "server", "Lorg/apache/catalina/startup/Tomcat;", "stopped", "Lkotlinx/atomicfu/AtomicBoolean;", "tempDirectory", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "getTempDirectory", "()Ljava/nio/file/Path;", "tempDirectory$delegate", "Lkotlin/Lazy;", "start", "wait", "", "stop", "gracePeriod", "", "timeout", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "Companion", "Configuration", "ktor-server-tomcat"})
public final class TomcatApplicationEngine
extends BaseApplicationEngine {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final Configuration configuration;
    private final Lazy tempDirectory$delegate;
    private CompletableDeferred<Unit> cancellationDeferred;
    private final ktorServlet.1 ktorServlet;
    private final Tomcat server;
    private volatile int stopped;
    private static final AtomicIntegerFieldUpdater stopped$FU;
    private static final List<String> nativeNames;
    public static final Companion Companion;

    private final Path getTempDirectory() {
        Lazy lazy = this.tempDirectory$delegate;
        TomcatApplicationEngine tomcatApplicationEngine = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Path)lazy.getValue();
    }

    @NotNull
    public TomcatApplicationEngine start(boolean wait) {
        this.getEnvironment().start();
        this.server.start();
        this.cancellationDeferred = EngineContextCancellationHelperKt.stopServerOnCancellation((ApplicationEngine)this);
        if (wait) {
            this.server.getServer().await();
            this.stop(1L, 5L, TimeUnit.SECONDS);
        }
        return this;
    }

    public void stop(long gracePeriod, long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        if (stopped$FU.compareAndSet(this, 0, 1)) {
            CompletableDeferred<Unit> completableDeferred = this.cancellationDeferred;
            if (completableDeferred != null) {
                completableDeferred.complete((Object)Unit.INSTANCE);
            }
            this.getEnvironment().getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
            this.server.stop();
            this.getEnvironment().stop();
            this.server.destroy();
            File file = this.getTempDirectory().toFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"tempDirectory.toFile()");
            FilesKt.deleteRecursively((File)file);
        }
    }

    public TomcatApplicationEngine(@NotNull ApplicationEngineEnvironment environment, @NotNull Function1<? super Configuration, Unit> configure) {
        Wrapper wrapper;
        Object $receiver$iv;
        Service service;
        Configuration configuration;
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull(configure, (String)"configure");
        super(environment, null, 2, null);
        Configuration configuration2 = new Configuration();
        TomcatApplicationEngine tomcatApplicationEngine = this;
        configure.invoke((Object)configuration2);
        tomcatApplicationEngine.configuration = configuration = configuration2;
        this.tempDirectory$delegate = LazyKt.lazy((Function0)tempDirectory.2.INSTANCE);
        this.ktorServlet = new KtorServlet(this){
            final /* synthetic */ TomcatApplicationEngine this$0;

            @NotNull
            protected EnginePipeline getEnginePipeline() {
                return this.this$0.getPipeline();
            }

            @NotNull
            protected Application getApplication() {
                return this.this$0.getApplication();
            }

            @NotNull
            protected ServletUpgrade getUpgrade() {
                return (ServletUpgrade)DefaultServletUpgrade.INSTANCE;
            }
            {
                this.this$0 = $outer;
            }
        };
        configuration2 = new Tomcat();
        tomcatApplicationEngine = this;
        Configuration $receiver = configuration2;
        this.configuration.getConfigureTomcat().invoke((Object)$receiver);
        Service $receiver2 = service = $receiver.getService();
        Connector[] connectorArray = $receiver2.findConnectors();
        Intrinsics.checkExpressionValueIsNotNull((Object)connectorArray, (String)"findConnectors()");
        Object object = $receiver$iv = connectorArray;
        int n = ((Connector[])object).length;
        for (int i = 0; i < n; ++i) {
            Connector element$iv;
            Connector existing = element$iv = object[i];
            $receiver2.removeConnector(existing);
        }
        $receiver$iv = environment.getConnectors();
        object = $receiver$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            EngineConnectorConfig ktorConnector = (EngineConnectorConfig)element$iv;
            Connector connector = new Connector();
            Service service2 = $receiver2;
            Connector $receiver3 = connector;
            $receiver3.setPort(ktorConnector.getPort());
            if (ktorConnector instanceof EngineSSLConnectorConfig) {
                $receiver3.setSecure(true);
                $receiver3.setScheme("https");
                if (((EngineSSLConnectorConfig)ktorConnector).getKeyStorePath() == null) {
                    throw (Throwable)new IllegalArgumentException("Tomcat requires keyStorePath");
                }
                $receiver3.setAttribute("keyAlias", (Object)((EngineSSLConnectorConfig)ktorConnector).getKeyAlias());
                char[] $i$f$forEach = (char[])((EngineSSLConnectorConfig)ktorConnector).getKeyStorePassword().invoke();
                String string = "keystorePass";
                Connector connector2 = $receiver3;
                String string2 = new String($i$f$forEach);
                connector2.setAttribute(string, (Object)string2);
                $i$f$forEach = (char[])((EngineSSLConnectorConfig)ktorConnector).getPrivateKeyPassword().invoke();
                string = "keyPass";
                connector2 = $receiver3;
                string2 = new String($i$f$forEach);
                connector2.setAttribute(string, (Object)string2);
                File file = ((EngineSSLConnectorConfig)ktorConnector).getKeyStorePath();
                if (file == null) {
                    Intrinsics.throwNpe();
                }
                $receiver3.setAttribute("keystoreFile", (Object)file.getAbsolutePath());
                $receiver3.setAttribute("clientAuth", (Object)false);
                $receiver3.setAttribute("sslProtocol", (Object)"TLS");
                $receiver3.setAttribute("SSLEnabled", (Object)true);
                Class sslImpl = TomcatApplicationEngine.Companion.chooseSSLImplementation();
                $receiver3.setAttribute("sslImplementationName", (Object)sslImpl.getName());
                if (Intrinsics.areEqual((Object)sslImpl.getSimpleName(), (Object)"OpenSSLImplementation")) {
                    $receiver3.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
                }
            } else {
                $receiver3.setScheme("http");
            }
            Connector connector3 = connector;
            service2.addConnector(connector3);
        }
        if ($receiver.getConnector() == null) {
            Configuration configuration3 = $receiver;
            Connector[] connectorArray2 = $receiver.getService().findConnectors();
            if (connectorArray2 == null || (connectorArray2 = (Connector[])ArraysKt.firstOrNull((Object[])connectorArray2)) == null) {
                service = new Connector();
                Configuration configuration4 = configuration3;
                $receiver2 = service;
                $receiver2.setPort(80);
                Service service3 = service;
                configuration3 = configuration4;
                connectorArray2 = service3;
            }
            configuration3.setConnector((Connector)connectorArray2);
        }
        $receiver.setBaseDir(((Object)this.getTempDirectory()).toString());
        Context ctx = $receiver.addContext("", ((Object)this.getTempDirectory()).toString());
        Wrapper $receiver4 = wrapper = Tomcat.addServlet((Context)ctx, (String)"ktor-servlet", (Servlet)((Servlet)this.ktorServlet));
        $receiver4.addMapping("/*");
        $receiver4.setAsyncSupported(true);
        $receiver4.setMultipartConfigElement(new MultipartConfigElement(""));
        configuration = configuration2;
        tomcatApplicationEngine.server = configuration;
        this.stopped = 0;
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TomcatApplicationEngine.class), "tempDirectory", "getTempDirectory()Ljava/nio/file/Path;"))};
        Companion = new Companion(null);
        nativeNames = CollectionsKt.listOf((Object)"netty-tcnative-windows-x86_64");
        stopped$FU = AtomicIntegerFieldUpdater.newUpdater(TomcatApplicationEngine.class, "stopped");
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lio/ktor/server/tomcat/TomcatApplicationEngine$Configuration;", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "()V", "configureTomcat", "Lkotlin/Function1;", "Lorg/apache/catalina/startup/Tomcat;", "", "Lkotlin/ExtensionFunctionType;", "getConfigureTomcat", "()Lkotlin/jvm/functions/Function1;", "setConfigureTomcat", "(Lkotlin/jvm/functions/Function1;)V", "ktor-server-tomcat"})
    public static final class Configuration
    extends BaseApplicationEngine.Configuration {
        @NotNull
        private Function1<? super Tomcat, Unit> configureTomcat = configureTomcat.1.INSTANCE;

        @NotNull
        public final Function1<Tomcat, Unit> getConfigureTomcat() {
            return this.configureTomcat;
        }

        public final void setConfigureTomcat(@NotNull Function1<? super Tomcat, Unit> function1) {
            Intrinsics.checkParameterIsNotNull(function1, (String)"<set-?>");
            this.configureTomcat = function1;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/ktor/server/tomcat/TomcatApplicationEngine$Companion;", "", "()V", "nativeNames", "", "", "chooseSSLImplementation", "Ljava/lang/Class;", "Lorg/apache/tomcat/util/net/SSLImplementation;", "tryLoadLibrary", "", "libraryName", "ktor-server-tomcat"})
    public static final class Companion {
        private final Class<? extends SSLImplementation> chooseSSLImplementation() {
            Class<JSSEImplementation> clazz;
            try {
                Class<JSSEImplementation> clazz2;
                Object v0;
                block5: {
                    Iterable $receiver$iv = nativeNames;
                    for (Object element$iv : $receiver$iv) {
                        String it = (String)element$iv;
                        if (!Companion.tryLoadLibrary(it)) continue;
                        v0 = element$iv;
                        break block5;
                    }
                    v0 = null;
                }
                String nativeName = v0;
                if (nativeName != null) {
                    Library.initialize((String)nativeName);
                    SSL.initialize(null);
                    SSL.freeSSL((long)SSL.newSSL((long)28, (boolean)true));
                    clazz2 = OpenSSLImplementation.class;
                } else {
                    clazz2 = JSSEImplementation.class;
                }
                clazz = clazz2;
            }
            catch (Throwable t) {
                clazz = JSSEImplementation.class;
            }
            return clazz;
        }

        private final boolean tryLoadLibrary(String libraryName) {
            boolean bl;
            try {
                System.loadLibrary(libraryName);
                bl = true;
            }
            catch (Throwable t) {
                bl = false;
            }
            return bl;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

