/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.servlet;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import io.ktor.application.Application;
import io.ktor.application.ApplicationEnvironment;
import io.ktor.application.DefaultApplicationEventsKt;
import io.ktor.config.ApplicationConfig;
import io.ktor.config.HoconApplicationConfig;
import io.ktor.config.HoconApplicationConfigKt;
import io.ktor.request.ApplicationReceivePipeline;
import io.ktor.response.ApplicationSendPipeline;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEngineEnvironmentKt;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.engine.DefaultEnginePipelineKt;
import io.ktor.server.engine.DefaultTransformKt;
import io.ktor.server.engine.EngineAPI;
import io.ktor.server.engine.EnginePipeline;
import io.ktor.server.servlet.DefaultServletUpgrade;
import io.ktor.server.servlet.KtorServlet;
import io.ktor.server.servlet.ServletApplicationEngine;
import io.ktor.server.servlet.ServletUpgrade;
import io.ktor.util.TextKt;
import io.ktor.util.pipeline.Pipeline;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MultipartConfig
@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020 H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001b\u0010\u000b\u001a\u00020\f8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00178TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\u00020\u001b8TX\u0094\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0010\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Lio/ktor/server/servlet/ServletApplicationEngine;", "Lio/ktor/server/servlet/KtorServlet;", "()V", "application", "Lio/ktor/application/Application;", "getApplication", "()Lio/ktor/application/Application;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "enginePipeline", "Lio/ktor/server/engine/EnginePipeline;", "getEnginePipeline", "()Lio/ktor/server/engine/EnginePipeline;", "enginePipeline$delegate", "Lkotlin/Lazy;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "getEnvironment", "()Lio/ktor/server/engine/ApplicationEngineEnvironment;", "environment$delegate", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "upgrade", "Lio/ktor/server/servlet/ServletUpgrade;", "getUpgrade", "()Lio/ktor/server/servlet/ServletUpgrade;", "upgrade$delegate", "destroy", "", "init", "Companion", "ktor-server-servlet"})
public class ServletApplicationEngine
extends KtorServlet {
    private final Lazy environment$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ApplicationEngineEnvironment>(this){
        final /* synthetic */ ServletApplicationEngine this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final ApplicationEngineEnvironment invoke() {
            Config combinedConfig;
            Config config;
            Object it2;
            void $this$associateByTo$iv$iv;
            void $this$filterTo$iv$iv;
            List list;
            List list2;
            boolean bl;
            Enumeration enumeration;
            ServletContext servletContext = this.this$0.getServletContext();
            ServletConfig servletConfig = this.this$0.getServletConfig();
            Object object = servletContext.getAttribute("_ktor_application_engine_environment_instance");
            if (object != null) {
                Object object2 = object;
                boolean bl2 = false;
                boolean bl3 = false;
                Object it = object2;
                boolean bl4 = false;
                Object object3 = it;
                if (object3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type io.ktor.server.engine.ApplicationEngineEnvironment");
                }
                return (ApplicationEngineEnvironment)object3;
            }
            ServletContext servletContext2 = servletContext;
            Intrinsics.checkNotNullExpressionValue((Object)servletContext2, (String)"servletContext");
            Enumeration enumeration2 = servletContext2.getInitParameterNames();
            if (enumeration2 != null) {
                enumeration = enumeration2;
                bl = false;
                ArrayList<T> arrayList = Collections.list(enumeration);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
                list2 = arrayList;
            } else {
                list2 = null;
            }
            enumeration = list2;
            bl = false;
            Object object4 = enumeration;
            if (object4 == null) {
                object4 = CollectionsKt.emptyList();
            }
            Collection collection = (Collection)object4;
            ServletConfig servletConfig2 = servletConfig;
            Intrinsics.checkNotNullExpressionValue((Object)servletConfig2, (String)"servletConfig");
            Enumeration enumeration3 = servletConfig2.getInitParameterNames();
            if (enumeration3 != null) {
                enumeration = enumeration3;
                bl = false;
                ArrayList<T> arrayList = Collections.list(enumeration);
                Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
                list = arrayList;
            } else {
                list = null;
            }
            enumeration = list;
            bl = false;
            Object object5 = enumeration;
            if (object5 == null) {
                object5 = CollectionsKt.emptyList();
            }
            Iterable $this$filter$iv = CollectionsKt.plus((Collection)collection, (Iterable)((Iterable)object5));
            boolean $i$f$filter = false;
            Iterable it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList<E>();
            boolean $i$f$filterTo22 = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                String it3 = (String)element$iv$iv;
                boolean bl5 = false;
                String string = it3;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it");
                if (!StringsKt.startsWith$default((String)string, (String)"io.ktor", (boolean)false, (int)2, null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List parameterNames = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
            Iterable $this$associateBy$iv = parameterNames;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable $i$f$filterTo22 = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap<K, V>(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (T element$iv$iv : $this$associateByTo$iv$iv) {
                String string = (String)element$iv$iv;
                Map map = destination$iv$iv2;
                boolean bl6 = false;
                void v14 = it2;
                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"it");
                String string2 = StringsKt.removePrefix((String)v14, (CharSequence)"io.ktor.");
                it2 = (String)element$iv$iv;
                boolean bl7 = false;
                String string3 = servletConfig.getInitParameter((String)it2);
                if (string3 == null) {
                    string3 = servletContext.getInitParameter((String)it2);
                }
                String string4 = string3;
                map.put(string2, string4);
            }
            Map parameters = destination$iv$iv2;
            Config hocon = ConfigFactory.parseMap((Map)parameters);
            String configPath = "ktor.config";
            String applicationIdPath = "ktor.application.id";
            if (hocon.hasPath(configPath)) {
                InputStream inputStream = servletContext.getClassLoader().getResourceAsStream(hocon.getString(configPath));
                if (inputStream == null) {
                    throw (Throwable)new ServletException("No config " + hocon.getString(configPath) + " found for the servlet named " + this.this$0.getServletName());
                }
                InputStream configStream = inputStream;
                Object object6 = configStream;
                Charset charset = Charsets.UTF_8;
                boolean it4 = false;
                Object bl7 = object6;
                int n = 0;
                bl7 = new InputStreamReader((InputStream)bl7, charset);
                n = 8192;
                boolean bl8 = false;
                object6 = bl7 instanceof BufferedReader ? (BufferedReader)bl7 : new BufferedReader((Reader)bl7, n);
                boolean bl9 = false;
                it4 = false;
                it2 = null;
                try {
                    BufferedReader it5 = (BufferedReader)object6;
                    boolean bl10 = false;
                    it5 = ConfigFactory.parseReader((Reader)it5);
                }
                catch (Throwable it5) {
                    it2 = it5;
                    throw it5;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object6, (Throwable)it2);
                }
                BufferedReader loadedKtorConfig = it5;
                config = hocon.withFallback((ConfigMergeable)loadedKtorConfig);
            } else {
                config = hocon.withFallback((ConfigMergeable)ConfigFactory.load());
            }
            Config config2 = combinedConfig = config;
            Intrinsics.checkNotNullExpressionValue((Object)config2, (String)"combinedConfig");
            String string = HoconApplicationConfigKt.tryGetString((Config)config2, (String)applicationIdPath);
            if (string == null) {
                string = "Application";
            }
            String applicationId = string;
            ApplicationEngineEnvironment applicationEngineEnvironment = ApplicationEngineEnvironmentKt.applicationEngineEnvironment((Function1)((Function1)new Function1<ApplicationEngineEnvironmentBuilder, Unit>(combinedConfig, applicationId, servletContext){
                final /* synthetic */ Config $combinedConfig;
                final /* synthetic */ String $applicationId;
                final /* synthetic */ ServletContext $servletContext;

                public final void invoke(@NotNull ApplicationEngineEnvironmentBuilder $this$applicationEngineEnvironment) {
                    Intrinsics.checkNotNullParameter((Object)$this$applicationEngineEnvironment, (String)"$receiver");
                    Config config = this.$combinedConfig;
                    Intrinsics.checkNotNullExpressionValue((Object)config, (String)"combinedConfig");
                    $this$applicationEngineEnvironment.setConfig((ApplicationConfig)new HoconApplicationConfig(config));
                    Logger logger = LoggerFactory.getLogger((String)this.$applicationId);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"LoggerFactory.getLogger(applicationId)");
                    $this$applicationEngineEnvironment.setLog(logger);
                    ServletContext servletContext = this.$servletContext;
                    Intrinsics.checkNotNullExpressionValue((Object)servletContext, (String)"servletContext");
                    ClassLoader classLoader = servletContext.getClassLoader();
                    Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"servletContext.classLoader");
                    $this$applicationEngineEnvironment.setClassLoader(classLoader);
                    ServletContext servletContext2 = this.$servletContext;
                    Intrinsics.checkNotNullExpressionValue((Object)servletContext2, (String)"servletContext");
                    String string = servletContext2.getContextPath();
                    if (string == null) {
                        string = "/";
                    }
                    $this$applicationEngineEnvironment.setRootPath(string);
                }
                {
                    this.$combinedConfig = config;
                    this.$applicationId = string;
                    this.$servletContext = servletContext;
                    super(1);
                }
            }));
            boolean bl11 = false;
            boolean bl12 = false;
            ApplicationEngineEnvironment $this$apply = applicationEngineEnvironment;
            boolean bl13 = false;
            $this$apply.getMonitor().subscribe(DefaultApplicationEventsKt.getApplicationStarting(), (Function1)new Function1<Application, Unit>(this){
                final /* synthetic */ environment.2 this$0;
                {
                    this.this$0 = var1_1;
                    super(1);
                }

                public final void invoke(@NotNull Application it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.getReceivePipeline().merge((Pipeline)this.this$0.this$0.getEnginePipeline().getReceivePipeline());
                    it.getSendPipeline().merge((Pipeline)this.this$0.this$0.getEnginePipeline().getSendPipeline());
                    DefaultTransformKt.installDefaultTransformations((ApplicationReceivePipeline)it.getReceivePipeline());
                    DefaultTransformKt.installDefaultTransformations((ApplicationSendPipeline)it.getSendPipeline());
                }
            });
            return applicationEngineEnvironment;
        }
        {
            this.this$0 = servletApplicationEngine;
            super(0);
        }
    }));
    @NotNull
    private final Lazy enginePipeline$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EnginePipeline>(this){
        final /* synthetic */ ServletApplicationEngine this$0;

        @NotNull
        public final EnginePipeline invoke() {
            EnginePipeline enginePipeline2 = DefaultEnginePipelineKt.defaultEnginePipeline((ApplicationEnvironment)((ApplicationEnvironment)ServletApplicationEngine.access$getEnvironment$p(this.this$0)));
            boolean bl = false;
            boolean bl2 = false;
            EnginePipeline it = enginePipeline2;
            boolean bl3 = false;
            BaseApplicationResponse.Companion.setupSendPipeline(it.getSendPipeline());
            return enginePipeline2;
        }
        {
            this.this$0 = servletApplicationEngine;
            super(0);
        }
    }));
    @NotNull
    private final Lazy upgrade$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ServletUpgrade>(this){
        final /* synthetic */ ServletApplicationEngine this$0;

        @NotNull
        public final ServletUpgrade invoke() {
            ServletUpgrade servletUpgrade;
            ServletContext servletContext = this.this$0.getServletContext();
            Intrinsics.checkNotNullExpressionValue((Object)servletContext, (String)"servletContext");
            String string = servletContext.getServerInfo();
            if (string == null || (string = TextKt.toLowerCasePreservingASCIIRules((String)string)) == null) {
                string = "";
            }
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"jetty", (boolean)false, (int)2, null)) {
                servletUpgrade = io.ktor.server.servlet.ServletApplicationEngine$Companion.access$getJettyUpgrade$p(ServletApplicationEngine.Companion);
                if (servletUpgrade == null) {
                    servletUpgrade = DefaultServletUpgrade.INSTANCE;
                }
            } else {
                servletUpgrade = DefaultServletUpgrade.INSTANCE;
            }
            return servletUpgrade;
        }
        {
            this.this$0 = servletApplicationEngine;
            super(0);
        }
    }));
    @NotNull
    public static final String ApplicationEngineEnvironmentAttributeKey = "_ktor_application_engine_environment_instance";
    private static final Lazy jettyUpgrade$delegate;
    @NotNull
    public static final Companion Companion;

    private final ApplicationEngineEnvironment getEnvironment() {
        Lazy lazy = this.environment$delegate;
        ServletApplicationEngine servletApplicationEngine = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ApplicationEngineEnvironment)lazy.getValue();
    }

    @Override
    @NotNull
    protected Application getApplication() {
        return this.getEnvironment().getApplication();
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        return this.getEnvironment().getLog();
    }

    @Override
    @NotNull
    protected EnginePipeline getEnginePipeline() {
        Lazy lazy = this.enginePipeline$delegate;
        ServletApplicationEngine servletApplicationEngine = this;
        Object var3_3 = null;
        boolean bl = false;
        return (EnginePipeline)lazy.getValue();
    }

    @Override
    @NotNull
    protected ServletUpgrade getUpgrade() {
        Lazy lazy = this.upgrade$delegate;
        ServletApplicationEngine servletApplicationEngine = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ServletUpgrade)lazy.getValue();
    }

    @Override
    @NotNull
    public CoroutineContext getCoroutineContext() {
        return super.getCoroutineContext().plus(this.getEnvironment().getParentCoroutineContext());
    }

    @Override
    public void init() {
        this.getEnvironment().start();
        super.init();
    }

    @Override
    public void destroy() {
        this.getEnvironment().getMonitor().raise(DefaultApplicationEventsKt.getApplicationStopPreparing(), (Object)this.getEnvironment());
        super.destroy();
        this.getEnvironment().stop();
    }

    static {
        Companion = new Companion(null);
        jettyUpgrade$delegate = LazyKt.lazy((Function0)Companion.jettyUpgrade.2.INSTANCE);
    }

    public static final /* synthetic */ ApplicationEngineEnvironment access$getEnvironment$p(ServletApplicationEngine $this) {
        return $this.getEnvironment();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u001d\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lio/ktor/server/servlet/ServletApplicationEngine$Companion;", "", "()V", "ApplicationEngineEnvironmentAttributeKey", "", "getApplicationEngineEnvironmentAttributeKey$annotations", "jettyUpgrade", "Lio/ktor/server/servlet/ServletUpgrade;", "getJettyUpgrade", "()Lio/ktor/server/servlet/ServletUpgrade;", "jettyUpgrade$delegate", "Lkotlin/Lazy;", "ktor-server-servlet"})
    public static final class Companion {
        @EngineAPI
        public static /* synthetic */ void getApplicationEngineEnvironmentAttributeKey$annotations() {
        }

        private final ServletUpgrade getJettyUpgrade() {
            Lazy lazy = jettyUpgrade$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (ServletUpgrade)lazy.getValue();
        }

        private Companion() {
        }

        public static final /* synthetic */ ServletUpgrade access$getJettyUpgrade$p(Companion $this) {
            return $this.getJettyUpgrade();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

