/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty.cio;

import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.util.internal.LockFreeLinkedListNode;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.channels.SendChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lio/ktor/server/netty/cio/NettyRequestQueue;", "", "readLimit", "", "runningLimit", "(II)V", "elements", "Lkotlinx/coroutines/channels/ReceiveChannel;", "Lio/ktor/server/netty/cio/NettyRequestQueue$CallElement;", "getElements", "()Lkotlinx/coroutines/channels/ReceiveChannel;", "incomingQueue", "Lkotlinx/coroutines/channels/Channel;", "getReadLimit$ktor_server_netty", "()I", "getRunningLimit$ktor_server_netty", "canRequestMoreEvents", "", "cancel", "", "close", "schedule", "call", "Lio/ktor/server/netty/NettyApplicationCall;", "CallElement", "ktor-server-netty"})
public final class NettyRequestQueue {
    private final Channel<CallElement> incomingQueue;
    @NotNull
    private final ReceiveChannel<CallElement> elements;
    private final int readLimit;
    private final int runningLimit;

    @NotNull
    public final ReceiveChannel<CallElement> getElements() {
        return this.elements;
    }

    public final void schedule(@NotNull NettyApplicationCall call) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)call), (String)"call");
        CallElement element = new CallElement(call);
        try {
            this.incomingQueue.offer((Object)element);
        }
        catch (Throwable t) {
            element.tryDispose();
        }
    }

    public final void close() {
        SendChannel.DefaultImpls.close$default(this.incomingQueue, null, (int)1, null);
    }

    public final void cancel() {
        SendChannel.DefaultImpls.close$default(this.incomingQueue, null, (int)1, null);
        while (true) {
            CallElement callElement = (CallElement)((Object)this.incomingQueue.poll());
            if (callElement == null) break;
            callElement.tryDispose();
        }
    }

    public final boolean canRequestMoreEvents() {
        return this.incomingQueue.isEmpty();
    }

    public final int getReadLimit$ktor_server_netty() {
        return this.readLimit;
    }

    public final int getRunningLimit$ktor_server_netty() {
        return this.runningLimit;
    }

    public NettyRequestQueue(int readLimit, int runningLimit) {
        this.readLimit = readLimit;
        this.runningLimit = runningLimit;
        boolean bl = this.readLimit > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "readLimit should be positive: " + this.readLimit;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = this.runningLimit > 0;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "executeLimit should be positive: " + this.runningLimit;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        this.incomingQueue = ChannelKt.Channel((int)Integer.MAX_VALUE);
        this.elements = (ReceiveChannel)this.incomingQueue;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\b\u0000\u0018\u00002\u00020\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0019\u0010\u0002\u001a\u00020\u00018\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0002\u0010\u000b\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00020\u00058F@\u0006\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0007R\u0016\u0010\u0010\u001a\u00020\u000f8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lio/ktor/server/netty/cio/NettyRequestQueue$CallElement;", "Lio/ktor/server/netty/NettyApplicationCall;", "call", "<init>", "(Lio/ktor/server/netty/NettyApplicationCall;)V", "", "ensureRunning", "()Z", "", "tryDispose", "()V", "Lio/ktor/server/netty/NettyApplicationCall;", "getCall", "()Lio/ktor/server/netty/NettyApplicationCall;", "isCompleted", "Lkotlinx/coroutines/Job;", "message", "Lkotlinx/coroutines/Job;", "ktor-server-netty", "Lio/ktor/util/internal/LockFreeLinkedListNode;"})
    public static final class CallElement
    extends LockFreeLinkedListNode {
        private volatile int scheduled;
        private static final AtomicIntegerFieldUpdater scheduled$FU = AtomicIntegerFieldUpdater.newUpdater(CallElement.class, "scheduled");
        private final Job message;
        @NotNull
        private final NettyApplicationCall call;

        public final boolean isCompleted() {
            return this.message.isCompleted();
        }

        public final boolean ensureRunning() {
            int upd$iv;
            int cur$iv;
            CallElement $this$update$iv = this;
            boolean $i$f$update = false;
            do {
                int value = cur$iv = $this$update$iv.scheduled;
                boolean bl = false;
                switch (value) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
            } while (!scheduled$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = 1));
            this.call.getContext().fireChannelRead((Object)this.call);
            return true;
        }

        public final void tryDispose() {
            if (scheduled$FU.compareAndSet(this, 0, 2)) {
                this.call.dispose$ktor_server_netty();
            }
        }

        @NotNull
        public final NettyApplicationCall getCall() {
            return this.call;
        }

        public CallElement(@NotNull NettyApplicationCall call) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)call), (String)"call");
            this.call = call;
            this.scheduled = 0;
            this.message = (Job)this.call.getResponse().getResponseMessage();
        }
    }
}

