/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.jetty;

import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ConnectorType;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"initializeServer", "", "Lorg/eclipse/jetty/server/Server;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "ktor-server-jetty"})
public final class ServerInitializerKt {
    /*
     * WARNING - void declaration
     */
    public static final void initializeServer(@NotNull Server $this$initializeServer, @NotNull ApplicationEngineEnvironment environment) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$initializeServer, (String)"$this$initializeServer");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Iterable $this$map$iv = environment.getConnectors();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AbstractConnectionFactory[] abstractConnectionFactoryArray;
            boolean bl;
            boolean bl2;
            void ktorConnector;
            EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            HttpConfiguration httpConfiguration = new HttpConfiguration();
            boolean bl4 = false;
            boolean bl5 = false;
            HttpConfiguration $this$apply = httpConfiguration;
            boolean bl6 = false;
            $this$apply.setSendServerVersion(false);
            $this$apply.setSendDateHeader(false);
            if (Intrinsics.areEqual((Object)ktorConnector.getType(), (Object)ConnectorType.Companion.getHTTPS())) {
                $this$apply.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            }
            HttpConfiguration httpConfig = httpConfiguration;
            boolean alpnAvailable = false;
            ALPNServerConnectionFactory alpnConnectionFactory = null;
            HTTP2ServerConnectionFactory http2ConnectionFactory = null;
            try {
                $this$apply = new ALPNServerConnectionFactory(new String[0]);
                boolean bl7 = false;
                bl2 = false;
                HttpConfiguration $this$apply2 = $this$apply;
                bl = false;
                $this$apply2.setDefaultProtocol(HttpVersion.HTTP_1_1.asString());
                alpnConnectionFactory = $this$apply;
                http2ConnectionFactory = new HTTP2ServerConnectionFactory(httpConfig);
                alpnAvailable = true;
            }
            catch (Throwable t) {
                alpnConnectionFactory = null;
                http2ConnectionFactory = null;
            }
            ConnectorType connectorType = ktorConnector.getType();
            if (Intrinsics.areEqual((Object)connectorType, (Object)ConnectorType.Companion.getHTTP())) {
                AbstractConnectionFactory[] abstractConnectionFactoryArray2 = new AbstractConnectionFactory[2];
                abstractConnectionFactoryArray2[0] = (AbstractConnectionFactory)new HttpConnectionFactory(httpConfig);
                abstractConnectionFactoryArray = abstractConnectionFactoryArray2;
                abstractConnectionFactoryArray2[1] = (AbstractConnectionFactory)new HTTP2CServerConnectionFactory(httpConfig);
            } else if (Intrinsics.areEqual((Object)connectorType, (Object)ConnectorType.Companion.getHTTPS())) {
                Object[] objectArray;
                SslContextFactory sslContextFactory = new SslContextFactory();
                int n = 0;
                Object[] objectArray2 = objectArray = new AbstractConnectionFactory[4];
                boolean $this$apply2 = false;
                bl = false;
                SslContextFactory $this$apply3 = sslContextFactory;
                boolean bl8 = false;
                if (alpnAvailable) {
                    $this$apply3.setCipherComparator(HTTP2Cipher.COMPARATOR);
                    $this$apply3.setUseCipherSuitesOrder(true);
                }
                void v2 = ktorConnector;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.ktor.server.engine.EngineSSLConnectorConfig");
                }
                $this$apply3.setKeyStore(((EngineSSLConnectorConfig)v2).getKeyStore());
                char[] cArray = (char[])((EngineSSLConnectorConfig)ktorConnector).getPrivateKeyPassword().invoke();
                SslContextFactory sslContextFactory2 = $this$apply3;
                boolean bl9 = false;
                String string = new String(cArray);
                sslContextFactory2.setKeyManagerPassword(string);
                cArray = (char[])((EngineSSLConnectorConfig)ktorConnector).getKeyStorePassword().invoke();
                sslContextFactory2 = $this$apply3;
                bl9 = false;
                string = new String(cArray);
                sslContextFactory2.setKeyStorePassword(string);
                $this$apply3.setExcludeCipherSuites(new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"});
                SslContextFactory sslContextFactory3 = sslContextFactory;
                String string2 = alpnAvailable ? "alpn" : HttpVersion.HTTP_1_1.asString();
                SslContextFactory sslContextFactory4 = sslContextFactory3;
                objectArray[n] = (AbstractConnectionFactory)new SslConnectionFactory(sslContextFactory4, string2);
                Object[] objectArray3 = objectArray2;
                objectArray2[1] = (AbstractConnectionFactory)alpnConnectionFactory;
                HTTP2ServerConnectionFactory hTTP2ServerConnectionFactory = http2ConnectionFactory;
                objectArray3[2] = hTTP2ServerConnectionFactory != null ? (AbstractConnectionFactory)hTTP2ServerConnectionFactory : (AbstractConnectionFactory)new HTTP2CServerConnectionFactory(httpConfig);
                objectArray3[3] = (AbstractConnectionFactory)new HttpConnectionFactory(httpConfig);
                Collection $this$toTypedArray$iv = ArraysKt.filterNotNull((Object[])objectArray3);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                AbstractConnectionFactory[] abstractConnectionFactoryArray3 = thisCollection$iv.toArray(new AbstractConnectionFactory[0]);
                if (abstractConnectionFactoryArray3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                abstractConnectionFactoryArray = abstractConnectionFactoryArray3;
            } else {
                throw (Throwable)new IllegalArgumentException("Connector type " + ktorConnector.getType() + " is not supported by Jetty engine implementation");
            }
            AbstractConnectionFactory[] connectionFactories = abstractConnectionFactoryArray;
            ConnectionFactory[] connectionFactoryArray = (ConnectionFactory[])connectionFactories;
            connectorType = new ServerConnector($this$initializeServer, Arrays.copyOf(connectionFactoryArray, connectionFactoryArray.length));
            bl2 = false;
            boolean bl10 = false;
            ConnectorType $this$apply4 = connectorType;
            boolean bl11 = false;
            $this$apply4.setHost(ktorConnector.getHost());
            $this$apply4.setPort(ktorConnector.getPort());
            ConnectorType connectorType2 = connectorType;
            collection.add(connectorType2);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerConnector it = (ServerConnector)element$iv;
            boolean bl = false;
            $this$initializeServer.addConnector((Connector)it);
        }
    }
}

