/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.jetty;

import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ConnectorType;
import io.ktor.server.engine.EngineConnectorConfig;
import io.ktor.server.engine.EngineSSLConnectorConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.alpn.server.ALPNServerConnectionFactory;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnectionFactory;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\u0005"}, d2={"initializeServer", "", "Lorg/eclipse/jetty/server/Server;", "environment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "ktor-server-jetty"})
public final class ServerInitializerKt {
    /*
     * WARNING - void declaration
     */
    public static final void initializeServer(@NotNull Server $receiver, @NotNull ApplicationEngineEnvironment environment) {
        ServerConnector[] serverConnectorArray;
        void $receiver$iv$iv;
        Collection $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Iterable iterable = environment.getConnectors();
        Server server = $receiver;
        void var3_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            AbstractConnectionFactory[] abstractConnectionFactoryArray;
            HTTP2ServerConnectionFactory http2ConnectionFactory;
            ALPNServerConnectionFactory alpnConnectionFactory;
            void ktorConnector;
            HttpConfiguration httpConfiguration;
            EngineConnectorConfig engineConnectorConfig = (EngineConnectorConfig)item$iv$iv;
            serverConnectorArray = destination$iv$iv;
            HttpConfiguration $receiver2 = httpConfiguration = new HttpConfiguration();
            $receiver2.setSendServerVersion(false);
            $receiver2.setSendDateHeader(false);
            if (Intrinsics.areEqual((Object)ktorConnector.getType(), (Object)ConnectorType.Companion.getHTTPS())) {
                $receiver2.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            }
            HttpConfiguration httpConfig = httpConfiguration;
            boolean alpnAvailable = false;
            try {
                ALPNServerConnectionFactory aLPNServerConnectionFactory;
                ALPNServerConnectionFactory $receiver3 = aLPNServerConnectionFactory = new ALPNServerConnectionFactory(new String[0]);
                $receiver3.setDefaultProtocol(HttpVersion.HTTP_1_1.asString());
                alpnConnectionFactory = aLPNServerConnectionFactory;
                http2ConnectionFactory = new HTTP2ServerConnectionFactory(httpConfig);
                alpnAvailable = true;
            }
            catch (Throwable t) {
                alpnConnectionFactory = null;
                http2ConnectionFactory = null;
            }
            ConnectorType connectorType = ktorConnector.getType();
            if (Intrinsics.areEqual((Object)connectorType, (Object)ConnectorType.Companion.getHTTP())) {
                AbstractConnectionFactory[] abstractConnectionFactoryArray2 = new AbstractConnectionFactory[2];
                abstractConnectionFactoryArray2[0] = (AbstractConnectionFactory)new HttpConnectionFactory(httpConfig);
                abstractConnectionFactoryArray = abstractConnectionFactoryArray2;
                abstractConnectionFactoryArray2[1] = (AbstractConnectionFactory)new HTTP2CServerConnectionFactory(httpConfig);
            } else if (Intrinsics.areEqual((Object)connectorType, (Object)ConnectorType.Companion.getHTTPS())) {
                Collection thisCollection$iv;
                Object[] objectArray;
                SslContextFactory $i$a$1$apply = new SslContextFactory();
                int n = 0;
                Object[] objectArray2 = objectArray = new AbstractConnectionFactory[4];
                SslContextFactory $receiver4 = $i$a$1$apply;
                if (alpnAvailable) {
                    $receiver4.setCipherComparator(HTTP2Cipher.COMPARATOR);
                    $receiver4.setUseCipherSuitesOrder(true);
                }
                void v2 = ktorConnector;
                if (v2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type io.ktor.server.engine.EngineSSLConnectorConfig");
                }
                $receiver4.setKeyStore(((EngineSSLConnectorConfig)v2).getKeyStore());
                char[] cArray = (char[])((EngineSSLConnectorConfig)ktorConnector).getPrivateKeyPassword().invoke();
                SslContextFactory sslContextFactory = $receiver4;
                String string = new String(cArray);
                sslContextFactory.setKeyManagerPassword(string);
                cArray = (char[])((EngineSSLConnectorConfig)ktorConnector).getKeyStorePassword().invoke();
                sslContextFactory = $receiver4;
                string = new String(cArray);
                sslContextFactory.setKeyStorePassword(string);
                $receiver4.setExcludeCipherSuites(new String[]{"SSL_RSA_WITH_DES_CBC_SHA", "SSL_DHE_RSA_WITH_DES_CBC_SHA", "SSL_DHE_DSS_WITH_DES_CBC_SHA", "SSL_RSA_EXPORT_WITH_RC4_40_MD5", "SSL_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA", "SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA"});
                SslContextFactory sslContextFactory2 = $i$a$1$apply;
                String string2 = alpnAvailable ? "alpn" : HttpVersion.HTTP_1_1.asString();
                SslContextFactory sslContextFactory3 = sslContextFactory2;
                objectArray[n] = (AbstractConnectionFactory)new SslConnectionFactory(sslContextFactory3, string2);
                Object[] objectArray3 = objectArray2;
                objectArray2[1] = (AbstractConnectionFactory)alpnConnectionFactory;
                HTTP2ServerConnectionFactory hTTP2ServerConnectionFactory = http2ConnectionFactory;
                objectArray3[2] = hTTP2ServerConnectionFactory != null ? (AbstractConnectionFactory)hTTP2ServerConnectionFactory : (AbstractConnectionFactory)new HTTP2CServerConnectionFactory(httpConfig);
                objectArray3[3] = (AbstractConnectionFactory)new HttpConnectionFactory(httpConfig);
                Collection $receiver$iv2 = ArraysKt.filterNotNull((Object[])objectArray3);
                if ($receiver$iv2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                AbstractConnectionFactory[] abstractConnectionFactoryArray3 = thisCollection$iv.toArray(new AbstractConnectionFactory[0]);
                if (abstractConnectionFactoryArray3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                abstractConnectionFactoryArray = abstractConnectionFactoryArray3;
            } else {
                throw (Throwable)new IllegalArgumentException("Connector type " + ktorConnector.getType() + " is not supported by Jetty engine implementation");
            }
            AbstractConnectionFactory[] connectionFactories = abstractConnectionFactoryArray;
            ConnectionFactory[] connectionFactoryArray = (ConnectionFactory[])connectionFactories;
            ConnectorType $receiver5 = connectorType = new ServerConnector($receiver, Arrays.copyOf(connectionFactoryArray, connectionFactoryArray.length));
            $receiver5.setHost(ktorConnector.getHost());
            $receiver5.setPort(ktorConnector.getPort());
            ConnectorType connectorType2 = connectorType;
            serverConnectorArray.add(connectorType2);
        }
        serverConnectorArray = (List)destination$iv$iv;
        Collection thisCollection$iv = $receiver$iv = (Collection)serverConnectorArray;
        ServerConnector[] serverConnectorArray2 = thisCollection$iv.toArray(new ServerConnector[0]);
        if (serverConnectorArray2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        serverConnectorArray = serverConnectorArray2;
        server.setConnectors((Connector[])serverConnectorArray);
    }
}

