/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.application.Application;
import io.ktor.application.ApplicationCall;
import io.ktor.features.OriginConnectionPointKt;
import io.ktor.http.ContentType;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.LinkHeaderKt;
import io.ktor.http.content.OutgoingContent;
import io.ktor.request.ApplicationRequest;
import io.ktor.response.ApplicationResponse;
import io.ktor.response.ApplicationResponsePropertiesKt;
import io.ktor.response.ApplicationSendPipeline;
import io.ktor.response.ResponseCookies;
import io.ktor.response.ResponseHeaders;
import io.ktor.response.ResponsePushBuilder;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.engine.EngineAPI;
import io.ktor.server.engine.LongKt;
import io.ktor.util.AttributeKey;
import io.ktor.util.cio.ByteBufferPoolKt;
import io.ktor.util.cio.ChannelWriteException;
import io.ktor.util.cio.ReadersKt;
import io.ktor.util.pipeline.Pipeline;
import io.ktor.util.pipeline.PipelineContext;
import java.nio.ByteBuffer;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.io.ByteReadChannel;
import kotlinx.coroutines.io.ByteReadChannelJVMKt;
import kotlinx.coroutines.io.ByteWriteChannel;
import kotlinx.coroutines.io.ByteWriteChannelKt;
import kotlinx.coroutines.io.ClosedWriteChannelException;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 B2\u00020\u0001:\u0005@ABCDB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0004J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0016J\u0019\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0019\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u0019\u0010-\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020.H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010/J\u0019\u00100\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\u0019\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u000204H\u00a4@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J\u0019\u00106\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u000207H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J\u0011\u00109\u001a\u00020:H\u00a4@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010;J\u0010\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u0006H$J\n\u0010>\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010>\u001a\u00020\u001b2\u0006\u0010?\u001a\u00020\u0006H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006E"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse;", "Lio/ktor/response/ApplicationResponse;", "call", "Lio/ktor/application/ApplicationCall;", "(Lio/ktor/application/ApplicationCall;)V", "_status", "Lio/ktor/http/HttpStatusCode;", "bufferPool", "Lkotlinx/io/pool/ObjectPool;", "Ljava/nio/ByteBuffer;", "getBufferPool", "()Lkotlinx/io/pool/ObjectPool;", "getCall", "()Lio/ktor/application/ApplicationCall;", "cookies", "Lio/ktor/response/ResponseCookies;", "getCookies", "()Lio/ktor/response/ResponseCookies;", "cookies$delegate", "Lkotlin/Lazy;", "pipeline", "Lio/ktor/response/ApplicationSendPipeline;", "getPipeline", "()Lio/ktor/response/ApplicationSendPipeline;", "responded", "", "commitHeaders", "", "content", "Lio/ktor/http/content/OutgoingContent;", "ensureLength", "expected", "", "actual", "push", "builder", "Lio/ktor/response/ResponsePushBuilder;", "respondFromBytes", "bytes", "", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondFromChannel", "readChannel", "Lkotlinx/coroutines/io/ByteReadChannel;", "(Lkotlinx/coroutines/io/ByteReadChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondNoContent", "Lio/ktor/http/content/OutgoingContent$NoContent;", "(Lio/ktor/http/content/OutgoingContent$NoContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondOutgoingContent", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondUpgrade", "upgrade", "Lio/ktor/http/content/OutgoingContent$ProtocolUpgrade;", "(Lio/ktor/http/content/OutgoingContent$ProtocolUpgrade;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondWriteChannelContent", "Lio/ktor/http/content/OutgoingContent$WriteChannelContent;", "(Lio/ktor/http/content/OutgoingContent$WriteChannelContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "responseChannel", "Lkotlinx/coroutines/io/ByteWriteChannel;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setStatus", "statusCode", "status", "value", "BodyLengthIsTooLong", "BodyLengthIsTooSmall", "Companion", "InvalidHeaderForContent", "ResponseAlreadySentException", "ktor-server-host-common"})
public abstract class BaseApplicationResponse
implements ApplicationResponse {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private HttpStatusCode _status;
    @NotNull
    private final Lazy cookies$delegate;
    private boolean responded;
    @NotNull
    private final ApplicationSendPipeline pipeline;
    @NotNull
    private final ApplicationCall call;
    @NotNull
    private static final AttributeKey<BaseApplicationResponse> EngineResponseAtributeKey;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(BaseApplicationResponse.class), "cookies", "getCookies()Lio/ktor/response/ResponseCookies;"))};
        Companion = new Companion(null);
        EngineResponseAtributeKey = new AttributeKey("EngineResponse");
    }

    @NotNull
    public ResponseCookies getCookies() {
        Lazy lazy = this.cookies$delegate;
        BaseApplicationResponse baseApplicationResponse = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (ResponseCookies)lazy.getValue();
    }

    @Nullable
    public HttpStatusCode status() {
        return this._status;
    }

    public void status(@NotNull HttpStatusCode value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this._status = value;
        this.setStatus(value);
    }

    @NotNull
    public final ApplicationSendPipeline getPipeline() {
        return this.pipeline;
    }

    /*
     * WARNING - void declaration
     */
    protected final void commitHeaders(@NotNull OutgoingContent content) {
        void transferEncodingSet;
        HttpStatusCode httpStatusCode;
        HttpStatusCode httpStatusCode2;
        HttpStatusCode it;
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        if (this.responded) {
            throw (Throwable)new ResponseAlreadySentException();
        }
        this.responded = true;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        HttpStatusCode httpStatusCode3 = content.getStatus();
        if (httpStatusCode3 != null) {
            HttpStatusCode httpStatusCode4;
            it = httpStatusCode4 = httpStatusCode3;
            this.status(it);
            httpStatusCode2 = Unit.INSTANCE;
        } else {
            httpStatusCode2 = httpStatusCode = this.status();
        }
        if (httpStatusCode2 == null) {
            this.status(HttpStatusCode.Companion.getOK());
            httpStatusCode = Unit.INSTANCE;
        }
        content.getHeaders().forEach((Function2)new Function2<String, List<? extends String>, Unit>(this, (Ref.BooleanRef)transferEncodingSet, content){
            final /* synthetic */ BaseApplicationResponse this$0;
            final /* synthetic */ Ref.BooleanRef $transferEncodingSet;
            final /* synthetic */ OutgoingContent $content;

            public final void invoke(@NotNull String name, @NotNull List<String> values) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                Intrinsics.checkParameterIsNotNull(values, (String)"values");
                String string = name;
                if (Intrinsics.areEqual((Object)string, (Object)HttpHeaders.INSTANCE.getTransferEncoding())) {
                    this.$transferEncodingSet.element = true;
                } else if (Intrinsics.areEqual((Object)string, (Object)HttpHeaders.INSTANCE.getUpgrade())) {
                    if (!(this.$content instanceof OutgoingContent.ProtocolUpgrade)) {
                        throw (Throwable)new InvalidHeaderForContent(HttpHeaders.INSTANCE.getUpgrade(), "non-upgrading response");
                    }
                    for (String value : values) {
                        this.this$0.getHeaders().append(name, value, false);
                    }
                    return;
                }
                for (String value : values) {
                    ResponseHeaders.append$default((ResponseHeaders)this.this$0.getHeaders(), (String)name, (String)value, (boolean)false, (int)4, null);
                }
            }
            {
                this.this$0 = baseApplicationResponse;
                this.$transferEncodingSet = booleanRef;
                this.$content = outgoingContent;
                super(2);
            }
        });
        Long contentLength = content.getContentLength();
        if (contentLength != null) {
            this.getHeaders().append(HttpHeaders.INSTANCE.getContentLength(), LongKt.toStringFast(contentLength), false);
        } else if (!transferEncodingSet.element && !((it = content) instanceof OutgoingContent.ProtocolUpgrade)) {
            if (it instanceof OutgoingContent.NoContent) {
                this.getHeaders().append(HttpHeaders.INSTANCE.getContentLength(), "0", false);
            } else {
                this.getHeaders().append(HttpHeaders.INSTANCE.getTransferEncoding(), "chunked", false);
            }
        }
        ContentType contentType = content.getContentType();
        if (contentType != null) {
            HttpStatusCode it2 = it = contentType;
            this.getHeaders().append(HttpHeaders.INSTANCE.getContentType(), it2.toString(), false);
        }
        String connection = this.getCall().getRequest().getHeaders().get(HttpHeaders.INSTANCE.getConnection());
        if (connection != null) {
            if (StringsKt.equals((String)connection, (String)"close", (boolean)true)) {
                ApplicationResponsePropertiesKt.header((ApplicationResponse)this, (String)"Connection", (String)"close");
            } else if (StringsKt.equals((String)connection, (String)"keep-alive", (boolean)true)) {
                ApplicationResponsePropertiesKt.header((ApplicationResponse)this, (String)"Connection", (String)"keep-alive");
            }
        }
    }

    @Nullable
    protected Object respondOutgoingContent(@NotNull OutgoingContent outgoingContent, @NotNull Continuation<? super Unit> continuation) {
        return BaseApplicationResponse.respondOutgoingContent$suspendImpl(this, outgoingContent, continuation);
    }

    static /* synthetic */ Object respondOutgoingContent$suspendImpl(BaseApplicationResponse this_, OutgoingContent content, Continuation continuation) {
        OutgoingContent outgoingContent = content;
        if (outgoingContent instanceof OutgoingContent.ProtocolUpgrade) {
            this_.commitHeaders(content);
            return this_.respondUpgrade((OutgoingContent.ProtocolUpgrade)content, (Continuation<? super Unit>)continuation);
        }
        if (outgoingContent instanceof OutgoingContent.ByteArrayContent) {
            byte[] bytes = ((OutgoingContent.ByteArrayContent)content).bytes();
            this_.commitHeaders(content);
            return this_.respondFromBytes(bytes, (Continuation<? super Unit>)continuation);
        }
        if (outgoingContent instanceof OutgoingContent.WriteChannelContent) {
            this_.commitHeaders(content);
            return this_.respondWriteChannelContent((OutgoingContent.WriteChannelContent)content, (Continuation<? super Unit>)continuation);
        }
        if (outgoingContent instanceof OutgoingContent.ReadChannelContent) {
            ByteReadChannel readChannel = ((OutgoingContent.ReadChannelContent)content).readFrom();
            this_.commitHeaders(content);
            return this_.respondFromChannel(readChannel, (Continuation<? super Unit>)continuation);
        }
        if (outgoingContent instanceof OutgoingContent.NoContent) {
            this_.commitHeaders(content);
            return this_.respondNoContent((OutgoingContent.NoContent)content, (Continuation<? super Unit>)continuation);
        }
        throw new NoWhenBranchMatchedException();
    }

    @Nullable
    protected Object respondNoContent(@NotNull OutgoingContent.NoContent noContent, @NotNull Continuation<? super Unit> continuation) {
        return BaseApplicationResponse.respondNoContent$suspendImpl(this, noContent, continuation);
    }

    static /* synthetic */ Object respondNoContent$suspendImpl(BaseApplicationResponse this_, OutgoingContent.NoContent content, Continuation continuation) {
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object respondWriteChannelContent(@NotNull OutgoingContent.WriteChannelContent writeChannelContent, @NotNull Continuation<? super Unit> continuation) {
        return BaseApplicationResponse.respondWriteChannelContent$suspendImpl(this, writeChannelContent, continuation);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondWriteChannelContent$suspendImpl(BaseApplicationResponse this, OutgoingContent.WriteChannelContent content, Continuation var2_2) {
        if (!(var2_2 instanceof respondWriteChannelContent.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ BaseApplicationResponse this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object result) {
                    this.result = result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondWriteChannelContent$suspendImpl(this.this$0, null, (Continuation)this);
                }
                {
                    this.this$0 = baseApplicationResponse;
                    super(continuation);
                }
            };
        }
        var3_4 = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                v0 = var3_4;
                if (v0 instanceof Result.Failure) {
                    throw ((Result.Failure)v0).exception;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = content;
                $continuation.label = 1;
                v1 = this.responseChannel((Continuation<? super ByteWriteChannel>)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                content = (OutgoingContent.WriteChannelContent)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                v2 = var3_4;
                if (v2 instanceof Result.Failure) {
                    throw ((Result.Failure)v2).exception;
                }
                v1 = var3_4;
lbl28:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = content;
                $continuation.label = 2;
                v3 = ReadersKt.use((ByteWriteChannel)((ByteWriteChannel)v1), (Function2)((Function2)new Function2<ByteWriteChannel, Continuation<? super Unit>, Object>(content, null){
                    private ByteWriteChannel p$;
                    int label;
                    final /* synthetic */ OutgoingContent.WriteChannelContent $content;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Object object2 = result;
                                if (object2 instanceof Result.Failure) {
                                    throw ((Result.Failure)object2).exception;
                                }
                                ByteWriteChannel byteWriteChannel = this.p$;
                                this.label = 1;
                                Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, byteWriteChannel, null){
                                    private CoroutineScope p$;
                                    int label;
                                    final /* synthetic */ respondWriteChannelContent.2 this$0;
                                    final /* synthetic */ ByteWriteChannel $receiver$0;

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                Object object2 = result;
                                                if (object2 instanceof Result.Failure) {
                                                    throw ((Result.Failure)object2).exception;
                                                }
                                                CoroutineScope coroutineScope = this.p$;
                                                this.label = 1;
                                                Object object3 = this.this$0.$content.writeTo(this.$receiver$0, (Continuation)this);
                                                if (object3 != object) return Unit.INSTANCE;
                                                return object;
                                            }
                                            case 1: {
                                                Object object4 = result;
                                                if (object4 instanceof Result.Failure) {
                                                    throw ((Result.Failure)object4).exception;
                                                }
                                                Object object3 = result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$receiver$0 = byteWriteChannel;
                                        super(2, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                        return function2;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)this);
                                if (object3 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                Object object3;
                                try {
                                    Object object4 = result;
                                    if (object4 instanceof Result.Failure) {
                                        throw ((Result.Failure)object4).exception;
                                    }
                                    object3 = result;
                                    return Unit.INSTANCE;
                                }
                                catch (ClosedWriteChannelException closed) {
                                    throw (Throwable)new ChannelWriteException(null, (Throwable)closed, 1, null);
                                }
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.$content = writeChannelContent;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                        Function2<ByteWriteChannel, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        ByteWriteChannel byteWriteChannel = function2.p$ = (ByteWriteChannel)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v3 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl42
            }
            case 2: {
                content = (OutgoingContent.WriteChannelContent)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                v4 = var3_4;
                if (v4 instanceof Result.Failure) {
                    throw ((Result.Failure)v4).exception;
                }
                v3 = var3_4;
lbl42:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondFromBytes(@NotNull byte[] byArray, @NotNull Continuation<? super Unit> continuation) {
        return BaseApplicationResponse.respondFromBytes$suspendImpl(this, byArray, continuation);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondFromBytes$suspendImpl(BaseApplicationResponse this, byte[] bytes, Continuation var2_2) {
        if (!(var2_2 instanceof respondFromBytes.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ BaseApplicationResponse this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object result) {
                    this.result = result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondFromBytes$suspendImpl(this.this$0, null, (Continuation)this);
                }
                {
                    this.this$0 = baseApplicationResponse;
                    super(continuation);
                }
            };
        }
        var7_4 = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                v0 = var7_4;
                if (v0 instanceof Result.Failure) {
                    throw ((Result.Failure)v0).exception;
                }
                v1 = this.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
                if (v1 != null && (v1 = Boxing.boxLong((long)Long.parseLong((String)(var3_6 = v1)))) != null) {
                    var3_6 = v1;
                    length = ((Number)var3_6).longValue();
                    this.ensureLength(length, bytes.length);
                }
                $continuation.L$0 = this;
                $continuation.L$1 = bytes;
                $continuation.label = 1;
                v2 = this.responseChannel((Continuation<? super ByteWriteChannel>)$continuation);
                if (v2 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl34
            }
            case 1: {
                bytes = (byte[])$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                v3 = var7_4;
                if (v3 instanceof Result.Failure) {
                    throw ((Result.Failure)v3).exception;
                }
                v2 = var7_4;
lbl34:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = bytes;
                $continuation.label = 2;
                v4 = ReadersKt.use((ByteWriteChannel)((ByteWriteChannel)v2), (Function2)((Function2)new Function2<ByteWriteChannel, Continuation<? super Unit>, Object>(bytes, null){
                    private ByteWriteChannel p$;
                    int label;
                    final /* synthetic */ byte[] $bytes;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Object object2 = result;
                                if (object2 instanceof Result.Failure) {
                                    throw ((Result.Failure)object2).exception;
                                }
                                ByteWriteChannel byteWriteChannel = this.p$;
                                this.label = 1;
                                Object object3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, byteWriteChannel, null){
                                    private CoroutineScope p$;
                                    int label;
                                    final /* synthetic */ respondFromBytes.3 this$0;
                                    final /* synthetic */ ByteWriteChannel $receiver$0;

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                Object object2 = result;
                                                if (object2 instanceof Result.Failure) {
                                                    throw ((Result.Failure)object2).exception;
                                                }
                                                CoroutineScope coroutineScope = this.p$;
                                                this.label = 1;
                                                Object object3 = ByteWriteChannelKt.writeFully((ByteWriteChannel)this.$receiver$0, (byte[])this.this$0.$bytes, (Continuation)this);
                                                if (object3 != object) return Unit.INSTANCE;
                                                return object;
                                            }
                                            case 1: {
                                                Object object4 = result;
                                                if (object4 instanceof Result.Failure) {
                                                    throw ((Result.Failure)object4).exception;
                                                }
                                                Object object3 = result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$receiver$0 = byteWriteChannel;
                                        super(2, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                        return function2;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)this);
                                if (object3 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                Object object4 = result;
                                if (object4 instanceof Result.Failure) {
                                    throw ((Result.Failure)object4).exception;
                                }
                                Object object3 = result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.$bytes = byArray;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                        Function2<ByteWriteChannel, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        ByteWriteChannel byteWriteChannel = function2.p$ = (ByteWriteChannel)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v4 == var9_5) {
                    return var9_5;
                }
                ** GOTO lbl48
            }
            case 2: {
                bytes = (byte[])$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                v5 = var7_4;
                if (v5 instanceof Result.Failure) {
                    throw ((Result.Failure)v5).exception;
                }
                v4 = var7_4;
lbl48:
                // 2 sources

                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondFromChannel(@NotNull ByteReadChannel byteReadChannel, @NotNull Continuation<? super Unit> continuation) {
        return BaseApplicationResponse.respondFromChannel$suspendImpl(this, byteReadChannel, continuation);
    }

    /*
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondFromChannel$suspendImpl(BaseApplicationResponse this, ByteReadChannel readChannel, Continuation var2_2) {
        if (!(var2_2 instanceof respondFromChannel.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ BaseApplicationResponse this$0;
                Object L$0;
                Object L$1;

                @Nullable
                public final Object invokeSuspend(@NotNull Object result) {
                    this.result = result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondFromChannel$suspendImpl(this.this$0, null, (Continuation)this);
                }
                {
                    this.this$0 = baseApplicationResponse;
                    super(continuation);
                }
            };
        }
        var3_4 = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                v0 = var3_4;
                if (v0 instanceof Result.Failure) {
                    throw ((Result.Failure)v0).exception;
                }
                $continuation.L$0 = this;
                $continuation.L$1 = readChannel;
                $continuation.label = 1;
                v1 = this.responseChannel((Continuation<? super ByteWriteChannel>)$continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                readChannel = (ByteReadChannel)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                v2 = var3_4;
                if (v2 instanceof Result.Failure) {
                    throw ((Result.Failure)v2).exception;
                }
                v1 = var3_4;
lbl28:
                // 2 sources

                $continuation.L$0 = this;
                $continuation.L$1 = readChannel;
                $continuation.label = 2;
                v3 = ReadersKt.use((ByteWriteChannel)((ByteWriteChannel)v1), (Function2)((Function2)new Function2<ByteWriteChannel, Continuation<? super Unit>, Object>(this, readChannel, null){
                    private ByteWriteChannel p$;
                    Object L$0;
                    long J$0;
                    int label;
                    final /* synthetic */ BaseApplicationResponse this$0;
                    final /* synthetic */ ByteReadChannel $readChannel;

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object result) {
                        var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                v0 = result;
                                if (v0 instanceof Result.Failure) {
                                    throw ((Result.Failure)v0).exception;
                                }
                                var2_3 = this.p$;
                                v1 = this.this$0.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
                                if (v1 != null) {
                                    var4_4 = v1;
                                    v2 = Boxing.boxLong((long)Long.parseLong(var4_4));
                                } else {
                                    v2 = null;
                                }
                                length = v2;
                                this.L$0 = length;
                                this.label = 1;
                                v3 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(this, var2_3, length, null){
                                    private CoroutineScope p$;
                                    int label;
                                    final /* synthetic */ respondFromChannel.2 this$0;
                                    final /* synthetic */ ByteWriteChannel $receiver$0;
                                    final /* synthetic */ Long $length;

                                    /*
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    @Nullable
                                    public final Object invokeSuspend(@NotNull Object result) {
                                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                Object object2 = result;
                                                if (object2 instanceof Result.Failure) {
                                                    throw ((Result.Failure)object2).exception;
                                                }
                                                CoroutineScope coroutineScope = this.p$;
                                                Long l = this.$length;
                                                this.label = 1;
                                                Object object3 = ByteReadChannelJVMKt.copyTo((ByteReadChannel)this.this$0.$readChannel, (ByteWriteChannel)this.$receiver$0, (long)(l != null ? l : Long.MAX_VALUE), (Continuation)this);
                                                if (object3 != object) return object3;
                                                return object;
                                            }
                                            case 1: {
                                                Object object4 = result;
                                                if (object4 instanceof Result.Failure) {
                                                    throw ((Result.Failure)object4).exception;
                                                }
                                                Object object3 = result;
                                                return object3;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$receiver$0 = byteWriteChannel;
                                        this.$length = l;
                                        super(2, continuation);
                                    }

                                    @NotNull
                                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                        Function2<CoroutineScope, Continuation<? super Long>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                        CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                        return function2;
                                    }

                                    public final Object invoke(Object object, Object object2) {
                                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)this);
                                if (v3 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl27
                            }
                            case 1: {
                                length = (Long)this.L$0;
                                v4 = result;
                                if (v4 instanceof Result.Failure) {
                                    throw ((Result.Failure)v4).exception;
                                }
                                v3 = result;
lbl27:
                                // 2 sources

                                copied = ((Number)v3).longValue();
                                v5 = length;
                                if (v5 == null) {
                                    return Unit.INSTANCE;
                                }
                                v5.longValue();
                                this.L$0 = length;
                                this.J$0 = copied;
                                this.label = 2;
                                v6 = this.$readChannel.discard(1L, (Continuation)this);
                                if (v6 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl46
                            }
                            case 2: {
                                copied = this.J$0;
                                length = (Long)this.L$0;
                                v7 = result;
                                if (v7 instanceof Result.Failure) {
                                    throw ((Result.Failure)v7).exception;
                                }
                                v6 = result;
lbl46:
                                // 2 sources

                                discarded = ((Number)v6).longValue();
                                BaseApplicationResponse.access$ensureLength(this.this$0, length, copied + discarded);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = baseApplicationResponse;
                        this.$readChannel = byteReadChannel;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                        Function2<ByteWriteChannel, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        ByteWriteChannel byteWriteChannel = function2.p$ = (ByteWriteChannel)value;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v3 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl42
            }
            case 2: {
                readChannel = (ByteReadChannel)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                v4 = var3_4;
                if (v4 instanceof Result.Failure) {
                    throw ((Result.Failure)v4).exception;
                }
                v3 = var3_4;
lbl42:
                // 2 sources

                return v3;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void ensureLength(long expected, long actual) {
        if (expected < actual) {
            throw (Throwable)new BodyLengthIsTooLong(expected);
        }
        if (expected > actual) {
            throw (Throwable)new BodyLengthIsTooSmall(expected, actual);
        }
    }

    @Nullable
    protected abstract Object respondUpgrade(@NotNull OutgoingContent.ProtocolUpgrade var1, @NotNull Continuation<? super Unit> var2);

    @Nullable
    protected abstract Object responseChannel(@NotNull Continuation<? super ByteWriteChannel> var1);

    @NotNull
    protected ObjectPool<ByteBuffer> getBufferPool() {
        return ByteBufferPoolKt.getKtorDefaultPool();
    }

    protected abstract void setStatus(@NotNull HttpStatusCode var1);

    public void push(@NotNull ResponsePushBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        LinkHeaderKt.link((ApplicationResponse)this, (String)builder.getUrl().buildString(), (String[])new String[]{"prefetch"});
    }

    @NotNull
    public ApplicationCall getCall() {
        return this.call;
    }

    public BaseApplicationResponse(@NotNull ApplicationCall call) {
        ApplicationSendPipeline applicationSendPipeline;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        this.call = call;
        this.cookies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ResponseCookies>(this){
            final /* synthetic */ BaseApplicationResponse this$0;

            @NotNull
            public final ResponseCookies invoke() {
                return new ResponseCookies((ApplicationResponse)this.this$0, Intrinsics.areEqual((Object)OriginConnectionPointKt.getOrigin((ApplicationRequest)this.this$0.getCall().getRequest()).getScheme(), (Object)"https"));
            }
            {
                this.this$0 = baseApplicationResponse;
                super(0);
            }
        }));
        ApplicationSendPipeline applicationSendPipeline2 = new ApplicationSendPipeline();
        BaseApplicationResponse baseApplicationResponse = this;
        ApplicationSendPipeline $receiver = applicationSendPipeline2;
        $receiver.merge((Pipeline)this.getCall().getApplication().getSendPipeline());
        baseApplicationResponse.pipeline = applicationSendPipeline = applicationSendPipeline2;
    }

    public static final /* synthetic */ void access$ensureLength(BaseApplicationResponse $this, long expected, long actual) {
        $this.ensureLength(expected, actual);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$ResponseAlreadySentException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "()V", "ktor-server-host-common"})
    public static final class ResponseAlreadySentException
    extends IllegalStateException {
        public ResponseAlreadySentException() {
            super("Response has already been sent");
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$InvalidHeaderForContent;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "name", "", "content", "(Ljava/lang/String;Ljava/lang/String;)V", "ktor-server-host-common"})
    public static final class InvalidHeaderForContent
    extends IllegalStateException {
        public InvalidHeaderForContent(@NotNull String name, @NotNull String content) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
            super("Header " + name + " is not allowed for " + content);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$BodyLengthIsTooSmall;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "expected", "", "actual", "(JJ)V", "ktor-server-host-common"})
    public static final class BodyLengthIsTooSmall
    extends IllegalStateException {
        public BodyLengthIsTooSmall(long expected, long actual) {
            super("Body.size is too small. Body: " + actual + ", Content-Length: " + expected);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$BodyLengthIsTooLong;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "expected", "", "(J)V", "ktor-server-host-common"})
    public static final class BodyLengthIsTooLong
    extends IllegalStateException {
        public BodyLengthIsTooLong(long expected) {
            super("Body.size is too long. Expected " + expected);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$Companion;", "", "()V", "EngineResponseAtributeKey", "Lio/ktor/util/AttributeKey;", "Lio/ktor/server/engine/BaseApplicationResponse;", "EngineResponseAtributeKey$annotations", "getEngineResponseAtributeKey", "()Lio/ktor/util/AttributeKey;", "setupSendPipeline", "", "application", "Lio/ktor/application/Application;", "ktor-server-host-common"})
    public static final class Companion {
        @EngineAPI
        public static /* synthetic */ void EngineResponseAtributeKey$annotations() {
        }

        @NotNull
        public final AttributeKey<BaseApplicationResponse> getEngineResponseAtributeKey() {
            return EngineResponseAtributeKey;
        }

        @EngineAPI
        public final void setupSendPipeline(@NotNull Application application) {
            Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
            application.getSendPipeline().intercept(ApplicationSendPipeline.Phases.getEngine(), (Function3)new Function3<PipelineContext<Object, ApplicationCall>, Object, Continuation<? super Unit>, Object>(null){
                private PipelineContext p$;
                private Object p$0;
                Object L$0;
                Object L$1;
                int label;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            BaseApplicationResponse baseApplicationResponse;
                            Object object2 = result;
                            if (object2 instanceof Result.Failure) {
                                throw ((Result.Failure)object2).exception;
                            }
                            PipelineContext pipelineContext = this.p$;
                            Object object3 = this.p$0;
                            if (!(object3 instanceof OutgoingContent)) {
                                throw (Throwable)new IllegalArgumentException("Response pipeline couldn't transform '" + object3.getClass() + "' to the OutgoingContent");
                            }
                            PipelineContext $receiver$iv = pipelineContext;
                            ApplicationCall call = (ApplicationCall)$receiver$iv.getContext();
                            ApplicationResponse applicationResponse = call.getResponse();
                            if (!(applicationResponse instanceof BaseApplicationResponse)) {
                                applicationResponse = null;
                            }
                            if ((baseApplicationResponse = (BaseApplicationResponse)applicationResponse) == null) {
                                baseApplicationResponse = (BaseApplicationResponse)call.getAttributes().get(BaseApplicationResponse.Companion.getEngineResponseAtributeKey());
                            }
                            BaseApplicationResponse callResponse = baseApplicationResponse;
                            this.L$0 = call;
                            this.L$1 = callResponse;
                            this.label = 1;
                            Object object4 = callResponse.respondOutgoingContent((OutgoingContent)object3, (Continuation<? super Unit>)this);
                            if (object4 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            BaseApplicationResponse callResponse = (BaseApplicationResponse)this.L$1;
                            ApplicationCall call = (ApplicationCall)this.L$0;
                            Object object5 = result;
                            if (object5 instanceof Result.Failure) {
                                throw ((Result.Failure)object5).exception;
                            }
                            Object object4 = result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@NotNull PipelineContext<Object, ApplicationCall> $receiver, @NotNull Object response, @NotNull Continuation<? super Unit> continuation) {
                    Intrinsics.checkParameterIsNotNull($receiver, (String)"receiver$0");
                    Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                    Intrinsics.checkParameterIsNotNull(continuation, (String)"continuation");
                    Function3<PipelineContext<Object, ApplicationCall>, Object, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    PipelineContext<Object, ApplicationCall> pipelineContext = function3.p$ = $receiver;
                    Object object = function3.p$0 = response;
                    return function3;
                }

                public final Object invoke(Object object, Object object2, Object object3) {
                    return (this.create((PipelineContext<Object, ApplicationCall>)((PipelineContext)object), object2, (Continuation<? super Unit>)((Continuation)object3))).invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

