/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.serialization;

import io.ktor.application.ApplicationCall;
import io.ktor.features.ContentConverter;
import io.ktor.features.ContentNegotiationKt;
import io.ktor.http.ContentType;
import io.ktor.http.ContentTypesKt;
import io.ktor.http.content.ByteArrayContent;
import io.ktor.http.content.OutgoingContent;
import io.ktor.http.content.TextContent;
import io.ktor.request.ApplicationReceiveRequest;
import io.ktor.request.ApplicationRequest;
import io.ktor.request.ApplicationRequestPropertiesKt;
import io.ktor.serialization.JsonSupportKt;
import io.ktor.serialization.SerializationConverter;
import io.ktor.serialization.SerializerLookupKt;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelKt;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.InputKt;
import io.ktor.utils.io.core.StringsKt;
import java.nio.charset.Charset;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tB\u0011\b\u0017\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u0007\b\u0017\u00a2\u0006\u0002\u0010\rB\u001d\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u000e\u0012\f\b\u0002\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\u000fJ'\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J7\u0010\u0017\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0011H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bR\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"Lio/ktor/serialization/SerializationConverter;", "Lio/ktor/features/ContentConverter;", "format", "Lkotlinx/serialization/BinaryFormat;", "(Lkotlinx/serialization/BinaryFormat;)V", "Lkotlinx/serialization/StringFormat;", "defaultCharset", "Ljava/nio/charset/Charset;", "Lio/ktor/utils/io/charsets/Charset;", "(Lkotlinx/serialization/StringFormat;Ljava/nio/charset/Charset;)V", "json", "Lkotlinx/serialization/json/Json;", "(Lkotlinx/serialization/json/Json;)V", "()V", "Lkotlinx/serialization/SerialFormat;", "(Lkotlinx/serialization/SerialFormat;Ljava/nio/charset/Charset;)V", "convertForReceive", "", "context", "Lio/ktor/util/pipeline/PipelineContext;", "Lio/ktor/request/ApplicationReceiveRequest;", "Lio/ktor/application/ApplicationCall;", "(Lio/ktor/util/pipeline/PipelineContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "convertForSend", "contentType", "Lio/ktor/http/ContentType;", "value", "(Lio/ktor/util/pipeline/PipelineContext;Lio/ktor/http/ContentType;Ljava/lang/Object;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "ktor-serialization"})
public final class SerializationConverter
implements ContentConverter {
    private final SerialFormat format;
    private final Charset defaultCharset;

    @Nullable
    public Object convertForSend(@NotNull PipelineContext<Object, ApplicationCall> context, @NotNull ContentType contentType, @NotNull Object value, @NotNull Continuation<Object> $completion) {
        OutgoingContent.ByteArrayContent byteArrayContent;
        KSerializer<?> kSerializer = SerializerLookupKt.serializerForSending(value, this.format.getSerializersModule());
        if (kSerializer == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
        }
        KSerializer<?> serializer = kSerializer;
        SerialFormat serialFormat = this.format;
        if (serialFormat instanceof StringFormat) {
            String content = ((StringFormat)this.format).encodeToString((SerializationStrategy)serializer, value);
            PipelineContext<Object, ApplicationCall> $this$call$iv = context;
            boolean $i$f$getCall = false;
            byteArrayContent = (OutgoingContent.ByteArrayContent)new TextContent(content, ContentTypesKt.withCharset((ContentType)contentType, (Charset)ContentNegotiationKt.suitableCharset$default((ApplicationCall)((ApplicationCall)$this$call$iv.getContext()), null, (int)1, null)), null, 4, null);
        } else if (serialFormat instanceof BinaryFormat) {
            byte[] content = ((BinaryFormat)this.format).encodeToByteArray((SerializationStrategy)serializer, value);
            byteArrayContent = (OutgoingContent.ByteArrayContent)new ByteArrayContent(content, contentType, null, 4, null);
        } else {
            String string = "Unsupported format " + this.format;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return byteArrayContent;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object convertForReceive(@NotNull PipelineContext<ApplicationReceiveRequest, ApplicationCall> var1_1, @NotNull Continuation<Object> var2_2) {
        if (!(var2_2 instanceof convertForReceive.1)) ** GOTO lbl-1000
        var12_3 = var2_2;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                int label;
                final /* synthetic */ SerializationConverter this$0;
                Object L$0;
                Object L$1;
                Object L$2;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.convertForReceive(null, (Continuation<Object>)this);
                }
                {
                    this.this$0 = serializationConverter;
                    super(continuation);
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                request = (ApplicationReceiveRequest)context.getSubject();
                v0 = request.getValue();
                if (!(v0 instanceof ByteReadChannel)) {
                    v0 = null;
                }
                v1 = (ByteReadChannel)v0;
                if (v1 == null) {
                    return null;
                }
                channel = v1;
                $this$call$iv = context;
                $i$f$getCall = false;
                v2 = ApplicationRequestPropertiesKt.contentCharset((ApplicationRequest)((ApplicationCall)$this$call$iv.getContext()).getRequest());
                if (v2 == null) {
                    v2 = this.defaultCharset;
                }
                charset = v2;
                serializer = SerializersKt.serializer((SerializersModule)this.format.getSerializersModule(), (KType)request.getTypeInfo());
                $continuation.L$0 = this;
                $continuation.L$1 = charset;
                $continuation.L$2 = serializer;
                $continuation.label = 1;
                v3 = ByteReadChannelKt.readRemaining((ByteReadChannel)channel, (Continuation)$continuation);
                if (v3 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl41
            }
            case 1: {
                serializer = (KSerializer)$continuation.L$2;
                charset = (Charset)$continuation.L$1;
                this = (SerializationConverter)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl41:
                // 2 sources

                contentPacket = (ByteReadPacket)v3;
                var8_12 = this.format;
                if (var8_12 instanceof StringFormat) {
                    v4 = ((StringFormat)this.format).decodeFromString((DeserializationStrategy)serializer, StringsKt.readText$default((Input)((Input)contentPacket), (Charset)charset, (int)0, (int)2, null));
                } else if (var8_12 instanceof BinaryFormat) {
                    v4 = ((BinaryFormat)this.format).decodeFromByteArray((DeserializationStrategy)serializer, StringsKt.readBytes$default((ByteReadPacket)contentPacket, (int)0, (int)1, null));
                } else {
                    InputKt.discard((Input)((Input)contentPacket));
                    var9_13 = "Unsupported format " + this.format;
                    var10_14 = false;
                    throw (Throwable)new IllegalStateException(var9_13.toString());
                }
                return v4;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private SerializationConverter(SerialFormat format, Charset defaultCharset) {
        this.format = format;
        this.defaultCharset = defaultCharset;
        boolean bl = this.format instanceof BinaryFormat || this.format instanceof StringFormat;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Only binary and string formats are supported, " + this.format + " is not supported.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    /* synthetic */ SerializationConverter(SerialFormat serialFormat, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(serialFormat, charset);
    }

    public SerializationConverter(@NotNull BinaryFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this((SerialFormat)format, null, 2, null);
    }

    public SerializationConverter(@NotNull StringFormat format, @NotNull Charset defaultCharset) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)defaultCharset, (String)"defaultCharset");
        this((SerialFormat)format, defaultCharset);
    }

    public /* synthetic */ SerializationConverter(StringFormat stringFormat, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(stringFormat, charset);
    }

    @Deprecated(message="Binary compatibility.", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ SerializationConverter(Json json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this((StringFormat)json, null, 2, null);
    }

    public /* synthetic */ SerializationConverter(Json json, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            json = JsonSupportKt.getDefaultJson();
        }
        this(json);
    }

    @Deprecated(message="Specify format explicitly. E.g SerializationConverter(Json(...))", level=DeprecationLevel.HIDDEN)
    public /* synthetic */ SerializationConverter() {
        this((StringFormat)JsonSupportKt.getDefaultJson(), null, 2, null);
    }
}

