/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.serialization;

import io.ktor.features.ContentConverter;
import io.ktor.features.ContentNegotiation;
import io.ktor.http.ContentType;
import io.ktor.serialization.SerializationConverter;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.jvm.KTypesJvm;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PlatformUtilsKt;
import kotlinx.serialization.SerializerResolvingKt;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.HashMapSerializer;
import kotlinx.serialization.internal.HashSetSerializer;
import kotlinx.serialization.internal.MapEntrySerializer;
import kotlinx.serialization.internal.ReferenceArraySerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001a\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u000b0\u0005*\u0006\u0012\u0002\b\u00030\rH\u0002\u001a\u001e\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0015"}, d2={"DefaultJsonConfiguration", "Lkotlinx/serialization/json/JsonConfiguration;", "getDefaultJsonConfiguration", "()Lkotlinx/serialization/json/JsonConfiguration;", "arraySerializer", "Lkotlinx/serialization/KSerializer;", "type", "Lkotlin/reflect/KType;", "serializerByTypeInfo", "serializerForSending", "value", "", "elementSerializer", "", "serialization", "", "Lio/ktor/features/ContentNegotiation$Configuration;", "contentType", "Lio/ktor/http/ContentType;", "json", "Lkotlinx/serialization/json/Json;", "ktor-serialization"})
public final class SerializationConverterKt {
    @NotNull
    private static final JsonConfiguration DefaultJsonConfiguration = JsonConfiguration.copy$default((JsonConfiguration)JsonConfiguration.Companion.getStable(), (boolean)true, (boolean)false, (boolean)false, (boolean)false, (boolean)false, null, (boolean)true, null, null, (int)424, null);

    public static final void serialization(@NotNull ContentNegotiation.Configuration $this$serialization, @NotNull ContentType contentType, @NotNull Json json) {
        Intrinsics.checkParameterIsNotNull((Object)$this$serialization, (String)"$this$serialization");
        Intrinsics.checkParameterIsNotNull((Object)contentType, (String)"contentType");
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        SerializationConverter converter = new SerializationConverter(json);
        ContentNegotiation.Configuration.register$default((ContentNegotiation.Configuration)$this$serialization, (ContentType)contentType, (ContentConverter)converter, null, (int)4, null);
    }

    public static /* synthetic */ void serialization$default(ContentNegotiation.Configuration configuration, ContentType contentType, Json json, int n, Object object) {
        if ((n & 1) != 0) {
            contentType = ContentType.Application.INSTANCE.getJson();
        }
        if ((n & 2) != 0) {
            json = new Json(DefaultJsonConfiguration, null, 2, null);
        }
        SerializationConverterKt.serialization(configuration, contentType, json);
    }

    @NotNull
    public static final JsonConfiguration getDefaultJsonConfiguration() {
        return DefaultJsonConfiguration;
    }

    private static final KSerializer<?> serializerByTypeInfo(KType type) {
        KClass classifierClass;
        if (type.getArguments().isEmpty()) {
            return PlatformUtilsKt.serializer((KClass)KTypesJvm.getJvmErasure((KType)type));
        }
        KClassifier kClassifier = type.getClassifier();
        if (!(kClassifier instanceof KClass)) {
            kClassifier = null;
        }
        if ((classifierClass = (KClass)kClassifier) != null && JvmClassMappingKt.getJavaClass((KClass)classifierClass).isArray()) {
            return SerializationConverterKt.arraySerializer(type);
        }
        return SerializerResolvingKt.serializer((KType)type);
    }

    private static final KSerializer<?> arraySerializer(KType type) {
        KType kType = ((KTypeProjection)type.getArguments().get(0)).getType();
        if (kType == null) {
            String string = "Array<*> is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        KType elementType = kType;
        KSerializer<?> elementSerializer = SerializationConverterKt.serializerByTypeInfo(elementType);
        KClass kClass = KTypesJvm.getJvmErasure((KType)elementType);
        if (kClass == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Any>");
        }
        KSerializer<?> kSerializer = elementSerializer;
        if (kSerializer == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
        }
        return (KSerializer)new ReferenceArraySerializer(kClass, kSerializer);
    }

    private static final KSerializer<?> serializerForSending(Object value) {
        if (value instanceof List) {
            return (KSerializer)new ArrayListSerializer(SerializationConverterKt.elementSerializer((Collection)value));
        }
        if (value instanceof Set) {
            return (KSerializer)new HashSetSerializer(SerializationConverterKt.elementSerializer((Collection)value));
        }
        if (value instanceof Map) {
            return (KSerializer)new HashMapSerializer(SerializationConverterKt.elementSerializer(((Map)value).keySet()), SerializationConverterKt.elementSerializer(((Map)value).values()));
        }
        if (value instanceof Map.Entry) {
            Object k = ((Map.Entry)value).getKey();
            if (k == null) {
                String string = "Map.Entry(null, ...) is not supported";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KSerializer<?> kSerializer = SerializationConverterKt.serializerForSending(k);
            Object v = ((Map.Entry)value).getValue();
            if (v == null) {
                String string = "Map.Entry(..., null) is not supported)";
                KSerializer<?> kSerializer2 = kSerializer;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KSerializer<?> kSerializer3 = SerializationConverterKt.serializerForSending(v);
            KSerializer<?> kSerializer4 = kSerializer;
            return (KSerializer)new MapEntrySerializer(kSerializer4, kSerializer3);
        }
        if (value instanceof Object[]) {
            KClass componentClass;
            Class<?> clazz = ((Object[])value).getClass().getComponentType();
            Intrinsics.checkExpressionValueIsNotNull(clazz, (String)"value.javaClass.componentType");
            KType componentType = KClassifiers.getStarProjectedType((KClassifier)((KClassifier)JvmClassMappingKt.getKotlinClass(clazz)));
            KClassifier kClassifier = componentType.getClassifier();
            if (!(kClassifier instanceof KClass)) {
                kClassifier = null;
            }
            KClass kClass = (KClass)kClassifier;
            if (kClass == null) {
                String string = "Unsupported component type " + componentType;
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            KClass kClass2 = componentClass = kClass;
            if (kClass2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.reflect.KClass<kotlin.Any>");
            }
            KSerializer<?> kSerializer = SerializationConverterKt.serializerByTypeInfo(componentType);
            if (kSerializer == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlinx.serialization.KSerializer<kotlin.Any>");
            }
            return (KSerializer)new ReferenceArraySerializer(kClass2, kSerializer);
        }
        return PlatformUtilsKt.serializer((KClass)Reflection.getOrCreateKotlinClass(value.getClass()));
    }

    private static final KSerializer<? extends Object> elementSerializer(@NotNull Collection<?> $this$elementSerializer) {
        KSerializer<?> kSerializer;
        block5: {
            block4: {
                Object object;
                block3: {
                    Iterable $this$firstOrNull$iv = $this$elementSerializer;
                    boolean $i$f$firstOrNull = false;
                    Iterator iterator = $this$firstOrNull$iv.iterator();
                    while (iterator.hasNext()) {
                        Object element$iv;
                        Object it = element$iv = iterator.next();
                        boolean bl = false;
                        if (!(it != null)) continue;
                        object = element$iv;
                        break block3;
                    }
                    object = kSerializer = null;
                }
                if (object == null) break block4;
                KSerializer<?> kSerializer2 = kSerializer;
                boolean bl = false;
                boolean bl2 = false;
                KSerializer<?> first = kSerializer2;
                boolean bl3 = false;
                kSerializer = SerializationConverterKt.serializerByTypeInfo(KClassifiers.getStarProjectedType((KClassifier)((KClassifier)JvmClassMappingKt.getKotlinClass(first.getClass()))));
                if (kSerializer != null) break block5;
            }
            kSerializer = PlatformUtilsKt.serializer((KClass)Reflection.getOrCreateKotlinClass(String.class));
        }
        return kSerializer;
    }

    public static final /* synthetic */ KSerializer access$serializerForSending(Object value) {
        return SerializationConverterKt.serializerForSending(value);
    }

    public static final /* synthetic */ KSerializer access$serializerByTypeInfo(KType type) {
        return SerializationConverterKt.serializerByTypeInfo(type);
    }
}

