/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.internals;

import io.ktor.util.KtorExperimentalAPI;
import io.ktor.util.internal.LockFreeLinkedListHead;
import io.ktor.util.internal.LockFreeLinkedListNode;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlinx.coroutines.ChildHandle;
import kotlinx.coroutines.ChildJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.ObsoleteCoroutinesApi;
import kotlinx.coroutines.selects.SelectClause0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KtorExperimentalAPI
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0004\u001d\u001e\u001f B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J@\u0010\u0015\u001a\u0002H\u0016\"\u0004\b\u0000\u0010\u00162'\u0010\u0017\u001a#\b\u0001\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00160\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0018\u00a2\u0006\u0002\b\u001bH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue;", "", "timeoutMillis", "", "clock", "Lkotlin/Function0;", "(JLkotlin/jvm/functions/Function0;)V", "cancelled", "", "head", "Lio/ktor/util/internal/LockFreeLinkedListHead;", "getTimeoutMillis", "()J", "cancel", "", "process", "now", "register", "Lio/ktor/http/cio/internals/WeakTimeoutQueue$Registration;", "job", "Lkotlinx/coroutines/Job;", "withTimeout", "T", "block", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Cancellable", "JobTask", "Registration", "WeakTimeoutCoroutine", "ktor-http-cio"})
public final class WeakTimeoutQueue {
    private final LockFreeLinkedListHead head;
    private volatile boolean cancelled;
    private final long timeoutMillis;
    private final Function0<Long> clock;

    @NotNull
    public final Registration register(@NotNull Job job) {
        Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
        long now = ((Number)this.clock.invoke()).longValue();
        LockFreeLinkedListHead head = this.head;
        if (this.cancelled) {
            throw (Throwable)new CancellationException();
        }
        JobTask cancellable = new JobTask(now + this.timeoutMillis, job);
        head.addLast((LockFreeLinkedListNode)cancellable);
        this.process(now, head, this.cancelled);
        if (this.cancelled) {
            cancellable.cancel();
            throw (Throwable)new CancellationException();
        }
        return cancellable;
    }

    public final void cancel() {
        this.cancelled = true;
        this.process();
    }

    public final void process() {
        this.process(((Number)this.clock.invoke()).longValue(), this.head, this.cancelled);
    }

    @Nullable
    public final <T> Object withTimeout(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> block, @NotNull Continuation<? super T> continuation) {
        Object object;
        Object object2;
        Continuation continuation2 = IntrinsicsKt.intercepted(continuation);
        WeakTimeoutCoroutine wrapped = new WeakTimeoutCoroutine(continuation2.getContext(), continuation2, null, 4, null);
        Registration handle = this.register(wrapped);
        wrapped.invokeOnCompletion((Function1<Throwable, Unit>)((Function1)handle));
        try {
            Object object3;
            if (wrapped.isCancelled()) {
                object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            } else {
                Object object4 = object2 = block;
                if (object4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type (R, kotlin.coroutines.Continuation<T>) -> kotlin.Any?");
                }
                object3 = ((Function2)TypeIntrinsics.beforeCheckcastToFunctionOfArity(object4, (int)2)).invoke(wrapped, (Object)wrapped);
            }
            object2 = object3;
        }
        catch (Throwable t) {
            if (wrapped.tryComplete()) {
                handle.dispose();
                throw t;
            }
            object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        }
        Object result = object2;
        if (result != IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            if (wrapped.tryComplete()) {
                handle.dispose();
                object = result;
            } else {
                object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            }
        } else {
            object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        }
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended(continuation);
        }
        return object;
    }

    private final void process(long now, LockFreeLinkedListHead head, boolean cancelled) {
        while (true) {
            Cancellable p;
            Object object;
            if (!((object = head.getNext()) instanceof Cancellable)) {
                object = null;
            }
            if ((Cancellable)object == null) {
                break;
            }
            if (!cancelled && p.getDeadline() > now) break;
            if (!p.isActive() || !p.remove()) continue;
            p.cancel();
        }
    }

    public final long getTimeoutMillis() {
        return this.timeoutMillis;
    }

    public WeakTimeoutQueue(long timeoutMillis, @NotNull Function0<Long> clock) {
        Intrinsics.checkParameterIsNotNull(clock, (String)"clock");
        this.timeoutMillis = timeoutMillis;
        this.clock = clock;
        this.head = new LockFreeLinkedListHead();
    }

    public /* synthetic */ WeakTimeoutQueue(long l, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(l, (Function0<Long>)function0);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002#\u0012\u0015\u0012\u0013\u0018\u00010\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\u0002`\u00072\u00020\bJ\u0013\u0010\t\u001a\u00020\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0002H\u0096\u0002\u00a8\u0006\n"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$Registration;", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "cause", "", "Lkotlinx/coroutines/CompletionHandler;", "Lkotlinx/coroutines/DisposableHandle;", "invoke", "ktor-http-cio"})
    public static interface Registration
    extends Function1<Throwable, Unit>,
    DisposableHandle {
        public void invoke(@Nullable Throwable var1);

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
        public static final class DefaultImpls {
            public static void invoke(Registration $this, @Nullable Throwable cause) {
                $this.dispose();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\"\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH&J\b\u0010\r\u001a\u00020\fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\n\u00a8\u0006\u000e"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$Cancellable;", "Lio/ktor/util/internal/LockFreeLinkedListNode;", "Lio/ktor/http/cio/internals/WeakTimeoutQueue$Registration;", "deadline", "", "(J)V", "getDeadline", "()J", "isActive", "", "()Z", "cancel", "", "dispose", "ktor-http-cio"})
    private static abstract class Cancellable
    extends LockFreeLinkedListNode
    implements Registration {
        private final long deadline;

        public boolean isActive() {
            return !this.isRemoved();
        }

        public abstract void cancel();

        public void dispose() {
            this.remove();
        }

        public final long getDeadline() {
            return this.deadline;
        }

        public Cancellable(long deadline) {
            this.deadline = deadline;
        }

        @Override
        public void invoke(@Nullable Throwable cause) {
            Registration.DefaultImpls.invoke(this, cause);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$JobTask;", "Lio/ktor/http/cio/internals/WeakTimeoutQueue$Cancellable;", "deadline", "", "job", "Lkotlinx/coroutines/Job;", "(JLkotlinx/coroutines/Job;)V", "isActive", "", "()Z", "cancel", "", "ktor-http-cio"})
    private static final class JobTask
    extends Cancellable {
        private final Job job;

        @Override
        public boolean isActive() {
            return super.isActive() && this.job.isActive();
        }

        @Override
        public void cancel() {
            this.job.cancel();
        }

        public JobTask(long deadline, @NotNull Job job) {
            Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
            super(deadline);
            this.job = job;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00002\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u00032\u00020\u0004B%\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\u0011\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0097\u0001J\t\u0010'\u001a\u00020(H\u0096\u0001J\u0015\u0010'\u001a\u00020\u00132\n\b\u0002\u0010)\u001a\u0004\u0018\u00010*H\u0097\u0001J\u000e\u0010+\u001a\u00020\u0013H\u0097\u0001\u00a2\u0006\u0002\b'J6\u0010,\u001a\u0002H-\"\u0004\b\u0001\u0010-2\u0006\u0010.\u001a\u0002H-2\u0018\u0010/\u001a\u0014\u0012\u0004\u0012\u0002H-\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002H-00H\u0096\u0001\u00a2\u0006\u0002\u00102J(\u00103\u001a\u0004\u0018\u0001H4\"\b\b\u0001\u00104*\u0002012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H40\u001aH\u0096\u0003\u00a2\u0006\u0002\u00105J\r\u00106\u001a\u000607j\u0002`8H\u0097\u0001JF\u00109\u001a\u00020:2\b\b\u0002\u0010;\u001a\u00020\u00132\b\b\u0002\u0010<\u001a\u00020\u00132'\u0010=\u001a#\u0012\u0015\u0012\u0013\u0018\u00010*\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b()\u0012\u0004\u0012\u00020(0>j\u0002`AH\u0097\u0001J2\u00109\u001a\u00020:2'\u0010=\u001a#\u0012\u0015\u0012\u0013\u0018\u00010*\u00a2\u0006\f\b?\u0012\b\b@\u0012\u0004\b\b()\u0012\u0004\u0012\u00020(0>j\u0002`AH\u0096\u0001J\u0011\u0010B\u001a\u00020(H\u0096A\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010CJ\u0015\u0010D\u001a\u00020\u00062\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0096\u0001J\u0011\u0010E\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0096\u0003J\u0011\u0010E\u001a\u00020\u00032\u0006\u0010F\u001a\u00020\u0003H\u0097\u0003J\u001e\u0010G\u001a\u00020(2\f\u0010H\u001a\b\u0012\u0004\u0012\u00028\u00000IH\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010JJ\t\u0010K\u001a\u00020\u0013H\u0096\u0001J\u0006\u0010L\u001a\u00020\u0013R\u0018\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0012\u0010\u0012\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0012\u0010\u0015\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0012\u0010\u0016\u001a\u00020\u0013X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0012\u0010\u001d\u001a\u00020\u001eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00020\"X\u0088\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006M"}, d2={"Lio/ktor/http/cio/internals/WeakTimeoutQueue$WeakTimeoutCoroutine;", "T", "Lkotlin/coroutines/Continuation;", "Lkotlinx/coroutines/Job;", "Lkotlinx/coroutines/CoroutineScope;", "context", "Lkotlin/coroutines/CoroutineContext;", "delegate", "job", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/Continuation;Lkotlinx/coroutines/Job;)V", "children", "Lkotlin/sequences/Sequence;", "getChildren", "()Lkotlin/sequences/Sequence;", "getContext", "()Lkotlin/coroutines/CoroutineContext;", "coroutineContext", "getCoroutineContext", "isActive", "", "()Z", "isCancelled", "isCompleted", "getJob", "()Lkotlinx/coroutines/Job;", "key", "Lkotlin/coroutines/CoroutineContext$Key;", "getKey", "()Lkotlin/coroutines/CoroutineContext$Key;", "onJoin", "Lkotlinx/coroutines/selects/SelectClause0;", "getOnJoin", "()Lkotlinx/coroutines/selects/SelectClause0;", "state", "Lkotlinx/atomicfu/AtomicRef;", "attachChild", "Lkotlinx/coroutines/ChildHandle;", "child", "Lkotlinx/coroutines/ChildJob;", "cancel", "", "cause", "", "cancel0", "fold", "R", "initial", "operation", "Lkotlin/Function2;", "Lkotlin/coroutines/CoroutineContext$Element;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "get", "E", "(Lkotlin/coroutines/CoroutineContext$Key;)Lkotlin/coroutines/CoroutineContext$Element;", "getCancellationException", "Ljava/util/concurrent/CancellationException;", "Lkotlinx/coroutines/CancellationException;", "invokeOnCompletion", "Lkotlinx/coroutines/DisposableHandle;", "onCancelling", "invokeImmediately", "handler", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Lkotlinx/coroutines/CompletionHandler;", "join", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "minusKey", "plus", "other", "resumeWith", "result", "Lkotlin/Result;", "(Ljava/lang/Object;)V", "start", "tryComplete", "ktor-http-cio"})
    private static final class WeakTimeoutCoroutine<T>
    implements Continuation<T>,
    Job,
    CoroutineScope {
        @NotNull
        private final CoroutineContext context;
        private volatile Object state;
        private static final AtomicReferenceFieldUpdater state$FU = AtomicReferenceFieldUpdater.newUpdater(WeakTimeoutCoroutine.class, Object.class, "state");
        @NotNull
        private final Job job;

        @NotNull
        public CoroutineContext getContext() {
            return this.context;
        }

        @NotNull
        public CoroutineContext getCoroutineContext() {
            return this.getContext();
        }

        public void resumeWith(@NotNull Object result) {
            block1: {
                Continuation continuation;
                Object upd$iv;
                Object cur$iv;
                WeakTimeoutCoroutine $receiver$iv = this;
                do {
                    Continuation it;
                    if ((it = (Continuation)(cur$iv = $receiver$iv.state)) != null) continue;
                    return;
                } while (!state$FU.compareAndSet($receiver$iv, cur$iv, upd$iv = null));
                Continuation continuation2 = (Continuation)cur$iv;
                if (continuation2 == null) break block1;
                Continuation it = continuation = continuation2;
                it.resumeWith(result);
                this.job.cancel();
            }
        }

        public final boolean tryComplete() {
            Object upd$iv;
            Object cur$iv;
            WeakTimeoutCoroutine $receiver$iv = this;
            do {
                Continuation it;
                if ((it = (Continuation)(cur$iv = $receiver$iv.state)) instanceof Continuation) continue;
                return false;
            } while (!state$FU.compareAndSet($receiver$iv, cur$iv, upd$iv = null));
            this.job.cancel();
            return true;
        }

        @NotNull
        public final Job getJob() {
            return this.job;
        }

        public WeakTimeoutCoroutine(@NotNull CoroutineContext context, @NotNull Continuation<? super T> delegate, @NotNull Job job) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(delegate, (String)"delegate");
            Intrinsics.checkParameterIsNotNull((Object)job, (String)"job");
            this.job = job;
            this.context = context.plus((CoroutineContext)this.job);
            this.state = delegate;
            Job job2 = (Job)context.get((CoroutineContext.Key)Job.Key);
            if (job2 != null) {
                Job job3;
                Job parent = job3 = job2;
                Job.DefaultImpls.invokeOnCompletion$default((Job)parent, (boolean)true, (boolean)false, (Function1)((Function1)new Function1<Throwable, Unit>(this){
                    final /* synthetic */ WeakTimeoutCoroutine this$0;
                    {
                        this.this$0 = weakTimeoutCoroutine;
                        super(1);
                    }

                    public final void invoke(@Nullable Throwable it) {
                        if (it != null) {
                            WeakTimeoutCoroutine weakTimeoutCoroutine = this.this$0;
                            Result.Companion companion = Result.Companion;
                            WeakTimeoutCoroutine weakTimeoutCoroutine2 = weakTimeoutCoroutine;
                            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it));
                            weakTimeoutCoroutine2.resumeWith(object);
                            this.this$0.getJob().cancel();
                        }
                    }
                }), (int)2, null);
            }
            this.job.invokeOnCompletion((Function1)new Function1<Throwable, Unit>(){

                public final void invoke(@Nullable Throwable it) {
                    WeakTimeoutCoroutine weakTimeoutCoroutine = this;
                    Throwable throwable = it;
                    if (throwable == null) {
                        throwable = new CancellationException();
                    }
                    Throwable throwable2 = throwable;
                    Result.Companion companion = Result.Companion;
                    WeakTimeoutCoroutine weakTimeoutCoroutine2 = weakTimeoutCoroutine;
                    Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    weakTimeoutCoroutine2.resumeWith(object);
                }
            });
        }

        public /* synthetic */ WeakTimeoutCoroutine(CoroutineContext coroutineContext, Continuation continuation, Job job, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                job = JobKt.Job((Job)((Job)coroutineContext.get((CoroutineContext.Key)Job.Key)));
            }
            this(coroutineContext, continuation, job);
        }

        @NotNull
        public Sequence<Job> getChildren() {
            return this.job.getChildren();
        }

        public boolean isActive() {
            return this.job.isActive();
        }

        public boolean isCancelled() {
            return this.job.isCancelled();
        }

        public boolean isCompleted() {
            return this.job.isCompleted();
        }

        @NotNull
        public CoroutineContext.Key<?> getKey() {
            return this.job.getKey();
        }

        @NotNull
        public SelectClause0 getOnJoin() {
            return this.job.getOnJoin();
        }

        @InternalCoroutinesApi
        @NotNull
        public ChildHandle attachChild(@NotNull ChildJob child) {
            Intrinsics.checkParameterIsNotNull((Object)child, (String)"child");
            return this.job.attachChild(child);
        }

        public void cancel() {
            this.job.cancel();
        }

        @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="cancel()"), message="Use CompletableDeferred.completeExceptionally(cause) or Job.cancel() instead", level=DeprecationLevel.WARNING)
        @ObsoleteCoroutinesApi
        public boolean cancel(@Nullable Throwable cause) {
            return this.job.cancel(cause);
        }

        @Deprecated(message="Left here for binary compatibility", level=DeprecationLevel.HIDDEN)
        @JvmName(name="cancel")
        public /* synthetic */ boolean cancel() {
            return this.job.cancel();
        }

        public <R> R fold(R initial, @NotNull Function2<? super R, ? super CoroutineContext.Element, ? extends R> operation) {
            Intrinsics.checkParameterIsNotNull(operation, (String)"operation");
            return (R)this.job.fold(initial, operation);
        }

        @Nullable
        public <E extends CoroutineContext.Element> E get(@NotNull CoroutineContext.Key<E> key) {
            Intrinsics.checkParameterIsNotNull(key, (String)"key");
            return (E)this.job.get(key);
        }

        @InternalCoroutinesApi
        @NotNull
        public CancellationException getCancellationException() {
            return this.job.getCancellationException();
        }

        @InternalCoroutinesApi
        @NotNull
        public DisposableHandle invokeOnCompletion(boolean onCancelling, boolean invokeImmediately, @NotNull Function1<? super Throwable, Unit> handler) {
            Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
            return this.job.invokeOnCompletion(onCancelling, invokeImmediately, handler);
        }

        @NotNull
        public DisposableHandle invokeOnCompletion(@NotNull Function1<? super Throwable, Unit> handler) {
            Intrinsics.checkParameterIsNotNull(handler, (String)"handler");
            return this.job.invokeOnCompletion(handler);
        }

        @Nullable
        public Object join(@NotNull Continuation<? super Unit> continuation) {
            return this.job.join(continuation);
        }

        @NotNull
        public CoroutineContext minusKey(@NotNull CoroutineContext.Key<?> key) {
            Intrinsics.checkParameterIsNotNull(key, (String)"key");
            return this.job.minusKey(key);
        }

        @NotNull
        public CoroutineContext plus(@NotNull CoroutineContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            return this.job.plus(context);
        }

        @Deprecated(message="Operator '+' on two Job objects is meaningless. Job is a coroutine context element and `+` is a set-sum operator for coroutine contexts. The job to the right of `+` just replaces the job the left of `+`.", level=DeprecationLevel.ERROR)
        @NotNull
        public Job plus(@NotNull Job other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return this.job.plus(other);
        }

        public boolean start() {
            return this.job.start();
        }
    }
}

