/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.rlp;

import io.ethers.rlp.RlpDecodable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rJ!\u0010\u000f\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012\u00a2\u0006\u0002\u0010\u0013J \u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0015\"\u0004\b\u0000\u0010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0012J0\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00100\u0015\"\u0004\b\u0000\u0010\u00102\u0019\u0010\u0016\u001a\u0015\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u0001H\u00100\u0017\u00a2\u0006\u0002\b\u0018H\u0086\bJ#\u0010\u0019\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\u000e\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H\u00100\u001b\u00a2\u0006\u0002\u0010\u001cJ1\u0010\u0019\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\u0019\u0010\u0016\u001a\u0015\u0012\u0004\u0012\u00020\u0000\u0012\u0006\u0012\u0004\u0018\u0001H\u00100\u0017\u00a2\u0006\u0002\b\u0018H\u0086\b\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0007J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0007J\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%J\b\u0010'\u001a\u0004\u0018\u00010%J\u0006\u0010(\u001a\u00020)J*\u0010*\u001a\u0004\u0018\u0001H\u0010\"\u0004\b\u0000\u0010\u00102\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00100\u0017H\u0086\b\u00a2\u0006\u0002\u0010\u001dJ\b\u0010*\u001a\u0004\u0018\u00010\u0003J\b\u0010+\u001a\u00020\u0007H\u0002J\b\u0010,\u001a\u00020\u0007H\u0002J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\u0007H\u0002J\u0010\u0010/\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0007H\u0002J\u0010\u00100\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u00061"}, d2={"Lio/ethers/rlp/RlpDecoder;", "", "array", "", "<init>", "([B)V", "startedListCount", "", "value", "position", "getPosition", "()I", "peekByte", "", "readByte", "decode", "T", "decodable", "Lio/ethers/rlp/RlpDecodable;", "(Lio/ethers/rlp/RlpDecodable;)Ljava/lang/Object;", "decodeAsList", "", "consumer", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "decodeList", "supplier", "Ljava/util/function/Supplier;", "(Ljava/util/function/Supplier;)Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isNextElementList", "", "startList", "finishList", "", "listEndPosition", "decodeBigIntegerElse", "Ljava/math/BigInteger;", "default", "decodeBigInteger", "decodeLong", "", "decodeByteArray", "peekFlag", "takeFlag", "takeLong", "size", "takeByteArray", "takeSizeFromLength", "ethers-rlp"})
@SourceDebugExtension(value={"SMAP\nRlpDecoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RlpDecoder.kt\nio/ethers/rlp/RlpDecoder\n*L\n1#1,318:1\n64#1,13:319\n102#1,10:332\n*S KotlinDebug\n*F\n+ 1 RlpDecoder.kt\nio/ethers/rlp/RlpDecoder\n*L\n50#1:319,13\n89#1:332,10\n*E\n"})
public final class RlpDecoder {
    @NotNull
    private final byte[] array;
    private int startedListCount;
    private int position;

    public RlpDecoder(@NotNull byte[] array) {
        this.array = array;
    }

    public final int getPosition() {
        return this.position;
    }

    public final byte peekByte() {
        return this.array[this.position];
    }

    public final byte readByte() {
        int n = this.position;
        this.position = n + 1;
        return this.array[n];
    }

    @Nullable
    public final <T> T decode(@NotNull RlpDecodable<T> decodable) {
        return decodable.rlpDecode(this);
    }

    @NotNull
    public final <T> List<T> decodeAsList(@NotNull RlpDecodable<T> decodable) {
        List list;
        RlpDecoder this_$iv = this;
        boolean $i$f$decodeAsList = false;
        int listEndPosition$iv = this_$iv.startList();
        if (this_$iv.getPosition() == listEndPosition$iv) {
            list = CollectionsKt.emptyList();
        } else {
            ArrayList<T> ret$iv = new ArrayList<T>();
            while (this_$iv.getPosition() < listEndPosition$iv) {
                T v$iv;
                RlpDecoder $this$decodeAsList_u24lambda_u240 = this_$iv;
                boolean bl = false;
                if ($this$decodeAsList_u24lambda_u240.decode(decodable) == null) continue;
                ret$iv.add(v$iv);
            }
            this_$iv.finishList(listEndPosition$iv);
            list = ret$iv;
        }
        return list;
    }

    @NotNull
    public final <T> List<T> decodeAsList(@NotNull Function1<? super RlpDecoder, ? extends T> consumer) {
        boolean $i$f$decodeAsList = false;
        int listEndPosition = this.startList();
        if (this.getPosition() == listEndPosition) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        while (this.getPosition() < listEndPosition) {
            Object v;
            if (consumer.invoke((Object)this) == null) continue;
            ret.add(v);
        }
        this.finishList(listEndPosition);
        return ret;
    }

    @Nullable
    public final <T> T decodeList(@NotNull Supplier<T> supplier) {
        T t;
        RlpDecoder this_$iv = this;
        boolean $i$f$decodeList = false;
        int listEndPosition$iv = this_$iv.startList();
        if (this_$iv.getPosition() == listEndPosition$iv) {
            t = null;
        } else {
            RlpDecoder $this$decodeList_u24lambda_u241 = this_$iv;
            boolean bl = false;
            T r$iv = supplier.get();
            this_$iv.finishList(listEndPosition$iv);
            t = r$iv;
        }
        return t;
    }

    @Nullable
    public final <T> T decodeList(@NotNull Function1<? super RlpDecoder, ? extends T> consumer) {
        boolean $i$f$decodeList = false;
        int listEndPosition = this.startList();
        if (this.getPosition() == listEndPosition) {
            return null;
        }
        Object r = consumer.invoke((Object)this);
        this.finishList(listEndPosition);
        return (T)r;
    }

    public final boolean isNextElementList() {
        int flag = this.peekFlag();
        return flag < 192 ? false : (flag == 192 ? true : (flag <= 247 ? true : flag <= 255));
    }

    public final int startList() {
        int n;
        int flag = this.takeFlag();
        if (flag == 192) {
            n = 0;
        } else if (flag <= 247) {
            n = flag - 192;
        } else if (flag <= 255) {
            int lengthOfSize = flag - 247;
            n = this.takeSizeFromLength(lengthOfSize);
        } else {
            throw new IllegalStateException("Not a list: " + flag);
        }
        int listByteLength = n;
        int n2 = this.startedListCount;
        this.startedListCount = n2 + 1;
        return this.position + listByteLength;
    }

    public final void finishList(int listEndPosition) {
        this.startedListCount += -1;
        if (this.startedListCount < 0) {
            throw new IllegalStateException("Not all list decodings were finished. Need to close " + this.startedListCount + " more.");
        }
        if (this.position != listEndPosition) {
            throw new IllegalStateException("List not decoded correctly. Expected end position to be " + listEndPosition + ", got " + this.position);
        }
    }

    @NotNull
    public final BigInteger decodeBigIntegerElse(@NotNull BigInteger bigInteger) {
        BigInteger bigInteger2 = this.decodeBigInteger();
        if (bigInteger2 == null) {
            bigInteger2 = bigInteger;
        }
        return bigInteger2;
    }

    @Nullable
    public final BigInteger decodeBigInteger() {
        int flag = this.takeFlag();
        if (flag == 128) {
            return null;
        }
        if (flag < 128) {
            return BigInteger.valueOf(flag);
        }
        if (flag <= 183) {
            int size = flag - 128;
            return new BigInteger(1, this.takeByteArray(size));
        }
        throw new IllegalStateException("Not a BigInteger: " + flag);
    }

    public final long decodeLong() {
        int flag = this.takeFlag();
        if (flag == 128) {
            return 0L;
        }
        if (flag < 128) {
            return flag;
        }
        if (flag <= 183) {
            int size = flag - 128;
            return this.takeLong(size);
        }
        throw new IllegalStateException("Not a long: " + flag);
    }

    @Nullable
    public final <T> T decodeByteArray(@NotNull Function1<? super byte[], ? extends T> consumer) {
        boolean $i$f$decodeByteArray = false;
        byte[] byArray = this.decodeByteArray();
        return (T)(byArray != null ? consumer.invoke((Object)byArray) : null);
    }

    @Nullable
    public final byte[] decodeByteArray() {
        int flag = this.takeFlag();
        if (flag == 128) {
            return null;
        }
        if (flag < 128) {
            byte[] result = new byte[]{(byte)flag};
            return result;
        }
        if (flag <= 183) {
            int size = flag - 128;
            return this.takeByteArray(size);
        }
        if (flag <= 192) {
            int lengthOfSize = flag - 183;
            int size = this.takeSizeFromLength(lengthOfSize);
            return this.takeByteArray(size);
        }
        throw new IllegalStateException("Not a byte array: " + flag);
    }

    private final int peekFlag() {
        return UByte.constructor-impl((byte)this.array[this.position]) & 0xFF;
    }

    private final int takeFlag() {
        int n = this.position;
        this.position = n + 1;
        return UByte.constructor-impl((byte)this.array[n]) & 0xFF;
    }

    private final long takeLong(int size) {
        long result = 0L;
        for (int i = 0; i < size; ++i) {
            int n = this.position;
            this.position = n + 1;
            result = result << 8 | (long)this.array[n] & 0xFFL;
        }
        return result;
    }

    private final byte[] takeByteArray(int size) {
        byte[] result = new byte[size];
        System.arraycopy(this.array, this.position, result, 0, size);
        this.position += size;
        return result;
    }

    private final int takeSizeFromLength(int size) {
        int n;
        switch (size) {
            case 1: {
                int n2 = this.position;
                this.position = n2 + 1;
                n = this.array[n2] & 0xFF;
                break;
            }
            case 2: {
                int n3 = this.position;
                this.position = n3 + 1;
                int n4 = (this.array[n3] & 0xFF) << 8;
                n3 = this.position;
                this.position = n3 + 1;
                n = n4 | this.array[n3] & 0xFF;
                break;
            }
            case 3: {
                int n5 = this.position;
                this.position = n5 + 1;
                int n6 = (this.array[n5] & 0xFF) << 16;
                n5 = this.position;
                this.position = n5 + 1;
                int n7 = n6 | (this.array[n5] & 0xFF) << 8;
                n5 = this.position;
                this.position = n5 + 1;
                n = n7 | this.array[n5] & 0xFF;
                break;
            }
            case 4: {
                int n8 = this.position;
                this.position = n8 + 1;
                int n9 = (this.array[n8] & 0xFF) << 24;
                n8 = this.position;
                this.position = n8 + 1;
                int n10 = n9 | (this.array[n8] & 0xFF) << 16;
                n8 = this.position;
                this.position = n8 + 1;
                int n11 = n10 | (this.array[n8] & 0xFF) << 8;
                n8 = this.position;
                this.position = n8 + 1;
                n = n11 | this.array[n8] & 0xFF;
                break;
            }
            default: {
                throw new IllegalArgumentException("Size not supported: " + size);
            }
        }
        return n;
    }
}

