/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers.types;

import io.ethers.core.Result;
import io.ethers.providers.RpcError;
import io.ethers.providers.types.BatchRpcRequest;
import io.ethers.providers.types.RpcRequest;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B!\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u0006H\u0016J\u001a\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u00060\u000bH\u0016J\"\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u00060\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00030\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/ethers/providers/types/SuppliedRpcRequest;", "T", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/providers/RpcError;", "supplier", "Ljava/util/function/Supplier;", "Lio/ethers/core/Result;", "<init>", "(Ljava/util/function/Supplier;)V", "sendAwait", "sendAsync", "Ljava/util/concurrent/CompletableFuture;", "batch", "Lio/ethers/providers/types/BatchRpcRequest;", "toString", "", "ethers-providers"})
public final class SuppliedRpcRequest<T>
extends RpcRequest<T, RpcError> {
    @NotNull
    private final Supplier<Result<T, RpcError>> supplier;

    public SuppliedRpcRequest(@NotNull Supplier<Result<T, RpcError>> supplier) {
        this.supplier = supplier;
    }

    @Override
    @NotNull
    public Result<T, RpcError> sendAwait() {
        return this.supplier.get();
    }

    @Override
    @NotNull
    public CompletableFuture<Result<T, RpcError>> sendAsync() {
        return CompletableFuture.supplyAsync(this.supplier, this.asyncExecutor());
    }

    @Override
    @NotNull
    public CompletableFuture<Result<T, RpcError>> batch(@NotNull BatchRpcRequest batch) {
        return CompletableFuture.supplyAsync(this.supplier, this.asyncExecutor());
    }

    @NotNull
    public String toString() {
        return "SuppliedRpcRequest(supplier=" + this.supplier + ")";
    }
}

