/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers.types;

import io.ethers.core.Result;
import io.ethers.providers.JsonRpcClient;
import io.ethers.providers.RpcError;
import io.ethers.providers.types.BatchRpcRequestKt;
import io.ethers.providers.types.ConditionalCompletableFuture;
import io.ethers.providers.types.RpcCall;
import io.ethers.providers.types.RpcRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020\u00150\u00140\u0013\"\u0004\b\u0000\u0010\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0\fJ\u0006\u0010 \u001a\u00020\u001bJ\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0013R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR&\u0010\n\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bj\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R>\u0010\u0012\u001a2\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00150\u00140\u00130\u000bj\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00150\u00140\u0013`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\u0002\b\u0003\u0012\u0004\u0012\u00020\u00150\u00140\u00130\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\u00a8\u0006#"}, d2={"Lio/ethers/providers/types/BatchRpcRequest;", "", "defaultSize", "", "<init>", "(I)V", "batchSent", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getBatchSent$ethers_providers", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "_requests", "Ljava/util/ArrayList;", "Lio/ethers/providers/types/RpcCall;", "Lkotlin/collections/ArrayList;", "requests", "", "getRequests$ethers_providers", "()Ljava/util/List;", "_responses", "Ljava/util/concurrent/CompletableFuture;", "Lio/ethers/core/Result;", "Lio/ethers/providers/RpcError;", "responses", "getResponses$ethers_providers", "client", "Lio/ethers/providers/JsonRpcClient;", "isEmpty", "", "()Z", "addRpcCall", "T", "request", "sendAwait", "sendAsync", "Companion", "ethers-providers"})
public final class BatchRpcRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean batchSent;
    @NotNull
    private final ArrayList<RpcCall<?>> _requests;
    @NotNull
    private final ArrayList<CompletableFuture<Result<?, RpcError>>> _responses;
    @Nullable
    private JsonRpcClient client;

    @JvmOverloads
    public BatchRpcRequest(int defaultSize) {
        this.batchSent = new AtomicBoolean(false);
        this._requests = new ArrayList(defaultSize);
        this._responses = new ArrayList(defaultSize);
    }

    public /* synthetic */ BatchRpcRequest(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 10;
        }
        this(n);
    }

    @NotNull
    public final AtomicBoolean getBatchSent$ethers_providers() {
        return this.batchSent;
    }

    @NotNull
    public final List<RpcCall<?>> getRequests$ethers_providers() {
        return this._requests;
    }

    @NotNull
    public final List<CompletableFuture<Result<?, RpcError>>> getResponses$ethers_providers() {
        return this._responses;
    }

    public final boolean isEmpty() {
        return this.getRequests$ethers_providers().isEmpty();
    }

    @NotNull
    public final <T> CompletableFuture<Result<T, RpcError>> addRpcCall(@NotNull RpcCall<T> request2) {
        if (this.client == null) {
            this.client = request2.getClient();
        } else if (this.client != request2.getClient()) {
            throw new IllegalArgumentException("All requests must use the same client");
        }
        ConditionalCompletableFuture future = new ConditionalCompletableFuture(this.batchSent);
        this._requests.add(request2);
        this._responses.add(future);
        return future;
    }

    public final boolean sendAwait() {
        return this.sendAsync().join();
    }

    @NotNull
    public final CompletableFuture<Boolean> sendAsync() {
        if (this.client == null) {
            return CompletableFuture.completedFuture(false);
        }
        if (!this.batchSent.compareAndSet(false, true)) {
            throw new IllegalStateException("Batch already sent");
        }
        JsonRpcClient jsonRpcClient = this.client;
        Intrinsics.checkNotNull((Object)jsonRpcClient);
        return jsonRpcClient.requestBatch(this);
    }

    @JvmOverloads
    public BatchRpcRequest() {
        this(0, 1, null);
    }

    @JvmStatic
    @JvmName(name="sendAwait")
    @NotNull
    public static final <T, E extends Result.Error> List<Result<T, E>> sendAwait(@NotNull Iterable<? extends RpcRequest<? extends T, E>> requests) {
        return Companion.sendAwait(requests);
    }

    @JvmStatic
    @JvmName(name="sendAsync")
    @NotNull
    public static final <T, E extends Result.Error> List<CompletableFuture<Result<T, E>>> sendAsync(@NotNull Iterable<? extends RpcRequest<T, E>> requests) {
        return Companion.sendAsync(requests);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JE\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u0005\"\u0004\b\u0000\u0010\u0006\"\b\b\u0001\u0010\u0007*\u00020\b2\u001a\u0010\t\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\b\u0001\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u000b0\nH\u0007\u00a2\u0006\u0002\u0010\fJC\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u000e\"\u0004\b\u0000\u0010\u0006\"\b\b\u0001\u0010\u0007*\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u00070\u000b0\nH\u0007\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u000f"}, d2={"Lio/ethers/providers/types/BatchRpcRequest$Companion;", "", "<init>", "()V", "sendAwait", "Lio/ethers/providers/types/BatchResponse;", "T", "E", "Lio/ethers/core/Result$Error;", "requests", "", "Lio/ethers/providers/types/RpcRequest;", "(Ljava/lang/Iterable;)Ljava/util/List;", "sendAsync", "Lio/ethers/providers/types/BatchResponseAsync;", "ethers-providers"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmName(name="sendAwait")
        @NotNull
        public final <T, E extends Result.Error> List<Result<T, E>> sendAwait(@NotNull Iterable<? extends RpcRequest<? extends T, E>> requests) {
            return BatchRpcRequestKt.sendAwait(requests);
        }

        @JvmStatic
        @JvmName(name="sendAsync")
        @NotNull
        public final <T, E extends Result.Error> List<CompletableFuture<Result<T, E>>> sendAsync(@NotNull Iterable<? extends RpcRequest<T, E>> requests) {
            return BatchRpcRequestKt.sendAsync(requests);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

