/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.providers.bindings;

import io.ethers.core.FastHex;
import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.core.types.Hash;
import io.ethers.crypto.bip39.MnemonicCode;
import io.ethers.providers.bindings.AnvilInstance;
import io.ethers.signers.PrivateKeySigner;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\tJ\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0005J\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001cR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\nR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0017j\b\u0012\u0004\u0012\u00020\u0005`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/ethers/providers/bindings/AnvilBuilder;", "", "<init>", "()V", "binaryPath", "", "port", "", "blockTime", "", "Ljava/lang/Long;", "chainId", "mnemonic", "Lio/ethers/crypto/bip39/MnemonicCode;", "forkUrl", "forkBlockNumber", "forkTransactionHash", "Lio/ethers/core/types/Hash;", "spawnTimeout", "autoImpersonate", "", "Ljava/lang/Boolean;", "additionalArgs", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "additionalArg", "arg", "spawn", "Lio/ethers/core/Result;", "Lio/ethers/providers/bindings/AnvilInstance;", "Lio/ethers/providers/bindings/AnvilBuilder$Error;", "Error", "Companion", "ethers-providers"})
@SourceDebugExtension(value={"SMAP\nAnvil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Anvil.kt\nio/ethers/providers/bindings/AnvilBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,262:1\n1#2:263\n1869#3,2:264\n*S KotlinDebug\n*F\n+ 1 Anvil.kt\nio/ethers/providers/bindings/AnvilBuilder\n*L\n183#1:264,2\n*E\n"})
public final class AnvilBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String binaryPath;
    private int port;
    @Nullable
    private Long blockTime;
    private long chainId = 31337L;
    @Nullable
    private MnemonicCode mnemonic;
    @Nullable
    private String forkUrl;
    @Nullable
    private Long forkBlockNumber;
    @Nullable
    private Hash forkTransactionHash;
    private long spawnTimeout = 10000L;
    @Nullable
    private Boolean autoImpersonate;
    @NotNull
    private final ArrayList<String> additionalArgs = new ArrayList();
    private static final long HARDHAT_CHAIN_ID = 31337L;
    private static final long DEFAULT_SPAWN_TIMEOUT = 10000L;

    @NotNull
    public final AnvilBuilder binaryPath(@NotNull String binaryPath) {
        AnvilBuilder anvilBuilder;
        AnvilBuilder $this$binaryPath_u24lambda_u240 = anvilBuilder = this;
        boolean bl = false;
        $this$binaryPath_u24lambda_u240.binaryPath = binaryPath;
        return anvilBuilder;
    }

    @NotNull
    public final AnvilBuilder port(int port) {
        AnvilBuilder anvilBuilder;
        AnvilBuilder $this$port_u24lambda_u241 = anvilBuilder = this;
        boolean bl = false;
        $this$port_u24lambda_u241.port = port;
        return anvilBuilder;
    }

    @NotNull
    public final AnvilBuilder blockTime(long blockTime) {
        AnvilBuilder anvilBuilder;
        AnvilBuilder $this$blockTime_u24lambda_u242 = anvilBuilder = this;
        boolean bl = false;
        $this$blockTime_u24lambda_u242.blockTime = blockTime;
        return anvilBuilder;
    }

    @NotNull
    public final AnvilBuilder chainId(long chainId) {
        AnvilBuilder anvilBuilder;
        AnvilBuilder $this$chainId_u24lambda_u243 = anvilBuilder = this;
        boolean bl = false;
        $this$chainId_u24lambda_u243.chainId = chainId;
        return anvilBuilder;
    }

    @NotNull
    public final AnvilBuilder mnemonic(@NotNull MnemonicCode mnemonic) {
        AnvilBuilder anvilBuilder;
        AnvilBuilder $this$mnemonic_u24lambda_u244 = anvilBuilder = this;
        boolean bl = false;
        $this$mnemonic_u24lambda_u244.mnemonic = mnemonic;
        return anvilBuilder;
    }

    @NotNull
    public final AnvilBuilder forkUrl(@NotNull String forkUrl) {
        AnvilBuilder anvilBuilder;
        AnvilBuilder $this$forkUrl_u24lambda_u245 = anvilBuilder = this;
        boolean bl = false;
        $this$forkUrl_u24lambda_u245.forkUrl = forkUrl;
        return anvilBuilder;
    }

    @NotNull
    public final AnvilBuilder forkBlockNumber(long forkBlockNumber) {
        AnvilBuilder anvilBuilder;
        AnvilBuilder $this$forkBlockNumber_u24lambda_u246 = anvilBuilder = this;
        boolean bl = false;
        $this$forkBlockNumber_u24lambda_u246.forkBlockNumber = forkBlockNumber;
        return anvilBuilder;
    }

    @NotNull
    public final AnvilBuilder forkTransactionHash(@NotNull Hash forkTransactionHash) {
        AnvilBuilder anvilBuilder;
        AnvilBuilder $this$forkTransactionHash_u24lambda_u247 = anvilBuilder = this;
        boolean bl = false;
        $this$forkTransactionHash_u24lambda_u247.forkTransactionHash = forkTransactionHash;
        return anvilBuilder;
    }

    @NotNull
    public final AnvilBuilder spawnTimeout(long spawnTimeout) {
        AnvilBuilder anvilBuilder;
        AnvilBuilder $this$spawnTimeout_u24lambda_u248 = anvilBuilder = this;
        boolean bl = false;
        $this$spawnTimeout_u24lambda_u248.spawnTimeout = spawnTimeout;
        return anvilBuilder;
    }

    @NotNull
    public final AnvilBuilder autoImpersonate(boolean autoImpersonate) {
        AnvilBuilder anvilBuilder;
        AnvilBuilder $this$autoImpersonate_u24lambda_u249 = anvilBuilder = this;
        boolean bl = false;
        $this$autoImpersonate_u24lambda_u249.autoImpersonate = autoImpersonate;
        return anvilBuilder;
    }

    @NotNull
    public final AnvilBuilder additionalArg(@NotNull String arg) {
        AnvilBuilder anvilBuilder;
        AnvilBuilder $this$additionalArg_u24lambda_u2410 = anvilBuilder = this;
        boolean bl = false;
        $this$additionalArg_u24lambda_u2410.additionalArgs.add(arg);
        return anvilBuilder;
    }

    @NotNull
    public final Result<AnvilInstance, Error> spawn() {
        String line;
        String[] nextErrorLine;
        ArrayList<String> commands = new ArrayList<String>();
        String string = this.binaryPath;
        if (string == null) {
            string = "anvil";
        }
        String it = string;
        boolean bl = false;
        commands.add(it);
        int it2 = this.port;
        boolean bl2 = false;
        commands.add("-p");
        commands.add(String.valueOf(it2));
        Long l = this.blockTime;
        if (l != null) {
            long it3 = ((Number)l).longValue();
            boolean bl3 = false;
            commands.add("-b");
            commands.add(String.valueOf(it3));
        }
        long it3 = this.chainId;
        boolean bl4 = false;
        commands.add("--chain-id");
        commands.add(String.valueOf(it3));
        MnemonicCode mnemonicCode = this.mnemonic;
        if (mnemonicCode != null) {
            MnemonicCode it4 = mnemonicCode;
            boolean bl5 = false;
            commands.add("-m");
            commands.add(CollectionsKt.joinToString$default((Iterable)it4.getWords(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        }
        String string2 = this.forkUrl;
        if (string2 != null) {
            String it5 = string2;
            boolean bl6 = false;
            commands.add("-f");
            commands.add(it5);
        }
        Long l2 = this.forkBlockNumber;
        if (l2 != null) {
            long it6 = ((Number)l2).longValue();
            boolean bl7 = false;
            commands.add("--fork-block-number");
            commands.add(String.valueOf(it6));
        }
        Hash hash = this.forkTransactionHash;
        if (hash != null) {
            Hash it7 = hash;
            boolean bl8 = false;
            commands.add("--fork-transaction-hash");
            commands.add(it7.toString());
        }
        if (Intrinsics.areEqual((Object)this.autoImpersonate, (Object)true)) {
            commands.add("--auto-impersonate");
        }
        Iterable $this$forEach$iv = this.additionalArgs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it8 = (String)element$iv;
            boolean bl9 = false;
            commands.add(it8);
        }
        Process process = new ProcessBuilder(new String[0]).command((List<String>)commands).start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> AnvilBuilder.spawn$lambda$20(process)));
        int port = this.port;
        ArrayList<PrivateKeySigner> accounts = new ArrayList<PrivateKeySigner>();
        long startTime = System.currentTimeMillis();
        InputStream inputStream = process.getInputStream();
        Object object = Charsets.UTF_8;
        Object object2 = new InputStreamReader(inputStream, (Charset)object);
        int n = 8192;
        BufferedReader reader = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
        object = process.getErrorStream();
        object2 = Charsets.UTF_8;
        String[] stringArray = (String[])new InputStreamReader((InputStream)object, (Charset)object2);
        int n2 = 8192;
        BufferedReader errorReader = stringArray instanceof BufferedReader ? (BufferedReader)stringArray : new BufferedReader((Reader)stringArray, n2);
        while (true) {
            if (System.currentTimeMillis() - startTime > this.spawnTimeout) {
                return ResultKt.failure((Result.Error)new Error.SpawnTimeout(this.spawnTimeout));
            }
            if (errorReader.ready()) {
                StringBuilder fullError = new StringBuilder();
                while (errorReader.readLine() != null) {
                    fullError.append("\n").append((String)nextErrorLine);
                }
                return ResultKt.failure((Result.Error)new Error.SpawnError(fullError.toString()));
            }
            if (!reader.ready()) {
                Thread.sleep(10L);
                continue;
            }
            line = reader.readLine();
            if (StringsKt.startsWith$default((String)line, (String)"Listening on", (boolean)false, (int)2, null)) break;
            if (!StringsKt.startsWith$default((String)line, (String)"Private Keys", (boolean)false, (int)2, null)) continue;
            while (!StringsKt.startsWith$default((String)(line = reader.readLine()), (String)"(", (boolean)false, (int)2, null)) {
            }
            do {
                String hexKey;
                if ((hexKey = (String)StringsKt.split$default((CharSequence)line, (String[])(stringArray = new String[]{" "}), (boolean)false, (int)0, (int)6, null).get(1)).length() != 66 || !FastHex.isValidHex((CharSequence)hexKey)) {
                    return ResultKt.failure((Result.Error)new Error.SpawnError("Invalid private key format: " + hexKey));
                }
                accounts.add(new PrivateKeySigner(hexKey));
            } while (((CharSequence)(line = reader.readLine())).length() > 0 && StringsKt.startsWith$default((String)line, (String)"(", (boolean)false, (int)2, null));
        }
        nextErrorLine = new String[]{":"};
        port = Integer.parseInt(((Object)StringsKt.trim((CharSequence)((String)StringsKt.split$default((CharSequence)line, (String[])nextErrorLine, (boolean)false, (int)0, (int)6, null).get(1)))).toString());
        return ResultKt.success((Object)new AnvilInstance(process, port, (List<PrivateKeySigner>)accounts, this.chainId));
    }

    private static final void spawn$lambda$20(Process $process) {
        $process.destroy();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lio/ethers/providers/bindings/AnvilBuilder$Companion;", "", "<init>", "()V", "HARDHAT_CHAIN_ID", "", "DEFAULT_SPAWN_TIMEOUT", "ethers-providers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lio/ethers/providers/bindings/AnvilBuilder$Error;", "Lio/ethers/core/Result$Error;", "SpawnTimeout", "SpawnError", "Lio/ethers/providers/bindings/AnvilBuilder$Error$SpawnError;", "Lio/ethers/providers/bindings/AnvilBuilder$Error$SpawnTimeout;", "ethers-providers"})
    public static interface Error
    extends Result.Error {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lio/ethers/providers/bindings/AnvilBuilder$Error$SpawnError;", "Lio/ethers/providers/bindings/AnvilBuilder$Error;", "error", "", "<init>", "(Ljava/lang/String;)V", "getError", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "ethers-providers"})
        public static final class SpawnError
        implements Error {
            @NotNull
            private final String error;

            public SpawnError(@NotNull String error) {
                this.error = error;
            }

            @NotNull
            public final String getError() {
                return this.error;
            }

            @NotNull
            public final String component1() {
                return this.error;
            }

            @NotNull
            public final SpawnError copy(@NotNull String error) {
                return new SpawnError(error);
            }

            public static /* synthetic */ SpawnError copy$default(SpawnError spawnError, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = spawnError.error;
                }
                return spawnError.copy(string);
            }

            @NotNull
            public String toString() {
                return "SpawnError(error=" + this.error + ")";
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SpawnError)) {
                    return false;
                }
                SpawnError spawnError = (SpawnError)other;
                return Intrinsics.areEqual((Object)this.error, (Object)spawnError.error);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lio/ethers/providers/bindings/AnvilBuilder$Error$SpawnTimeout;", "Lio/ethers/providers/bindings/AnvilBuilder$Error;", "spawnTimeout", "", "<init>", "(J)V", "getSpawnTimeout", "()J", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "ethers-providers"})
        public static final class SpawnTimeout
        implements Error {
            private final long spawnTimeout;

            public SpawnTimeout(long spawnTimeout) {
                this.spawnTimeout = spawnTimeout;
            }

            public final long getSpawnTimeout() {
                return this.spawnTimeout;
            }

            public final long component1() {
                return this.spawnTimeout;
            }

            @NotNull
            public final SpawnTimeout copy(long spawnTimeout) {
                return new SpawnTimeout(spawnTimeout);
            }

            public static /* synthetic */ SpawnTimeout copy$default(SpawnTimeout spawnTimeout, long l, int n, Object object) {
                if ((n & 1) != 0) {
                    l = spawnTimeout.spawnTimeout;
                }
                return spawnTimeout.copy(l);
            }

            @NotNull
            public String toString() {
                return "SpawnTimeout(spawnTimeout=" + this.spawnTimeout + ")";
            }

            public int hashCode() {
                return Long.hashCode(this.spawnTimeout);
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SpawnTimeout)) {
                    return false;
                }
                SpawnTimeout spawnTimeout = (SpawnTimeout)other;
                return this.spawnTimeout == spawnTimeout.spawnTimeout;
            }
        }
    }
}

