/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.crypto.bip39;

import io.ethers.crypto.bip39.MnemonicWordList;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.bouncycastle.jcajce.provider.digest.SHA256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0015"}, d2={"Lio/ethers/crypto/bip39/MnemonicWordListEnglish;", "Lio/ethers/crypto/bip39/MnemonicWordList;", "<init>", "()V", "BIP39_ENGLISH_SHA256", "", "separator", "", "getSeparator", "()C", "words", "", "getWords", "()Ljava/util/List;", "equals", "", "other", "", "hashCode", "", "toString", "ethers-crypto"})
@SourceDebugExtension(value={"SMAP\nMnemonicWordListEnglish.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MnemonicWordListEnglish.kt\nio/ethers/crypto/bip39/MnemonicWordListEnglish\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,31:1\n1869#2,2:32\n*S KotlinDebug\n*F\n+ 1 MnemonicWordListEnglish.kt\nio/ethers/crypto/bip39/MnemonicWordListEnglish\n*L\n22#1:32,2\n*E\n"})
public final class MnemonicWordListEnglish
implements MnemonicWordList {
    @NotNull
    public static final MnemonicWordListEnglish INSTANCE;
    @NotNull
    private static final String BIP39_ENGLISH_SHA256 = "ad90bf3beb7b0eb7e5acd74727dc0da96e0a280a258354e7293fb7e211ac03db";
    private static final char separator;
    @NotNull
    private static final List<String> words;

    private MnemonicWordListEnglish() {
    }

    @Override
    public char getSeparator() {
        return separator;
    }

    @Override
    @NotNull
    public List<String> getWords() {
        return words;
    }

    @NotNull
    public String toString() {
        return "MnemonicWordListEnglish";
    }

    @Override
    public int hashCode() {
        return -34422669;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MnemonicWordListEnglish)) {
            return false;
        }
        MnemonicWordListEnglish cfr_ignored_0 = (MnemonicWordListEnglish)other;
        return true;
    }

    static {
        InputStream stream;
        INSTANCE = new MnemonicWordListEnglish();
        separator = (char)32;
        InputStream inputStream = MnemonicWordListEnglish.class.getResourceAsStream("/bip39/wordlist_english.txt");
        if (inputStream == null) {
            throw new RuntimeException("English wordlist not found");
        }
        InputStream inputStream2 = stream = inputStream;
        Charset charset = Charsets.UTF_8;
        Reader reader = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        words = TextStreamsKt.readLines((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)));
        SHA256.Digest sha256 = new SHA256.Digest();
        Iterable $this$forEach$iv = INSTANCE.getWords();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            byte[] byArray = it.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            sha256.update(byArray);
        }
        byte[] digest = sha256.digest();
        String digestHex = new BigInteger(1, digest).toString(16);
        if (!Intrinsics.areEqual((Object)digestHex, (Object)BIP39_ENGLISH_SHA256)) {
            throw new RuntimeException("Invalid SHA256 digest for english wordlist. Expected: 'ad90bf3beb7b0eb7e5acd74727dc0da96e0a280a258354e7293fb7e211ac03db', got: '" + digestHex + "'");
        }
    }
}

