/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi.error;

import io.ethers.abi.AbiCodec;
import io.ethers.abi.AbiFunction;
import io.ethers.abi.AbiType;
import io.ethers.abi.error.ContractError;
import io.ethers.core.types.Bytes;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lio/ethers/abi/error/PanicError;", "Lio/ethers/abi/error/ContractError;", "kind", "Lio/ethers/abi/error/PanicError$Kind;", "<init>", "(Lio/ethers/abi/error/PanicError$Kind;)V", "getKind", "()Lio/ethers/abi/error/PanicError$Kind;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Kind", "Companion", "ethers-abi"})
public final class PanicError
extends ContractError {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Kind kind;
    @JvmField
    @NotNull
    public static final AbiFunction FUNCTION = new AbiFunction("Panic", CollectionsKt.listOf((Object)new AbiType.UInt(256)), CollectionsKt.emptyList());

    public PanicError(@NotNull Kind kind) {
        super(null);
        this.kind = kind;
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NotNull
    public final Kind component1() {
        return this.kind;
    }

    @NotNull
    public final PanicError copy(@NotNull Kind kind) {
        return new PanicError(kind);
    }

    public static /* synthetic */ PanicError copy$default(PanicError panicError, Kind kind, int n, Object object) {
        if ((n & 1) != 0) {
            kind = panicError.kind;
        }
        return panicError.copy(kind);
    }

    @NotNull
    public String toString() {
        return "PanicError(kind=" + this.kind + ")";
    }

    public int hashCode() {
        return this.kind.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PanicError)) {
            return false;
        }
        PanicError panicError = (PanicError)other;
        return this.kind == panicError.kind;
    }

    @JvmStatic
    @Nullable
    public static final PanicError getOrNull(@NotNull Bytes data) {
        return Companion.getOrNull(data);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lio/ethers/abi/error/PanicError$Companion;", "", "<init>", "()V", "FUNCTION", "Lio/ethers/abi/AbiFunction;", "getOrNull", "Lio/ethers/abi/error/PanicError;", "data", "Lio/ethers/core/types/Bytes;", "ethers-abi"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final PanicError getOrNull(@NotNull Bytes data) {
            if (data.getSize() < 4) {
                return null;
            }
            if (!Arrays.equals(data.asByteArray(), 0, 4, FUNCTION.getSelector().asByteArray(), 0, 4)) {
                return null;
            }
            ?[] decoded = AbiCodec.decodeWithPrefix(FUNCTION.getSelector().getSize(), FUNCTION.getInputs(), data.asByteArray());
            Object obj = decoded[0];
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger errorCode = (BigInteger)obj;
            int n = ((Collection)Kind.getEntries()).size();
            for (int i = 0; i < n; ++i) {
                Kind kind = (Kind)((Object)Kind.getEntries().get(i));
                if (!Intrinsics.areEqual((Object)kind.getCode(), (Object)errorCode)) continue;
                return new PanicError(kind);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000f\u00a8\u0006\u0013"}, d2={"Lio/ethers/abi/error/PanicError$Kind;", "", "code", "", "<init>", "(Ljava/lang/String;II)V", "GENERIC", "ASSERT_FAILED", "UNDERFLOW_OVERFLOW", "DIVIDE_BY_ZERO", "ENUM_CONVERSION_FAILED", "STORAGE_ENCODING_ERROR", "POP_ON_EMPTY_ARRAY", "INDEX_OUT_OF_BOUNDS", "OUT_OF_MEMORY", "INVALID_INTERNAL_FUNCTION", "Ljava/math/BigInteger;", "getCode", "()Ljava/math/BigInteger;", "ethers-abi"})
    public static final class Kind
    extends Enum<Kind> {
        @NotNull
        private final BigInteger code;
        public static final /* enum */ Kind GENERIC = new Kind(0);
        public static final /* enum */ Kind ASSERT_FAILED = new Kind(1);
        public static final /* enum */ Kind UNDERFLOW_OVERFLOW = new Kind(17);
        public static final /* enum */ Kind DIVIDE_BY_ZERO = new Kind(18);
        public static final /* enum */ Kind ENUM_CONVERSION_FAILED = new Kind(33);
        public static final /* enum */ Kind STORAGE_ENCODING_ERROR = new Kind(34);
        public static final /* enum */ Kind POP_ON_EMPTY_ARRAY = new Kind(49);
        public static final /* enum */ Kind INDEX_OUT_OF_BOUNDS = new Kind(50);
        public static final /* enum */ Kind OUT_OF_MEMORY = new Kind(65);
        public static final /* enum */ Kind INVALID_INTERNAL_FUNCTION = new Kind(81);
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Kind(int code) {
            BigInteger bigInteger = BigInteger.valueOf(code);
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
            this.code = bigInteger;
        }

        @NotNull
        public final BigInteger getCode() {
            return this.code;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value) {
            return Enum.valueOf(Kind.class, value);
        }

        @NotNull
        public static EnumEntries<Kind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.GENERIC, Kind.ASSERT_FAILED, Kind.UNDERFLOW_OVERFLOW, Kind.DIVIDE_BY_ZERO, Kind.ENUM_CONVERSION_FAILED, Kind.STORAGE_ENCODING_ERROR, Kind.POP_ON_EMPTY_ARRAY, Kind.INDEX_OUT_OF_BOUNDS, Kind.OUT_OF_MEMORY, Kind.INVALID_INTERNAL_FUNCTION};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

