/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi.call;

import io.ethers.abi.call.Multicall3;
import io.ethers.abi.call.ReadContractCall;
import io.ethers.abi.error.ContractError;
import io.ethers.abi.error.DecodingError;
import io.ethers.core.Result;
import io.ethers.core.ResultKt;
import io.ethers.core.types.Address;
import io.ethers.core.types.BlockId;
import io.ethers.core.types.BlockOverride;
import io.ethers.core.types.Bytes;
import io.ethers.core.types.IntoCallRequest;
import io.ethers.core.types.StateOverride;
import io.ethers.providers.RpcError;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.RpcRequest;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\f\u0010\rJ0\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\u001c\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00130\u001b2\u0006\u0010\u001c\u001a\u00020\tH\u0016R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00028\u00000\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00008TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lio/ethers/abi/call/ReadFunctionCall;", "T", "Lio/ethers/abi/call/ReadContractCall;", "Lio/ethers/abi/call/Multicall3$Aggregatable;", "provider", "Lio/ethers/providers/middleware/Middleware;", "to", "Lio/ethers/core/types/Address;", "data", "Lio/ethers/core/types/Bytes;", "decoder", "Ljava/util/function/Function;", "<init>", "(Lio/ethers/providers/middleware/Middleware;Lio/ethers/core/types/Address;Lio/ethers/core/types/Bytes;Ljava/util/function/Function;)V", "self", "getSelf", "()Lio/ethers/abi/call/ReadFunctionCall;", "doCall", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/abi/error/ContractError;", "blockId", "Lio/ethers/core/types/BlockId;", "stateOverride", "Lio/ethers/core/types/StateOverride;", "blockOverride", "Lio/ethers/core/types/BlockOverride;", "decodeCallResult", "Lio/ethers/core/Result;", "result", "ethers-abi"})
public final class ReadFunctionCall<T>
extends ReadContractCall<T, ReadFunctionCall<T>>
implements Multicall3.Aggregatable<T> {
    @NotNull
    private final java.util.function.Function<Bytes, T> decoder;

    public ReadFunctionCall(@NotNull Middleware provider, @NotNull Address to, @Nullable Bytes data, @NotNull java.util.function.Function<Bytes, T> decoder) {
        super(provider);
        this.decoder = decoder;
        this.getCall().setTo(to);
        this.getCall().setData(data);
    }

    @Override
    @NotNull
    protected ReadFunctionCall<T> getSelf() {
        return this;
    }

    @Override
    @NotNull
    protected RpcRequest<T, ContractError> doCall(@NotNull BlockId blockId, @Nullable StateOverride stateOverride, @Nullable BlockOverride blockOverride) {
        return this.getProvider().call((IntoCallRequest)this.getCall(), blockId, stateOverride, blockOverride).mapError(new Result.Transformer(this){
            final /* synthetic */ ReadFunctionCall<T> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final ContractError invoke(RpcError p0) {
                return this.$tmp0.tryDecodingContractRevert(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, ReadFunctionCall.class, "tryDecodingContractRevert", "tryDecodingContractRevert(Lio/ethers/providers/RpcError;)Lio/ethers/abi/error/ContractError;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof Result.Transformer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }).andThen(new Result.Transformer(this){
            final /* synthetic */ ReadFunctionCall<T> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final Result<T, ContractError> invoke(Bytes p0) {
                return this.$tmp0.decodeCallResult(p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, ReadFunctionCall.class, "decodeCallResult", "decodeCallResult(Lio/ethers/core/types/Bytes;)Lio/ethers/core/Result;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof Result.Transformer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
    }

    @Override
    @NotNull
    public Result<T, ContractError> decodeCallResult(@NotNull Bytes result) {
        Result result2;
        try {
            result2 = ResultKt.success(this.decoder.apply(result));
        }
        catch (Exception e) {
            result2 = ResultKt.failure((Result.Error)new DecodingError(result, "Unable to decode result", e));
        }
        return result2;
    }
}

