/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi;

import io.ethers.abi.ContractEvent;
import io.ethers.abi.EventFactory;
import io.ethers.core.Result;
import io.ethers.core.types.Address;
import io.ethers.core.types.BlockId;
import io.ethers.core.types.Hash;
import io.ethers.core.types.Log;
import io.ethers.core.types.LogFilter;
import io.ethers.providers.RpcError;
import io.ethers.providers.SubscriptionStream;
import io.ethers.providers.middleware.Middleware;
import io.ethers.providers.types.FilterPoller;
import io.ethers.providers.types.RpcRequest;
import io.ethers.providers.types.RpcSubscribe;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u00002\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0011\u0012\u0004\u0012\u00020\u00120\u0010J\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00120\u0014J\u0018\u0010\u0015\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0016\u0012\u0004\u0012\u00020\u00120\u0010J\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0002J\u001b\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0002\u0010!J\u001b\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00020\"2\u0006\u0010 \u001a\u00020\"\u00a2\u0006\u0002\u0010#J\u001b\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00020$2\u0006\u0010 \u001a\u00020$\u00a2\u0006\u0002\u0010%J\u001b\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00020\"2\u0006\u0010 \u001a\u00020$\u00a2\u0006\u0002\u0010&J\u001b\u0010\u001d\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00020$2\u0006\u0010 \u001a\u00020\"\u00a2\u0006\u0002\u0010'J\u0013\u0010(\u001a\u00028\u00012\u0006\u0010)\u001a\u00020*\u00a2\u0006\u0002\u0010+J\u0013\u0010(\u001a\u00028\u00012\u0006\u0010)\u001a\u00020,\u00a2\u0006\u0002\u0010-J\u0013\u0010(\u001a\u00028\u00012\u0006\u0010.\u001a\u00020\u001f\u00a2\u0006\u0002\u0010/J\u0013\u0010(\u001a\u00028\u00012\u0006\u0010.\u001a\u00020\"\u00a2\u0006\u0002\u00100J\u0013\u0010(\u001a\u00028\u00012\u0006\u00101\u001a\u00020$\u00a2\u0006\u0002\u00102J\u0013\u00103\u001a\u00028\u00012\u0006\u00103\u001a\u000204\u00a2\u0006\u0002\u00105J\u001f\u00103\u001a\u00028\u00012\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020407\"\u000204\u00a2\u0006\u0002\u00108J\u0019\u00103\u001a\u00028\u00012\f\u00106\u001a\b\u0012\u0004\u0012\u00020409\u00a2\u0006\u0002\u0010:J\u0013\u0010;\u001a\u00028\u00012\u0006\u0010)\u001a\u00020*\u00a2\u0006\u0002\u0010+J\u0013\u0010;\u001a\u00028\u00012\u0006\u0010<\u001a\u00020=\u00a2\u0006\u0002\u0010>J\u0013\u0010;\u001a\u00028\u00012\u0006\u00103\u001a\u000204\u00a2\u0006\u0002\u00105J\u001f\u0010;\u001a\u00028\u00012\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020*07\"\u00020*\u00a2\u0006\u0002\u0010@J\u001f\u0010;\u001a\u00028\u00012\u0012\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020=07\"\u00020=\u00a2\u0006\u0002\u0010BJ\u001f\u0010;\u001a\u00028\u00012\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020407\"\u000204\u00a2\u0006\u0002\u00108J\u0019\u0010;\u001a\u00028\u00012\f\u0010?\u001a\b\u0012\u0004\u0012\u00020*09\u00a2\u0006\u0002\u0010:J\u0013\u0010C\u001a\u00028\u00012\u0006\u0010)\u001a\u00020*\u00a2\u0006\u0002\u0010+J\u0013\u0010C\u001a\u00028\u00012\u0006\u0010<\u001a\u00020=\u00a2\u0006\u0002\u0010>J\u0013\u0010C\u001a\u00028\u00012\u0006\u00103\u001a\u000204\u00a2\u0006\u0002\u00105J\u001f\u0010C\u001a\u00028\u00012\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020*07\"\u00020*\u00a2\u0006\u0002\u0010@J\u001f\u0010C\u001a\u00028\u00012\u0012\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020=07\"\u00020=\u00a2\u0006\u0002\u0010BJ\u001f\u0010C\u001a\u00028\u00012\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020407\"\u000204\u00a2\u0006\u0002\u00108J\u0019\u0010C\u001a\u00028\u00012\f\u0010?\u001a\b\u0012\u0004\u0012\u00020*09\u00a2\u0006\u0002\u0010:J\u0013\u0010D\u001a\u00028\u00012\u0006\u0010)\u001a\u00020*\u00a2\u0006\u0002\u0010+J\u0013\u0010D\u001a\u00028\u00012\u0006\u0010<\u001a\u00020=\u00a2\u0006\u0002\u0010>J\u0013\u0010D\u001a\u00028\u00012\u0006\u00103\u001a\u000204\u00a2\u0006\u0002\u00105J\u001f\u0010D\u001a\u00028\u00012\u0012\u0010?\u001a\n\u0012\u0006\b\u0001\u0012\u00020*07\"\u00020*\u00a2\u0006\u0002\u0010@J\u001f\u0010D\u001a\u00028\u00012\u0012\u0010A\u001a\n\u0012\u0006\b\u0001\u0012\u00020=07\"\u00020=\u00a2\u0006\u0002\u0010BJ\u001f\u0010D\u001a\u00028\u00012\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020407\"\u000204\u00a2\u0006\u0002\u00108J\u0019\u0010D\u001a\u00028\u00012\f\u0010?\u001a\b\u0012\u0004\u0012\u00020*09\u00a2\u0006\u0002\u0010:R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0012\u0010\u001a\u001a\u00028\u0001X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006E"}, d2={"Lio/ethers/abi/EventFilterBase;", "T", "Lio/ethers/abi/ContractEvent;", "F", "", "provider", "Lio/ethers/providers/middleware/Middleware;", "factory", "Lio/ethers/abi/EventFactory;", "<init>", "(Lio/ethers/providers/middleware/Middleware;Lio/ethers/abi/EventFactory;)V", "filter", "Lio/ethers/core/types/LogFilter;", "getFilter", "()Lio/ethers/core/types/LogFilter;", "watch", "Lio/ethers/providers/types/RpcRequest;", "Lio/ethers/providers/types/FilterPoller;", "Lio/ethers/providers/RpcError;", "subscribe", "Lio/ethers/providers/types/RpcSubscribe;", "query", "", "decodeMatchingLogs", "logs", "Lio/ethers/core/types/Log;", "self", "getSelf", "()Lio/ethers/abi/EventFilterBase;", "blockRange", "from", "", "to", "(JJ)Lio/ethers/abi/EventFilterBase;", "Lio/ethers/core/types/BlockId$Number;", "(Lio/ethers/core/types/BlockId$Number;Lio/ethers/core/types/BlockId$Number;)Lio/ethers/abi/EventFilterBase;", "Lio/ethers/core/types/BlockId$Name;", "(Lio/ethers/core/types/BlockId$Name;Lio/ethers/core/types/BlockId$Name;)Lio/ethers/abi/EventFilterBase;", "(Lio/ethers/core/types/BlockId$Number;Lio/ethers/core/types/BlockId$Name;)Lio/ethers/abi/EventFilterBase;", "(Lio/ethers/core/types/BlockId$Name;Lio/ethers/core/types/BlockId$Number;)Lio/ethers/abi/EventFilterBase;", "atBlock", "hash", "Lio/ethers/core/types/Hash;", "(Lio/ethers/core/types/Hash;)Lio/ethers/abi/EventFilterBase;", "Lio/ethers/core/types/BlockId$Hash;", "(Lio/ethers/core/types/BlockId$Hash;)Lio/ethers/abi/EventFilterBase;", "number", "(J)Lio/ethers/abi/EventFilterBase;", "(Lio/ethers/core/types/BlockId$Number;)Lio/ethers/abi/EventFilterBase;", "name", "(Lio/ethers/core/types/BlockId$Name;)Lio/ethers/abi/EventFilterBase;", "address", "Lio/ethers/core/types/Address;", "(Lio/ethers/core/types/Address;)Lio/ethers/abi/EventFilterBase;", "addresses", "", "([Lio/ethers/core/types/Address;)Lio/ethers/abi/EventFilterBase;", "", "(Ljava/util/Collection;)Lio/ethers/abi/EventFilterBase;", "topic1", "value", "Ljava/math/BigInteger;", "(Ljava/math/BigInteger;)Lio/ethers/abi/EventFilterBase;", "hashes", "([Lio/ethers/core/types/Hash;)Lio/ethers/abi/EventFilterBase;", "values", "([Ljava/math/BigInteger;)Lio/ethers/abi/EventFilterBase;", "topic2", "topic3", "ethers-abi"})
public abstract class EventFilterBase<T extends ContractEvent, F extends EventFilterBase<T, F>> {
    @NotNull
    private final Middleware provider;
    @NotNull
    private final EventFactory<T> factory;
    @NotNull
    private final LogFilter filter;

    public EventFilterBase(@NotNull Middleware provider, @NotNull EventFactory<T> factory) {
        this.provider = provider;
        this.factory = factory;
        this.filter = new LogFilter();
    }

    @NotNull
    protected final LogFilter getFilter() {
        return this.filter;
    }

    @NotNull
    public final RpcRequest<FilterPoller<T>, RpcError> watch() {
        return this.provider.watchLogs(this.filter).map(arg_0 -> EventFilterBase.watch$lambda$0(this, arg_0));
    }

    @NotNull
    public final RpcSubscribe<T, RpcError> subscribe() {
        return this.provider.subscribeLogs(this.filter).map(arg_0 -> EventFilterBase.subscribe$lambda$3(this, arg_0));
    }

    @NotNull
    public final RpcRequest<List<T>, RpcError> query() {
        return this.provider.getLogs(this.filter).map(new Result.Transformer(this){
            final /* synthetic */ EventFilterBase<T, F> $tmp0;
            {
                this.$tmp0 = $tmp0;
            }

            public final List<T> invoke(List<Log> p0) {
                return EventFilterBase.access$decodeMatchingLogs(this.$tmp0, p0);
            }

            public final Function<?> getFunctionDelegate() {
                return (Function)new FunctionReferenceImpl(1, this.$tmp0, EventFilterBase.class, "decodeMatchingLogs", "decodeMatchingLogs(Ljava/util/List;)Ljava/util/List;", 0);
            }

            public final boolean equals(Object other) {
                return other instanceof Result.Transformer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        });
    }

    private final List<T> decodeMatchingLogs(List<Log> logs) {
        ArrayList<T> ret = new ArrayList<T>(logs.size());
        int n = ((Collection)logs).size();
        for (int i = 0; i < n; ++i) {
            T event;
            if (this.factory.decode(logs.get(i)) == null) continue;
            ret.add(event);
        }
        return ret;
    }

    @NotNull
    protected abstract F getSelf();

    @NotNull
    public final F blockRange(long from, long to) {
        this.filter.blockRange(from, to);
        return this.getSelf();
    }

    @NotNull
    public final F blockRange(@NotNull BlockId.Number from, @NotNull BlockId.Number to) {
        this.filter.blockRange(from, to);
        return this.getSelf();
    }

    @NotNull
    public final F blockRange(@NotNull BlockId.Name from, @NotNull BlockId.Name to) {
        this.filter.blockRange(from, to);
        return this.getSelf();
    }

    @NotNull
    public final F blockRange(@NotNull BlockId.Number from, @NotNull BlockId.Name to) {
        this.filter.blockRange(from, to);
        return this.getSelf();
    }

    @NotNull
    public final F blockRange(@NotNull BlockId.Name from, @NotNull BlockId.Number to) {
        this.filter.blockRange(from, to);
        return this.getSelf();
    }

    @NotNull
    public final F atBlock(@NotNull Hash hash) {
        this.filter.atBlock(hash);
        return this.getSelf();
    }

    @NotNull
    public final F atBlock(@NotNull BlockId.Hash hash) {
        this.filter.atBlock((BlockId)hash);
        return this.getSelf();
    }

    @NotNull
    public final F atBlock(long number) {
        return this.blockRange(number, number);
    }

    @NotNull
    public final F atBlock(@NotNull BlockId.Number number) {
        return this.blockRange(number, number);
    }

    @NotNull
    public final F atBlock(@NotNull BlockId.Name name) {
        return this.blockRange(name, name);
    }

    @NotNull
    public final F address(@NotNull Address address) {
        this.filter.address(address);
        return this.getSelf();
    }

    @NotNull
    public final F address(Address ... addresses) {
        this.filter.address(Arrays.copyOf(addresses, addresses.length));
        return this.getSelf();
    }

    @NotNull
    public final F address(@NotNull Collection<Address> addresses) {
        this.filter.address(addresses);
        return this.getSelf();
    }

    @NotNull
    public final F topic1(@NotNull Hash hash) {
        this.filter.topic1(hash);
        return this.getSelf();
    }

    @NotNull
    public final F topic1(@NotNull BigInteger value) {
        this.filter.topic1(new Hash(value));
        return this.getSelf();
    }

    @NotNull
    public final F topic1(@NotNull Address address) {
        this.filter.topic1(new Hash(address));
        return this.getSelf();
    }

    @NotNull
    public final F topic1(Hash ... hashes) {
        this.filter.topic1(Arrays.copyOf(hashes, hashes.length));
        return this.getSelf();
    }

    @NotNull
    public final F topic1(BigInteger ... values) {
        int n = 0;
        int n2 = values.length;
        Hash[] hashArray = new Hash[n2];
        LogFilter logFilter = this.filter;
        while (n < n2) {
            int n3 = n++;
            hashArray[n3] = new Hash(values[n3]);
        }
        logFilter.topic1(hashArray);
        return this.getSelf();
    }

    @NotNull
    public final F topic1(Address ... addresses) {
        int n = 0;
        int n2 = addresses.length;
        Hash[] hashArray = new Hash[n2];
        LogFilter logFilter = this.filter;
        while (n < n2) {
            int n3 = n++;
            hashArray[n3] = new Hash(addresses[n3]);
        }
        logFilter.topic1(hashArray);
        return this.getSelf();
    }

    @NotNull
    public final F topic1(@NotNull Collection<Hash> hashes) {
        this.filter.topic1(hashes);
        return this.getSelf();
    }

    @NotNull
    public final F topic2(@NotNull Hash hash) {
        this.filter.topic2(hash);
        return this.getSelf();
    }

    @NotNull
    public final F topic2(@NotNull BigInteger value) {
        this.filter.topic2(new Hash(value));
        return this.getSelf();
    }

    @NotNull
    public final F topic2(@NotNull Address address) {
        this.filter.topic2(new Hash(address));
        return this.getSelf();
    }

    @NotNull
    public final F topic2(Hash ... hashes) {
        this.filter.topic2(Arrays.copyOf(hashes, hashes.length));
        return this.getSelf();
    }

    @NotNull
    public final F topic2(BigInteger ... values) {
        int n = 0;
        int n2 = values.length;
        Hash[] hashArray = new Hash[n2];
        LogFilter logFilter = this.filter;
        while (n < n2) {
            int n3 = n++;
            hashArray[n3] = new Hash(values[n3]);
        }
        logFilter.topic2(hashArray);
        return this.getSelf();
    }

    @NotNull
    public final F topic2(Address ... addresses) {
        int n = 0;
        int n2 = addresses.length;
        Hash[] hashArray = new Hash[n2];
        LogFilter logFilter = this.filter;
        while (n < n2) {
            int n3 = n++;
            hashArray[n3] = new Hash(addresses[n3]);
        }
        logFilter.topic2(hashArray);
        return this.getSelf();
    }

    @NotNull
    public final F topic2(@NotNull Collection<Hash> hashes) {
        this.filter.topic2(hashes);
        return this.getSelf();
    }

    @NotNull
    public final F topic3(@NotNull Hash hash) {
        this.filter.topic3(hash);
        return this.getSelf();
    }

    @NotNull
    public final F topic3(@NotNull BigInteger value) {
        this.filter.topic3(new Hash(value));
        return this.getSelf();
    }

    @NotNull
    public final F topic3(@NotNull Address address) {
        this.filter.topic3(new Hash(address));
        return this.getSelf();
    }

    @NotNull
    public final F topic3(Hash ... hashes) {
        this.filter.topic3(Arrays.copyOf(hashes, hashes.length));
        return this.getSelf();
    }

    @NotNull
    public final F topic3(BigInteger ... values) {
        int n = 0;
        int n2 = values.length;
        Hash[] hashArray = new Hash[n2];
        LogFilter logFilter = this.filter;
        while (n < n2) {
            int n3 = n++;
            hashArray[n3] = new Hash(values[n3]);
        }
        logFilter.topic3(hashArray);
        return this.getSelf();
    }

    @NotNull
    public final F topic3(Address ... addresses) {
        int n = 0;
        int n2 = addresses.length;
        Hash[] hashArray = new Hash[n2];
        LogFilter logFilter = this.filter;
        while (n < n2) {
            int n3 = n++;
            hashArray[n3] = new Hash(addresses[n3]);
        }
        logFilter.topic3(hashArray);
        return this.getSelf();
    }

    @NotNull
    public final F topic3(@NotNull Collection<Hash> hashes) {
        this.filter.topic3(hashes);
        return this.getSelf();
    }

    private static final FilterPoller watch$lambda$0(EventFilterBase this$0, FilterPoller it) {
        return it.mapPoller(this$0::decodeMatchingLogs);
    }

    private static final ContractEvent subscribe$lambda$3$lambda$1(EventFilterBase this$0, Log it) {
        return this$0.factory.decode(it);
    }

    private static final boolean subscribe$lambda$3$lambda$2(ContractEvent it) {
        return it != null;
    }

    private static final SubscriptionStream subscribe$lambda$3(EventFilterBase this$0, SubscriptionStream stream) {
        SubscriptionStream subscriptionStream = stream.map(arg_0 -> EventFilterBase.subscribe$lambda$3$lambda$1(this$0, arg_0)).filter(EventFilterBase::subscribe$lambda$3$lambda$2);
        Intrinsics.checkNotNull((Object)subscriptionStream, (String)"null cannot be cast to non-null type io.ethers.providers.SubscriptionStream<T of io.ethers.abi.EventFilterBase>");
        return subscriptionStream;
    }

    public static final /* synthetic */ List access$decodeMatchingLogs(EventFilterBase $this, List logs) {
        return $this.decodeMatchingLogs(logs);
    }
}

