/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi;

import io.ethers.abi.AbiEvent;
import io.ethers.abi.ContractEvent;
import io.ethers.abi.EventFilterBase;
import io.ethers.core.types.Log;
import io.ethers.providers.middleware.Middleware;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003J\u001a\u0010\b\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0017\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a2\u0006\u0002\u0010\u0011J%\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0013H&\u00a2\u0006\u0002\u0010\u0014R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lio/ethers/abi/EventFactory;", "T", "Lio/ethers/abi/ContractEvent;", "", "abi", "Lio/ethers/abi/AbiEvent;", "getAbi", "()Lio/ethers/abi/AbiEvent;", "filter", "Lio/ethers/abi/EventFilterBase;", "provider", "Lio/ethers/providers/middleware/Middleware;", "isLogValid", "", "log", "Lio/ethers/core/types/Log;", "decode", "(Lio/ethers/core/types/Log;)Lio/ethers/abi/ContractEvent;", "data", "", "(Lio/ethers/core/types/Log;[Ljava/lang/Object;)Lio/ethers/abi/ContractEvent;", "ethers-abi"})
public interface EventFactory<T extends ContractEvent> {
    @NotNull
    public AbiEvent getAbi();

    @NotNull
    public EventFilterBase<T, ?> filter(@NotNull Middleware var1);

    default public boolean isLogValid(@NotNull Log log) {
        if (this.getAbi().isAnonymous()) {
            if (this.getAbi().getIndexed().size() != log.getTopics().size()) {
                return false;
            }
            return this.getAbi().getData().isEmpty() == log.getData().isEmpty();
        }
        if (this.getAbi().getIndexed().size() != log.getTopics().size() - 1) {
            return false;
        }
        if (this.getAbi().getData().isEmpty() != log.getData().isEmpty()) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getAbi().getTopicId(), log.getTopics().get(0));
    }

    @Nullable
    default public T decode(@NotNull Log log) {
        Object[] topics = null;
        Object[] data = null;
        int logTopicSize = 0;
        if (this.getAbi().isAnonymous()) {
            logTopicSize = log.getTopics().size();
            if (this.getAbi().getIndexed().size() != logTopicSize) {
                return null;
            }
            if (this.getAbi().getData().isEmpty() != log.getData().isEmpty()) {
                return null;
            }
            topics = logTopicSize == 0 ? new Object[]{} : this.getAbi().decodeTopics(log.getTopics());
            data = this.getAbi().getData().isEmpty() ? new Object[]{} : this.getAbi().decodeData(log.getData());
        } else {
            logTopicSize = log.getTopics().size() - 1;
            if (this.getAbi().getIndexed().size() != logTopicSize) {
                return null;
            }
            if (this.getAbi().getData().isEmpty() != log.getData().isEmpty()) {
                return null;
            }
            if (!Intrinsics.areEqual((Object)this.getAbi().getTopicId(), log.getTopics().get(0))) {
                return null;
            }
            topics = logTopicSize == 0 ? new Object[]{} : this.getAbi().decodeTopics(log.getTopics());
            data = this.getAbi().getData().isEmpty() ? new Object[]{} : this.getAbi().decodeData(log.getData());
        }
        int topicIndex = 0;
        int dataIndex = 0;
        int n = logTopicSize + data.length;
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            objectArray[n2] = this.getAbi().getTokens().get(n2).getIndexed() ? topics[topicIndex++] : data[dataIndex++];
        }
        Object[] merged = objectArray;
        return this.decode(log, merged);
    }

    @NotNull
    public T decode(@NotNull Log var1, @NotNull Object[] var2);
}

