/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi;

import io.ethers.abi.ContractEvent;
import io.ethers.abi.EventFactory;
import io.ethers.abi.EventFilterBase;
import io.ethers.core.types.Address;
import io.ethers.core.types.Hash;
import io.ethers.core.types.LogFilter;
import io.ethers.providers.middleware.Middleware;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00000\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0012\u001a\u00020\u0013J%\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000f0\u0015\"\u00020\u000f\u00a2\u0006\u0002\u0010\u0016J%\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0015\"\u00020\u0011\u00a2\u0006\u0002\u0010\u0018J%\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0012\u0010\u0019\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u0015\"\u00020\u0013\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00008TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lio/ethers/abi/AnonymousEventFilter;", "T", "Lio/ethers/abi/ContractEvent;", "Lio/ethers/abi/EventFilterBase;", "provider", "Lio/ethers/providers/middleware/Middleware;", "factory", "Lio/ethers/abi/EventFactory;", "<init>", "(Lio/ethers/providers/middleware/Middleware;Lio/ethers/abi/EventFactory;)V", "self", "getSelf", "()Lio/ethers/abi/AnonymousEventFilter;", "topic0", "hash", "Lio/ethers/core/types/Hash;", "value", "Ljava/math/BigInteger;", "address", "Lio/ethers/core/types/Address;", "hashes", "", "([Lio/ethers/core/types/Hash;)Lio/ethers/abi/AnonymousEventFilter;", "values", "([Ljava/math/BigInteger;)Lio/ethers/abi/AnonymousEventFilter;", "addresses", "([Lio/ethers/core/types/Address;)Lio/ethers/abi/AnonymousEventFilter;", "", "ethers-abi"})
@SourceDebugExtension(value={"SMAP\nEventFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventFilters.kt\nio/ethers/abi/AnonymousEventFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,428:1\n1#2:429\n*E\n"})
public final class AnonymousEventFilter<T extends ContractEvent>
extends EventFilterBase<T, AnonymousEventFilter<T>> {
    public AnonymousEventFilter(@NotNull Middleware provider, @NotNull EventFactory<T> factory) {
        super(provider, factory);
        if (!factory.getAbi().isAnonymous()) {
            boolean bl = false;
            String string = "Cannot create AnonymousEventFilter for non-anonymous event. Use EventFilter instead.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    protected AnonymousEventFilter<T> getSelf() {
        return this;
    }

    @NotNull
    public final AnonymousEventFilter<T> topic0(@NotNull Hash hash) {
        this.getFilter().topic0(hash);
        return this;
    }

    @NotNull
    public final AnonymousEventFilter<T> topic0(@NotNull BigInteger value) {
        this.getFilter().topic0(new Hash(value));
        return this;
    }

    @NotNull
    public final AnonymousEventFilter<T> topic0(@NotNull Address address) {
        this.getFilter().topic0(new Hash(address));
        return this;
    }

    @NotNull
    public final AnonymousEventFilter<T> topic0(Hash ... hashes) {
        this.getFilter().topic0(Arrays.copyOf(hashes, hashes.length));
        return this;
    }

    @NotNull
    public final AnonymousEventFilter<T> topic0(BigInteger ... values) {
        int n = 0;
        int n2 = values.length;
        Hash[] hashArray = new Hash[n2];
        LogFilter logFilter = this.getFilter();
        while (n < n2) {
            int n3 = n++;
            hashArray[n3] = new Hash(values[n3]);
        }
        logFilter.topic0(hashArray);
        return this;
    }

    @NotNull
    public final AnonymousEventFilter<T> topic0(Address ... addresses) {
        int n = 0;
        int n2 = addresses.length;
        Hash[] hashArray = new Hash[n2];
        LogFilter logFilter = this.getFilter();
        while (n < n2) {
            int n3 = n++;
            hashArray[n3] = new Hash(addresses[n3]);
        }
        logFilter.topic0(hashArray);
        return this;
    }

    @NotNull
    public final AnonymousEventFilter<T> topic0(@NotNull Collection<Hash> hashes) {
        this.getFilter().topic0(hashes);
        return this;
    }
}

