/*
 * Decompiled with CFR 0.152.
 */
package io.ethers.abi;

import io.ethers.abi.AbiCodecKt;
import io.ethers.abi.AbiType;
import io.ethers.abi.Utf8;
import io.ethers.core.FastHex;
import io.ethers.core.types.Address;
import io.ethers.core.types.Bytes;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JE\u0010\u0004\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\rH\u0007\u00a2\u0006\u0002\u0010\u000eJ=\u0010\u000f\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00012\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\rH\u0007\u00a2\u0006\u0002\u0010\u0010J-\u0010\u000f\u001a\u00020\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b2\u0006\u0010\f\u001a\u0002H\u0006H\u0007\u00a2\u0006\u0002\u0010\u0012JC\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00060\r\"\b\b\u0000\u0010\u0006*\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u00152\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u000b0\n2\u0006\u0010\f\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0016J;\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00060\r\"\b\b\u0000\u0010\u0006*\u00020\u00012\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u000b0\n2\u0006\u0010\f\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0017\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00012\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0019J?\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010\u001fJ9\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r2\u0006\u0010\u001e\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u0010 J,\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u0010\"\u001a\u00020\u0015H\u0002J$\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002JP\u0010$\u001a\u0002H%\"\u0004\b\u0000\u0010%2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\r2\u0018\u0010&\u001a\u0014\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u0002H%0'H\u0082\b\u00a2\u0006\u0002\u0010(J\u001c\u0010)\u001a\u00020\u00152\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002J\u001c\u0010*\u001a\u00020\u00152\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0001H\u0002J-\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\u0010\u0010\t\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u00a2\u0006\u0002\u0010,J$\u0010-\u001a\u00020\u00012\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u0015H\u0002J'\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00010\r2\n\u00100\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u00101\u001a\u00020\u0015H\u0002\u00a2\u0006\u0002\u00102J=\u00103\u001a\u00020\b\"\b\b\u0000\u0010\u0006*\u00020\u00012\u0014\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\u000b0\n2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00060\rH\u0007\u00a2\u0006\u0002\u00104J$\u00105\u001a\u00020\u00152\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u00106\u001a\u000207H\u0002J,\u00103\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u00012\u0006\u00106\u001a\u000207H\u0002\u00a8\u00068"}, d2={"Lio/ethers/abi/AbiCodec;", "", "<init>", "()V", "encodeWithPrefix", "", "T", "prefix", "Lio/ethers/core/types/Bytes;", "types", "", "Lio/ethers/abi/AbiType;", "data", "", "(Lio/ethers/core/types/Bytes;Ljava/util/List;[Ljava/lang/Object;)[B", "encode", "(Ljava/util/List;[Ljava/lang/Object;)[B", "type", "(Lio/ethers/abi/AbiType;Ljava/lang/Object;)[B", "decodeWithPrefix", "prefixSize", "", "(ILjava/util/List;[B)[Ljava/lang/Object;", "decode", "(Ljava/util/List;[B)[Ljava/lang/Object;", "(Lio/ethers/abi/AbiType;[B)Ljava/lang/Object;", "encodeTokensHeadTail", "", "buff", "Ljava/nio/ByteBuffer;", "headLength", "(Ljava/nio/ByteBuffer;Ljava/util/List;[Ljava/lang/Object;I)V", "(Ljava/nio/ByteBuffer;Lio/ethers/abi/AbiType;[Ljava/lang/Object;I)V", "encodeTokenHead", "headOffset", "encodeTokenTail", "withHeadTailLengths", "R", "consumer", "Lkotlin/Function2;", "(Ljava/util/List;[Ljava/lang/Object;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "getTokenHeadLength", "getTokenTailLength", "decodeTokens", "(Ljava/util/List;Ljava/nio/ByteBuffer;)[Ljava/lang/Object;", "decodeToken", "currOffset", "getTypedArrayForElementType", "elementType", "size", "(Lio/ethers/abi/AbiType;I)[Ljava/lang/Object;", "encodePacked", "(Ljava/util/List;[Ljava/lang/Object;)Lio/ethers/core/types/Bytes;", "packEncodedSize", "inArray", "", "ethers-abi"})
@SourceDebugExtension(value={"SMAP\nAbiCodec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbiCodec.kt\nio/ethers/abi/AbiCodec\n*L\n1#1,846:1\n381#1,7:847\n381#1,7:854\n*S KotlinDebug\n*F\n+ 1 AbiCodec.kt\nio/ethers/abi/AbiCodec\n*L\n32#1:847,7\n53#1:854,7\n*E\n"})
public final class AbiCodec {
    @NotNull
    public static final AbiCodec INSTANCE = new AbiCodec();

    private AbiCodec() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final <T> byte[] encodeWithPrefix(@NotNull Bytes prefix, @NotNull List<? extends AbiType<? extends T>> types, @NotNull T[] data) {
        void tail;
        if (types.isEmpty()) {
            return prefix.asByteArray();
        }
        if (types.size() != data.length) {
            throw new IllegalArgumentException("Expected " + types.size() + " arguments, got " + data.length);
        }
        AbiCodec this_$iv = INSTANCE;
        boolean $i$f$withHeadTailLengths = false;
        int head$iv = 0;
        int tail$iv = 0;
        int n = ((Collection)types).size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            head$iv += this_$iv.getTokenHeadLength(types.get(i$iv), data[i$iv]);
            tail$iv += this_$iv.getTokenTailLength(types.get(i$iv), data[i$iv]);
        }
        int n2 = tail$iv;
        int head = head$iv;
        boolean bl = false;
        ByteBuffer ret = ByteBuffer.allocate(prefix.getSize() + head + tail);
        ret.put(prefix.asByteArray());
        INSTANCE.encodeTokensHeadTail(ret, types, (Object[])data, head);
        return ret.array();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final <T> byte[] encode(@NotNull List<? extends AbiType<? extends T>> types, @NotNull T[] data) {
        void tail;
        if (types.isEmpty()) {
            throw new IllegalArgumentException("Cannot encode empty tokens");
        }
        if (types.size() != data.length) {
            throw new IllegalArgumentException("Expected " + types.size() + " arguments, got " + data.length);
        }
        AbiCodec this_$iv = INSTANCE;
        boolean $i$f$withHeadTailLengths = false;
        int head$iv = 0;
        int tail$iv = 0;
        int n = ((Collection)types).size();
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            head$iv += this_$iv.getTokenHeadLength(types.get(i$iv), data[i$iv]);
            tail$iv += this_$iv.getTokenTailLength(types.get(i$iv), data[i$iv]);
        }
        int n2 = tail$iv;
        int head = head$iv;
        boolean bl = false;
        ByteBuffer ret = ByteBuffer.allocate(head + tail);
        INSTANCE.encodeTokensHeadTail(ret, types, (Object[])data, head);
        return ret.array();
    }

    @JvmStatic
    @NotNull
    public static final <T> byte[] encode(@NotNull AbiType<T> type, @NotNull T data) {
        int head = INSTANCE.getTokenHeadLength(type, data);
        int tail = INSTANCE.getTokenTailLength(type, data);
        ByteBuffer ret = ByteBuffer.allocate(head + tail);
        INSTANCE.encodeTokenHead(ret, type, data, head);
        INSTANCE.encodeTokenTail(ret, type, data);
        return ret.array();
    }

    @JvmStatic
    @NotNull
    public static final <T> T[] decodeWithPrefix(int prefixSize, @NotNull List<? extends AbiType<? extends T>> types, @NotNull byte[] data) {
        if (data.length < prefixSize) {
            throw new IllegalArgumentException("Data is too short: " + data.length);
        }
        if (types.isEmpty() && data.length > prefixSize) {
            throw new IllegalArgumentException("Expected empty input, got: " + FastHex.encodeWithoutPrefix((byte[])data));
        }
        if (!((Collection)types).isEmpty() && data.length == prefixSize) {
            throw new IllegalArgumentException("Expected input, got empty data");
        }
        if (types.isEmpty()) {
            return new Object[0];
        }
        return INSTANCE.decodeTokens(types, ByteBuffer.wrap(data).position(prefixSize));
    }

    @JvmStatic
    @NotNull
    public static final <T> T[] decode(@NotNull List<? extends AbiType<? extends T>> types, @NotNull byte[] data) {
        if (types.isEmpty()) {
            throw new IllegalArgumentException("Cannot decode empty tokens");
        }
        if (data.length < 32) {
            throw new IllegalArgumentException("Cannot decode empty data: " + FastHex.encodeWithoutPrefix((byte[])data));
        }
        return INSTANCE.decodeTokens(types, ByteBuffer.wrap(data));
    }

    @JvmStatic
    @NotNull
    public static final <T> T decode(@NotNull AbiType<T> type, @NotNull byte[] data) {
        if (data.length < 32) {
            throw new IllegalArgumentException("Cannot decode empty data: " + FastHex.encodeWithoutPrefix((byte[])data));
        }
        Object object = INSTANCE.decodeToken(type, ByteBuffer.wrap(data), 0);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of io.ethers.abi.AbiCodec.decode");
        return (T)object;
    }

    private final void encodeTokensHeadTail(ByteBuffer buff, List<? extends AbiType<?>> types, Object[] data, int headLength) {
        int i;
        int headOffset = headLength;
        int n = ((Collection)types).size();
        for (i = 0; i < n; ++i) {
            this.encodeTokenHead(buff, types.get(i), data[i], headOffset);
            headOffset += this.getTokenTailLength(types.get(i), data[i]);
        }
        n = ((Collection)types).size();
        for (i = 0; i < n; ++i) {
            this.encodeTokenTail(buff, types.get(i), data[i]);
        }
    }

    private final void encodeTokensHeadTail(ByteBuffer buff, AbiType<?> type, Object[] data, int headLength) {
        int i;
        int headOffset = headLength;
        int n = data.length;
        for (i = 0; i < n; ++i) {
            this.encodeTokenHead(buff, type, data[i], headOffset);
            headOffset += this.getTokenTailLength(type, data[i]);
        }
        n = data.length;
        for (i = 0; i < n; ++i) {
            this.encodeTokenTail(buff, type, data[i]);
        }
    }

    private final void encodeTokenHead(ByteBuffer buff, AbiType<?> type, Object data, int headOffset) {
        ByteBuffer byteBuffer;
        AbiType<?> abiType = type;
        if (Intrinsics.areEqual(abiType, (Object)AbiType.Address.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Address");
            Address value = (Address)data;
            buff.position(buff.position() + 12);
            byteBuffer = buff.put(value.asByteArray());
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.Bool.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Boolean");
            boolean value = (Boolean)data;
            buff.position(buff.position() + 31);
            byteBuffer = buff.put(value ? (byte)1 : 0);
        } else if (abiType instanceof AbiType.Int) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger v = (BigInteger)data;
            if (v.bitLength() > ((AbiType.Int)type).getBitSize() - 1) {
                throw new IllegalArgumentException("Provided INT value has more than " + (((AbiType.Int)type).getBitSize() - 1) + " bits: " + v.bitLength());
            }
            if (v.signum() == -1) {
                byte[] arr = v.toByteArray();
                buff.put(AbiCodecKt.access$getTWOS_COMPLEMENT_PADDING$p()[32 - arr.length]);
                buff.put(arr);
                return;
            }
            byte[] arr = v.toByteArray();
            if (arr.length == 33 && arr[0] == 0) {
                byteBuffer = buff.put(arr, 1, 32);
            } else {
                buff.position(buff.position() + (32 - arr.length));
                byteBuffer = buff.put(arr);
            }
        } else if (abiType instanceof AbiType.UInt) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger v = (BigInteger)data;
            if (v.signum() == -1) {
                throw new IllegalArgumentException("Expected UINT, got INT: " + v);
            }
            if (v.bitLength() > ((AbiType.UInt)type).getBitSize()) {
                throw new IllegalArgumentException("Provided UINT value has more than " + ((AbiType.UInt)type).getBitSize() + " bits: " + v.bitLength());
            }
            byte[] arr = v.toByteArray();
            if (arr.length > 33 || arr.length == 33 && arr[0] != 0) {
                throw new IllegalArgumentException("Provided value has more than 256 bits: " + v);
            }
            if (arr.length == 33 && arr[0] == 0) {
                byteBuffer = buff.put(arr, 1, 32);
            } else {
                buff.position(buff.position() + (32 - arr.length));
                byteBuffer = buff.put(arr);
            }
        } else if (abiType instanceof AbiType.FixedBytes) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
            Bytes value = (Bytes)data;
            if (value.getSize() != ((AbiType.FixedBytes)type).getLength()) {
                throw new IllegalArgumentException("Provided value has length " + value.getSize() + ", expected " + ((AbiType.FixedBytes)type).getLength());
            }
            int rem = 32 - value.getSize();
            buff.put(value.asByteArray());
            if (rem > 0) {
                buff.position(buff.position() + rem);
            }
            byteBuffer = Unit.INSTANCE;
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.Bytes.INSTANCE) || Intrinsics.areEqual(abiType, (Object)AbiType.String.INSTANCE) || abiType instanceof AbiType.Array) {
            buff.position(buff.position() + 28);
            byteBuffer = buff.putInt(headOffset);
        } else if (abiType instanceof AbiType.FixedArray) {
            if (((AbiType.FixedArray)type).isDynamic()) {
                buff.position(buff.position() + 28);
                buff.putInt(headOffset);
                return;
            }
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] value = (Object[])data;
            if (value.length != ((AbiType.FixedArray)type).getLength()) {
                throw new IllegalArgumentException("Provided value has length " + value.length + ", expected " + ((AbiType.FixedArray)type).getLength());
            }
            int n = value.length;
            for (int i = 0; i < n; ++i) {
                AbiType abiType2 = ((AbiType.FixedArray)type).getType();
                Object object = value[i];
                Intrinsics.checkNotNull((Object)object);
                this.encodeTokenHead(buff, abiType2, object, headOffset);
            }
            byteBuffer = Unit.INSTANCE;
        } else if (abiType instanceof AbiType.Tuple) {
            if (((AbiType.Tuple)type).isDynamic()) {
                buff.position(buff.position() + 28);
                buff.putInt(headOffset);
                return;
            }
            Object[] value = ((AbiType.Tuple)type).dataAsTuple(data);
            if (value.length != ((AbiType.Tuple)type).getTypes().size()) {
                throw new IllegalArgumentException("Provided value has length " + value.length + ", expected " + ((AbiType.Tuple)type).getTypes().size());
            }
            int n = ((Collection)((AbiType.Tuple)type).getTypes()).size();
            for (int i = 0; i < n; ++i) {
                this.encodeTokenHead(buff, ((AbiType.Tuple)type).getTypes().get(i), value[i], headOffset);
            }
            byteBuffer = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void encodeTokenTail(ByteBuffer buff, AbiType<?> type, Object data) {
        AbiType<?> abiType = type;
        if (!(Intrinsics.areEqual(abiType, (Object)AbiType.Address.INSTANCE) || Intrinsics.areEqual(abiType, (Object)AbiType.Bool.INSTANCE) || abiType instanceof AbiType.Int || abiType instanceof AbiType.UInt || abiType instanceof AbiType.FixedBytes)) {
            if (Intrinsics.areEqual(abiType, (Object)AbiType.Bytes.INSTANCE)) {
                Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
                byte[] value = ((Bytes)data).asByteArray();
                buff.position(buff.position() + 28);
                buff.putInt(value.length);
                int numOfWords = (value.length + 32 - 1) / 32;
                for (int i = 0; i < numOfWords; ++i) {
                    int start = i * 32;
                    int end = Math.min(start + 32, value.length);
                    int length = end - start;
                    buff.put(value, start, length);
                    if (length >= 32) continue;
                    buff.position(buff.position() + (32 - length));
                }
            } else if (Intrinsics.areEqual(abiType, (Object)AbiType.String.INSTANCE)) {
                Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.String");
                byte[] byArray = ((String)data).getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] value = byArray;
                buff.position(buff.position() + 28);
                buff.putInt(value.length);
                int numOfWords = (value.length + 32 - 1) / 32;
                for (int i = 0; i < numOfWords; ++i) {
                    int start = i * 32;
                    int end = Math.min(start + 32, value.length);
                    int length = end - start;
                    buff.put(value, start, length);
                    if (length >= 32) continue;
                    buff.position(buff.position() + (32 - length));
                }
            } else if (abiType instanceof AbiType.Array) {
                Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
                Object[] value = (Object[])data;
                buff.position(buff.position() + 28);
                buff.putInt(value.length);
                if (!(value.length == 0)) {
                    int headLength = 0;
                    int n = value.length;
                    for (int i = 0; i < n; ++i) {
                        headLength += this.getTokenHeadLength(((AbiType.Array)type).getType(), value[i]);
                    }
                    this.encodeTokensHeadTail(buff, ((AbiType.Array)type).getType(), value, headLength);
                }
            } else if (abiType instanceof AbiType.FixedArray) {
                if (!((AbiType.FixedArray)type).isDynamic()) {
                    return;
                }
                Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
                Object[] value = (Object[])data;
                if (value.length != ((AbiType.FixedArray)type).getLength()) {
                    throw new IllegalArgumentException("Provided value has length " + value.length + ", expected " + ((AbiType.FixedArray)type).getLength());
                }
                int headLength = 0;
                int n = value.length;
                for (int i = 0; i < n; ++i) {
                    headLength += this.getTokenHeadLength(((AbiType.FixedArray)type).getType(), value[i]);
                }
                this.encodeTokensHeadTail(buff, ((AbiType.FixedArray)type).getType(), value, headLength);
            } else if (abiType instanceof AbiType.Tuple) {
                if (!((AbiType.Tuple)type).isDynamic()) {
                    return;
                }
                Object[] value = ((AbiType.Tuple)type).dataAsTuple(data);
                if (value.length != ((AbiType.Tuple)type).getTypes().size()) {
                    throw new IllegalArgumentException("Provided value has length " + value.length + ", expected " + ((AbiType.Tuple)type).getTypes().size());
                }
                int headLength = 0;
                int n = value.length;
                for (int i = 0; i < n; ++i) {
                    headLength += this.getTokenHeadLength(((AbiType.Tuple)type).getTypes().get(i), value[i]);
                }
                this.encodeTokensHeadTail(buff, ((AbiType.Tuple)type).getTypes(), value, headLength);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final <R> R withHeadTailLengths(List<? extends AbiType<?>> types, Object[] data, Function2<? super Integer, ? super Integer, ? extends R> consumer) {
        boolean $i$f$withHeadTailLengths = false;
        int head = 0;
        int tail = 0;
        int n = ((Collection)types).size();
        for (int i = 0; i < n; ++i) {
            head += this.getTokenHeadLength(types.get(i), data[i]);
            tail += this.getTokenTailLength(types.get(i), data[i]);
        }
        return (R)consumer.invoke((Object)head, (Object)tail);
    }

    private final int getTokenHeadLength(AbiType<?> type, Object data) {
        int n;
        AbiType<?> abiType = type;
        if (Intrinsics.areEqual(abiType, (Object)AbiType.Address.INSTANCE)) {
            n = 32;
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.Bool.INSTANCE)) {
            n = 32;
        } else if (abiType instanceof AbiType.FixedBytes) {
            n = 32;
        } else if (abiType instanceof AbiType.Int || abiType instanceof AbiType.UInt) {
            n = 32;
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.Bytes.INSTANCE)) {
            n = 32;
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.String.INSTANCE)) {
            n = 32;
        } else if (abiType instanceof AbiType.Array) {
            n = 32;
        } else if (abiType instanceof AbiType.FixedArray) {
            if (((AbiType.FixedArray)type).isDynamic()) {
                return 32;
            }
            int headLength = 0;
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] values = (Object[])data;
            int n2 = values.length;
            for (int i = 0; i < n2; ++i) {
                AbiType abiType2 = ((AbiType.FixedArray)type).getType();
                Object object = ((Object[])data)[i];
                Intrinsics.checkNotNull((Object)object);
                headLength += this.getTokenHeadLength(abiType2, object);
            }
            n = headLength;
        } else if (abiType instanceof AbiType.Tuple) {
            if (((AbiType.Tuple)type).isDynamic()) {
                return 32;
            }
            int headLength = 0;
            Object[] value = ((AbiType.Tuple)type).dataAsTuple(data);
            int n3 = ((Collection)((AbiType.Tuple)type).getTypes()).size();
            for (int i = 0; i < n3; ++i) {
                headLength += this.getTokenHeadLength(((AbiType.Tuple)type).getTypes().get(i), value[i]);
            }
            n = headLength;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final int getTokenTailLength(AbiType<?> type, Object data) {
        int n;
        AbiType<?> abiType = type;
        if (Intrinsics.areEqual(abiType, (Object)AbiType.Address.INSTANCE)) {
            n = 0;
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.Bool.INSTANCE)) {
            n = 0;
        } else if (abiType instanceof AbiType.FixedBytes) {
            n = 0;
        } else if (abiType instanceof AbiType.Int || abiType instanceof AbiType.UInt) {
            n = 0;
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.Bytes.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
            Bytes value = (Bytes)data;
            int numOfWords = (value.getSize() + 32 - 1) / 32;
            n = 32 + numOfWords * 32;
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.String.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.String");
            int utf8Length = Utf8.INSTANCE.encodedLength((String)data);
            int numOfWords = (utf8Length + 32 - 1) / 32;
            n = 32 + numOfWords * 32;
        } else if (abiType instanceof AbiType.Array) {
            int length = 0;
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] value = (Object[])data;
            int n2 = value.length;
            for (int i = 0; i < n2; ++i) {
                Object v;
                Intrinsics.checkNotNull((Object)value[i]);
                length += this.getTokenHeadLength(((AbiType.Array)type).getType(), v) + this.getTokenTailLength(((AbiType.Array)type).getType(), v);
            }
            n = 32 + length;
        } else if (abiType instanceof AbiType.FixedArray) {
            if (!((AbiType.FixedArray)type).isDynamic()) {
                return 0;
            }
            int length = 0;
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] value = (Object[])data;
            int n3 = value.length;
            for (int i = 0; i < n3; ++i) {
                Object v;
                Intrinsics.checkNotNull((Object)value[i]);
                length += this.getTokenHeadLength(((AbiType.FixedArray)type).getType(), v) + this.getTokenTailLength(((AbiType.FixedArray)type).getType(), v);
            }
            n = length;
        } else if (abiType instanceof AbiType.Tuple) {
            if (!((AbiType.Tuple)type).isDynamic()) {
                return 0;
            }
            int length = 0;
            Object[] value = ((AbiType.Tuple)type).dataAsTuple(data);
            int n4 = ((Collection)((AbiType.Tuple)type).getTypes()).size();
            for (int i = 0; i < n4; ++i) {
                Object v = value[i];
                length += this.getTokenHeadLength(((AbiType.Tuple)type).getTypes().get(i), v) + this.getTokenTailLength(((AbiType.Tuple)type).getTypes().get(i), v);
            }
            n = length;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final Object[] decodeTokens(List<? extends AbiType<?>> types, ByteBuffer buff) {
        AbiType<?> type = types.get(0);
        boolean ofSingleType = true;
        int n = ((Collection)types).size();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual(types.get(i).getClassType(), type.getClassType())) continue;
            ofSingleType = false;
            break;
        }
        Object[] ret = ofSingleType ? this.getTypedArrayForElementType(type, types.size()) : new Object[types.size()];
        int offset = buff.position();
        int n2 = ((Collection)types).size();
        for (int i = 0; i < n2; ++i) {
            ret[i] = this.decodeToken(types.get(i), buff, offset);
        }
        return ret;
    }

    private final Object decodeToken(AbiType<?> type, ByteBuffer buff, int currOffset) {
        AbiType<?> abiType = type;
        if (Intrinsics.areEqual(abiType, (Object)AbiType.Address.INSTANCE)) {
            byte[] arr = new byte[20];
            AbiCodecKt.access$skip(buff, 12).get(arr);
            return new Address(arr);
        }
        if (Intrinsics.areEqual(abiType, (Object)AbiType.Bool.INSTANCE)) {
            return AbiCodecKt.access$skip(buff, 31).get() == 1;
        }
        if (abiType instanceof AbiType.FixedBytes) {
            byte[] arr = new byte[((AbiType.FixedBytes)type).getLength()];
            AbiCodecKt.access$skip(buff.get(arr), 32 - ((AbiType.FixedBytes)type).getLength());
            return new Bytes(arr);
        }
        if (abiType instanceof AbiType.Int) {
            BigInteger ret = new BigInteger(buff.array(), buff.position(), 32);
            AbiCodecKt.access$skip(buff, 32);
            return ret;
        }
        if (abiType instanceof AbiType.UInt) {
            BigInteger ret = new BigInteger(1, buff.array(), buff.position(), 32);
            AbiCodecKt.access$skip(buff, 32);
            return ret;
        }
        if (Intrinsics.areEqual(abiType, (Object)AbiType.Bytes.INSTANCE)) {
            int offset = currOffset + AbiCodecKt.access$skip(buff, 28).getInt();
            int endPosition = buff.position();
            int length = AbiCodecKt.access$skip(buff.position(offset), 28).getInt();
            byte[] arr = new byte[length];
            buff.get(arr).position(endPosition);
            return new Bytes(arr);
        }
        if (Intrinsics.areEqual(abiType, (Object)AbiType.String.INSTANCE)) {
            int offset = currOffset + AbiCodecKt.access$skip(buff, 28).getInt();
            int endPosition = buff.position();
            int length = AbiCodecKt.access$skip(buff.position(offset), 28).getInt();
            String ret = new String(buff.array(), buff.position(), length, Charsets.UTF_8);
            buff.position(endPosition);
            return ret;
        }
        if (abiType instanceof AbiType.Array) {
            int offset = currOffset + AbiCodecKt.access$skip(buff, 28).getInt();
            int endPosition = buff.position();
            int length = AbiCodecKt.access$skip(buff.position(offset), 28).getInt();
            offset += 32;
            Object[] arr = this.getTypedArrayForElementType(((AbiType.Array)type).getType(), length);
            for (int i = 0; i < length; ++i) {
                arr[i] = this.decodeToken(((AbiType.Array)type).getType(), buff, offset);
            }
            buff.position(endPosition);
            return arr;
        }
        if (abiType instanceof AbiType.FixedArray) {
            Object[] arr = this.getTypedArrayForElementType(((AbiType.FixedArray)type).getType(), ((AbiType.FixedArray)type).getLength());
            if (((AbiType.FixedArray)type).isDynamic()) {
                int offset = currOffset + AbiCodecKt.access$skip(buff, 28).getInt();
                int endPosition = buff.position();
                buff.position(offset);
                int n = ((AbiType.FixedArray)type).getLength();
                for (int i = 0; i < n; ++i) {
                    arr[i] = this.decodeToken(((AbiType.FixedArray)type).getType(), buff, offset);
                }
                buff.position(endPosition);
            } else {
                int endPosition = ((AbiType.FixedArray)type).getLength();
                for (int i = 0; i < endPosition; ++i) {
                    arr[i] = this.decodeToken(((AbiType.FixedArray)type).getType(), buff, currOffset);
                }
            }
            return arr;
        }
        if (abiType instanceof AbiType.Tuple) {
            Object[] arr = new Object[((AbiType.Tuple)type).getTypes().size()];
            if (((AbiType.Tuple)type).isDynamic()) {
                int offset = currOffset + AbiCodecKt.access$skip(buff, 28).getInt();
                int endPosition = buff.position();
                buff.position(offset);
                int n = arr.length;
                for (int i = 0; i < n; ++i) {
                    arr[i] = this.decodeToken(((AbiType.Tuple)type).getTypes().get(i), buff, offset);
                }
                buff.position(endPosition);
            } else {
                int n = arr.length;
                for (int i = 0; i < n; ++i) {
                    arr[i] = this.decodeToken(((AbiType.Tuple)type).getTypes().get(i), buff, currOffset);
                }
            }
            return ((AbiType.Tuple)type).getFactory().apply(arr);
        }
        throw new NoWhenBranchMatchedException();
    }

    private final Object[] getTypedArrayForElementType(AbiType<?> elementType, int size) {
        Object[] objectArray;
        AbiType<?> abiType = elementType;
        if (abiType instanceof AbiType.Address) {
            objectArray = new Address[size];
        } else if (abiType instanceof AbiType.String) {
            objectArray = new String[size];
        } else if (abiType instanceof AbiType.FixedBytes || abiType instanceof AbiType.Bytes) {
            objectArray = new Bytes[size];
        } else if (abiType instanceof AbiType.Int || abiType instanceof AbiType.UInt) {
            objectArray = new BigInteger[size];
        } else if (abiType instanceof AbiType.Bool) {
            objectArray = new Boolean[size];
        } else if (abiType instanceof AbiType.FixedArray) {
            Object object = Array.newInstance(((AbiType.FixedArray)elementType).getClassType(), size);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
            objectArray = (Object[])object;
        } else if (abiType instanceof AbiType.Array) {
            Object object = Array.newInstance(((AbiType.Array)elementType).getClassType(), size);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
            objectArray = (Object[])object;
        } else if (abiType instanceof AbiType.Tuple) {
            Object object = Array.newInstance(((AbiType.Tuple)elementType).getClassType(), size);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<kotlin.Any>");
            objectArray = (Object[])object;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return objectArray;
    }

    @JvmStatic
    @NotNull
    public static final <T> Bytes encodePacked(@NotNull List<? extends AbiType<? extends T>> types, @NotNull T[] data) {
        int encodedSize = 0;
        int n = ((Collection)types).size();
        for (int i = 0; i < n; ++i) {
            encodedSize += INSTANCE.packEncodedSize(types.get(i), data[i], false);
        }
        ByteBuffer ret = ByteBuffer.allocate(encodedSize);
        int n2 = ((Collection)types).size();
        for (int i = 0; i < n2; ++i) {
            INSTANCE.encodePacked(ret, types.get(i), data[i], false);
        }
        return new Bytes(ret.array());
    }

    private final int packEncodedSize(AbiType<?> type, Object data, boolean inArray) {
        int n;
        AbiType<?> abiType = type;
        if (Intrinsics.areEqual(abiType, (Object)AbiType.Address.INSTANCE)) {
            n = inArray ? 32 : 20;
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.Bool.INSTANCE)) {
            n = inArray ? 32 : 1;
        } else if (abiType instanceof AbiType.FixedBytes) {
            n = inArray ? 32 : ((AbiType.FixedBytes)type).getLength();
        } else if (abiType instanceof AbiType.Int) {
            n = inArray ? 32 : ((AbiType.Int)type).getBitSize() / 8;
        } else if (abiType instanceof AbiType.UInt) {
            n = inArray ? 32 : ((AbiType.UInt)type).getBitSize() / 8;
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.Bytes.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
            n = ((Bytes)data).getSize();
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.String.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.String");
            n = Utf8.INSTANCE.encodedLength((String)data);
        } else if (abiType instanceof AbiType.Array) {
            if (((AbiType.Array)type).getType().isDynamic() || ((AbiType.Array)type).getType() instanceof AbiType.Array) {
                throw new IllegalArgumentException("Cannot encode dynamic or nested arrays in packed format");
            }
            int size = 0;
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] values = (Object[])data;
            int n2 = values.length;
            for (int i = 0; i < n2; ++i) {
                AbiType abiType2 = ((AbiType.Array)type).getType();
                Object object = values[i];
                Intrinsics.checkNotNull((Object)object);
                size += this.packEncodedSize(abiType2, object, true);
            }
            n = size;
        } else if (abiType instanceof AbiType.FixedArray) {
            if (((AbiType.FixedArray)type).getType().isDynamic() || ((AbiType.FixedArray)type).getType() instanceof AbiType.Array) {
                throw new IllegalArgumentException("Cannot encode dynamic or nested arrays in packed format");
            }
            int size = 0;
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] values = (Object[])data;
            int n3 = values.length;
            for (int i = 0; i < n3; ++i) {
                AbiType abiType3 = ((AbiType.FixedArray)type).getType();
                Object object = values[i];
                Intrinsics.checkNotNull((Object)object);
                size += this.packEncodedSize(abiType3, object, true);
            }
            n = size;
        } else {
            if (abiType instanceof AbiType.Tuple) {
                throw new IllegalArgumentException("Cannot encode tuple in packed format");
            }
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    private final void encodePacked(ByteBuffer buff, AbiType<?> type, Object data, boolean inArray) {
        ByteBuffer byteBuffer;
        AbiType<?> abiType = type;
        if (Intrinsics.areEqual(abiType, (Object)AbiType.Address.INSTANCE)) {
            if (inArray) {
                AbiCodecKt.access$skip(buff, 12);
            }
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Address");
            byteBuffer = buff.put(((Address)data).asByteArray());
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.Bool.INSTANCE)) {
            if (inArray) {
                AbiCodecKt.access$skip(buff, 31);
            }
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Boolean");
            byteBuffer = buff.put((Boolean)data != false ? (byte)1 : 0);
        } else if (abiType instanceof AbiType.FixedBytes) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
            Bytes value = (Bytes)data;
            if (value.getSize() != ((AbiType.FixedBytes)type).getLength()) {
                throw new IllegalArgumentException("Provided value has length " + value.getSize() + ", expected " + ((AbiType.FixedBytes)type).getLength());
            }
            buff.put(value.asByteArray());
            if (inArray) {
                AbiCodecKt.access$skip(buff, ((AbiType.FixedBytes)type).getLength() - value.getSize());
            }
            byteBuffer = Unit.INSTANCE;
        } else if (abiType instanceof AbiType.Int) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger v = (BigInteger)data;
            if (v.bitLength() > ((AbiType.Int)type).getBitSize() - 1) {
                throw new IllegalArgumentException("Provided INT value has more than " + (((AbiType.Int)type).getBitSize() - 1) + " bits: " + v.bitLength());
            }
            byte[] arr = v.toByteArray();
            if (v.signum() == -1) {
                ByteBuffer byteBuffer2 = inArray ? buff.put(AbiCodecKt.access$getTWOS_COMPLEMENT_PADDING$p()[32 - arr.length]) : buff.put(AbiCodecKt.access$getTWOS_COMPLEMENT_PADDING$p()[((AbiType.Int)type).getBitSize() / 8 - arr.length]);
                buff.put(arr);
                return;
            }
            ByteBuffer byteBuffer3 = inArray ? AbiCodecKt.access$skip(buff, 32 - arr.length) : AbiCodecKt.access$skip(buff, ((AbiType.Int)type).getBitSize() / 8 - arr.length);
            byteBuffer = buff.put(arr);
        } else if (abiType instanceof AbiType.UInt) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type java.math.BigInteger");
            BigInteger v = (BigInteger)data;
            if (v.signum() == -1) {
                throw new IllegalArgumentException("Expected UINT, got INT: " + v);
            }
            if (v.bitLength() > ((AbiType.UInt)type).getBitSize()) {
                throw new IllegalArgumentException("Provided UINT value has more than " + ((AbiType.UInt)type).getBitSize() + " bits: " + v.bitLength());
            }
            byte[] arr = v.toByteArray();
            if (arr.length > 33 || arr.length == 33 && arr[0] != 0) {
                throw new IllegalArgumentException("Provided value has more than 256 bits: " + v);
            }
            if (arr.length == 33 && arr[0] == 0) {
                byteBuffer = buff.put(arr, 1, 32);
            } else {
                ByteBuffer byteBuffer4 = inArray ? AbiCodecKt.access$skip(buff, 32 - arr.length) : AbiCodecKt.access$skip(buff, ((AbiType.UInt)type).getBitSize() / 8 - arr.length);
                byteBuffer = buff.put(arr);
            }
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.Bytes.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type io.ethers.core.types.Bytes");
            byteBuffer = buff.put(((Bytes)data).asByteArray());
        } else if (Intrinsics.areEqual(abiType, (Object)AbiType.String.INSTANCE)) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.String");
            byte[] byArray = ((String)data).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            byteBuffer = buff.put(byArray);
        } else if (abiType instanceof AbiType.Array) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] values = (Object[])data;
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                AbiType abiType2 = ((AbiType.Array)type).getType();
                Object object = values[i];
                Intrinsics.checkNotNull((Object)object);
                this.encodePacked(buff, abiType2, object, true);
            }
            byteBuffer = Unit.INSTANCE;
        } else if (abiType instanceof AbiType.FixedArray) {
            Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type kotlin.Array<*>");
            Object[] values = (Object[])data;
            if (values.length != ((AbiType.FixedArray)type).getLength()) {
                throw new IllegalArgumentException("Provided value has length " + values.length + ", expected " + ((AbiType.FixedArray)type).getLength());
            }
            int n = values.length;
            for (int i = 0; i < n; ++i) {
                AbiType abiType3 = ((AbiType.FixedArray)type).getType();
                Object object = values[i];
                Intrinsics.checkNotNull((Object)object);
                this.encodePacked(buff, abiType3, object, true);
            }
            byteBuffer = Unit.INSTANCE;
        } else {
            if (abiType instanceof AbiType.Tuple) {
                throw new IllegalArgumentException("Cannot encode tuple in packed format");
            }
            throw new NoWhenBranchMatchedException();
        }
    }
}

