/*
 * Decompiled with CFR 0.152.
 */
package io.kri.anotherViewPager;

import android.support.design.widget.TabLayout;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import io.kri.anotherViewPager.TabbedViewPagerItem;
import java.util.ArrayList;
import java.util.List;

public class TabbedViewPagerAdapter
extends PagerAdapter {
    private List<TabbedViewPagerItem> tabbedViewPagerItems;
    private TabLayout tabLayout;

    public Object instantiateItem(ViewGroup collection, int position) {
        TabbedViewPagerItem item = this.tabbedViewPagerItems.get(position);
        item.bindItem(collection.getContext(), collection);
        collection.addView(item.getItem());
        return item.getItem();
    }

    public List<TabbedViewPagerItem> getTabbedViewPagerItems() {
        if (this.tabbedViewPagerItems == null || this.tabbedViewPagerItems.isEmpty()) {
            throw new RuntimeException("Adapter is empty");
        }
        return this.tabbedViewPagerItems;
    }

    private void populateTabs() {
        for (int position = 0; position < this.tabbedViewPagerItems.size(); ++position) {
            TabbedViewPagerItem item = this.tabbedViewPagerItems.get(position);
            this.updateTab(position, item);
        }
    }

    private void updateTab(int position, TabbedViewPagerItem item) {
        if (this.tabLayout.getTabAt(position) == null) {
            return;
        }
        View view = item.getTabWithCustomView(this.tabLayout.getContext());
        if (view != null) {
            this.tabLayout.getTabAt(position).setCustomView(view);
        } else {
            this.tabLayout.getTabAt(position).setText((CharSequence)item.getTitle());
        }
    }

    public TabbedViewPagerItem getItemAtPosition(int position) {
        if (this.tabbedViewPagerItems == null || this.tabbedViewPagerItems.isEmpty()) {
            throw new RuntimeException("Adapter is empty");
        }
        if (this.tabbedViewPagerItems.get(position) == null) {
            throw new RuntimeException("No item at position" + position);
        }
        return this.tabbedViewPagerItems.get(position);
    }

    public TabbedViewPagerAdapter addItem(TabbedViewPagerItem item) {
        if (this.tabbedViewPagerItems == null) {
            this.tabbedViewPagerItems = new ArrayList<TabbedViewPagerItem>();
        }
        this.tabbedViewPagerItems.add(item);
        this.notifyDataSetChanged();
        return this;
    }

    public void destroyItem(ViewGroup collection, int position, Object view) {
        collection.removeView((View)view);
    }

    public int getCount() {
        if (this.tabbedViewPagerItems == null) {
            return 0;
        }
        return this.tabbedViewPagerItems.size();
    }

    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    public CharSequence getPageTitle(int position) {
        if (this.tabbedViewPagerItems == null || this.tabbedViewPagerItems.isEmpty()) {
            throw new RuntimeException("Adapter is empty");
        }
        if (this.tabbedViewPagerItems.get(position) == null) {
            throw new RuntimeException("No item at position" + position);
        }
        return this.tabbedViewPagerItems.get(position).getTitle();
    }

    public void setTabLayout(TabLayout tabLayout) {
        this.tabLayout = tabLayout;
        this.populateTabs();
    }
}

