/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.resource;

import io.kjson.resource.Resource;
import io.kjson.resource.ResourceDescriptor;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0015\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010\u0013J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u001a\u001a\u00020\u001bR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lio/kjson/resource/ResourceLoader;", "T", "", "()V", "defaultExtension", "", "getDefaultExtension", "()Ljava/lang/String;", "defaultMIMEType", "getDefaultMIMEType", "addExtension", "s", "checkHTTP", "", "conn", "Ljava/net/HttpURLConnection;", "load", "rd", "Lio/kjson/resource/ResourceDescriptor;", "(Lio/kjson/resource/ResourceDescriptor;)Ljava/lang/Object;", "resource", "Lio/kjson/resource/Resource;", "resourceFile", "Ljava/io/File;", "resourceURL", "Ljava/net/URL;", "resourcePath", "Ljava/nio/file/Path;", "resource-loader"})
public abstract class ResourceLoader<T> {
    @Nullable
    private final String defaultExtension;
    @Nullable
    private final String defaultMIMEType;

    @Nullable
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    @Nullable
    public String getDefaultMIMEType() {
        return this.defaultMIMEType;
    }

    public abstract T load(@NotNull ResourceDescriptor var1);

    public boolean checkHTTP(@NotNull HttpURLConnection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        return true;
    }

    @NotNull
    public final Resource<T> resource(@NotNull File resourceFile) {
        Intrinsics.checkNotNullParameter((Object)resourceFile, (String)"resourceFile");
        Path path = resourceFile.toPath();
        URL uRL = resourceFile.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"resourceFile.toURI().toURL()");
        return new Resource(path, uRL, this);
    }

    @NotNull
    public final Resource<T> resource(@NotNull Path resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        URL uRL = resourcePath.toUri().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"resourcePath.toUri().toURL()");
        return new Resource(resourcePath, uRL, this);
    }

    @NotNull
    public final Resource<T> resource(@NotNull URL resourceURL) {
        Intrinsics.checkNotNullParameter((Object)resourceURL, (String)"resourceURL");
        return new Resource(Resource.Companion.derivePath(resourceURL), resourceURL, this);
    }

    @NotNull
    public final String addExtension(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return this.getDefaultExtension() != null && StringsKt.indexOf$default((CharSequence)s, (char)'.', (int)(StringsKt.lastIndexOf$default((CharSequence)s, (char)File.separatorChar, (int)0, (boolean)false, (int)6, null) + 1), (boolean)false, (int)4, null) < 0 ? s + '.' + this.getDefaultExtension() : s;
    }
}

