/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.resource;

import io.kjson.resource.ResourceDescriptor;
import io.kjson.resource.ResourceLoaderException;
import io.kjson.resource.ResourceNotFoundException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 \u001e*\u0004\b\u0000\u0010\u0001*\u0014\b\u0001\u0010\u0002*\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u00002\u00020\u0003:\u0001\u001eB\u0019\b\u0004\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000b\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0014J\u0015\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0015\u001a\u00020\u0016H&\u00a2\u0006\u0002\u0010\u0017J\u0013\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0018\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0019J\u0015\u0010\u001a\u001a\u00028\u00012\u0006\u0010\u0018\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u001c\u001a\u00028\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\u001dR\u0016\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lio/kjson/resource/ResourceLoader;", "T", "R", "", "resourcePath", "Ljava/nio/file/Path;", "resourceURL", "Ljava/net/URL;", "(Ljava/nio/file/Path;Ljava/net/URL;)V", "defaultExtension", "", "getDefaultExtension", "()Ljava/lang/String;", "getResourceURL", "()Ljava/net/URL;", "checkHTTP", "", "conn", "Ljava/net/HttpURLConnection;", "load", "()Ljava/lang/Object;", "rd", "Lio/kjson/resource/ResourceDescriptor;", "(Lio/kjson/resource/ResourceDescriptor;)Ljava/lang/Object;", "name", "(Ljava/lang/String;)Ljava/lang/Object;", "resolve", "(Ljava/lang/String;)Lio/kjson/resource/ResourceLoader;", "resolvedLoader", "(Ljava/nio/file/Path;Ljava/net/URL;)Lio/kjson/resource/ResourceLoader;", "Companion", "resource-loader"})
public abstract class ResourceLoader<T, R extends ResourceLoader<T, R>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Path resourcePath;
    @NotNull
    private final URL resourceURL;
    @Nullable
    private final String defaultExtension;
    @NotNull
    private static final File currentDirectory = new File(".");
    private static final char separator = File.separatorChar;
    @NotNull
    private static final Map<String, FileSystem> fileSystemCache;

    protected ResourceLoader(@Nullable Path resourcePath, @NotNull URL resourceURL) {
        Intrinsics.checkNotNullParameter((Object)resourceURL, (String)"resourceURL");
        this.resourcePath = resourcePath;
        this.resourceURL = resourceURL;
    }

    @NotNull
    public final URL getResourceURL() {
        return this.resourceURL;
    }

    @Nullable
    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public abstract T load(@NotNull ResourceDescriptor var1);

    @NotNull
    public abstract R resolvedLoader(@Nullable Path var1, @NotNull URL var2);

    public final T load(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ((ResourceLoader)this.resolve(name)).load();
    }

    /*
     * WARNING - void declaration
     */
    public final T load() {
        T t;
        Instant instant;
        Object object;
        Object object2 = this.resourcePath;
        if (object2 != null) {
            Path path = object2;
            boolean bl = false;
            boolean bl2 = false;
            Path path2 = path;
            boolean bl3 = false;
            if (!Files.exists(path2, new LinkOption[0]) || Files.isDirectory(path2, new LinkOption[0])) {
                throw new ResourceNotFoundException(this.getResourceURL());
            }
            long size = Files.size(path2);
            Instant time = Files.getLastModifiedTime(path2, new LinkOption[0]).toInstant();
            InputStream inputStream = Files.newInputStream(path2, new OpenOption[0]);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(path)");
            return this.load(new ResourceDescriptor(inputStream, null, size, time, null, 18, null));
        }
        object2 = this.resourceURL.openConnection();
        boolean bl = false;
        boolean bl4 = false;
        Object conn = object2;
        boolean bl5 = false;
        Long bl3 = ((URLConnection)conn).getContentLengthLong();
        boolean bl6 = false;
        boolean bl7 = false;
        long it = ((Number)bl3).longValue();
        boolean bl82 = false;
        Long contentLength = it >= 0L ? bl3 : null;
        Object object3 = ((URLConnection)conn).getLastModified();
        boolean bl9 = false;
        boolean bl10 = false;
        long it2 = ((Number)object3).longValue();
        boolean bl11 = false;
        Object object4 = object = it2 != 0L ? object3 : null;
        if (object == null) {
            instant = null;
        } else {
            object3 = object;
            bl9 = false;
            bl10 = false;
            it2 = ((Number)object3).longValue();
            boolean bl12 = false;
            instant = Instant.ofEpochMilli(it2);
        }
        Instant lastModified = instant;
        object = conn;
        if (object instanceof HttpURLConnection) {
            String string;
            InputStream contentType;
            Object object5;
            Intrinsics.checkNotNullExpressionValue((Object)conn, (String)"conn");
            if (!this.checkHTTP((HttpURLConnection)conn)) {
                throw new ResourceLoaderException(Intrinsics.stringPlus((String)"Connection vetoed - ", (Object)this.getResourceURL()));
            }
            if (((HttpURLConnection)conn).getResponseCode() == 404) {
                throw new ResourceNotFoundException(this.getResourceURL());
            }
            if (((HttpURLConnection)conn).getResponseCode() != 200) {
                throw new IOException("Error status - " + ((HttpURLConnection)conn).getResponseCode() + " - " + this.getResourceURL());
            }
            String string2 = ((HttpURLConnection)conn).getContentType();
            if (string2 == null) {
                object5 = null;
            } else {
                char[] bl82 = new char[]{';'};
                List list = StringsKt.split$default((CharSequence)string2, (char[])bl82, (boolean)false, (int)0, (int)6, null);
                if (list == null) {
                    object5 = null;
                } else {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list;
                    boolean $i$f$map = false;
                    Iterable bl12 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it3;
                        String string3 = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl13 = false;
                        String string4 = Companion.strim((String)it3);
                        collection.add(string4);
                    }
                    object5 = (List)destination$iv$iv;
                }
            }
            InputStream inputStream = contentType = object5;
            if (inputStream == null) {
                string = null;
            } else {
                String string5;
                Object v4;
                block18: {
                    void $this$findStartingFrom$iv;
                    Companion $i$f$map = Companion;
                    InputStream $this$mapTo$iv$iv = inputStream;
                    int index$iv = 1;
                    boolean $i$f$findStartingFrom = false;
                    int n = index$iv;
                    int n2 = $this$findStartingFrom$iv.size();
                    if (n < n2) {
                        do {
                            int i$iv = n++;
                            Object e = $this$findStartingFrom$iv.get(i$iv);
                            boolean bl14 = false;
                            boolean bl15 = false;
                            Object it$iv = e;
                            boolean bl16 = false;
                            String it4 = (String)it$iv;
                            boolean bl17 = false;
                            if (!StringsKt.startsWith$default((String)it4, (String)"charset=", (boolean)false, (int)2, null)) continue;
                            v4 = it$iv;
                            break block18;
                        } while (n < n2);
                    }
                    v4 = null;
                }
                String string6 = v4;
                string = string6 == null ? null : ((string5 = StringsKt.drop((String)string6, (int)8)) == null ? null : Companion.strim(string5));
            }
            String charsetName = string;
            inputStream = ((URLConnection)conn).getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"conn.getInputStream()");
            InputStream inputStream2 = inputStream;
            inputStream = contentType;
            t = this.load(new ResourceDescriptor(inputStream2, charsetName, contentLength, lastModified, inputStream == null ? null : (String)inputStream.get(0)));
        } else {
            object3 = ((URLConnection)conn).getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"conn.getInputStream()");
            t = this.load(new ResourceDescriptor((InputStream)object3, null, contentLength, lastModified, ((URLConnection)conn).getContentType()));
        }
        return t;
    }

    public boolean checkHTTP(@NotNull HttpURLConnection conn) {
        Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
        return true;
    }

    @NotNull
    public R resolve(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String extendedName = Companion.addExtension(name, this.getDefaultExtension());
        if (new URI(extendedName).getScheme() == null && this.resourcePath != null) {
            Path resolved = Files.isDirectory(this.resourcePath, new LinkOption[0]) ? this.resourcePath.resolve(extendedName) : this.resourcePath.resolveSibling(extendedName);
            URL uRL = resolved.toUri().toURL();
            Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"resolved.toUri().toURL()");
            return this.resolvedLoader(resolved, uRL);
        }
        URL resolvedURL = this.resourceURL.toURI().resolve(extendedName).toURL();
        Intrinsics.checkNotNullExpressionValue((Object)resolvedURL, (String)"resolvedURL");
        return this.resolvedLoader(Companion.derivePath(resolvedURL), resolvedURL);
    }

    static {
        boolean bl = false;
        fileSystemCache = new LinkedHashMap();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\tJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013JA\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0002\u0010\u0015*\b\u0012\u0004\u0012\u0002H\u00150\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u00020\u001b0\u001aH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\n\u0010\u001d\u001a\u00020\t*\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"Lio/kjson/resource/ResourceLoader$Companion;", "", "()V", "currentDirectory", "Ljava/io/File;", "getCurrentDirectory", "()Ljava/io/File;", "fileSystemCache", "", "", "Ljava/nio/file/FileSystem;", "separator", "", "addExtension", "s", "defaultExtension", "derivePath", "Ljava/nio/file/Path;", "url", "Ljava/net/URL;", "findStartingFrom", "T", "", "index", "", "predicate", "Lkotlin/Function1;", "", "(Ljava/util/List;ILkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "strim", "resource-loader"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getCurrentDirectory() {
            return currentDirectory;
        }

        @NotNull
        public final String addExtension(@NotNull String s, @Nullable String defaultExtension) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return defaultExtension != null && StringsKt.indexOf$default((CharSequence)s, (char)'.', (int)(StringsKt.lastIndexOf$default((CharSequence)s, (char)separator, (int)0, (boolean)false, (int)6, null) + 1), (boolean)false, (int)4, null) < 0 ? s + '.' + defaultExtension : s;
        }

        @Nullable
        public final Path derivePath(@NotNull URL url) {
            Path path;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            URI uri = url.toURI();
            String string = uri.getScheme();
            if (Intrinsics.areEqual((Object)string, (Object)"jar")) {
                FileSystem fileSystem;
                String schemeSpecific = uri.getSchemeSpecificPart();
                Intrinsics.checkNotNullExpressionValue((Object)schemeSpecific, (String)"schemeSpecific");
                String jarName = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)schemeSpecific, (char)':', null, (int)2, null), (char)'!', null, (int)2, null);
                FileSystem fileSystem2 = (FileSystem)fileSystemCache.get(jarName);
                if (fileSystem2 == null) {
                    FileSystem fileSystem3 = FileSystems.newFileSystem(Paths.get(jarName, new String[0]), null);
                    boolean bl = false;
                    boolean bl2 = false;
                    FileSystem it = fileSystem3;
                    boolean bl3 = false;
                    Map map = fileSystemCache;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    FileSystem fileSystem4 = it;
                    boolean bl4 = false;
                    map.put(jarName, fileSystem4);
                    fileSystem = fileSystem3;
                } else {
                    fileSystem = fileSystem2;
                }
                FileSystem fs = fileSystem;
                path = fs.getPath(StringsKt.substringAfter$default((String)schemeSpecific, (char)'!', null, (int)2, null), new String[0]);
            } else {
                path = Intrinsics.areEqual((Object)string, (Object)"file") ? FileSystems.getDefault().getPath(uri.getPath(), new String[0]) : null;
            }
            return path;
        }

        @Nullable
        public final <T> T findStartingFrom(@NotNull List<? extends T> $this$findStartingFrom, int index, @NotNull Function1<? super T, Boolean> predicate) {
            Intrinsics.checkNotNullParameter($this$findStartingFrom, (String)"<this>");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            boolean $i$f$findStartingFrom = false;
            int n = index;
            int n2 = $this$findStartingFrom.size();
            if (n < n2) {
                do {
                    int i = n++;
                    T t = $this$findStartingFrom.get(i);
                    boolean bl = false;
                    boolean bl2 = false;
                    T it = t;
                    boolean bl3 = false;
                    if (!((Boolean)predicate.invoke(it)).booleanValue()) continue;
                    return it;
                } while (n < n2);
            }
            return null;
        }

        public static /* synthetic */ Object findStartingFrom$default(Companion this_, List receiver, int index, Function1 predicate, int n, Object object) {
            if ((n & 1) != 0) {
                index = 0;
            }
            Intrinsics.checkNotNullParameter((Object)receiver, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
            boolean $i$f$findStartingFrom = false;
            int n2 = index;
            int n3 = receiver.size();
            if (n2 < n3) {
                do {
                    int i = n2++;
                    Object e = receiver.get(i);
                    boolean bl = false;
                    boolean bl2 = false;
                    Object it = e;
                    boolean bl3 = false;
                    if (!((Boolean)predicate.invoke(it)).booleanValue()) continue;
                    return it;
                } while (n2 < n3);
            }
            return null;
        }

        @NotNull
        public final String strim(@NotNull String $this$strim) {
            String string;
            int n;
            Intrinsics.checkNotNullParameter((Object)$this$strim, (String)"<this>");
            int end = $this$strim.length();
            if (end == 0) {
                return $this$strim;
            }
            int start = 0;
            while (true) {
                if (start >= end) {
                    return "";
                }
                if ($this$strim.charAt(start) != ' ') break;
                n = start;
                start = n + 1;
            }
            while ($this$strim.charAt(end - 1) == ' ') {
                n = end;
                end = n + -1;
            }
            if (start == 0 && end == $this$strim.length()) {
                string = $this$strim;
            } else {
                String string2 = $this$strim;
                boolean bl = false;
                String string3 = string2.substring(start, end);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

