/*
 * Decompiled with CFR 0.152.
 */
package io.kjson.pointer;

import io.jstuff.util.ImmutableList;
import io.kjson.pointer.JSONPointerException;
import io.kstuff.text.CharMapResult;
import io.kstuff.text.MapResult;
import io.kstuff.text.StringMapper;
import io.kstuff.text.URIStringMapper;
import io.kstuff.text.UTF8StringMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\u0001\n\u0002\b\b\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0017\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0011\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\nJ\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018J\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\rJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\rJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0000J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0004H\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\rH\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\rJ\u0006\u0010\"\u001a\u00020\u0004J\u000e\u0010#\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\rJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0004J\u000e\u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\rJ\u0013\u0010)\u001a\u00020\u00142\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010+\u001a\u00020\rH\u0016J\b\u0010'\u001a\u00020\u0004H\u0016R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015\u00a8\u0006-"}, d2={"Lio/kjson/pointer/JSONPointer;", "", "tokens", "", "", "<init>", "([Ljava/lang/String;)V", "pointer", "(Ljava/lang/String;)V", "getTokens$kjson_pointer_core", "()[Ljava/lang/String;", "[Ljava/lang/String;", "depth", "", "getDepth", "()I", "current", "getCurrent", "()Ljava/lang/String;", "isRoot", "", "()Z", "tokensAsArray", "tokensAsList", "", "parent", "child", "string", "index", "childPointer", "withParent", "plus", "truncate", "n", "toURIFragment", "getToken", "throwPointerException", "", "text", "toString", "numTokens", "equals", "other", "hashCode", "Companion", "kjson-pointer-core"})
public final class JSONPointer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] tokens;
    @NotNull
    private static final JSONPointer root = new JSONPointer(new String[0]);
    @NotNull
    private static final String emptyString = "";
    @NotNull
    private static final CharMapResult mapJSONPointerTilde = new CharMapResult(2, '~');
    @NotNull
    private static final CharMapResult mapJSONPointerSlash = new CharMapResult(2, '/');

    public JSONPointer(@NotNull String[] tokens) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        this.tokens = tokens;
    }

    @NotNull
    public final String[] getTokens$kjson_pointer_core() {
        return this.tokens;
    }

    public JSONPointer(@NotNull String pointer) {
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        this(Companion.parseString(pointer));
    }

    public final int getDepth() {
        return this.tokens.length;
    }

    @Nullable
    public final String getCurrent() {
        return (String)ArraysKt.lastOrNull((Object[])this.tokens);
    }

    public final boolean isRoot() {
        return this.tokens.length == 0;
    }

    @NotNull
    public final String[] tokensAsArray() {
        String[] stringArray;
        if (this.tokens.length == 0) {
            stringArray = new String[]{};
        } else {
            String[] stringArray2 = Arrays.copyOf(this.tokens, this.tokens.length);
            Intrinsics.checkNotNullExpressionValue((Object)stringArray2, (String)"copyOf(...)");
            stringArray = stringArray2;
        }
        return stringArray;
    }

    @NotNull
    public final List<String> tokensAsList() {
        ImmutableList immutableList = ImmutableList.listOf((Object[])this.tokens);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"listOf(...)");
        return (List)immutableList;
    }

    @NotNull
    public final JSONPointer parent() {
        JSONPointer jSONPointer;
        int len = this.tokens.length;
        switch (len) {
            case 0: {
                Companion.throwRootParentError();
                throw new KotlinNothingValueException();
            }
            case 1: {
                jSONPointer = root;
                break;
            }
            default: {
                Object[] objectArray = this.tokens;
                int n = 0;
                int n2 = len - 1;
                JSONPointer jSONPointer2 = new JSONPointer((String[])ArraysKt.copyOfRange((Object[])objectArray, (int)n, (int)n2));
                jSONPointer = jSONPointer2;
            }
        }
        return jSONPointer;
    }

    @NotNull
    public final JSONPointer child(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return new JSONPointer((String[])ArraysKt.plus((Object[])this.tokens, (Object)string));
    }

    @NotNull
    public final JSONPointer child(int index) {
        if (index < 0) {
            this.throwPointerException("JSON Pointer index " + index + " must not be negative");
            throw new KotlinNothingValueException();
        }
        return this.child(String.valueOf(index));
    }

    @NotNull
    public final JSONPointer child(@NotNull JSONPointer childPointer) {
        Intrinsics.checkNotNullParameter((Object)childPointer, (String)"childPointer");
        if (this.isRoot()) {
            return childPointer;
        }
        if (childPointer.isRoot()) {
            return this;
        }
        return new JSONPointer((String[])ArraysKt.plus((Object[])this.tokens, (Object[])childPointer.tokens));
    }

    @NotNull
    public final JSONPointer withParent(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int n = this.tokens.length + 1;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            stringArray[n2] = n2 == 0 ? string : this.tokens[n2 - 1];
        }
        String[] stringArray2 = stringArray;
        return new JSONPointer(stringArray2);
    }

    @NotNull
    public final JSONPointer withParent(int index) {
        if (index < 0) {
            this.throwPointerException("JSON Pointer index " + index + " must not be negative");
            throw new KotlinNothingValueException();
        }
        return this.withParent(String.valueOf(index));
    }

    @NotNull
    public final JSONPointer withParent(@NotNull JSONPointer parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        if (this.isRoot()) {
            return parent;
        }
        if (parent.isRoot()) {
            return this;
        }
        return new JSONPointer((String[])ArraysKt.plus((Object[])parent.tokens, (Object[])this.tokens));
    }

    @NotNull
    public final JSONPointer plus(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.child(string);
    }

    @NotNull
    public final JSONPointer plus(int index) {
        return this.child(index);
    }

    @NotNull
    public final JSONPointer plus(@NotNull JSONPointer childPointer) {
        Intrinsics.checkNotNullParameter((Object)childPointer, (String)"childPointer");
        return this.child(childPointer);
    }

    @NotNull
    public final JSONPointer truncate(int n) {
        JSONPointer jSONPointer;
        int n2 = n;
        if (n2 == 0) {
            jSONPointer = root;
        } else if (n2 == this.getDepth()) {
            jSONPointer = this;
        } else {
            boolean bl = 1 <= n2 ? n2 < this.getDepth() : false;
            if (bl) {
                Object[] objectArray = this.tokens;
                int n3 = 0;
                JSONPointer jSONPointer2 = new JSONPointer((String[])ArraysKt.copyOfRange((Object[])objectArray, (int)n3, (int)n));
                jSONPointer = jSONPointer2;
            } else {
                this.throwPointerException("Illegal truncate (" + n + ')');
                throw new KotlinNothingValueException();
            }
        }
        return jSONPointer;
    }

    @NotNull
    public final String toURIFragment() {
        StringBuilder stringBuilder;
        StringBuilder $this$toURIFragment_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        for (String token : this.tokens) {
            $this$toURIFragment_u24lambda_u240.append('/');
            $this$toURIFragment_u24lambda_u240.append(URIStringMapper.INSTANCE.encodeURI(UTF8StringMapper.INSTANCE.encodeUTF8(Companion.encodeJSONPointerToken(token))));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public final String getToken(int index) {
        return this.tokens[index];
    }

    @NotNull
    public final Void throwPointerException(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        throw new JSONPointerException(text, this);
    }

    @NotNull
    public final String toString(int numTokens) {
        return Companion.toString(this.tokens, numTokens);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof JSONPointer && Arrays.equals(this.tokens, ((JSONPointer)other).tokens);
    }

    public int hashCode() {
        return Arrays.hashCode(this.tokens);
    }

    @NotNull
    public String toString() {
        return Companion.toString(this.tokens, this.tokens.length);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u000b\u001a\u00020\u00052\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\r\"\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\tJ\u0019\u0010\u000f\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\t0\r\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\t0\u0013J!\u0010\u0014\u001a\u00020\t2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0019\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0019\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001aJ\u000e\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\tJ\n\u0010\u001d\u001a\u00020\t*\u00020\tJ\n\u0010\u001e\u001a\u00020\t*\u00020\tJ\u0006\u0010\"\u001a\u00020#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/kjson/pointer/JSONPointer$Companion;", "", "<init>", "()V", "root", "Lio/kjson/pointer/JSONPointer;", "getRoot", "()Lio/kjson/pointer/JSONPointer;", "emptyString", "", "getEmptyString$annotations", "of", "tokens", "", "([Ljava/lang/String;)Lio/kjson/pointer/JSONPointer;", "from", "pointer", "array", "list", "", "toString", "n", "", "([Ljava/lang/String;I)Ljava/lang/String;", "parseString", "string", "(Ljava/lang/String;)[Ljava/lang/String;", "fromURIFragment", "fragment", "encodeJSONPointerToken", "decodeJSONPointerToken", "mapJSONPointerTilde", "Lio/kstuff/text/CharMapResult;", "mapJSONPointerSlash", "throwRootParentError", "", "kjson-pointer-core"})
    @SourceDebugExtension(value={"SMAP\nJSONPointer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSONPointer.kt\nio/kjson/pointer/JSONPointer$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,318:1\n37#2,2:319\n37#2,2:325\n1557#3:321\n1628#3,3:322\n*S KotlinDebug\n*F\n+ 1 JSONPointer.kt\nio/kjson/pointer/JSONPointer$Companion\n*L\n225#1:319,2\n257#1:325,2\n249#1:321\n249#1:322,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSONPointer getRoot() {
            return root;
        }

        private static /* synthetic */ void getEmptyString$annotations() {
        }

        @NotNull
        public final JSONPointer of(String ... tokens) {
            JSONPointer jSONPointer;
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            if (tokens.length == 0) {
                jSONPointer = this.getRoot();
            } else {
                String[] stringArray = Arrays.copyOf(tokens, tokens.length);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(...)");
                jSONPointer = new JSONPointer(stringArray);
            }
            return jSONPointer;
        }

        @NotNull
        public final JSONPointer from(@NotNull String pointer) {
            Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
            return ((CharSequence)pointer).length() == 0 ? this.getRoot() : new JSONPointer(pointer);
        }

        @NotNull
        public final JSONPointer from(@NotNull String[] array) {
            JSONPointer jSONPointer;
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            if (array.length == 0) {
                jSONPointer = this.getRoot();
            } else {
                String[] stringArray = Arrays.copyOf(array, array.length);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(...)");
                jSONPointer = new JSONPointer(stringArray);
            }
            return jSONPointer;
        }

        @NotNull
        public final JSONPointer from(@NotNull List<String> list) {
            JSONPointer jSONPointer;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (list.isEmpty()) {
                jSONPointer = this.getRoot();
            } else {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                JSONPointer jSONPointer2 = new JSONPointer(thisCollection$iv.toArray(new String[0]));
                jSONPointer = jSONPointer2;
            }
            return jSONPointer;
        }

        @NotNull
        public final String toString(@NotNull String[] tokens, int n) {
            StringBuilder stringBuilder;
            Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
            if (n == 0) {
                return JSONPointer.emptyString;
            }
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                $this$toString_u24lambda_u240.append('/');
                $this$toString_u24lambda_u240.append(Companion.encodeJSONPointerToken(tokens[i]));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String[] parseString(@NotNull String string) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            if (((CharSequence)string).length() == 0) {
                return new String[0];
            }
            if (string.charAt(0) != '/') {
                throw new JSONPointerException("Illegal JSON Pointer - \"" + string + '\"', null, 2, null);
            }
            String string2 = string.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            char[] cArray = new char[]{'/'};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string2, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string3;
                String string4 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                try {
                    void it;
                    string3 = Companion.decodeJSONPointerToken((String)it);
                }
                catch (JSONPointerException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new JSONPointerException("Illegal token in JSON Pointer - \"" + string + '\"', null, 2, null).withCause(e);
                }
                collection.add(string3);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new String[0]);
        }

        @NotNull
        public final JSONPointer fromURIFragment(@NotNull String fragment) {
            String string;
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            try {
                string = UTF8StringMapper.INSTANCE.decodeUTF8(URIStringMapper.INSTANCE.decodeURI(fragment));
            }
            catch (Exception e) {
                throw new JSONPointerException("Illegal URI fragment - \"" + fragment + '\"', null, 2, null).withCause(e);
            }
            String pointer = string;
            return this.from(pointer);
        }

        @NotNull
        public final String encodeJSONPointerToken(@NotNull String $this$encodeJSONPointerToken) {
            Intrinsics.checkNotNullParameter((Object)$this$encodeJSONPointerToken, (String)"<this>");
            return StringMapper.INSTANCE.mapCharacters($this$encodeJSONPointerToken, Companion::encodeJSONPointerToken$lambda$2);
        }

        @NotNull
        public final String decodeJSONPointerToken(@NotNull String $this$decodeJSONPointerToken) {
            Intrinsics.checkNotNullParameter((Object)$this$decodeJSONPointerToken, (String)"<this>");
            return StringMapper.INSTANCE.mapSubstrings($this$decodeJSONPointerToken, arg_0 -> Companion.decodeJSONPointerToken$lambda$3($this$decodeJSONPointerToken, arg_0));
        }

        @NotNull
        public final Void throwRootParentError() {
            throw new JSONPointerException("Can't get parent of root JSON Pointer", this.getRoot());
        }

        private static final CharSequence encodeJSONPointerToken$lambda$2(char it) {
            CharSequence charSequence;
            switch (it) {
                case '~': {
                    charSequence = "~0";
                    break;
                }
                case '/': {
                    charSequence = "~1";
                    break;
                }
                default: {
                    charSequence = null;
                }
            }
            return charSequence;
        }

        private static final MapResult decodeJSONPointerToken$lambda$3(String $this_decodeJSONPointerToken, int index) {
            MapResult mapResult;
            try {
                CharMapResult charMapResult;
                block7: {
                    block6: {
                        if ($this_decodeJSONPointerToken.charAt(index) != '~') break block6;
                        StringMapper.checkLength$default((StringMapper)StringMapper.INSTANCE, (String)$this_decodeJSONPointerToken, (int)index, (int)2, null, (int)8, null);
                        switch ($this_decodeJSONPointerToken.charAt(index + 1)) {
                            case '0': {
                                charMapResult = mapJSONPointerTilde;
                                break block7;
                            }
                            case '1': {
                                charMapResult = mapJSONPointerSlash;
                                break block7;
                            }
                            default: {
                                throw new IllegalArgumentException("Invalid escape sequence in \"" + $this_decodeJSONPointerToken + '\"');
                            }
                        }
                    }
                    charMapResult = null;
                }
                mapResult = (MapResult)charMapResult;
            }
            catch (Exception e) {
                throw new JSONPointerException("Illegal token in JSON Pointer - \"" + $this_decodeJSONPointerToken + '\"', null, 2, null).withCause(e);
            }
            return mapResult;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

