/*
 * Decompiled with CFR 0.152.
 */
package io.kjson;

import io.kjson.JSONDecimal;
import io.kjson.JSONLong;
import io.kjson.JSONNumber;
import io.kjson.JSONPrimitive;
import java.math.BigDecimal;
import java.util.function.IntConsumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.ULong;
import kotlin.UShort;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.util.CoIntOutput;
import net.pwall.util.IntOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 Y2\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001YB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0014\u0010\u0019\u001a\u00020\u001a2\n\u0010\u001b\u001a\u00060\u001cj\u0002`\u001dH\u0016J2\u0010\u001e\u001a\u00020\u001a2\"\u0010\u001f\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\"\u0012\u0006\u0012\u0004\u0018\u00010#0 H\u0097@\u00a2\u0006\u0002\u0010$J2\u0010%\u001a\u00020\u001a2\"\u0010\u001f\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020!\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\"\u0012\u0006\u0012\u0004\u0018\u00010#0 H\u0096@\u00a2\u0006\u0002\u0010$J\u0013\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010)\u001a\u00020\u0003H\u0016J\b\u0010*\u001a\u00020'H\u0016J\b\u0010+\u001a\u00020'H\u0016J\b\u0010,\u001a\u00020'H\u0016J\b\u0010-\u001a\u00020'H\u0016J\b\u0010.\u001a\u00020'H\u0016J\b\u0010/\u001a\u00020'H\u0016J\b\u00100\u001a\u00020'H\u0016J\b\u00101\u001a\u00020'H\u0016J\b\u00102\u001a\u00020'H\u0016J\b\u00103\u001a\u00020'H\u0016J\b\u00104\u001a\u00020'H\u0016J\b\u00105\u001a\u00020'H\u0016J\b\u00106\u001a\u00020'H\u0016J\b\u00107\u001a\u00020'H\u0016J\b\u00108\u001a\u00020'H\u0016J\u0010\u00109\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020:H\u0017J\u0010\u0010;\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020:H\u0016J\b\u0010<\u001a\u00020=H\u0016J\b\u0010>\u001a\u00020!H\u0017J\b\u0010?\u001a\u00020\u0007H\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020\u0003H\u0016J\b\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020\u0012H\u0016J\b\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020FH\u0016J\u0015\u0010K\u001a\u00020LH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bM\u0010NJ\u0015\u0010O\u001a\u00020PH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bQ\u0010\u000eJ\u0015\u0010R\u001a\u00020SH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bT\u0010\u0014J\u0015\u0010U\u001a\u00020VH\u0016\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\bW\u0010XR\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006Z"}, d2={"Lio/kjson/JSONInt;", "Lio/kjson/JSONNumber;", "Lio/kjson/JSONPrimitive;", "", "value", "(I)V", "asDecimal", "Ljava/math/BigDecimal;", "getAsDecimal", "()Ljava/math/BigDecimal;", "asDecimalOrNull", "getAsDecimalOrNull", "asInt", "getAsInt", "()I", "asIntOrNull", "getAsIntOrNull", "asLong", "", "getAsLong", "()J", "asLongOrNull", "getAsLongOrNull", "getValue", "()Ljava/lang/Integer;", "appendTo", "", "a", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "coOutput", "out", "Lkotlin/Function2;", "", "Lkotlin/coroutines/Continuation;", "", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "coOutputTo", "equals", "", "other", "hashCode", "isByte", "isInt", "isIntegral", "isLong", "isNegative", "isNotNegative", "isNotPositive", "isNotZero", "isPositive", "isShort", "isUByte", "isUInt", "isULong", "isUShort", "isZero", "output", "Ljava/util/function/IntConsumer;", "outputTo", "toByte", "", "toChar", "toDecimal", "toDouble", "", "toFloat", "", "toInt", "toJSON", "", "toLong", "toShort", "", "toString", "toUByte", "Lkotlin/UByte;", "toUByte-w2LRezQ", "()B", "toUInt", "Lkotlin/UInt;", "toUInt-pVg5ArA", "toULong", "Lkotlin/ULong;", "toULong-s-VKNKU", "toUShort", "Lkotlin/UShort;", "toUShort-Mh2AYeg", "()S", "Companion", "kjson-core"})
public final class JSONInt
extends JSONNumber
implements JSONPrimitive<Integer> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int value;
    @NotNull
    private static final JSONInt ZERO = new JSONInt(0);

    public JSONInt(int value) {
        super(null);
        this.value = value;
    }

    @Override
    @NotNull
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void appendTo(@NotNull Appendable a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        IntOutput.appendInt((Appendable)a, (int)this.getValue());
    }

    @Override
    @NotNull
    public String toJSON() {
        if (this.getValue() == 0) {
            return "0";
        }
        StringBuilder sb = new StringBuilder(11);
        this.appendTo(sb);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public void outputTo(@NotNull IntConsumer out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        IntOutput.outputInt((int)this.getValue(), (IntConsumer)out);
    }

    @Override
    @Deprecated(message="renamed to outputTo", replaceWith=@ReplaceWith(expression="outputTo(out)", imports={}))
    public void output(@NotNull IntConsumer out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        IntOutput.outputInt((int)this.getValue(), (IntConsumer)out);
    }

    @Override
    @Nullable
    public Object coOutputTo(@NotNull Function2<? super Character, ? super Continuation<? super Unit>, ? extends Object> out, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoIntOutput.INSTANCE.outputInt(out, this.getValue().intValue(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Deprecated(message="renamed to coOutputTo", replaceWith=@ReplaceWith(expression="coOutputTo(out)", imports={}))
    @Nullable
    public Object coOutput(@NotNull Function2<? super Character, ? super Continuation<? super Unit>, ? extends Object> out, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoIntOutput.INSTANCE.outputInt(out, this.getValue().intValue(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public boolean isIntegral() {
        return true;
    }

    @Override
    public boolean isLong() {
        return true;
    }

    @Override
    public boolean isInt() {
        return true;
    }

    @Override
    public boolean isShort() {
        int n = this.getValue();
        return Short.MIN_VALUE <= n ? n <= Short.MAX_VALUE : false;
    }

    @Override
    public boolean isByte() {
        int n = this.getValue();
        return -128 <= n ? n <= 127 : false;
    }

    @Override
    public boolean isULong() {
        return this.getValue() >= 0;
    }

    @Override
    public boolean isUInt() {
        return this.getValue() >= 0;
    }

    @Override
    public boolean isUShort() {
        int n = 0xFFFFFFFF & 0xFFFF;
        int n2 = this.getValue();
        return 0 <= n2 ? n2 <= n : false;
    }

    @Override
    public boolean isUByte() {
        int n = 0xFFFFFFFF & 0xFF;
        int n2 = this.getValue();
        return 0 <= n2 ? n2 <= n : false;
    }

    @Override
    public boolean isZero() {
        return this.getValue() == 0;
    }

    @Override
    public boolean isNegative() {
        return this.getValue() < 0;
    }

    @Override
    public boolean isPositive() {
        return this.getValue() > 0;
    }

    @Override
    public boolean isNotZero() {
        return this.getValue() != 0;
    }

    @Override
    public boolean isNotNegative() {
        return this.getValue() >= 0;
    }

    @Override
    public boolean isNotPositive() {
        return this.getValue() <= 0;
    }

    @Override
    public double toDouble() {
        return this.getValue().intValue();
    }

    @Override
    public float toFloat() {
        return this.getValue().intValue();
    }

    @Override
    public long toLong() {
        return this.getValue().intValue();
    }

    @Override
    public int toInt() {
        return this.getValue();
    }

    @Deprecated(message="Direct conversion to Char is deprecated. Use toInt().toChar() or Char constructor instead.", replaceWith=@ReplaceWith(expression="this.toInt().toChar()", imports={}))
    public char toChar() {
        return (char)this.getValue().intValue();
    }

    @Override
    public short toShort() {
        return (short)this.getValue().intValue();
    }

    @Override
    public byte toByte() {
        return (byte)this.getValue().intValue();
    }

    @Override
    @NotNull
    public BigDecimal toDecimal() {
        BigDecimal bigDecimal = BigDecimal.valueOf(this.getValue().intValue());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return bigDecimal;
    }

    @Override
    public long toULong-s-VKNKU() {
        return ULong.constructor-impl((long)this.getValue().intValue());
    }

    @Override
    public int toUInt-pVg5ArA() {
        return UInt.constructor-impl((int)this.getValue());
    }

    @Override
    public short toUShort-Mh2AYeg() {
        return UShort.constructor-impl((short)((short)this.getValue().intValue()));
    }

    @Override
    public byte toUByte-w2LRezQ() {
        return UByte.constructor-impl((byte)((byte)this.getValue().intValue()));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (this == other) {
            return true;
        }
        if (!(other instanceof JSONNumber)) {
            return false;
        }
        JSONNumber jSONNumber = (JSONNumber)other;
        if (jSONNumber instanceof JSONInt) {
            bl = this.getValue().intValue() == ((JSONInt)other).getValue().intValue();
        } else if (jSONNumber instanceof JSONLong) {
            bl = (long)this.getValue().intValue() == ((JSONLong)other).getValue();
        } else if (jSONNumber instanceof JSONDecimal) {
            BigDecimal bigDecimal = BigDecimal.valueOf(this.getValue().intValue());
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
            bl = bigDecimal.compareTo(((JSONDecimal)other).getValue()) == 0;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public int hashCode() {
        return this.getValue();
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.getValue());
    }

    public final int getAsInt() {
        return this.getValue();
    }

    public final int getAsIntOrNull() {
        return this.getValue();
    }

    public final long getAsLong() {
        return this.getValue().intValue();
    }

    public final long getAsLongOrNull() {
        return this.getValue().intValue();
    }

    @NotNull
    public final BigDecimal getAsDecimal() {
        BigDecimal bigDecimal = BigDecimal.valueOf(this.getValue().intValue());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return bigDecimal;
    }

    @NotNull
    public final BigDecimal getAsDecimalOrNull() {
        BigDecimal bigDecimal = BigDecimal.valueOf(this.getValue().intValue());
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
        return bigDecimal;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lio/kjson/JSONInt$Companion;", "", "()V", "ZERO", "Lio/kjson/JSONInt;", "getZERO", "()Lio/kjson/JSONInt;", "of", "i", "", "kjson-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSONInt getZERO() {
            return ZERO;
        }

        @NotNull
        public final JSONInt of(int i) {
            return i == 0 ? this.getZERO() : new JSONInt(i);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

