/*
 * Decompiled with CFR 0.152.
 */
package io.kjson;

import io.kjson.JSON;
import io.kjson.JSONBoolean;
import io.kjson.JSONDecimal;
import io.kjson.JSONException;
import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONString;
import io.kjson.JSONValue;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import net.pwall.util.ImmutableList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 *2\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0002:\u0002)*B!\b\u0000\u0012\u0010\u0010\u0003\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010H\u0016J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0016H\u0016J\u0013\u0010\u0017\u001a\u00020\u00122\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0096\u0002J\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001b\u001a\u00020\u0006H\u0096\u0002J\b\u0010\u001c\u001a\u00020\u0006H\u0016J\u0012\u0010\u001d\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0016J\u0011\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010 H\u0096\u0002J\u0012\u0010!\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0016J\u0010\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010#H\u0016J\u0018\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010#2\u0006\u0010\u001b\u001a\u00020\u0006H\u0016J \u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00022\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u0006H\u0016J\b\u0010'\u001a\u00020(H\u0016R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006+"}, d2={"Lio/kjson/JSONArray;", "Lio/kjson/JSONValue;", "", "array", "", "size", "", "([Lio/kjson/JSONValue;I)V", "immutableList", "Lnet/pwall/util/ImmutableList;", "getSize", "()I", "appendTo", "", "a", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "contains", "", "element", "containsAll", "elements", "", "equals", "other", "", "get", "index", "hashCode", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "subList", "fromIndex", "toIndex", "toString", "", "Builder", "Companion", "kjson-core"})
public final class JSONArray
implements JSONValue,
List<JSONValue>,
KMappedMarker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int size;
    @NotNull
    private final ImmutableList<JSONValue> immutableList;
    @NotNull
    private static final JSONArray EMPTY;

    public JSONArray(@NotNull JSONValue[] array, int size) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        this.size = size;
        this.immutableList = new ImmutableList((Object[])array, this.size());
    }

    public int getSize() {
        return this.size;
    }

    @Override
    public void appendTo(@NotNull Appendable a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        a.append('[');
        if (!((Collection)this).isEmpty()) {
            Iterator<JSONValue> iterator = this.iterator();
            while (true) {
                JSON.INSTANCE.appendTo(iterator.next(), a);
                if (!iterator.hasNext()) break;
                a.append(',');
            }
        }
        a.append(']');
    }

    @Override
    public boolean isEmpty() {
        return this.immutableList.isEmpty();
    }

    public boolean contains(@Nullable JSONValue element) {
        return this.immutableList.contains((Object)element);
    }

    @Override
    @NotNull
    public Iterator<JSONValue> iterator() {
        Iterator iterator = this.immutableList.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"immutableList.iterator()");
        return iterator;
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return this.immutableList.containsAll(elements);
    }

    @Override
    @Nullable
    public JSONValue get(int index) {
        return (JSONValue)this.immutableList.get(index);
    }

    public int indexOf(@Nullable JSONValue element) {
        return this.immutableList.indexOf((Object)element);
    }

    public int lastIndexOf(@Nullable JSONValue element) {
        return this.immutableList.lastIndexOf((Object)element);
    }

    @Override
    @NotNull
    public ListIterator<JSONValue> listIterator() {
        ListIterator listIterator = this.immutableList.listIterator();
        Intrinsics.checkNotNullExpressionValue((Object)listIterator, (String)"immutableList.listIterator()");
        return listIterator;
    }

    @Override
    @NotNull
    public ListIterator<JSONValue> listIterator(int index) {
        ListIterator listIterator = this.immutableList.listIterator(index);
        Intrinsics.checkNotNullExpressionValue((Object)listIterator, (String)"immutableList.listIterator(index)");
        return listIterator;
    }

    @Override
    @NotNull
    public List<JSONValue> subList(int fromIndex, int toIndex) {
        ImmutableList immutableList = this.immutableList.subList(fromIndex, toIndex);
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"immutableList.subList(fromIndex, toIndex)");
        return (List)immutableList;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof List && Intrinsics.areEqual(this.immutableList, (Object)other);
    }

    @Override
    public int hashCode() {
        return this.immutableList.hashCode();
    }

    @NotNull
    public String toString() {
        return this.toJSON();
    }

    @Override
    @NotNull
    public String toJSON() {
        return JSONValue.DefaultImpls.toJSON(this);
    }

    @Override
    public boolean add(JSONValue element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, JSONValue element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends JSONValue> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends JSONValue> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public JSONValue remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<JSONValue> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public JSONValue set(int index, JSONValue element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super JSONValue> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    static {
        boolean $i$f$emptyArray = false;
        EMPTY = new JSONArray(new JSONValue[0], 0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0007\u001a\u00020\u00042\u0017\u0010\b\u001a\u0013\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\b\fJ\u0016\u0010\r\u001a\u00020\u00042\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000fJ#\u0010\u0011\u001a\u00020\u00042\u0016\u0010\u0012\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00100\u0013\"\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lio/kjson/JSONArray$Companion;", "", "()V", "EMPTY", "Lio/kjson/JSONArray;", "getEMPTY", "()Lio/kjson/JSONArray;", "build", "block", "Lkotlin/Function1;", "Lio/kjson/JSONArray$Builder;", "", "Lkotlin/ExtensionFunctionType;", "from", "list", "", "Lio/kjson/JSONValue;", "of", "items", "", "([Lio/kjson/JSONValue;)Lio/kjson/JSONArray;", "kjson-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSONArray getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final JSONArray of(JSONValue ... items) {
            Intrinsics.checkNotNullParameter((Object)items, (String)"items");
            return items.length == 0 ? this.getEMPTY() : new JSONArray(items, items.length);
        }

        @NotNull
        public final JSONArray from(@NotNull List<? extends JSONValue> list) {
            JSONArray jSONArray;
            Intrinsics.checkNotNullParameter(list, (String)"list");
            if (list.isEmpty()) {
                jSONArray = this.getEMPTY();
            } else {
                Collection $this$toTypedArray$iv = list;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                JSONValue[] jSONValueArray = thisCollection$iv.toArray(new JSONValue[0]);
                if (jSONValueArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                jSONArray = new JSONArray(jSONValueArray, list.size());
            }
            return jSONArray;
        }

        @NotNull
        public final JSONArray build(@NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            return new Builder(0, block, 1, null).build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0010\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B*\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0019\b\u0002\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0013J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0014J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0015\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nH\u0002\u00a2\u0006\u0002\u0010\u0019R\u001a\u0010\t\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lio/kjson/JSONArray$Builder;", "", "size", "", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "(ILkotlin/jvm/functions/Function1;)V", "array", "", "Lio/kjson/JSONValue;", "[Lio/kjson/JSONValue;", "count", "getSize", "()I", "add", "value", "Ljava/math/BigDecimal;", "", "", "", "build", "Lio/kjson/JSONArray;", "checkArray", "()[Lio/kjson/JSONValue;", "kjson-core"})
    public static final class Builder {
        @Nullable
        private JSONValue[] array;
        private int count;

        public Builder(int size, @NotNull Function1<? super Builder, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            int n = 0;
            JSONValue[] jSONValueArray = new JSONValue[size];
            Builder builder = this;
            while (n < size) {
                int n2 = n++;
                jSONValueArray[n2] = null;
            }
            builder.array = jSONValueArray;
            block.invoke((Object)this);
        }

        public /* synthetic */ Builder(int n, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 8;
            }
            if ((n2 & 2) != 0) {
                function1 = 1.INSTANCE;
            }
            this(n, (Function1<? super Builder, Unit>)function1);
        }

        public final int getSize() {
            this.checkArray();
            return this.count;
        }

        private final JSONValue[] checkArray() {
            if (this.array == null) {
                throw new JSONException("Builder is closed");
            }
            return this.array;
        }

        public final void add(@Nullable JSONValue value) {
            JSONValue[] validArray = this.checkArray();
            boolean bl = false;
            int len = validArray.length;
            if (this.count >= len) {
                int n;
                int n2 = len + RangesKt.coerceAtMost((int)len, (int)4096);
                JSONValue[] jSONValueArray = new JSONValue[n2];
                for (n = 0; n < n2; ++n) {
                    int n3 = n;
                    jSONValueArray[n3] = n3 < len ? validArray[n3] : null;
                }
                JSONValue[] newArray = jSONValueArray;
                n = this.count;
                this.count = n + 1;
                newArray[n] = value;
                this.array = newArray;
            } else {
                int n = this.count;
                this.count = n + 1;
                validArray[n] = value;
            }
        }

        public final void add(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.add(new JSONString(value));
        }

        public final void add(int value) {
            this.add(JSONInt.Companion.of(value));
        }

        public final void add(long value) {
            this.add(JSONLong.Companion.of(value));
        }

        public final void add(@NotNull BigDecimal value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.add(JSONDecimal.Companion.of(value));
        }

        public final void add(boolean value) {
            this.add(JSONBoolean.Companion.of(value));
        }

        @NotNull
        public final JSONArray build() {
            JSONArray jSONArray;
            JSONValue[] it = this.checkArray();
            boolean bl = false;
            JSONArray it2 = jSONArray = this.count == 0 ? Companion.getEMPTY() : new JSONArray(it, this.count);
            boolean bl2 = false;
            this.array = null;
            return jSONArray;
        }

        public Builder() {
            this(0, null, 3, null);
        }
    }
}

