/*
 * Decompiled with CFR 0.152.
 */
package io.kjson;

import io.kjson.JSONArray;
import io.kjson.JSONBoolean;
import io.kjson.JSONDecimal;
import io.kjson.JSONException;
import io.kjson.JSONInt;
import io.kjson.JSONLong;
import io.kjson.JSONNumberValue;
import io.kjson.JSONObject;
import io.kjson.JSONString;
import io.kjson.JSONValue;
import io.kjson.parser.Parser;
import java.math.BigDecimal;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.pwall.json.JSONFunctions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u0012J\u000e\u00101\u001a\u0002042\u0006\u00103\u001a\u00020\u000bJ\u000e\u00101\u001a\u0002052\u0006\u00103\u001a\u00020\u0018J\u000e\u00101\u001a\u0002062\u0006\u00103\u001a\u00020\u001fJ\u000e\u00101\u001a\u0002072\u0006\u00103\u001a\u00020,J\u0010\u00108\u001a\u0004\u0018\u00010\u00052\u0006\u00109\u001a\u00020,J\u000e\u0010:\u001a\u00020\u00042\u0006\u00109\u001a\u00020,J\u000e\u0010;\u001a\u00020&2\u0006\u00109\u001a\u00020,J\u001c\u0010<\u001a\u00060=j\u0002`>*\u00060=j\u0002`>2\b\u00109\u001a\u0004\u0018\u00010\u0005J\u0018\u0010?\u001a\u00020@*\u0004\u0018\u00010\u00052\n\u0010A\u001a\u00060=j\u0002`>J\f\u0010B\u001a\u00020,*\u0004\u0018\u00010\u0005J\f\u0010C\u001a\u00020,*\u0004\u0018\u00010\u0005R\u0017\u0010\u0003\u001a\u00020\u0004*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\u0004\u0018\u00010\u0004*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0017\u0010\n\u001a\u00020\u000b*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u000b*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0011\u001a\u00020\u0012*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u0012*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0017\u0010\u0017\u001a\u00020\u0018*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0019\u0010\u001b\u001a\u0004\u0018\u00010\u0018*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0017\u0010\u001e\u001a\u00020\u001f*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0019\u0010\"\u001a\u0004\u0018\u00010\u001f*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\u00020&*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0019\u0010)\u001a\u0004\u0018\u00010&*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b*\u0010(R\u0017\u0010+\u001a\u00020,*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0019\u0010/\u001a\u0004\u0018\u00010,*\u0004\u0018\u00010\u00058F\u00a2\u0006\u0006\u001a\u0004\b0\u0010.\u00a8\u0006D"}, d2={"Lio/kjson/JSON;", "", "()V", "asArray", "Lio/kjson/JSONArray;", "Lio/kjson/JSONValue;", "getAsArray", "(Lio/kjson/JSONValue;)Lio/kjson/JSONArray;", "asArrayOrNull", "getAsArrayOrNull", "asBoolean", "", "getAsBoolean", "(Lio/kjson/JSONValue;)Z", "asBooleanOrNull", "getAsBooleanOrNull", "(Lio/kjson/JSONValue;)Ljava/lang/Boolean;", "asDecimal", "Ljava/math/BigDecimal;", "getAsDecimal", "(Lio/kjson/JSONValue;)Ljava/math/BigDecimal;", "asDecimalOrNull", "getAsDecimalOrNull", "asInt", "", "getAsInt", "(Lio/kjson/JSONValue;)I", "asIntOrNull", "getAsIntOrNull", "(Lio/kjson/JSONValue;)Ljava/lang/Integer;", "asLong", "", "getAsLong", "(Lio/kjson/JSONValue;)J", "asLongOrNull", "getAsLongOrNull", "(Lio/kjson/JSONValue;)Ljava/lang/Long;", "asObject", "Lio/kjson/JSONObject;", "getAsObject", "(Lio/kjson/JSONValue;)Lio/kjson/JSONObject;", "asObjectOrNull", "getAsObjectOrNull", "asString", "", "getAsString", "(Lio/kjson/JSONValue;)Ljava/lang/String;", "asStringOrNull", "getAsStringOrNull", "of", "Lio/kjson/JSONDecimal;", "value", "Lio/kjson/JSONBoolean;", "Lio/kjson/JSONInt;", "Lio/kjson/JSONLong;", "Lio/kjson/JSONString;", "parse", "json", "parseArray", "parseObject", "appendJSONValue", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "appendTo", "", "a", "displayValue", "toJSON", "kjson-core"})
public final class JSON {
    @NotNull
    public static final JSON INSTANCE = new JSON();

    private JSON() {
    }

    @NotNull
    public final JSONInt of(int value) {
        return JSONInt.Companion.of(value);
    }

    @NotNull
    public final JSONLong of(long value) {
        return JSONLong.Companion.of(value);
    }

    @NotNull
    public final JSONDecimal of(@NotNull BigDecimal value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return JSONDecimal.Companion.of(value);
    }

    @NotNull
    public final JSONString of(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return JSONString.Companion.of(value);
    }

    @NotNull
    public final JSONBoolean of(boolean value) {
        return JSONBoolean.Companion.of(value);
    }

    @Nullable
    public final JSONValue parse(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return Parser.INSTANCE.parse(json);
    }

    @NotNull
    public final JSONArray parseArray(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return this.getAsArray(this.parse(json));
    }

    @NotNull
    public final JSONObject parseObject(@NotNull String json) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        return this.getAsObject(this.parse(json));
    }

    @NotNull
    public final String toJSON(@Nullable JSONValue $this$toJSON) {
        String string;
        JSONValue jSONValue = $this$toJSON;
        return jSONValue == null ? "null" : ((string = jSONValue.toJSON()) == null ? "null" : string);
    }

    public final void appendTo(@Nullable JSONValue $this$appendTo, @NotNull Appendable a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        if ($this$appendTo == null) {
            a.append("null");
        } else {
            $this$appendTo.appendTo(a);
        }
    }

    @NotNull
    public final Appendable appendJSONValue(@NotNull Appendable $this$appendJSONValue, @Nullable JSONValue json) {
        Intrinsics.checkNotNullParameter((Object)$this$appendJSONValue, (String)"<this>");
        Appendable appendable = $this$appendJSONValue;
        boolean bl = false;
        boolean bl2 = false;
        Appendable $this$appendJSONValue_u24lambda_u2d0 = appendable;
        boolean bl3 = false;
        if (json == null) {
            $this$appendJSONValue_u24lambda_u2d0.append("null");
        } else {
            json.appendTo($this$appendJSONValue_u24lambda_u2d0);
        }
        return appendable;
    }

    @NotNull
    public final String displayValue(@Nullable JSONValue $this$displayValue) {
        String string;
        JSONValue jSONValue = $this$displayValue;
        if (jSONValue == null) {
            string = "null";
        } else if (jSONValue instanceof JSONString) {
            String string2 = JSONFunctions.displayString((String)((JSONString)$this$displayValue).getValue(), (int)21);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"displayString(value, 21)");
            string = string2;
        } else if (jSONValue instanceof JSONArray) {
            int n = ((JSONArray)$this$displayValue).size();
            switch (n) {
                case 0: {
                    string = "[]";
                    break;
                }
                case 1: {
                    string = '[' + this.displayValue(((JSONArray)$this$displayValue).get(0)) + ']';
                    break;
                }
                default: {
                    string = "[...]";
                    break;
                }
            }
        } else if (jSONValue instanceof JSONObject) {
            int n = ((JSONObject)$this$displayValue).size();
            switch (n) {
                case 0: {
                    string = "{}";
                    break;
                }
                case 1: {
                    Map.Entry<String, JSONValue> entry = ((JSONObject)$this$displayValue).entrySet().iterator().next();
                    boolean bl = false;
                    boolean bl2 = false;
                    Map.Entry<String, JSONValue> it = entry;
                    boolean bl3 = false;
                    string = '{' + JSONFunctions.displayString((String)it.getKey(), (int)21) + ':' + INSTANCE.displayValue(it.getValue()) + '}';
                    break;
                }
                default: {
                    string = "{...}";
                    break;
                }
            }
        } else {
            string = $this$displayValue.toString();
        }
        return string;
    }

    @NotNull
    public final String getAsString(@Nullable JSONValue $this$asString) {
        String string = this.getAsStringOrNull($this$asString);
        if (string == null) {
            throw new JSONException(Intrinsics.stringPlus((String)"Not a string - ", (Object)this.displayValue($this$asString)));
        }
        return string;
    }

    @Nullable
    public final String getAsStringOrNull(@Nullable JSONValue $this$asStringOrNull) {
        JSONString jSONString = $this$asStringOrNull instanceof JSONString ? (JSONString)$this$asStringOrNull : null;
        return jSONString == null ? null : jSONString.getValue();
    }

    public final int getAsInt(@Nullable JSONValue $this$asInt) {
        Integer n = this.getAsIntOrNull($this$asInt);
        if (n == null) {
            throw new JSONException(Intrinsics.stringPlus((String)"Not an int - ", (Object)this.displayValue($this$asInt)));
        }
        return n;
    }

    @Nullable
    public final Integer getAsIntOrNull(@Nullable JSONValue $this$asIntOrNull) {
        Integer n;
        JSONNumberValue jSONNumberValue;
        JSONNumberValue jSONNumberValue2 = jSONNumberValue = $this$asIntOrNull instanceof JSONNumberValue ? (JSONNumberValue)((Object)$this$asIntOrNull) : null;
        if (jSONNumberValue == null) {
            n = null;
        } else {
            JSONNumberValue jSONNumberValue3 = jSONNumberValue;
            boolean bl = false;
            boolean bl2 = false;
            JSONNumberValue it = jSONNumberValue3;
            boolean bl3 = false;
            n = it.isInt() ? Integer.valueOf(it.intValue()) : null;
        }
        return n;
    }

    public final long getAsLong(@Nullable JSONValue $this$asLong) {
        Long l = this.getAsLongOrNull($this$asLong);
        if (l == null) {
            throw new JSONException(Intrinsics.stringPlus((String)"Not a long - ", (Object)this.displayValue($this$asLong)));
        }
        return l;
    }

    @Nullable
    public final Long getAsLongOrNull(@Nullable JSONValue $this$asLongOrNull) {
        Long l;
        JSONNumberValue jSONNumberValue;
        JSONNumberValue jSONNumberValue2 = jSONNumberValue = $this$asLongOrNull instanceof JSONNumberValue ? (JSONNumberValue)((Object)$this$asLongOrNull) : null;
        if (jSONNumberValue == null) {
            l = null;
        } else {
            JSONNumberValue jSONNumberValue3 = jSONNumberValue;
            boolean bl = false;
            boolean bl2 = false;
            JSONNumberValue it = jSONNumberValue3;
            boolean bl3 = false;
            l = it.isLong() ? Long.valueOf(it.longValue()) : null;
        }
        return l;
    }

    @NotNull
    public final BigDecimal getAsDecimal(@Nullable JSONValue $this$asDecimal) {
        BigDecimal bigDecimal = this.getAsDecimalOrNull($this$asDecimal);
        if (bigDecimal == null) {
            throw new JSONException(Intrinsics.stringPlus((String)"Not a decimal - ", (Object)this.displayValue($this$asDecimal)));
        }
        return bigDecimal;
    }

    @Nullable
    public final BigDecimal getAsDecimalOrNull(@Nullable JSONValue $this$asDecimalOrNull) {
        JSONNumberValue jSONNumberValue = $this$asDecimalOrNull instanceof JSONNumberValue ? (JSONNumberValue)((Object)$this$asDecimalOrNull) : null;
        return jSONNumberValue == null ? null : jSONNumberValue.toDecimal();
    }

    public final boolean getAsBoolean(@Nullable JSONValue $this$asBoolean) {
        Boolean bl = this.getAsBooleanOrNull($this$asBoolean);
        if (bl == null) {
            throw new JSONException(Intrinsics.stringPlus((String)"Not a boolean - ", (Object)this.displayValue($this$asBoolean)));
        }
        return bl;
    }

    @Nullable
    public final Boolean getAsBooleanOrNull(@Nullable JSONValue $this$asBooleanOrNull) {
        JSONBoolean jSONBoolean = $this$asBooleanOrNull instanceof JSONBoolean ? (JSONBoolean)$this$asBooleanOrNull : null;
        return jSONBoolean == null ? null : Boolean.valueOf(jSONBoolean.getValue());
    }

    @NotNull
    public final JSONArray getAsArray(@Nullable JSONValue $this$asArray) {
        JSONArray jSONArray = this.getAsArrayOrNull($this$asArray);
        if (jSONArray == null) {
            throw new JSONException(Intrinsics.stringPlus((String)"Not an array - ", (Object)this.displayValue($this$asArray)));
        }
        return jSONArray;
    }

    @Nullable
    public final JSONArray getAsArrayOrNull(@Nullable JSONValue $this$asArrayOrNull) {
        return $this$asArrayOrNull instanceof JSONArray ? (JSONArray)$this$asArrayOrNull : null;
    }

    @NotNull
    public final JSONObject getAsObject(@Nullable JSONValue $this$asObject) {
        JSONObject jSONObject = this.getAsObjectOrNull($this$asObject);
        if (jSONObject == null) {
            throw new JSONException(Intrinsics.stringPlus((String)"Not an object - ", (Object)this.displayValue($this$asObject)));
        }
        return jSONObject;
    }

    @Nullable
    public final JSONObject getAsObjectOrNull(@Nullable JSONValue $this$asObjectOrNull) {
        return $this$asObjectOrNull instanceof JSONObject ? (JSONObject)$this$asObjectOrNull : null;
    }
}

