/*
 * Decompiled with CFR 0.152.
 */
package io.keen.client.java;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.keen.client.java.KeenJsonHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;

class JacksonJsonHandler
implements KeenJsonHandler {
    private static final MapType MAP_TYPE = TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Object.class);
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public Map<String, Object> readJson(Reader reader) throws IOException {
        return (Map)this.mapper.readValue(reader, (JavaType)MAP_TYPE);
    }

    @Override
    public void writeJson(Writer writer, Map<String, ?> value) throws IOException {
        this.mapper.writeValue(writer, value);
    }

    JacksonJsonHandler() {
        this.mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
    }
}

