/*
 * Decompiled with CFR 0.152.
 */
package akka.remote.kamon.instrumentation.akka.instrumentations.akka_26.remote;

import akka.actor.ActorSystem;
import akka.remote.artery.EnvelopeBuffer;
import akka.remote.kamon.instrumentation.akka.instrumentations.akka_26.remote.DeserializeForArteryAdvice;
import java.nio.ByteBuffer;
import kamon.Kamon$;
import kamon.context.BinaryPropagation;
import kamon.context.Context;
import kamon.context.Context$;
import kamon.instrumentation.akka.AkkaRemoteMetrics;
import kamon.instrumentation.akka.AkkaRemoteMetrics$;
import kanela.agent.libs.net.bytebuddy.asm.Advice;
import scala.Array$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public final class DeserializeForArteryAdvice$ {
    public static final DeserializeForArteryAdvice$ MODULE$ = new DeserializeForArteryAdvice$();
    private static final ThreadLocal<Context> LastDeserializedContext = new ThreadLocal<Context>(){

        public Context initialValue() {
            return null;
        }
    };

    public ThreadLocal<Context> LastDeserializedContext() {
        return LastDeserializedContext;
    }

    @Advice.OnMethodEnter
    public DeserializeForArteryAdvice.DeserializationInfo exit(@Advice.Argument(value=5) EnvelopeBuffer envelopeBuffer) {
        Context context;
        long startTime = System.nanoTime();
        ByteBuffer messageBuffer = envelopeBuffer.byteBuffer();
        int messageStart = messageBuffer.position();
        messageBuffer.mark();
        messageBuffer.position(messageBuffer.limit() - 4);
        int contextSize = messageBuffer.getInt();
        int contextStart = messageBuffer.limit() - (contextSize + 4);
        int messageSize = contextStart - messageStart;
        if (contextSize == 0) {
            context = Context$.MODULE$.Empty();
        } else {
            messageBuffer.position(contextStart).limit(contextStart + contextSize);
            context = Kamon$.MODULE$.defaultBinaryPropagation().read((Object)this.byteBufferReader(messageBuffer));
        }
        Context context2 = context;
        messageBuffer.reset();
        messageBuffer.limit(contextStart);
        return new DeserializeForArteryAdvice.DeserializationInfo(context2, startTime, messageSize);
    }

    @Advice.OnMethodExit(onThrowable=Throwable.class)
    public void exit(@Advice.Argument(value=0) ActorSystem system, @Advice.Argument(value=5) EnvelopeBuffer envelopeBuffer, @Advice.Enter DeserializeForArteryAdvice.DeserializationInfo deserializationInfo, @Advice.Thrown Throwable error) {
        if (error == null) {
            this.LastDeserializedContext().set(deserializationInfo.context());
            AkkaRemoteMetrics.SerializationInstruments instruments = AkkaRemoteMetrics$.MODULE$.serializationInstruments(system.name());
            instruments.deserializationTime().record(System.nanoTime() - deserializationInfo.timeStamp());
            instruments.inboundMessageSize().record(deserializationInfo.messageSize());
            return;
        }
    }

    public BinaryPropagation.ByteStreamReader byteBufferReader(ByteBuffer bb) {
        return new BinaryPropagation.ByteStreamReader(bb){
            private final ByteBuffer bb$2;

            public int available() {
                return this.bb$2.remaining();
            }

            public int read(byte[] target) {
                this.bb$2.get(target);
                return target.length;
            }

            public int read(byte[] target, int offset, int count) {
                this.bb$2.get(target, offset, count);
                return target.length;
            }

            public byte[] readAll() {
                byte[] array = (byte[])Array$.MODULE$.ofDim(this.bb$2.remaining(), (ClassTag)ClassTag$.MODULE$.Byte());
                this.bb$2.get(array);
                return array;
            }
            {
                this.bb$2 = bb$2;
            }
        };
    }

    private DeserializeForArteryAdvice$() {
    }
}

